//
//
//	Sharp Zaurus SL-C7x0 updater.sh script encoder/decoder
//
//	mailto:sash@cacko.biz
//
//

#include <stdio.h>

unsigned char enctab[] = {
    0x4a,0xf7,0x77,0x62,0xb0,0xe3,0xd8,0xf6,0xd1,0x98,0x09,0x2e,0x19,0x0c,0x0d,0x7c,
    0x04,0xe0,0x6b,0x22,0x10,0x08,0x15,0x16,0xb9,0x28,0x83,0x1f,0x91,0x06,0xfa,0xe8,
    0xbd,0xc6,0x21,0x32,0x23,0x6f,0x01,0x26,0x5f,0x03,0x33,0xb6,0x35,0xac,0x2d,0x0a,
    0x6e,0x6c,0xfc,0xc4,0x29,0x34,0x2b,0x42,0x25,0x66,0xc9,0x3e,0x87,0xb4,0x74,0xf2,
    0x11,0x20,0x41,0xb3,0x27,0x14,0xc1,0xcd,0x3d,0x80,0xd5,0x7f,0xcf,0x4c,0x4d,0xca,
    0x75,0x51,0xc8,0xa6,0x17,0xf0,0x55,0x82,0x79,0xdc,0x59,0x5a,0x5b,0xb8,0x5d,0x40,
    0x64,0x58,0xff,0xc5,0xab,0xc0,0xae,0xeb,0xa3,0xad,0xea,0x6a,0x37,0x3b,0x73,0x9a,
    0x88,0x3a,0xe1,0x68,0x0b,0xec,0xc7,0x76,0xf9,0x38,0x57,0xdd,0x49,0x96,0x95,0x7a,
    0x50,0x2a,0x4e,0xdb,0x00,0x48,0xd7,0x86,0x47,0x94,0xa0,0x1c,0x8b,0x8c,0x8d,0x92,
    0x45,0x90,0x7e,0x56,0x93,0xef,0x1a,0x52,0x97,0xbc,0x99,0xb5,0x7d,0x72,0x9d,0x9c,
    0xfb,0x24,0xa1,0xa2,0x07,0x46,0xa5,0x02,0x69,0xe6,0xa9,0xd3,0x30,0xba,0xd6,0x84,
    0x63,0x13,0x1b,0xb2,0x1d,0xaf,0x36,0x8e,0xb7,0x53,0x05,0xbb,0x12,0x78,0x8f,0xbe,
    0x71,0xbf,0xe4,0x1e,0x9e,0xa4,0xe5,0x2f,0x9b,0x31,0x67,0x4b,0xcb,0x43,0xc3,0xce,
    0x44,0x3c,0x0f,0xd2,0xaa,0xd4,0xed,0xa7,0x7b,0x18,0xd0,0xda,0x0e,0x54,0xf1,0xde,
    0xdf,0xa8,0x3f,0xe2,0x6d,0xcc,0xf8,0x70,0xe7,0x61,0xe9,0x85,0x65,0x2c,0x39,0xee,
    0x60,0x81,0x89,0xc2,0xf3,0xf4,0xf5,0x8a,0x5c,0x5e,0xd9,0x4f,0x9f,0xb1,0xfd,0xfe,
};

unsigned char decode_c(unsigned char c)
{
    int i;
    for (i = 0; i < 256; i++) {
	if (c == enctab[i]) return i;
    }
    printf("Internal bug: encode_c()\n");
    exit(1);
    return 0;
}

unsigned char encode_c(unsigned char c)
{
    int i;
    return enctab[c];
}

int main(int argc, char *argv[])
{
    int i, decode;
    int c;
    FILE *inf, *outf;
    char name[256];

    if (argc < 3) {
	printf("Decode file:\n\tencsh -d file.sh\nEncode file:\n\tencsh -c file.sh\n");
	exit(1);
    }

    if (strcmp(argv[1], "-d")) decode = 1;
    else decode = 0;

    strcpy(name, argv[2]);
    strcat(name, ".$$$$");

    inf = fopen(argv[2], "rb");
    outf = fopen(name, "wb");

    while ((c = fgetc(inf)) >= 0) {
	if (decode) c = decode_c(c);
	else c = encode_c(c);
	fputc(c, outf);
    }

    fclose(inf);
    fclose(outf);

    rename(name, argv[2]);

    return 0;
}
