DESCRIPTION = "Qt/X11 Version ${PV}"
SECTION = "libs"
PRIORITY = "optional"
LICENSE = "GPL | QPL"
DEPENDS = "xmu-native"
HOMEPAGE = "http://www.trolltech.com"
PR = "r0"

PROVIDES += "qt-x11-free-native"
FILESDIR = "${@os.path.dirname(bb.data.getVar('FILE',d,1))}/qt-x11-free"

LIC_FILES_CHKSUM = "file://LICENSE.GPL;md5=629178675a7d49c9fa19dfe9f43ea256 \
                    file://LICENSE.QPL;md5=fff372435cb41647bc0b3cb940ea5c51"

SRC_URI = "ftp://ftp.trolltech.com/qt/source/qt-x11-free-${PV}.tar.bz2 \
	   file://no-examples.patch"
S = "${WORKDIR}/qt-x11-free-${PV}"

#
# FIXME - This should be updated to use OE's qmake_base.oeclass
#         or the full qmake.oeclass.
#

PROVIDES = "qt-x11-free-native"
export QTDIR = "${S}"
export SYSCONF_CXX = "${CCACHE} g++"
export SYSCONF_CC  = "${CCACHE} gcc"
export SYSCONF_LINK  = "${CCACHE} g++"
THIS_QMAKESPEC = "${STAGING_DATADIR}/qmake/${TARGET_OS}-oe-g++"
export QMAKESPEC = ""
ARCH_i686 = "x86"

QT_CONFIG_FLAGS = "-release -shared -qt-zlib -no-nas-sound -no-sm -qt-libpng -qt-gif -no-xshape -no-xinerama -no-xcursor -no-xrandr \
                   -no-xrender -no-xft -no-tablet -no-xkb -no-dlopen-opengl -no-freetype -no-nis -no-cups -stl -thread -no-exceptions"


inherit native

do_configure() {
	echo "yes" | ./configure -prefix ${prefix} ${QT_CONFIG_FLAGS} -fast -L ${STAGING_LIBDIR} \
                -I ${STAGING_INCDIR_NATIVE} 
}

do_compile() {
	LD_LIBRARY_PATH=${S}/lib oe_runmake \
		QMAKE="${STAGING_BINDIR_NATIVE}/qmake -after INCLUDEPATH+=${STAGING_INCDIR} LIBS+=-L${STAGING_LIBDIR}" \
		QMAKESPEC="${THIS_QMAKESPEC}"
}


do_install() {
    install -d ${D}${bindir}/
    install -m 0755 bin/qmake ${D}${bindir}/qmake3
    for i in moc uic  lrelease lupdate; do
        install -m 0755 bin/${i} ${D}${bindir}/${i}3
    done
 
    install -d ${D}${datadir}/qt3/
    cp -PfR mkspecs ${D}${datadir}/qt3/
    ln -sf linux-g++ ${D}${datadir}/qt3/mkspecs/${TARGET_OS}-oe-g++
    ln -s ${D}${datadir}/qt3/mkspecs/ ${D}${datadir}/qmake
    install -d ${D}${libdir}/
    oe_soinstall lib/libqt-mt.so.${PV} ${D}${libdir}/
    cd ${D}${bindir}
    for i in qmake moc uic lrelease lupdate;do
        ln -s ${i}3 ${i}
    done
}


SRC_URI[md5sum] = "05d04688c0c0230ed54e89102d689ca4"
SRC_URI[sha256sum] = "aac89e862c74b2f3ead768e50e9fa7ada1e4225fe9d1d9e05723a3279259eb96"
