/*
 * OProfile User Interface
 *
 * Copyright (C) 2007 Nokia Corporation. All rights reserved.
 *
 * Author: Robert Bradford <rob@openedhand.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


#ifndef __RESPONSE_H__
#define __RESPONSE_H__

#define RESPONSE_OP_OK 'A'
#define RESPONSE_OP_ERROR 'B'
#define RESPONSE_OP_FILE 'C'
#define RESPONSE_OP_ARCHIVE 'D'
#define RESPONSE_OP_STATUS 'E'

#define RESPONSE_STATUS_RUNNING 'A'
#define RESPONSE_STATUS_STOPPED 'B'

struct response
{
  char opcode;
  unsigned long length;
  char payload[];
};

#define SIZE_OF_RESPONSE(x) sizeof(struct response) + x->length
#endif /* __RESPONSE_H__ */
