/* Windows image family application for Xconq.
   Copyright (C) 1998-2000 Stanley T. Shebs.

Xconq is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.  See the file COPYING.  */

#include "config.h"
#include "misc.h"
#include "lisp.h"
#include "imf.h"

extern void ui_init(int argc, char *argv[]);
extern void imfapp_main(void);

extern char *outdirname;

static void usage(void);

main(int argc, char *argv[])
{
    char *arg, *mask_color_name = NULL;
    char *stype;
    int i, nfsave;

    /* Tweak behavior of tcl/tk image handling. */
    use_clip_mask = FALSE;

    ui_init(argc, argv);

    init_lisp();

    for (i = 1; i < argc; ++i) {
	arg = argv[i];
	if (arg == NULL)
	  continue;
	if (strcmp(arg, "-mc") == 0) {
	    if (i + 1 < argc) {
		mask_color_name = xmalloc((2 + strlen(argv[i + 1])) * sizeof(char));
		strcpy(mask_color_name, argv[i + 1]);
		argv[i] = NULL;
		argv[i + 1] = NULL;
	    } else {
		low_init_error("No color following -mc");
		usage();
	    }
	} else if ((strcmp(arg, "-help") == 0)
		   || (strcmp(arg, "--help") == 0)) {
	    usage();
	    return;
	} else if (strcmp(arg, "-o") == 0) {
	    if (i+1 < argc) {
		outdirname = argv[i+1];
		/* Blast the arg because we'll be scanning the args again
		   and we want to ignore it then. */
		argv[i] = NULL;
		argv[i+1] = NULL;
		++i;
	    } else {
		low_init_error("No output directory following -o");
		usage();
	    }
	}
    }

    /* Any remaining arguments are files, read them. */
    for (i = 1; i < argc; ++i) {
	if (argv[i] != NULL) {
	    /*	    read_suggest = write_suggest = argv[i]; */
	    /* try to guess the format and read the file */
	    if (!read_any_file(argv[i], NULL)) {
		run_warning("Couldn't read \"%s\"", argv[i]);
	    }
	}
    }
    imfapp_main();
}

void
usage()
{
    fprintf(stderr,
	    "usage: ximfapp [-mc mask color] [-o outdir] imfile ...\n");
    exit(1);
}

char *outdirname = NULL;

LibraryPath *xconq_libs;

char spbuf[BUFSIZE];

char readerrbuf[1000];

/* This is needed because error handling refers to it. */

void
close_displays(void)
{
}

/* This is needed because error handling refers to it. */

int
write_entire_game_state(char *fname)
{
    return 0;
}

/* Need these so we can link in Lisp reader code. */

void
announce_read_progress(void)
{
}

void  
syntax_error(Obj *x, char *msg)
{
    sprintlisp(readerrbuf, x, BUFSIZE);
    init_warning("syntax error in `%s' - %s", readerrbuf, msg);
}

void
low_init_error(char *str)
{
    fprintf(stderr, "Error: %s.\n", str);
    fflush(stderr);
}

/* A warning just gets displayed, no other action is taken. */

void
low_init_warning(char *str)
{
    fprintf(stdout, "Warning: %s.\n", str);
    fflush(stdout);
}

/* A run error is fatal. */

void
low_run_error(char *str)
{
    fprintf(stderr, "Error: %s.\n", str);
    fflush(stderr);
    exit(1);
}

void
low_run_warning(char *str)
{
    fprintf(stdout, "Warning: %s.\n", str);
    fflush(stdout);
}

/* Fake definitions of unneeded routines called by lisp.c. */

int
keyword_code(char *str)
{
    run_warning("fake keyword_code being called");
    return 0;
}

/* Make the table so keyword lookup works. */

struct a_key {
    char *name;
} keywordtable[] = {

#undef  DEF_KWD
#define DEF_KWD(NAME,code)  { NAME },

#include "keyword.def"

    { NULL }
};

char *
keyword_name(enum keywords k)
{
    return keywordtable[k].name;
}

void
init_predefined_symbols(void)
{
}

int
lazy_bind(Obj *sym)
{
    run_warning("fake lazy_bind being called");
    return FALSE;
}

void
prealloc_debug(void)
{
}


/* Given a raw filename, come up with a image family name. */

char *
find_imf_name(char *rawname)
{
    int lastpos;
    char *a, *b;

    b = copy_string(rawname);
    lastpos = strlen(b) - 1;
    /* Remove leading path. */
    for (a = b + lastpos - 1; a > b; --a) {
	if (*a == '/') {
	    b = a + 1;
	    break;
	}
    }
    /* Remove trailing extension. */
    if ((a = strchr(b, '.'))) {
	*a = '\0';
    }
    return b;
}

int
read_any_file(char *filename, readimf_hook hook)
{
    ImageFamily *imf;
    char *ext;
    int rc;

    /* Find the extension. */
    for (ext = filename + strlen(filename) - 1; ext > filename; ext--) {
	if (*ext == '.') {
	    ext++;
	    break;
	}
    }
    if (ext == filename)
      ext = "";
    if (strcmp(ext, "imf") == 0) {
	return load_imf_file(filename, hook);
    }
    return 0;
}

void 
reverse_rawdata(ImageFamily *imf)
{
    int numbytes;
    Image *img;

    if (imf == NULL)
      return;
    for_all_images(imf, img) {
	numbytes = img->h * computed_rowbytes(img->w, 1);
	if (img->rawmonodata)
	  reverse_bit_endianness(img->rawmonodata, numbytes);
	if (img->rawmaskdata)
	  reverse_bit_endianness(img->rawmaskdata, numbytes);
    }
}

XSetTile() {}
