/* Tcl/tk based image family application for Xconq.
   Copyright (C) 1998, 1999 Stanley T. Shebs.

Xconq is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.  See the file COPYING.  */

#include "config.h"
#include "misc.h"
#include "lisp.h"
#include "imf.h"

#include <tcl.h>
#include <tk.h>

#include "tkimf.h"

extern int imfsample_cmd(ClientData client_data, Tcl_Interp *interp,
			 int argc, char **argv);

extern int tmp_valid;
extern Tk_Window tmp_root_window;

Tk_Window tkwin;

int depth, screen;

char *read_suggest="", *write_suggest="";

Tcl_Interp *interp;

char *outdirname;

int
tk_load_imf_file(ClientData cldata, Tcl_Interp *interp, int argc, char *argv[])
{
    char tclbuf[100];

    load_imf_file(argv[1], NULL);
    sort_all_images();
    sprintf(tclbuf, ".images.content add all");
    Tcl_Eval(interp, tclbuf);
    return TCL_OK;
}

int
tk_save_imf_file(ClientData cldata, Tcl_Interp *interp, int argc, char *argv[])
{
    int i;
    char *filename;
    FILE *fp;

    filename = argv[1];
    fp = fopen(filename, "w");
    if (fp != NULL) {
	/* Write out the imf forms of all the image families. */
	for (i = 0; i < numimages; ++i) {
	    if (1 /*write_all || is_selected(images[i])*/) {
		make_generic_image_data(images[i]);
		write_imf(fp, images[i]);
	    }
	}
	fclose(fp);
    } else {
	run_warning("could not open file for writing");
    }
    return TCL_OK;
}

int
get_imf_status_cmd(ClientData cldata, Tcl_Interp *interp, int argc, char *argv[])
{
    sprintf(interp->result, "%d image families", numimages);
    return TCL_OK;
}

int
get_imf_name_cmd(ClientData cldata, Tcl_Interp *interp, int argc, char *argv[])
{
    int n;

    n = strtol(argv[1], NULL, 10);
    sprintf(interp->result, "%s", images[n]->name);
    return TCL_OK;
}

int
get_imf_numsizes_cmd(ClientData cldata, Tcl_Interp *interp, int argc, char *argv[])
{
    int n, rslt = 0;
    Image *img;

    n = strtol(argv[1], NULL, 10);
    for_all_images(images[n], img)
      if (!img->synthetic)
	++rslt;
    sprintf(interp->result, "%d", rslt);
    return TCL_OK;
}

int
tk_init()
{
    Tcl_FindExecutable("ximfapp");

    interp = Tcl_CreateInterp();

    if (Tcl_Init(interp) == TCL_ERROR)
      return TCL_ERROR;

    if (Tk_Init(interp) == TCL_ERROR)
      return TCL_ERROR;

    Tcl_CreateCommand(interp, "load_imf_file", tk_load_imf_file,
		      (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
    Tcl_CreateCommand(interp, "save_imf_file", tk_save_imf_file,
		      (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);

    Tcl_CreateCommand(interp, "get_imf_status", get_imf_status_cmd,
		      (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);

    Tcl_CreateCommand(interp, "get_imf_name", get_imf_name_cmd,
		      (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);

    Tcl_CreateCommand(interp, "get_imf_numsizes", get_imf_numsizes_cmd,
		      (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);

    tkwin = Tk_MainWindow(interp);

    Tcl_CreateCommand(interp, "imfsample", imfsample_cmd,
		      (ClientData) tkwin, (Tcl_CmdDeleteProc *) NULL);

    Tcl_EvalFile(interp, "../../xc7.2.x/tcltk/imfapp.tcl");
}

void
imfapp_main()
{
    int i;
    char tclbuf[100];
    ImageFamily *imf;

    sort_all_images();

    imf_interp_hook = tk_interp_imf;
    imf_load_hook = tk_load_imf;
    tmp_root_window = tkwin;
    tmp_valid = TRUE;

    Tk_MakeWindowExist(tkwin);

    for (i = 0; i < numimages; ++i) {
	imf = images[i];
	if (imf->numsizes > 0 && imf_interp_hook != NULL)
	  imf = (*imf_interp_hook)(imf, NULL, FALSE);
	if (imf_load_hook != NULL)
	  imf = (*imf_load_hook)(imf);
	images[i] = imf;
    }

    strcpy(tclbuf, "set_initial_view");
    Tcl_Eval(interp, tclbuf);

    sprintf(tclbuf, ".images.content add all");
    Tcl_Eval(interp, tclbuf);

    Tk_MainLoop();
}

ImageFamily *
hack_find_imf(char *name)
{
  int i;

  for (i = 0; i < numimages; ++i)
    if (strcmp(images[i]->name, name) == 0)
      return images[i];
  return NULL;
}
