;;; Nationalities of the modern world of at least 1,000,000 members,
;;; weighted by approx population in millions.  We allow Iceland in,
;;; because it's high-tech, and there are Xconq players there, and
;;; exclude a few countries for which the people names are awkward or
;;; unknown.

;;; Weights are generally based on 1990 population estimates, with a ceiling
;;; of 50, so that we can have a chance of games with other than Chinese and
;;; Indian sides...

;;; Note that the "name" of a side is not defined, since the names correspond
;;; better to the physical countries, not nationalities (a subtle distinction).

(include "ng-african")
(include "ng-american")
(include "ng-asian")
(include "ng-chinese")
(include "ng-english")
(include "ng-european")
(include "ng-german")
(include "ng-italian")
(include "ng-japanese")
(include "ng-misc")

(set side-library '(
  (17 (noun "Afghan") (emblem-name "flag-afghanistan") (units ("Kabul"))
    (unit-namers ((town city) afghan-place-names)))
  (3 (noun "Albanian") (emblem-name "flag-albania") (units ("Tirane"))
    (unit-namers ((town city) albanian-place-names)))
  (25 (noun "Algerian") (emblem-name "flag-algeria") (units ("Algiers" "Oran"))
    (unit-namers ((town city) algerian-place-names)))
  (10 (noun "Angolan") (emblem-name "flag-angola") (units ("Luanda"))
    (unit-namers ((town city) angolan-place-names)))
  (32 (noun "Argentinian") (emblem-name "flag-argentina")
    (units ("Buenos Aires"))
    (unit-namers ((town city) argentinian-place-names)))
  (3 (noun "Armenian") (emblem-name "flag-armenia") (units ("Jerevan"))
    (unit-namers ((town city) armenian-place-names)))
  (17 (noun "Australian") (emblem-name "flag-australia")
    (units ("Sydney" "Melbourne" "Perth"))
    (unit-namers ((town city) australian-place-names)))
  (7 (noun "Austrian") (emblem-name "flag-austria") (units ("Vienna"))
    (unit-namers ((town city) german-place-names)))
  (7 (noun "Azerbaijani") (emblem-name "flag-azerbaijan") (units ("Baku"))
    (unit-namers ((town city) azerbaijani-place-names)))
  (50 #|116|# (noun "Bangladeshi") (emblem-name "flag-bangladesh")
    (units ("Dacca"))
    (unit-namers ((town city) bangladeshi-place-names)))
  (10 (noun "Belarussian") (emblem-name "flag-belarus") (units ("Minsk"))
    (unit-namers ((town city) russian-place-names)))
  (10 (noun "Belgian") (emblem-name "flag-belgium") (units ("Brussels"))
    (unit-namers ((town city) belgian-place-names)))
  (5 (noun "Beninese") (emblem-name "flag-benin")
    (unit-namers ((town city) beninese-place-names)))
  (7 (noun "Bolivian") (emblem-name "flag-bolivia") (units ("La Paz"))
    (unit-namers ((town city) bolivian-place-names)))
  (3 (noun "Bosnian") (emblem-name "flag-bosnia") (units ("Sarajevo"))
    (unit-namers ((town city) bosnian-place-names)))
  ;; The noun and plural-noun below are *not* typos!
  (1 (noun "Motswana") (plural-noun "Batswana") (emblem-name "flag-botswana")
    (unit-namers ((town city) botswana-place-names)))
  (50 #|150|# (noun "Brazilian") (emblem-name "flag-brazil")
    (units ("Rio de Janeiro" "Sao Paulo"))
    (unit-namers ((town city) brazilian-place-names)))
  (9 (noun "Bulgarian") (emblem-name "flag-bulgaria") (units ("Sofia"))
    (unit-namers ((town city) bulgarian-place-names)))
  (9 (noun "Burkinabe") (emblem-name "flag-burkina-faso")
    (unit-namers ((town city) burkinabe-place-names)))
  (42 (noun "Burmese") (emblem-name "flag-burma") (units ("Rangoon"))
    (unit-namers ((town city) burmese-place-names)))
  (4 (noun "Burundi") (emblem-name "flag-burundi")
    (unit-namers ((town city) burundi-place-names)))
  (8 (noun "Kampuchean") (emblem-name "flag-cambodia")
    (unit-namers ((town city) kampuchean-place-names)))
  (11 (noun "Cameroonian") (emblem-name "flag-cameroon")
    (unit-namers ((town city) cameroonian-place-names)))
  (27 (noun "Canadian") (emblem-name "flag-canada")
    (units ("Toronto" "Montreal"))
    (unit-namers ((town city) canadian-place-names)))
  (3 (noun "Central African") (emblem-name "flag-central-africa")
    (unit-namers ((town city) central-african-place-names)))
  (6 (noun "Chadian") (emblem-name "flag-chad")
    (unit-namers ((town city) chadian-place-names)))
  (13 (noun "Chilean") (emblem-name "flag-chile")
    (unit-namers ((town city) chilean-place-names)))
  (50 #|1135|# (noun "Chinese") (emblem-name "flag-china") (units ("Beijing"))
    (unit-namers ((town city) chinese-place-names)))
  (31 (noun "Colombian") (emblem-name "flag-colombia")
    (unit-namers ((town city) colombian-place-names)))
  (2 (noun "Congolese") (emblem-name "flag-congo")
    (unit-namers ((town city) congolese-place-names)))
  (3 (noun "Costa Rican") (emblem-name "flag-costa-rica")
    (unit-namers ((town city) costa-rican-place-names)))
  (12 (noun "Ivorian") (emblem-name "flag-cote-divoire") (units ("Abidjan"))
    (unit-namers ((town city) ivorian-place-names)))
  (5 (noun "Croatian") (emblem-name "flag-croatia") (units ("Zagreb"))
    (unit-namers ((town city) croatian-place-names)))
  (10 (noun "Cuban") (emblem-name "flag-cuba")
    (unit-namers ((town city) cuban-place-names)))
  (10 (noun "Czech") (emblem-name "flag-czech") (units ("Prague"))
    (unit-namers ((town city) czech-place-names)))
  (5 (noun "Danish") (emblem-name "flag-denmark") (units ("Copenhagen"))
    (unit-namers ((town city) danish-place-names)))
  ;; Dominican Republic
  (11 (noun "Ecuadorean") (emblem-name "flag-ecuador") (units ("Quito"))
    (unit-namers ((town city) ecuadorean-place-names)))
  (50 #|54|# (noun "Egyptian") (emblem-name "flag-egypt")
    (units ("Alexandria" "Cairo"))
    (unit-namers ((town city) egyptian-place-names)))
  (4 (noun "Eritrean") (emblem-name "flag-eritrea") (units ("Asmera"))
    (unit-namers ((town city) eritrean-place-names)))
  (2 (noun "Estonian") (emblem-name "flag-estonia") (units ("Tallinn"))
    (unit-namers ((town city) estonian-place-names)))
  (47 (noun "Ethiopian") (emblem-name "flag-ethiopia")
    (unit-namers ((town city) ethiopian-place-names)))
  (5 (noun "Finn") (adjective "Finnish") (emblem-name "flag-finland")
    (units ("Helsinki"))
    (unit-namers ((town city) finnish-place-names)))
  (50 #|56|# (noun "French") (emblem-name "flag-france") (units ("Paris"))
    (unit-namers ((town city) french-place-names)))
  (1 (noun "Gabonese") (emblem-name "flag-gabon")
    (unit-namers ((town city) gabonese-place-names)))
  ;; Gambia
  (5 (noun "Georgian") (emblem-name "flag-georgia") (units ("Tbilisi"))
    (unit-namers ((town city) georgian-place-names)))
  (50 #|76|# (noun "German") (emblem-name "flag-germany") (units ("Berlin"))
    (unit-namers ((town city) german-place-names)))
  (15 (noun "Ghanaian") (emblem-name "flag-ghana") (units ("Accra"))
    (unit-namers ((town city) ghanaian-place-names)))
  (10 (noun "Greek") (emblem-name "flag-greece") (units ("Athens"))
    (unit-namers ((town city) greek-place-names)))
  (9 (noun "Guatemalan") (emblem-name "flag-guatemala")
    (unit-namers ((town city) guatemalan-place-names)))
  (7 (noun "Guinean") (emblem-name "flag-guinea")
    (unit-namers ((town city) guinean-place-names)))
  (7 (noun "Haitian") (emblem-name "flag-haiti")
    (unit-namers ((town city) haitian-place-names)))
  (5 (noun "Honduran") (emblem-name "flag-honduras") (units ("Tegucigalpa"))
    (unit-namers ((town city) honduran-place-names)))
  (11 (noun "Hungarian") (emblem-name "flag-hungary") (units ("Budapest"))
    (unit-namers ((town city) hungarian-place-names)))
  (1 (noun "Icelander") (adjective "Icelandic") (emblem-name "flag-iceland")
    (units ("Reykjavik"))
    (unit-namers ((town city) icelandic-place-names)))
  (50 #|853|# (noun "Indian") (emblem-name "flag-india")
    (units ("New Delhi"))
    (unit-namers ((town city) indian-place-names)))
  (50 #|181|# (noun "Indonesian") (emblem-name "flag-indonesia")
    (units ("Jakarta"))
    (unit-namers ((town city) indonesian-place-names)))
  (50 #|57|# (noun "Iranian") (emblem-name "flag-iran") (units ("Tehran"))
    (unit-namers ((town city) iranian-place-names)))
  (19 (noun "Iraqi") (emblem-name "flag-iraq") (units ("Baghdad"))
    (unit-namers ((town city) iraqi-place-names)))
  (4 (noun "Irish") (emblem-name "flag-ireland") (units ("Dublin"))
    (unit-namers ((town city) irish-place-names)))
  (5 (noun "Israeli") (emblem-name "flag-israel") (units ("Tel Aviv"))
    (unit-namers ((town city) israeli-place-names)))
  (50 #|57|# (noun "Italian") (emblem-name "flag-italy") (units ("Rome"))
    (unit-namers ((town city) italian-place-names)))
  (3 (noun "Jamaican") (emblem-name "flag-jamaica") (units ("Kingston"))
    (unit-namers ((town city) jamaican-place-names)))
  (50 #|123|# (noun "Japanese") (emblem-name "flag-japan")
    (units ("Tokyo" "Osaka"))
    (unit-namers ((town city) japanese-place-names)))
  (4 (noun "Jordanian") (emblem-name "flag-jordan") (units ("Amman"))
    (unit-namers ((town city) jordanian-place-names)))
  (16 (noun "Kazakh") (emblem-name "flag-kazakhstan")
    (unit-namers ((town city) kazakh-place-names)))
  (25 (noun "Kenyan") (emblem-name "flag-kenya") (units ("Nairobi"))
    (unit-namers ((town city) kenyan-place-names)))
  (50 #|65|# (noun "Korean") (emblem-name "flag-korea") (units ("Seoul"))
    (unit-namers ((town city) korean-place-names)))
  (2 (noun "Kuwaiti") (emblem-name "flag-kuwait"))
  ;; (should fix flag name)
  (4 (noun "Kyrgyz") (emblem-name "flag-kirghizistan")
    (unit-namers ((town city) kyrgyz-place-names)))
  (4 (noun "Laotian") (emblem-name "flag-laos")
    (unit-namers ((town city) laotian-place-names)))
  (3 (noun "Latvian") (emblem-name "flag-latvia") (units ("Riga"))
    (unit-namers ((town city) latvian-place-names)))
  (3 (noun "Lebanese") (emblem-name "flag-lebanon")
    (unit-namers ((town city) lebanese-place-names)))
  ;; Lesotho has no towns
  (3 (noun "Liberian") (emblem-name "flag-liberia") (units ("Monrovia"))
    (unit-namers ((town city) liberian-place-names)))
  (5 (noun "Libyan") (emblem-name "flag-libya") (units ("Tripoli"))
    (unit-namers ((town city) libyan-place-names)))
  (4 (noun "Lithuanian") (emblem-name "flag-lithuania")
    (unit-namers ((town city) lithuanian-place-names)))
  (2 (noun "Macedonian") (emblem-name "flag-macedonia")
    (unit-namers ((town city) macedonian-place-names)))
  (12 (noun "Madagascaran") (emblem-name "flag-madagascar")
    (units ("Antananarivo"))
    (unit-namers ((town city) madagascaran-place-names)))
  (10 (noun "Malawian") (emblem-name "flag-malawi") (units ("Blantyre"))
    (unit-namers ((town city) malawian-place-names)))
  (17 (noun "Malaysian") (emblem-name "flag-malaysia")
    (unit-namers ((town city) malaysian-place-names)))
  (9 (noun "Malian") (emblem-name "flag-mali") (units ("Bamako"))
    (unit-namers ((town city) malian-place-names)))
  (2 (noun "Mauritanian") (emblem-name "flag-mauritania")
    (units ("Nouakchott"))
    (unit-namers ((town city) mauritanian-place-names)))
  ;; Mauritius
  (50 #|89|# (noun "Mexican") (emblem-name "flag-mexico")
    (units ("Mexico City"))
    (unit-namers ((town city) mexican-place-names)))
  (4 (noun "Moldovan") (emblem-name "flag-moldova") (units ("Kishinev"))
    (unit-namers ((town city) moldovan-place-names)))
  (2 (noun "Mongolian") (emblem-name "flag-mongolia")
    (unit-namers ((town city) mongolian-place-names)))
  (25 (noun "Moroccan") (emblem-name "flag-morocco")
    (unit-namers ((town city) moroccan-place-names)))
  (16 (noun "Mozambican") (emblem-name "flag-mozambique")
    (unit-namers ((town city) mozambican-place-names)))
  (2 (noun "Namibian") (emblem-name "flag-namibia") (units ("Windhoek"))
    (unit-namers ((town city) namibian-place-names)))
  (19 (noun "Nepalese") (emblem-name "flag-nepal") (units ("Kathmandu"))
    (unit-namers ((town city) nepalese-place-names)))
  (15 (noun "Dutch") (emblem-name "flag-netherlands")
    (units ("Amsterdam" "Rotterdam"))
    (unit-namers ((town city) dutch-place-names)))
  (3 (noun "New Zealander") (emblem-name "flag-new-zealand")
    (unit-namers ((town city) new-zealander-place-names)))
  (4 (noun "Nicaraguan") (emblem-name "flag-nicaragua")
    (unit-namers ((town city) nicaraguan-place-names)))
  (8 (noun "Nigerien") (emblem-name "flag-niger")
    (unit-namers ((town city) nigerien-place-names)))
  (50 #|113|# (noun "Nigerian") (emblem-name "flag-nigeria")
    (unit-namers ((town city) nigerian-place-names)))
  (4 (noun "Norwegian") (emblem-name "flag-norway") (units ("Oslo"))
    (unit-namers ((town city) norwegian-place-names)))
  (1 (noun "Omani") (emblem-name "flag-oman")
    (unit-namers ((town city) omani-place-names)))
  (50 #|123|# (noun "Pakistani") (emblem-name "flag-pakistan")
    (unit-namers ((town city) pakistani-place-names)))
  (2 (noun "Panamanian") (emblem-name "flag-panama")
    (unit-namers ((town city) panamanian-place-names)))
  (4 (noun "Papuan") (emblem-name "flag-papua")
    (unit-namers ((town city) papuan-place-names)))
  (4 (noun "Paraguayan") (emblem-name "flag-paraguay") (units ("Asuncion"))
    (unit-namers ((town city) paraguayan-place-names)))
  (22 (noun "Peruvian") (emblem-name "flag-peru") (units ("Lima"))
    (unit-namers ((town city) peruvian-place-names)))
  (50 #|65|# (noun "Filipino") (adjective "Philippine") (emblem-name "flag-philippines")
    (units ("Manila"))
    (unit-namers ((town city) philippine-place-names)))
  (38 (noun "Polish") (emblem-name "flag-poland") (units ("Warsaw"))
    (unit-namers ((town city) polish-place-names)))
  (10 (noun "Portuguese") (emblem-name "flag-portugal") (units ("Lisbon"))
    (unit-namers ((town city) portuguese-place-names)))
  (23 (noun "Romanian") (emblem-name "flag-romania") (units ("Bucharest"))
    (unit-namers ((town city) romanian-place-names)))
  (50 #|148|# (noun "Russian") (emblem-name "flag-russia") (units ("Moscow"))
    (unit-namers ((town city) russian-place-names)))
  (7 (noun "Rwandan") (emblem-name "flag-rwanda")
    (unit-namers ((town city) rwandan-place-names)))
  (5 (noun "Salvadoran") (emblem-name "flag-el-salvador")
    (unit-namers ((town city) salvadoran-place-names)))
  (14 (noun "Saudi") (emblem-name "flag-saudi")
    (units ("Riyadh" "Jiddah" "Mecca" "Medina"))
    (unit-namers ((town city) saudi-place-names)))
  (7 (noun "Senegalese") (emblem-name "flag-senegal")
    (unit-namers ((town city) senegalese-place-names)))
  (4 (noun "Sierra Leonan") (emblem-name "flag-sierra-leone")
    (unit-namers ((town city) sierra-leonan-place-names)))
  (3 (noun "Singaporean") (emblem-name "flag-singapore") (units ("Singapore"))
    (unit-namers ((town city) singaporean-place-names)))
  (6 (noun "Slovakian") (emblem-name "flag-slovakia")
    (unit-namers ((town city) slovakian-place-names)))
  (1 (noun "Slovenian") (emblem-name "flag-slovenia")
    (unit-namers ((town city) slovenian-place-names)))
  (7 (noun "Somalian") (emblem-name "flag-somalia")
    (unit-namers ((town city) somalian-place-names)))
  (35 (noun "South African") (emblem-name "flag-south-africa")
    (units ("Cape Town" "Durban" "Johannesburg"))
    (unit-namers ((town city) south-african-place-names)))
  (39 (noun "Spanish") (emblem-name "flag-spain") (units ("Madrid"))
    (unit-namers ((town city) spanish-place-names)))
  (17 (noun "Sri Lankan") (emblem-name "flag-sri-lanka")
    (unit-namers ((town city) sri-lankan-place-names)))
  (25 (noun "Sudanese") (emblem-name "flag-sudan") (units ("Khartoum"))
    (unit-namers ((town city) sudanese-place-names)))
  ;; Swaziland has no towns
  (8 (noun "Swede") (adjective "Swedish") (emblem-name "flag-sweden")
    (units ("Stockholm"))
    (unit-namers ((town city) swedish-place-names)))
  (7 (noun "Swiss") (emblem-name "flag-switzerland") (units ("Zurich"))
    (unit-namers ((town city) swiss-place-names)))
  (13 (noun "Syrian") (emblem-name "flag-syria") (units ("Damascus"))
    (unit-namers ((town city) syrian-place-names)))
  (5 (noun "Tajik") (emblem-name "flag-tajikistan")
    (unit-namers ((town city) tajik-place-names)))
  (27 (noun "Tanzanian") (emblem-name "flag-tanzania")
    (unit-namers ((town city) tanzanian-place-names)))
  (50 #|56|# (noun "Siamese") (emblem-name "flag-thailand")
    (units ("Bangkok"))
    (unit-namers ((town city) thai-place-names)))
  (3 (noun "Togolese") (emblem-name "flag-togo")
    (unit-namers ((town city) togolese-place-names)))
  ;; Trinidad and Tobago
  (8 (noun "Tunisian") (emblem-name "flag-tunisia")
    (unit-namers ((town city) tunisian-place-names)))
  (50 #|56|# (noun "Turk") (emblem-name "flag-turkey")
    (unit-namers ((town city) turkish-place-names)))
  (3 (noun "Turkmen") (emblem-name "flag-turkmenistan")
    (unit-namers ((town city) turkmen-place-names)))
  (18 (noun "Ugandan") (emblem-name "flag-uganda")
    (unit-namers ((town city) ugandan-place-names)))
  (50 (noun "Ukrainian") (emblem-name "flag-ukraine") (units ("Kiev"))
    (unit-namers ((town city) ukrainian-place-names)))
  ;; United Arab Emirates
  (50 #|57|# (noun "British") (emblem-name "flag-uk")
    (units ("London" "Glasgow"))
    (unit-namers ((town city) english-place-names)))
  (50 #|250|# (noun "American") (emblem-name "flag-usa")
    (units ("New York" "Houston" "San Francisco"))
    (unit-namers ((town city) american-place-names)))
  (3 (noun "Uruguayan") (emblem-name "flag-uruguay") (units ("Montevideo"))
    (unit-namers ((town city) uruguayan-place-names)))
  (17 (noun "Uzbek") (emblem-name "flag-uzbekistan") (units ("Tashkent"))
    (unit-namers ((town city) uzbek-place-names)))
  (20 (noun "Venezuelan") (emblem-name "flag-venezuela") (units ("Caracas"))
    (unit-namers ((town city) venezuelan-place-names)))
  (50 #|67|# (noun "Vietnamese") (emblem-name "flag-vietnam")
    (unit-namers ((town city) vietnamese-place-names)))
  (11 (noun "Yemeni") (emblem-name "flag-yemen")
    (unit-namers ((town city) yemeni-place-names)))
  (11 (noun "Yugoslavian") (emblem-name "flag-yugoslavia")
    (unit-namers ((town city) yugoslavian-place-names)))
  (36 (noun "Zairean") (emblem-name "flag-zaire") (units ("Kinshasa"))
    (unit-namers ((town city) zairean-place-names)))
  (8 (noun "Zambian") (emblem-name "flag-zambia")
    (unit-namers ((town city) zambian-place-names)))
  (10 (noun "Zimbabwean") (emblem-name "flag-zimbabwe")
    (unit-namers ((town city) zimbabwean-place-names)))
  ))
