/* Declarations of functions only visible to Xconq kernel.
   Copyright (C) 1996-1997 Stanley T. Shebs.

Xconq is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.  See the file COPYING.  */

extern int move_unit PARAMS ((Unit *unit, int nx, int ny));
extern int maybe_react_to_move PARAMS ((Unit *unit, int ox, int oy));
extern void consume_move_supplies PARAMS ((Unit *unit));

#undef  DEF_ACTION
#define DEF_ACTION(name,code,args,PREPFN,netprepfn,dofn,checkfn,ARGDECL,doc)  \
  extern int PREPFN PARAMS (ARGDECL);

#include "action.def"

extern void finish_turn PARAMS ((Side *side));
extern void resign_game PARAMS ((Side *side, Side *side2));
extern void change_people_side_around PARAMS ((int x, int y, int u,
					       Side *side));
extern void change_control_side_around PARAMS ((int x, int y, int u,
						Side *side));
extern void maybe_starve PARAMS ((Unit *unit, int partial));

extern void set_side_ai PARAMS ((Side *side, char *typename));

extern int change_cell PARAMS ((Unit *unit, int x, int y));
extern void rescue_occupants PARAMS ((Unit *unit));
extern void wreck_unit PARAMS ((Unit *unit));
extern void maybe_track PARAMS ((Unit *unit));
extern void maybe_lose_track PARAMS ((Unit *unit, int nx, int ny));

extern void notify_tech PARAMS ((Side *side, int u, int oldtech, int newtech));
extern void notify_tp PARAMS ((Side *side, Unit *unit, int u2, int oldtp,
			       int newtp));
extern void reckon_damage_around PARAMS ((int x, int y, int r));
extern void damage_unit PARAMS ((Unit *unit, enum damage_reasons reason, Unit *agent));
extern void capture_unit PARAMS ((Unit *unit, Unit *pris, int captype));
extern int detonate_unit PARAMS ((Unit *unit, int x, int y, int z));
extern void damage_terrain PARAMS ((int u, int x, int y));
extern int damaged_terrain_type PARAMS ((int t));

extern void set_side_name PARAMS ((Side *side, Side *side2, char *newname));
extern void set_side_longname PARAMS ((Side *side, Side *side2,
				       char *newname));
extern void set_side_shortname PARAMS ((Side *side, Side *side2,
					char *newname));
extern void set_side_noun PARAMS ((Side *side, Side *side2, char *newname));
extern void set_side_pluralnoun PARAMS ((Side *side, Side *side2,
					 char *newname));
extern void set_side_adjective PARAMS ((Side *side, Side *side2,
					char *newname));
extern void set_side_emblemname PARAMS ((Side *side, Side *side2,
					 char *newname));
extern void set_side_colorscheme PARAMS ((Side *side, Side *side2,
					  char *newname));
extern void become_designer PARAMS ((Side *side));
extern void become_nondesigner PARAMS ((Side *side));
extern void set_trust PARAMS ((Side *side, Side *side2, int val));
extern void set_mutual_trust PARAMS ((Side *side, Side *side2, int val));
extern void set_autofinish PARAMS ((Side *side, int value));
extern void set_willing_to_save PARAMS ((Side *side, int flag));
extern void set_willing_to_draw PARAMS ((Side *side, int flag));
extern void send_message PARAMS ((Side *side, SideMask sidemask, char *str));
extern void set_side_self_unit PARAMS ((Side *side, struct a_unit *unit));
extern void set_doctrine PARAMS ((Side *side, char *spec));
extern void set_controlled_by PARAMS ((Side *side, Side *side2, int val));

#ifdef DESIGNERS
extern void paint_view PARAMS ((Side *side, int x, int y, int r, int tview,
				int uview));
#endif /* DESIGNERS */

extern void change_unit_side PARAMS ((Unit *unit, Side *newside, int reason,
				      Unit *agent));
extern int set_unit_side PARAMS ((Unit *unit, Side *side));
extern int set_unit_origside PARAMS ((Unit *unit, Side *side));
extern void set_unit_plan_type PARAMS ((Side *side, Unit *unit, int type));
extern void set_unit_asleep PARAMS ((Side *side, Unit *unit, int flag,
				     int recurse));
extern void set_unit_reserve PARAMS ((Side *side, Unit *unit, int flag,
				      int recurse));
extern void set_unit_ai_control PARAMS ((Side *side, Unit *unit, int flag,
					 int recurse));
extern void set_unit_main_goal PARAMS ((Side *side, Unit *unit, Goal *goal));
extern void set_unit_waiting_for_transport PARAMS ((Side *side, Unit *unit,
						    int flag));
extern void set_unit_name PARAMS ((Side *side, Unit *unit, char *newname));
extern int disband_unit PARAMS ((Side *side, Unit *unit));
extern void kill_unit PARAMS ((Unit *unit, int reason));
extern void kill_unit_aux PARAMS ((Unit *unit, int reason));
extern void set_unit_position PARAMS ((Unit *unit, int x, int y, int z));
extern void change_morale PARAMS ((Unit *unit, int sign, int morchange));

#ifdef DESIGNERS
extern Unit *designer_create_unit PARAMS ((Side *side, int u, int s,
					   int x, int y));
extern int designer_teleport PARAMS ((Unit *unit, int x, int y, Unit *other));
extern int designer_change_side PARAMS ((Unit *unit, Side *side));
extern int designer_disband PARAMS ((Unit *unit));
#endif /* DESIGNERS */

extern void reserve_unit PARAMS ((Side *side, Unit *unit));
extern void wake_unit PARAMS ((Side *side, Unit *unit, int wakeoccs));
extern void wake_area PARAMS ((Side *side, int x, int y, int n, int occs));
extern void set_formation PARAMS ((Unit *unit, Unit *leader, int x, int y,
				   int dist, int flex));
extern void delay_unit PARAMS ((Unit *unit, int flag));
extern int clear_task_agenda PARAMS ((Plan *plan));
extern void force_replan PARAMS ((Side *side, Unit *unit, int passive_only));

extern void execute_plan PARAMS ((Unit *unit, int try));
extern int resupply_if_low PARAMS ((Unit *unit));
extern int rearm_if_low PARAMS ((Unit *unit));
extern int do_for_occupants PARAMS ((Unit *unit));
extern int go_after_victim PARAMS ((Unit *unit, int range));
extern int fire_at_opportunity PARAMS ((Unit *unit));
extern int explore_reachable_cell PARAMS ((Unit *unit, int range));
extern int capture_useful_if_nearby PARAMS ((Unit *unit));
extern int capture_indep_if_nearby PARAMS ((Unit *unit));
extern void random_walk PARAMS ((Unit *unit));

extern TaskOutcome execute_task PARAMS ((Unit *unit));
extern TaskOutcome execute_task_aux PARAMS ((Unit *unit, Task *task));
extern void pop_task PARAMS ((Plan *plan));

extern void add_task PARAMS ((Unit *unit, int pos, Task *task));
extern void push_move_to_task PARAMS ((Unit *unit, int x, int y));
extern void set_move_to_task PARAMS ((Unit *unit, int x, int y));
extern void set_move_near_task PARAMS ((Unit *unit, int x, int y, int dist));
extern void push_move_near_task PARAMS ((Unit *unit, int x, int y, int dist));
extern void set_move_dir_task PARAMS ((Unit *unit, int dir, int n));
extern void set_build_task PARAMS ((Unit *unit, int u2, int run));
extern void push_build_task PARAMS ((Unit *unit, int u2, int run));
extern void push_research_task PARAMS ((Unit *unit, int u2, int n));
extern void set_hit_task PARAMS ((Unit *unit, int x, int y));
extern void push_specific_hit_task PARAMS ((Unit *unit, int x, int y,
					    int u, int s));
extern void set_specific_hit_task PARAMS ((Unit *unit, int x, int y,
					   int u, int s));
extern void push_hit_task PARAMS ((Unit *unit, int x, int y));
extern void set_capture_task PARAMS ((Unit *unit, int x, int y));
extern void push_capture_task PARAMS ((Unit *unit, int x, int y));
extern void set_disband_task PARAMS ((Unit *unit));
extern void set_resupply_task PARAMS ((Unit *unit, int m));
extern void push_occupy_task PARAMS ((Unit *unit, Unit *transport));
extern void push_pickup_task PARAMS ((Unit *unit, Unit *occ));
extern void push_produce_task PARAMS ((Unit *unit, int m, int n));
extern void set_sentry_task PARAMS ((Unit *unit, int n));
extern void push_sentry_task PARAMS ((Unit *unit, int n));

extern Feature *create_feature PARAMS ((char *typename, char *name));
extern void set_feature_type_name PARAMS ((Feature *feature, char *typename));
extern void set_feature_name PARAMS ((Feature *feature, char *name));
extern void destroy_feature PARAMS ((Feature *feature));
extern void renumber_features PARAMS ((void));

#ifdef DESIGNERS
extern void paint_cell PARAMS ((Side *side, int x, int y, int r, int t));
extern void paint_border PARAMS ((Side *side, int x, int y, int dir,
				  int t, int mode));
extern void paint_connection PARAMS ((Side *side, int x, int y, int dir,
				      int t, int mode));
extern void paint_coating PARAMS ((Side *side, int x, int y, int r,
				   int t, int depth));
extern void paint_people PARAMS ((Side *side, int x, int y, int r, int s));
extern void paint_control PARAMS ((Side *side, int x, int y, int r, int s));
extern void paint_feature PARAMS ((Side *side, int x, int y, int r, int f));
extern void paint_elevation PARAMS ((Side *side, int x, int y, int r,
				     int elev));
extern void paint_temperature PARAMS ((Side *side, int x, int y, int r,
				       int temp));
extern void paint_material PARAMS ((Side *side, int x, int y, int r,
				    int m, int amt));
extern void paint_clouds PARAMS ((Side *side, int x, int y, int r,
				  int cloudtype, int bot, int hgt));
extern void paint_winds PARAMS ((Side *side, int x, int y, int r,
				 int dir, int force));
#endif /* DESIGNERS */

extern void request_additional_side PARAMS ((char *playerspec));
