/* Generated by "gen_toolint.pl callwrap" */
#include "vg_include.h"

/* These are the parameterised functions in the core.  The default definitions
   are overridden by LD_PRELOADed skin version.  At the very least, a skin
   must define the fundamental template functions.  Depending on what needs
   are set, extra template functions will be used too.  Functions are
   grouped under the needs that govern their use.

   ------------------------------------------------------------------
   Fundamental template functions

   Do initialisation that can only be done after command line processing.
 */
void SK_(post_clo_init)(void)
{
   return (*VG_(tool_interface).tool_post_clo_init)();
}

/* Instrument a basic block.  Must be a true function, ie. the same input
   always results in the same output, because basic blocks can be
   retranslated.  Unless you're doing something really strange...
   'orig_addr' is the address of the first instruction in the block.
 */
UCodeBlock* SK_(instrument)(UCodeBlock* cb, Addr orig_addr)
{
   return (*VG_(tool_interface).tool_instrument)(cb, orig_addr);
}

/* Finish up, print out any results, etc.  `exitcode' is program's exit
   code.  The shadow (if the `shadow_regs' need is set) can be found with
   VG_(get_shadow_archreg)(R_EBX), since %ebx holds the argument to the
   exit() syscall.
 */
void SK_(fini)(Int exitcode)
{
   return (*VG_(tool_interface).tool_fini)(exitcode);
}


/* ------------------------------------------------------------------
   VG_(needs).core_errors

   (none needed)

   ------------------------------------------------------------------
   VG_(needs).skin_errors

   Identify if two errors are equal, or equal enough.  `res' indicates how
   close is "close enough".  `res' should be passed on as necessary, eg. if
   the Error's `extra' part contains an ExeContext, `res' should be
   passed to VG_(eq_ExeContext)() if the ExeContexts are considered.  Other
   than that, probably don't worry about it unless you have lots of very
   similar errors occurring.
 */
Bool SK_(eq_SkinError)(VgRes res, Error* e1, Error* e2)
{
   return (*VG_(tool_interface).tool_eq_SkinError)(res, e1, e2);
}

/* Print error context. */
void SK_(pp_SkinError)(Error* err)
{
   return (*VG_(tool_interface).tool_pp_SkinError)(err);
}

/* Should fill in any details that could be postponed until after the
   decision whether to ignore the error (ie. details not affecting the
   result of SK_(eq_SkinError)()).  This saves time when errors are ignored.
   Yuk.

   Return value: must be the size of the `extra' part in bytes -- used by
   the core to make a copy.
 */
UInt SK_(update_extra)(Error* err)
{
   return (*VG_(tool_interface).tool_update_extra)(err);
}

/* Return value indicates recognition.  If recognised, must set skind using
   VG_(set_supp_kind)().
 */
Bool SK_(recognised_suppression)(Char* name, Supp* su)
{
   return (*VG_(tool_interface).tool_recognised_suppression)(name, su);
}

/* Read any extra info for this suppression kind.  Most likely for filling
   in the `extra' and `string' parts (with VG_(set_supp_{extra, string})())
   of a suppression if necessary.  Should return False if a syntax error
   occurred, True otherwise.
 */
Bool SK_(read_extra_suppression_info)(Int fd, Char* buf, Int nBuf, Supp* su)
{
   return (*VG_(tool_interface).tool_read_extra_suppression_info)(fd, buf, nBuf, su);
}

/* This should just check the kinds match and maybe some stuff in the
   `string' and `extra' field if appropriate (using VG_(get_supp_*)() to
   get the relevant suppression parts).
 */
Bool SK_(error_matches_suppression)(Error* err, Supp* su)
{
   return (*VG_(tool_interface).tool_error_matches_suppression)(err, su);
}

/* This should return the suppression name, for --gen-suppressions, or NULL
   if that error type cannot be suppressed.  This is the inverse of
   SK_(recognised_suppression)().
 */
Char* SK_(get_error_name)(Error* err)
{
   return (*VG_(tool_interface).tool_get_error_name)(err);
}

/* This should print any extra info for the error, for --gen-suppressions,
   including the newline.  This is the inverse of
   SK_(read_extra_suppression_info)().
 */
void SK_(print_extra_suppression_info)(Error* err)
{
   return (*VG_(tool_interface).tool_print_extra_suppression_info)(err);
}


/* ------------------------------------------------------------------
   VG_(needs).basic_block_discards

   Should discard any information that pertains to specific basic blocks
   or instructions within the address range given.
 */
void SK_(discard_basic_block_info)(Addr a, UInt size)
{
   return (*VG_(tool_interface).tool_discard_basic_block_info)(a, size);
}


/* ------------------------------------------------------------------
   VG_(needs).shadow_regs

   No functions must be defined, but the post_reg[s]_write_* events should
   be tracked.

   ------------------------------------------------------------------
   VG_(needs).command_line_options

   Return True if option was recognised.  Presumably sets some state to
   record the option as well.
 */
Bool SK_(process_cmd_line_option)(Char* argv)
{
   return (*VG_(tool_interface).tool_process_cmd_line_option)(argv);
}

/* Print out command line usage for options for normal skin operation. */
void SK_(print_usage)(void)
{
   return (*VG_(tool_interface).tool_print_usage)();
}

/* Print out command line usage for options for debugging the skin. */
void SK_(print_debug_usage)(void)
{
   return (*VG_(tool_interface).tool_print_debug_usage)();
}

/* ------------------------------------------------------------------
   VG_(needs).client_requests

   If using client requests, the number of the first request should be equal
   to VG_USERREQ_SKIN_BASE('X', 'Y'), where 'X' and 'Y' form a suitable two
   character identification for the string.  The second and subsequent
   requests should follow.

   This function should use the VG_IS_SKIN_USERREQ macro (in
   include/valgrind.h) to first check if it's a request for this skin.  Then
   should handle it if it's recognised (and return True), or return False if
   not recognised.  arg_block[0] holds the request number, any further args
   from the request are in arg_block[1..].  'ret' is for the return value...
   it should probably be filled, if only with 0.
 */
Bool SK_(handle_client_request)(ThreadId tid, UInt* arg_block, UInt* ret)
{
   return (*VG_(tool_interface).tool_handle_client_request)(tid, arg_block, ret);
}


/* ------------------------------------------------------------------
   VG_(needs).extends_UCode

   'X' prefix indicates eXtended UCode.
 */
Int SK_(get_Xreg_usage)(UInstr* u, Tag tag, Int* regs, Bool* isWrites)
{
   return (*VG_(tool_interface).tool_get_Xreg_usage)(u, tag, regs, isWrites);
}
void SK_(emit_XUInstr)(UInstr* u, RRegSet regs_live_before)
{
   return (*VG_(tool_interface).tool_emit_XUInstr)(u, regs_live_before);
}
Bool SK_(sane_XUInstr)(Bool beforeRA, Bool beforeLiveness, UInstr* u)
{
   return (*VG_(tool_interface).tool_sane_XUInstr)(beforeRA, beforeLiveness, u);
}
Char * SK_(name_XUOpcode)(Opcode opc)
{
   return (*VG_(tool_interface).tool_name_XUOpcode)(opc);
}
void SK_(pp_XUInstr)(UInstr* u)
{
   return (*VG_(tool_interface).tool_pp_XUInstr)(u);
}


/* ------------------------------------------------------------------
   VG_(needs).syscall_wrapper

   If either of the pre_ functions malloc() something to return, the
   corresponding post_ function had better free() it!

 */
void * SK_(pre_syscall)(ThreadId tid, UInt syscallno, Bool is_blocking)
{
   return (*VG_(tool_interface).tool_pre_syscall)(tid, syscallno, is_blocking);
}
void SK_(post_syscall)(ThreadId tid, UInt syscallno, void* pre_result, Int res, Bool is_blocking)
{
   return (*VG_(tool_interface).tool_post_syscall)(tid, syscallno, pre_result, res, is_blocking);
}


/* ---------------------------------------------------------------------
     VG_(needs).sanity_checks

   Can be useful for ensuring a skin's correctness.  SK_(cheap_sanity_check)
   is called very frequently;  SK_(expensive_sanity_check) is called less
   frequently and can be more involved.
 */
Bool SK_(cheap_sanity_check)(void)
{
   return (*VG_(tool_interface).tool_cheap_sanity_check)();
}
Bool SK_(expensive_sanity_check)(void)
{
   return (*VG_(tool_interface).tool_expensive_sanity_check)();
}


/* ================================================================================
   Event tracking functions

   Events happening in core to track.  To be notified, pass a callback
   function to the appropriate function.  To ignore an event, don't do
   anything (default is for events to be ignored).

   Note that most events aren't passed a ThreadId.  To find out the ThreadId
   of the affected thread, use VG_(get_current_or_recent_tid)().  For the
   ones passed a ThreadId, use that instead, since
   VG_(get_current_or_recent_tid)() might not give the right ThreadId in
   that case.

   Memory events (Nb: to track heap allocation/freeing, a skin must replace
   malloc() et al.  See above how to do this.)

   These ones occur at startup, upon some signals, and upon some syscalls
 */
void SK_(new_mem_startup)(Addr a, UInt len, Bool rr, Bool ww, Bool xx)
{
   return (*VG_(tool_interface).track_new_mem_startup)(a, len, rr, ww, xx);
}
void SK_(new_mem_stack_signal)(Addr a, UInt len)
{
   return (*VG_(tool_interface).track_new_mem_stack_signal)(a, len);
}
void SK_(new_mem_brk)(Addr a, UInt len)
{
   return (*VG_(tool_interface).track_new_mem_brk)(a, len);
}
void SK_(new_mem_mmap)(Addr a, UInt len, Bool rr, Bool ww, Bool xx)
{
   return (*VG_(tool_interface).track_new_mem_mmap)(a, len, rr, ww, xx);
}

void SK_(copy_mem_remap)(Addr from, Addr to, UInt len)
{
   return (*VG_(tool_interface).track_copy_mem_remap)(from, to, len);
}
void SK_(change_mem_mprotect)(Addr a, UInt len, Bool rr, Bool ww, Bool xx)
{
   return (*VG_(tool_interface).track_change_mem_mprotect)(a, len, rr, ww, xx);
}
void SK_(die_mem_stack_signal)(Addr a, UInt len)
{
   return (*VG_(tool_interface).track_die_mem_stack_signal)(a, len);
}
void SK_(die_mem_brk)(Addr a, UInt len)
{
   return (*VG_(tool_interface).track_die_mem_brk)(a, len);
}
void SK_(die_mem_munmap)(Addr a, UInt len)
{
   return (*VG_(tool_interface).track_die_mem_munmap)(a, len);
}

/* These ones are called when %esp changes.  A skin could track these itself
   (except for ban_mem_stack) but it's much easier to use the core's help.

   The specialised ones are called in preference to the general one, if they
   are defined.  These functions are called a lot if they are used, so
   specialising can optimise things significantly.  If any of the
   specialised cases are defined, the general case must be defined too.

   Nb: they must all use the __attribute__((regparm(n))) attribute.
 */
void SK_(new_mem_stack_4)(Addr new_ESP)
{
   return (*VG_(tool_interface).track_new_mem_stack_4)(new_ESP);
}
void SK_(new_mem_stack_8)(Addr new_ESP)
{
   return (*VG_(tool_interface).track_new_mem_stack_8)(new_ESP);
}
void SK_(new_mem_stack_12)(Addr new_ESP)
{
   return (*VG_(tool_interface).track_new_mem_stack_12)(new_ESP);
}
void SK_(new_mem_stack_16)(Addr new_ESP)
{
   return (*VG_(tool_interface).track_new_mem_stack_16)(new_ESP);
}
void SK_(new_mem_stack_32)(Addr new_ESP)
{
   return (*VG_(tool_interface).track_new_mem_stack_32)(new_ESP);
}
void SK_(new_mem_stack)(Addr a, UInt len)
{
   return (*VG_(tool_interface).track_new_mem_stack)(a, len);
}

void SK_(die_mem_stack_4)(Addr die_ESP)
{
   return (*VG_(tool_interface).track_die_mem_stack_4)(die_ESP);
}
void SK_(die_mem_stack_8)(Addr die_ESP)
{
   return (*VG_(tool_interface).track_die_mem_stack_8)(die_ESP);
}
void SK_(die_mem_stack_12)(Addr die_ESP)
{
   return (*VG_(tool_interface).track_die_mem_stack_12)(die_ESP);
}
void SK_(die_mem_stack_16)(Addr die_ESP)
{
   return (*VG_(tool_interface).track_die_mem_stack_16)(die_ESP);
}
void SK_(die_mem_stack_32)(Addr die_ESP)
{
   return (*VG_(tool_interface).track_die_mem_stack_32)(die_ESP);
}
void SK_(die_mem_stack)(Addr a, UInt len)
{
   return (*VG_(tool_interface).track_die_mem_stack)(a, len);
}

/* Used for redzone at end of thread stacks */
void SK_(ban_mem_stack)(Addr a, UInt len)
{
   return (*VG_(tool_interface).track_ban_mem_stack)(a, len);
}

/* These ones occur around syscalls, signal handling, etc */
void SK_(pre_mem_read)(CorePart part, ThreadId tid, Char* s, Addr a, UInt size)
{
   return (*VG_(tool_interface).track_pre_mem_read)(part, tid, s, a, size);
}
void SK_(pre_mem_read_asciiz)(CorePart part, ThreadId tid, Char* s, Addr a)
{
   return (*VG_(tool_interface).track_pre_mem_read_asciiz)(part, tid, s, a);
}
void SK_(pre_mem_write)(CorePart part, ThreadId tid, Char* s, Addr a, UInt size)
{
   return (*VG_(tool_interface).track_pre_mem_write)(part, tid, s, a, size);
}
/* Not implemented yet -- have to add in lots of places, which is a
   pain.  Won't bother unless/until there's a need.
   void (*post_mem_read)  ( ThreadState* tst, Char* s, Addr a, UInt size );
 */
void SK_(post_mem_write)(Addr a, UInt size)
{
   return (*VG_(tool_interface).track_post_mem_write)(a, size);
}


/* Register events -- if `shadow_regs' need is set, all should probably be
   used.  Use VG_(set_thread_shadow_archreg)() to set the shadow of the
   changed register.

   Use VG_(set_shadow_archreg)() to set the eight general purpose regs,
   and use VG_(set_shadow_eflags)() to set eflags.
 */
void SK_(post_regs_write_init)(void)
{
   return (*VG_(tool_interface).track_post_regs_write_init)();
}

/* Use VG_(set_thread_shadow_archreg)() to set the shadow regs for these
   events.
 */
void SK_(post_reg_write_syscall_return)(ThreadId tid, UInt reg)
{
   return (*VG_(tool_interface).track_post_reg_write_syscall_return)(tid, reg);
}
void SK_(post_reg_write_deliver_signal)(ThreadId tid, UInt reg)
{
   return (*VG_(tool_interface).track_post_reg_write_deliver_signal)(tid, reg);
}
void SK_(post_reg_write_pthread_return)(ThreadId tid, UInt reg)
{
   return (*VG_(tool_interface).track_post_reg_write_pthread_return)(tid, reg);
}
void SK_(post_reg_write_clientreq_return)(ThreadId tid, UInt reg)
{
   return (*VG_(tool_interface).track_post_reg_write_clientreq_return)(tid, reg);
}
/* This one is called for malloc() et al if they are replaced by a skin. */
void SK_(post_reg_write_clientcall_return)(ThreadId tid, UInt reg, Addr f)
{
   return (*VG_(tool_interface).track_post_reg_write_clientcall_return)(tid, reg, f);
}


/* Scheduler events (not exhaustive) */
void SK_(thread_run)(ThreadId tid)
{
   return (*VG_(tool_interface).track_thread_run)(tid);
}


/* Thread events (not exhaustive)

   Called during thread create, before the new thread has run any
   instructions (or touched any memory).
 */
void SK_(post_thread_create)(ThreadId tid, ThreadId child)
{
   return (*VG_(tool_interface).track_post_thread_create)(tid, child);
}
void SK_(post_thread_join)(ThreadId joiner, ThreadId joinee)
{
   return (*VG_(tool_interface).track_post_thread_join)(joiner, joinee);
}


/* Mutex events (not exhaustive)
   "void *mutex" is really a pthread_mutex *

   Called before a thread can block while waiting for a mutex (called
   regardless of whether the thread will block or not).
 */
void SK_(pre_mutex_lock)(ThreadId tid, void* mutex)
{
   return (*VG_(tool_interface).track_pre_mutex_lock)(tid, mutex);
}
/* Called once the thread actually holds the mutex (always paired with
   pre_mutex_lock).
 */
void SK_(post_mutex_lock)(ThreadId tid, void* mutex)
{
   return (*VG_(tool_interface).track_post_mutex_lock)(tid, mutex);
}
/* Called after a thread has released a mutex (no need for a corresponding
   pre_mutex_unlock, because unlocking can't block).
 */
void SK_(post_mutex_unlock)(ThreadId tid, void* mutex)
{
   return (*VG_(tool_interface).track_post_mutex_unlock)(tid, mutex);
}

/* Signal events (not exhaustive)

   ... pre_send_signal, post_send_signal ...

   Called before a signal is delivered;  `alt_stack' indicates if it is
   delivered on an alternative stack. 
 */
void SK_(pre_deliver_signal)(ThreadId tid, Int sigNo, Bool alt_stack)
{
   return (*VG_(tool_interface).track_pre_deliver_signal)(tid, sigNo, alt_stack);
}
/* Called after a signal is delivered.  Nb: unfortunately, if the signal
   handler longjmps, this won't be called.
 */
void SK_(post_deliver_signal)(ThreadId tid, Int sigNo)
{
   return (*VG_(tool_interface).track_post_deliver_signal)(tid, sigNo);
}


/* Others... condition variable...
   ...

   Shadow memory management
 */
void SK_(init_shadow_page)(Addr p)
{
   return (*VG_(tool_interface).track_init_shadow_page)(p);
}

/* ================================================================================
   malloc and friends
 */
void* SK_(malloc)(Int n)
{
   return (*VG_(tool_interface).malloc_malloc)(n);
}
void* SK_(__builtin_new)(Int n)
{
   return (*VG_(tool_interface).malloc___builtin_new)(n);
}
void* SK_(__builtin_vec_new)(Int n)
{
   return (*VG_(tool_interface).malloc___builtin_vec_new)(n);
}
void* SK_(memalign)(Int align, Int n)
{
   return (*VG_(tool_interface).malloc_memalign)(align, n);
}
void* SK_(calloc)(Int nmemb, Int n)
{
   return (*VG_(tool_interface).malloc_calloc)(nmemb, n);
}
void SK_(free)(void* p)
{
   return (*VG_(tool_interface).malloc_free)(p);
}
void SK_(__builtin_delete)(void* p)
{
   return (*VG_(tool_interface).malloc___builtin_delete)(p);
}
void SK_(__builtin_vec_delete)(void* p)
{
   return (*VG_(tool_interface).malloc___builtin_vec_delete)(p);
}
void* SK_(realloc)(void* p, Int size)
{
   return (*VG_(tool_interface).malloc_realloc)(p, size);
}
/* Generated by "gen_toolint.pl missingfuncs" */
#include "vg_include.h"

   /* These are the parameterised functions in the core.  The default definitions
      are overridden by LD_PRELOADed skin version.  At the very least, a skin
      must define the fundamental template functions.  Depending on what needs
      are set, extra template functions will be used too.  Functions are
      grouped under the needs that govern their use.
   
      ------------------------------------------------------------------
      Fundamental template functions
   
      Do initialisation that can only be done after command line processing.
    */
static void missing_tool_post_clo_init(void) {
   VG_(missing_tool_func)("tool_post_clo_init");
}
Bool VG_(defined_post_clo_init)(void) {
   return VG_(tool_interface).tool_post_clo_init != missing_tool_post_clo_init;
}


   /* Instrument a basic block.  Must be a true function, ie. the same input
      always results in the same output, because basic blocks can be
      retranslated.  Unless you're doing something really strange...
      'orig_addr' is the address of the first instruction in the block.
    */
static UCodeBlock* missing_tool_instrument(UCodeBlock* cb, Addr orig_addr) {
   VG_(missing_tool_func)("tool_instrument");
}
Bool VG_(defined_instrument)(void) {
   return VG_(tool_interface).tool_instrument != missing_tool_instrument;
}


   /* Finish up, print out any results, etc.  `exitcode' is program's exit
      code.  The shadow (if the `shadow_regs' need is set) can be found with
      VG_(get_shadow_archreg)(R_EBX), since %ebx holds the argument to the
      exit() syscall.
    */
static void missing_tool_fini(Int exitcode) {
   VG_(missing_tool_func)("tool_fini");
}
Bool VG_(defined_fini)(void) {
   return VG_(tool_interface).tool_fini != missing_tool_fini;
}



   /* ------------------------------------------------------------------
      VG_(needs).core_errors
   
      (none needed)
   
      ------------------------------------------------------------------
      VG_(needs).skin_errors
   
      Identify if two errors are equal, or equal enough.  `res' indicates how
      close is "close enough".  `res' should be passed on as necessary, eg. if
      the Error's `extra' part contains an ExeContext, `res' should be
      passed to VG_(eq_ExeContext)() if the ExeContexts are considered.  Other
      than that, probably don't worry about it unless you have lots of very
      similar errors occurring.
    */
static Bool missing_tool_eq_SkinError(VgRes res, Error* e1, Error* e2) {
   VG_(missing_tool_func)("tool_eq_SkinError");
}
Bool VG_(defined_eq_SkinError)(void) {
   return VG_(tool_interface).tool_eq_SkinError != missing_tool_eq_SkinError;
}


   /* Print error context. */
static void missing_tool_pp_SkinError(Error* err) {
   VG_(missing_tool_func)("tool_pp_SkinError");
}
Bool VG_(defined_pp_SkinError)(void) {
   return VG_(tool_interface).tool_pp_SkinError != missing_tool_pp_SkinError;
}


   /* Should fill in any details that could be postponed until after the
      decision whether to ignore the error (ie. details not affecting the
      result of SK_(eq_SkinError)()).  This saves time when errors are ignored.
      Yuk.
   
      Return value: must be the size of the `extra' part in bytes -- used by
      the core to make a copy.
    */
static UInt missing_tool_update_extra(Error* err) {
   VG_(missing_tool_func)("tool_update_extra");
}
Bool VG_(defined_update_extra)(void) {
   return VG_(tool_interface).tool_update_extra != missing_tool_update_extra;
}


   /* Return value indicates recognition.  If recognised, must set skind using
      VG_(set_supp_kind)().
    */
static Bool missing_tool_recognised_suppression(Char* name, Supp* su) {
   VG_(missing_tool_func)("tool_recognised_suppression");
}
Bool VG_(defined_recognised_suppression)(void) {
   return VG_(tool_interface).tool_recognised_suppression != missing_tool_recognised_suppression;
}


   /* Read any extra info for this suppression kind.  Most likely for filling
      in the `extra' and `string' parts (with VG_(set_supp_{extra, string})())
      of a suppression if necessary.  Should return False if a syntax error
      occurred, True otherwise.
    */
static Bool missing_tool_read_extra_suppression_info(Int fd, Char* buf, Int nBuf, Supp* su) {
   VG_(missing_tool_func)("tool_read_extra_suppression_info");
}
Bool VG_(defined_read_extra_suppression_info)(void) {
   return VG_(tool_interface).tool_read_extra_suppression_info != missing_tool_read_extra_suppression_info;
}


   /* This should just check the kinds match and maybe some stuff in the
      `string' and `extra' field if appropriate (using VG_(get_supp_*)() to
      get the relevant suppression parts).
    */
static Bool missing_tool_error_matches_suppression(Error* err, Supp* su) {
   VG_(missing_tool_func)("tool_error_matches_suppression");
}
Bool VG_(defined_error_matches_suppression)(void) {
   return VG_(tool_interface).tool_error_matches_suppression != missing_tool_error_matches_suppression;
}


   /* This should return the suppression name, for --gen-suppressions, or NULL
      if that error type cannot be suppressed.  This is the inverse of
      SK_(recognised_suppression)().
    */
static Char* missing_tool_get_error_name(Error* err) {
   VG_(missing_tool_func)("tool_get_error_name");
}
Bool VG_(defined_get_error_name)(void) {
   return VG_(tool_interface).tool_get_error_name != missing_tool_get_error_name;
}


   /* This should print any extra info for the error, for --gen-suppressions,
      including the newline.  This is the inverse of
      SK_(read_extra_suppression_info)().
    */
static void missing_tool_print_extra_suppression_info(Error* err) {
   VG_(missing_tool_func)("tool_print_extra_suppression_info");
}
Bool VG_(defined_print_extra_suppression_info)(void) {
   return VG_(tool_interface).tool_print_extra_suppression_info != missing_tool_print_extra_suppression_info;
}



   /* ------------------------------------------------------------------
      VG_(needs).basic_block_discards
   
      Should discard any information that pertains to specific basic blocks
      or instructions within the address range given.
    */
static void missing_tool_discard_basic_block_info(Addr a, UInt size) {
   VG_(missing_tool_func)("tool_discard_basic_block_info");
}
Bool VG_(defined_discard_basic_block_info)(void) {
   return VG_(tool_interface).tool_discard_basic_block_info != missing_tool_discard_basic_block_info;
}



   /* ------------------------------------------------------------------
      VG_(needs).shadow_regs
   
      No functions must be defined, but the post_reg[s]_write_* events should
      be tracked.
   
      ------------------------------------------------------------------
      VG_(needs).command_line_options
   
      Return True if option was recognised.  Presumably sets some state to
      record the option as well.
    */
static Bool missing_tool_process_cmd_line_option(Char* argv) {
   VG_(missing_tool_func)("tool_process_cmd_line_option");
}
Bool VG_(defined_process_cmd_line_option)(void) {
   return VG_(tool_interface).tool_process_cmd_line_option != missing_tool_process_cmd_line_option;
}


   /* Print out command line usage for options for normal skin operation. */
static void missing_tool_print_usage(void) {
   VG_(missing_tool_func)("tool_print_usage");
}
Bool VG_(defined_print_usage)(void) {
   return VG_(tool_interface).tool_print_usage != missing_tool_print_usage;
}


   /* Print out command line usage for options for debugging the skin. */
static void missing_tool_print_debug_usage(void) {
   VG_(missing_tool_func)("tool_print_debug_usage");
}
Bool VG_(defined_print_debug_usage)(void) {
   return VG_(tool_interface).tool_print_debug_usage != missing_tool_print_debug_usage;
}


   /* ------------------------------------------------------------------
      VG_(needs).client_requests
   
      If using client requests, the number of the first request should be equal
      to VG_USERREQ_SKIN_BASE('X', 'Y'), where 'X' and 'Y' form a suitable two
      character identification for the string.  The second and subsequent
      requests should follow.
   
      This function should use the VG_IS_SKIN_USERREQ macro (in
      include/valgrind.h) to first check if it's a request for this skin.  Then
      should handle it if it's recognised (and return True), or return False if
      not recognised.  arg_block[0] holds the request number, any further args
      from the request are in arg_block[1..].  'ret' is for the return value...
      it should probably be filled, if only with 0.
    */
static Bool missing_tool_handle_client_request(ThreadId tid, UInt* arg_block, UInt* ret) {
   VG_(missing_tool_func)("tool_handle_client_request");
}
Bool VG_(defined_handle_client_request)(void) {
   return VG_(tool_interface).tool_handle_client_request != missing_tool_handle_client_request;
}



   /* ------------------------------------------------------------------
      VG_(needs).extends_UCode
   
      'X' prefix indicates eXtended UCode.
    */
static Int missing_tool_get_Xreg_usage(UInstr* u, Tag tag, Int* regs, Bool* isWrites) {
   VG_(missing_tool_func)("tool_get_Xreg_usage");
}
Bool VG_(defined_get_Xreg_usage)(void) {
   return VG_(tool_interface).tool_get_Xreg_usage != missing_tool_get_Xreg_usage;
}

static void missing_tool_emit_XUInstr(UInstr* u, RRegSet regs_live_before) {
   VG_(missing_tool_func)("tool_emit_XUInstr");
}
Bool VG_(defined_emit_XUInstr)(void) {
   return VG_(tool_interface).tool_emit_XUInstr != missing_tool_emit_XUInstr;
}

static Bool missing_tool_sane_XUInstr(Bool beforeRA, Bool beforeLiveness, UInstr* u) {
   VG_(missing_tool_func)("tool_sane_XUInstr");
}
Bool VG_(defined_sane_XUInstr)(void) {
   return VG_(tool_interface).tool_sane_XUInstr != missing_tool_sane_XUInstr;
}

static Char * missing_tool_name_XUOpcode(Opcode opc) {
   VG_(missing_tool_func)("tool_name_XUOpcode");
}
Bool VG_(defined_name_XUOpcode)(void) {
   return VG_(tool_interface).tool_name_XUOpcode != missing_tool_name_XUOpcode;
}

static void missing_tool_pp_XUInstr(UInstr* u) {
   VG_(missing_tool_func)("tool_pp_XUInstr");
}
Bool VG_(defined_pp_XUInstr)(void) {
   return VG_(tool_interface).tool_pp_XUInstr != missing_tool_pp_XUInstr;
}



   /* ------------------------------------------------------------------
      VG_(needs).syscall_wrapper
   
      If either of the pre_ functions malloc() something to return, the
      corresponding post_ function had better free() it!
   
    */
static void * missing_tool_pre_syscall(ThreadId tid, UInt syscallno, Bool is_blocking) {
   VG_(missing_tool_func)("tool_pre_syscall");
}
Bool VG_(defined_pre_syscall)(void) {
   return VG_(tool_interface).tool_pre_syscall != missing_tool_pre_syscall;
}

static void missing_tool_post_syscall(ThreadId tid, UInt syscallno, void* pre_result, Int res, Bool is_blocking) {
   VG_(missing_tool_func)("tool_post_syscall");
}
Bool VG_(defined_post_syscall)(void) {
   return VG_(tool_interface).tool_post_syscall != missing_tool_post_syscall;
}



   /* ---------------------------------------------------------------------
        VG_(needs).sanity_checks
   
      Can be useful for ensuring a skin's correctness.  SK_(cheap_sanity_check)
      is called very frequently;  SK_(expensive_sanity_check) is called less
      frequently and can be more involved.
    */
static Bool missing_tool_cheap_sanity_check(void) {
   VG_(missing_tool_func)("tool_cheap_sanity_check");
}
Bool VG_(defined_cheap_sanity_check)(void) {
   return VG_(tool_interface).tool_cheap_sanity_check != missing_tool_cheap_sanity_check;
}

static Bool missing_tool_expensive_sanity_check(void) {
   VG_(missing_tool_func)("tool_expensive_sanity_check");
}
Bool VG_(defined_expensive_sanity_check)(void) {
   return VG_(tool_interface).tool_expensive_sanity_check != missing_tool_expensive_sanity_check;
}



   /* ================================================================================
      Event tracking functions
   
      Events happening in core to track.  To be notified, pass a callback
      function to the appropriate function.  To ignore an event, don't do
      anything (default is for events to be ignored).
   
      Note that most events aren't passed a ThreadId.  To find out the ThreadId
      of the affected thread, use VG_(get_current_or_recent_tid)().  For the
      ones passed a ThreadId, use that instead, since
      VG_(get_current_or_recent_tid)() might not give the right ThreadId in
      that case.
   
      Memory events (Nb: to track heap allocation/freeing, a skin must replace
      malloc() et al.  See above how to do this.)
   
      These ones occur at startup, upon some signals, and upon some syscalls
    */
static void missing_track_new_mem_startup(Addr a, UInt len, Bool rr, Bool ww, Bool xx) {
   VG_(missing_tool_func)("track_new_mem_startup");
}
Bool VG_(defined_new_mem_startup)(void) {
   return VG_(tool_interface).track_new_mem_startup != missing_track_new_mem_startup;
}

static void missing_track_new_mem_stack_signal(Addr a, UInt len) {
   VG_(missing_tool_func)("track_new_mem_stack_signal");
}
Bool VG_(defined_new_mem_stack_signal)(void) {
   return VG_(tool_interface).track_new_mem_stack_signal != missing_track_new_mem_stack_signal;
}

static void missing_track_new_mem_brk(Addr a, UInt len) {
   VG_(missing_tool_func)("track_new_mem_brk");
}
Bool VG_(defined_new_mem_brk)(void) {
   return VG_(tool_interface).track_new_mem_brk != missing_track_new_mem_brk;
}

static void missing_track_new_mem_mmap(Addr a, UInt len, Bool rr, Bool ww, Bool xx) {
   VG_(missing_tool_func)("track_new_mem_mmap");
}
Bool VG_(defined_new_mem_mmap)(void) {
   return VG_(tool_interface).track_new_mem_mmap != missing_track_new_mem_mmap;
}


static void missing_track_copy_mem_remap(Addr from, Addr to, UInt len) {
   VG_(missing_tool_func)("track_copy_mem_remap");
}
Bool VG_(defined_copy_mem_remap)(void) {
   return VG_(tool_interface).track_copy_mem_remap != missing_track_copy_mem_remap;
}

static void missing_track_change_mem_mprotect(Addr a, UInt len, Bool rr, Bool ww, Bool xx) {
   VG_(missing_tool_func)("track_change_mem_mprotect");
}
Bool VG_(defined_change_mem_mprotect)(void) {
   return VG_(tool_interface).track_change_mem_mprotect != missing_track_change_mem_mprotect;
}

static void missing_track_die_mem_stack_signal(Addr a, UInt len) {
   VG_(missing_tool_func)("track_die_mem_stack_signal");
}
Bool VG_(defined_die_mem_stack_signal)(void) {
   return VG_(tool_interface).track_die_mem_stack_signal != missing_track_die_mem_stack_signal;
}

static void missing_track_die_mem_brk(Addr a, UInt len) {
   VG_(missing_tool_func)("track_die_mem_brk");
}
Bool VG_(defined_die_mem_brk)(void) {
   return VG_(tool_interface).track_die_mem_brk != missing_track_die_mem_brk;
}

static void missing_track_die_mem_munmap(Addr a, UInt len) {
   VG_(missing_tool_func)("track_die_mem_munmap");
}
Bool VG_(defined_die_mem_munmap)(void) {
   return VG_(tool_interface).track_die_mem_munmap != missing_track_die_mem_munmap;
}


   /* These ones are called when %esp changes.  A skin could track these itself
      (except for ban_mem_stack) but it's much easier to use the core's help.
   
      The specialised ones are called in preference to the general one, if they
      are defined.  These functions are called a lot if they are used, so
      specialising can optimise things significantly.  If any of the
      specialised cases are defined, the general case must be defined too.
   
      Nb: they must all use the __attribute__((regparm(n))) attribute.
    */
static void missing_track_new_mem_stack_4(Addr new_ESP) {
   VG_(missing_tool_func)("track_new_mem_stack_4");
}
Bool VG_(defined_new_mem_stack_4)(void) {
   return VG_(tool_interface).track_new_mem_stack_4 != missing_track_new_mem_stack_4;
}

static void missing_track_new_mem_stack_8(Addr new_ESP) {
   VG_(missing_tool_func)("track_new_mem_stack_8");
}
Bool VG_(defined_new_mem_stack_8)(void) {
   return VG_(tool_interface).track_new_mem_stack_8 != missing_track_new_mem_stack_8;
}

static void missing_track_new_mem_stack_12(Addr new_ESP) {
   VG_(missing_tool_func)("track_new_mem_stack_12");
}
Bool VG_(defined_new_mem_stack_12)(void) {
   return VG_(tool_interface).track_new_mem_stack_12 != missing_track_new_mem_stack_12;
}

static void missing_track_new_mem_stack_16(Addr new_ESP) {
   VG_(missing_tool_func)("track_new_mem_stack_16");
}
Bool VG_(defined_new_mem_stack_16)(void) {
   return VG_(tool_interface).track_new_mem_stack_16 != missing_track_new_mem_stack_16;
}

static void missing_track_new_mem_stack_32(Addr new_ESP) {
   VG_(missing_tool_func)("track_new_mem_stack_32");
}
Bool VG_(defined_new_mem_stack_32)(void) {
   return VG_(tool_interface).track_new_mem_stack_32 != missing_track_new_mem_stack_32;
}

static void missing_track_new_mem_stack(Addr a, UInt len) {
   VG_(missing_tool_func)("track_new_mem_stack");
}
Bool VG_(defined_new_mem_stack)(void) {
   return VG_(tool_interface).track_new_mem_stack != missing_track_new_mem_stack;
}


static void missing_track_die_mem_stack_4(Addr die_ESP) {
   VG_(missing_tool_func)("track_die_mem_stack_4");
}
Bool VG_(defined_die_mem_stack_4)(void) {
   return VG_(tool_interface).track_die_mem_stack_4 != missing_track_die_mem_stack_4;
}

static void missing_track_die_mem_stack_8(Addr die_ESP) {
   VG_(missing_tool_func)("track_die_mem_stack_8");
}
Bool VG_(defined_die_mem_stack_8)(void) {
   return VG_(tool_interface).track_die_mem_stack_8 != missing_track_die_mem_stack_8;
}

static void missing_track_die_mem_stack_12(Addr die_ESP) {
   VG_(missing_tool_func)("track_die_mem_stack_12");
}
Bool VG_(defined_die_mem_stack_12)(void) {
   return VG_(tool_interface).track_die_mem_stack_12 != missing_track_die_mem_stack_12;
}

static void missing_track_die_mem_stack_16(Addr die_ESP) {
   VG_(missing_tool_func)("track_die_mem_stack_16");
}
Bool VG_(defined_die_mem_stack_16)(void) {
   return VG_(tool_interface).track_die_mem_stack_16 != missing_track_die_mem_stack_16;
}

static void missing_track_die_mem_stack_32(Addr die_ESP) {
   VG_(missing_tool_func)("track_die_mem_stack_32");
}
Bool VG_(defined_die_mem_stack_32)(void) {
   return VG_(tool_interface).track_die_mem_stack_32 != missing_track_die_mem_stack_32;
}

static void missing_track_die_mem_stack(Addr a, UInt len) {
   VG_(missing_tool_func)("track_die_mem_stack");
}
Bool VG_(defined_die_mem_stack)(void) {
   return VG_(tool_interface).track_die_mem_stack != missing_track_die_mem_stack;
}


   /* Used for redzone at end of thread stacks */
static void missing_track_ban_mem_stack(Addr a, UInt len) {
   VG_(missing_tool_func)("track_ban_mem_stack");
}
Bool VG_(defined_ban_mem_stack)(void) {
   return VG_(tool_interface).track_ban_mem_stack != missing_track_ban_mem_stack;
}


   /* These ones occur around syscalls, signal handling, etc */
static void missing_track_pre_mem_read(CorePart part, ThreadId tid, Char* s, Addr a, UInt size) {
   VG_(missing_tool_func)("track_pre_mem_read");
}
Bool VG_(defined_pre_mem_read)(void) {
   return VG_(tool_interface).track_pre_mem_read != missing_track_pre_mem_read;
}

static void missing_track_pre_mem_read_asciiz(CorePart part, ThreadId tid, Char* s, Addr a) {
   VG_(missing_tool_func)("track_pre_mem_read_asciiz");
}
Bool VG_(defined_pre_mem_read_asciiz)(void) {
   return VG_(tool_interface).track_pre_mem_read_asciiz != missing_track_pre_mem_read_asciiz;
}

static void missing_track_pre_mem_write(CorePart part, ThreadId tid, Char* s, Addr a, UInt size) {
   VG_(missing_tool_func)("track_pre_mem_write");
}
Bool VG_(defined_pre_mem_write)(void) {
   return VG_(tool_interface).track_pre_mem_write != missing_track_pre_mem_write;
}

   /* Not implemented yet -- have to add in lots of places, which is a
      pain.  Won't bother unless/until there's a need.
      void (*post_mem_read)  ( ThreadState* tst, Char* s, Addr a, UInt size );
    */
static void missing_track_post_mem_write(Addr a, UInt size) {
   VG_(missing_tool_func)("track_post_mem_write");
}
Bool VG_(defined_post_mem_write)(void) {
   return VG_(tool_interface).track_post_mem_write != missing_track_post_mem_write;
}



   /* Register events -- if `shadow_regs' need is set, all should probably be
      used.  Use VG_(set_thread_shadow_archreg)() to set the shadow of the
      changed register.
   
      Use VG_(set_shadow_archreg)() to set the eight general purpose regs,
      and use VG_(set_shadow_eflags)() to set eflags.
    */
static void missing_track_post_regs_write_init(void) {
   VG_(missing_tool_func)("track_post_regs_write_init");
}
Bool VG_(defined_post_regs_write_init)(void) {
   return VG_(tool_interface).track_post_regs_write_init != missing_track_post_regs_write_init;
}


   /* Use VG_(set_thread_shadow_archreg)() to set the shadow regs for these
      events.
    */
static void missing_track_post_reg_write_syscall_return(ThreadId tid, UInt reg) {
   VG_(missing_tool_func)("track_post_reg_write_syscall_return");
}
Bool VG_(defined_post_reg_write_syscall_return)(void) {
   return VG_(tool_interface).track_post_reg_write_syscall_return != missing_track_post_reg_write_syscall_return;
}

static void missing_track_post_reg_write_deliver_signal(ThreadId tid, UInt reg) {
   VG_(missing_tool_func)("track_post_reg_write_deliver_signal");
}
Bool VG_(defined_post_reg_write_deliver_signal)(void) {
   return VG_(tool_interface).track_post_reg_write_deliver_signal != missing_track_post_reg_write_deliver_signal;
}

static void missing_track_post_reg_write_pthread_return(ThreadId tid, UInt reg) {
   VG_(missing_tool_func)("track_post_reg_write_pthread_return");
}
Bool VG_(defined_post_reg_write_pthread_return)(void) {
   return VG_(tool_interface).track_post_reg_write_pthread_return != missing_track_post_reg_write_pthread_return;
}

static void missing_track_post_reg_write_clientreq_return(ThreadId tid, UInt reg) {
   VG_(missing_tool_func)("track_post_reg_write_clientreq_return");
}
Bool VG_(defined_post_reg_write_clientreq_return)(void) {
   return VG_(tool_interface).track_post_reg_write_clientreq_return != missing_track_post_reg_write_clientreq_return;
}

   /* This one is called for malloc() et al if they are replaced by a skin. */
static void missing_track_post_reg_write_clientcall_return(ThreadId tid, UInt reg, Addr f) {
   VG_(missing_tool_func)("track_post_reg_write_clientcall_return");
}
Bool VG_(defined_post_reg_write_clientcall_return)(void) {
   return VG_(tool_interface).track_post_reg_write_clientcall_return != missing_track_post_reg_write_clientcall_return;
}



   /* Scheduler events (not exhaustive) */
static void missing_track_thread_run(ThreadId tid) {
   VG_(missing_tool_func)("track_thread_run");
}
Bool VG_(defined_thread_run)(void) {
   return VG_(tool_interface).track_thread_run != missing_track_thread_run;
}



   /* Thread events (not exhaustive)
   
      Called during thread create, before the new thread has run any
      instructions (or touched any memory).
    */
static void missing_track_post_thread_create(ThreadId tid, ThreadId child) {
   VG_(missing_tool_func)("track_post_thread_create");
}
Bool VG_(defined_post_thread_create)(void) {
   return VG_(tool_interface).track_post_thread_create != missing_track_post_thread_create;
}

static void missing_track_post_thread_join(ThreadId joiner, ThreadId joinee) {
   VG_(missing_tool_func)("track_post_thread_join");
}
Bool VG_(defined_post_thread_join)(void) {
   return VG_(tool_interface).track_post_thread_join != missing_track_post_thread_join;
}



   /* Mutex events (not exhaustive)
      "void *mutex" is really a pthread_mutex *
   
      Called before a thread can block while waiting for a mutex (called
      regardless of whether the thread will block or not).
    */
static void missing_track_pre_mutex_lock(ThreadId tid, void* mutex) {
   VG_(missing_tool_func)("track_pre_mutex_lock");
}
Bool VG_(defined_pre_mutex_lock)(void) {
   return VG_(tool_interface).track_pre_mutex_lock != missing_track_pre_mutex_lock;
}

   /* Called once the thread actually holds the mutex (always paired with
      pre_mutex_lock).
    */
static void missing_track_post_mutex_lock(ThreadId tid, void* mutex) {
   VG_(missing_tool_func)("track_post_mutex_lock");
}
Bool VG_(defined_post_mutex_lock)(void) {
   return VG_(tool_interface).track_post_mutex_lock != missing_track_post_mutex_lock;
}

   /* Called after a thread has released a mutex (no need for a corresponding
      pre_mutex_unlock, because unlocking can't block).
    */
static void missing_track_post_mutex_unlock(ThreadId tid, void* mutex) {
   VG_(missing_tool_func)("track_post_mutex_unlock");
}
Bool VG_(defined_post_mutex_unlock)(void) {
   return VG_(tool_interface).track_post_mutex_unlock != missing_track_post_mutex_unlock;
}


   /* Signal events (not exhaustive)
   
      ... pre_send_signal, post_send_signal ...
   
      Called before a signal is delivered;  `alt_stack' indicates if it is
      delivered on an alternative stack. 
    */
static void missing_track_pre_deliver_signal(ThreadId tid, Int sigNo, Bool alt_stack) {
   VG_(missing_tool_func)("track_pre_deliver_signal");
}
Bool VG_(defined_pre_deliver_signal)(void) {
   return VG_(tool_interface).track_pre_deliver_signal != missing_track_pre_deliver_signal;
}

   /* Called after a signal is delivered.  Nb: unfortunately, if the signal
      handler longjmps, this won't be called.
    */
static void missing_track_post_deliver_signal(ThreadId tid, Int sigNo) {
   VG_(missing_tool_func)("track_post_deliver_signal");
}
Bool VG_(defined_post_deliver_signal)(void) {
   return VG_(tool_interface).track_post_deliver_signal != missing_track_post_deliver_signal;
}



   /* Others... condition variable...
      ...
   
      Shadow memory management
    */
static void missing_track_init_shadow_page(Addr p) {
   VG_(missing_tool_func)("track_init_shadow_page");
}
Bool VG_(defined_init_shadow_page)(void) {
   return VG_(tool_interface).track_init_shadow_page != missing_track_init_shadow_page;
}


   /* ================================================================================
      malloc and friends
    */
static void* missing_malloc_malloc(Int n) {
   VG_(missing_tool_func)("malloc_malloc");
}
Bool VG_(defined_malloc)(void) {
   return VG_(tool_interface).malloc_malloc != missing_malloc_malloc;
}

static void* missing_malloc___builtin_new(Int n) {
   VG_(missing_tool_func)("malloc___builtin_new");
}
Bool VG_(defined___builtin_new)(void) {
   return VG_(tool_interface).malloc___builtin_new != missing_malloc___builtin_new;
}

static void* missing_malloc___builtin_vec_new(Int n) {
   VG_(missing_tool_func)("malloc___builtin_vec_new");
}
Bool VG_(defined___builtin_vec_new)(void) {
   return VG_(tool_interface).malloc___builtin_vec_new != missing_malloc___builtin_vec_new;
}

static void* missing_malloc_memalign(Int align, Int n) {
   VG_(missing_tool_func)("malloc_memalign");
}
Bool VG_(defined_memalign)(void) {
   return VG_(tool_interface).malloc_memalign != missing_malloc_memalign;
}

static void* missing_malloc_calloc(Int nmemb, Int n) {
   VG_(missing_tool_func)("malloc_calloc");
}
Bool VG_(defined_calloc)(void) {
   return VG_(tool_interface).malloc_calloc != missing_malloc_calloc;
}

static void missing_malloc_free(void* p) {
   VG_(missing_tool_func)("malloc_free");
}
Bool VG_(defined_free)(void) {
   return VG_(tool_interface).malloc_free != missing_malloc_free;
}

static void missing_malloc___builtin_delete(void* p) {
   VG_(missing_tool_func)("malloc___builtin_delete");
}
Bool VG_(defined___builtin_delete)(void) {
   return VG_(tool_interface).malloc___builtin_delete != missing_malloc___builtin_delete;
}

static void missing_malloc___builtin_vec_delete(void* p) {
   VG_(missing_tool_func)("malloc___builtin_vec_delete");
}
Bool VG_(defined___builtin_vec_delete)(void) {
   return VG_(tool_interface).malloc___builtin_vec_delete != missing_malloc___builtin_vec_delete;
}

static void* missing_malloc_realloc(void* p, Int size) {
   VG_(missing_tool_func)("malloc_realloc");
}
Bool VG_(defined_realloc)(void) {
   return VG_(tool_interface).malloc_realloc != missing_malloc_realloc;
}

/* Generated by "gen_toolint.pl initfunc" */
#include "vg_skin.h"

/* These are the parameterised functions in the core.  The default definitions
   are overridden by LD_PRELOADed skin version.  At the very least, a skin
   must define the fundamental template functions.  Depending on what needs
   are set, extra template functions will be used too.  Functions are
   grouped under the needs that govern their use.

   ------------------------------------------------------------------
   Fundamental template functions

   Do initialisation that can only be done after command line processing.
 */
void VG_(init_post_clo_init)(void (*func)(void))
{
	if (func == NULL)
		func = missing_tool_post_clo_init;
	if (VG_(defined_post_clo_init)())
		VG_(printf)("Warning tool is redefining post_clo_init\n");
	if (func == SK_(post_clo_init))
		VG_(printf)("Warning tool is defining post_clo_init recursively\n");
	VG_(tool_interface).tool_post_clo_init = func;
}

/* Instrument a basic block.  Must be a true function, ie. the same input
   always results in the same output, because basic blocks can be
   retranslated.  Unless you're doing something really strange...
   'orig_addr' is the address of the first instruction in the block.
 */
void VG_(init_instrument)(UCodeBlock* (*func)(UCodeBlock* cb, Addr orig_addr))
{
	if (func == NULL)
		func = missing_tool_instrument;
	if (VG_(defined_instrument)())
		VG_(printf)("Warning tool is redefining instrument\n");
	if (func == SK_(instrument))
		VG_(printf)("Warning tool is defining instrument recursively\n");
	VG_(tool_interface).tool_instrument = func;
}

/* Finish up, print out any results, etc.  `exitcode' is program's exit
   code.  The shadow (if the `shadow_regs' need is set) can be found with
   VG_(get_shadow_archreg)(R_EBX), since %ebx holds the argument to the
   exit() syscall.
 */
void VG_(init_fini)(void (*func)(Int exitcode))
{
	if (func == NULL)
		func = missing_tool_fini;
	if (VG_(defined_fini)())
		VG_(printf)("Warning tool is redefining fini\n");
	if (func == SK_(fini))
		VG_(printf)("Warning tool is defining fini recursively\n");
	VG_(tool_interface).tool_fini = func;
}


/* ------------------------------------------------------------------
   VG_(needs).core_errors

   (none needed)

   ------------------------------------------------------------------
   VG_(needs).skin_errors

   Identify if two errors are equal, or equal enough.  `res' indicates how
   close is "close enough".  `res' should be passed on as necessary, eg. if
   the Error's `extra' part contains an ExeContext, `res' should be
   passed to VG_(eq_ExeContext)() if the ExeContexts are considered.  Other
   than that, probably don't worry about it unless you have lots of very
   similar errors occurring.
 */
void VG_(init_eq_SkinError)(Bool (*func)(VgRes res, Error* e1, Error* e2))
{
	if (func == NULL)
		func = missing_tool_eq_SkinError;
	if (VG_(defined_eq_SkinError)())
		VG_(printf)("Warning tool is redefining eq_SkinError\n");
	if (func == SK_(eq_SkinError))
		VG_(printf)("Warning tool is defining eq_SkinError recursively\n");
	VG_(tool_interface).tool_eq_SkinError = func;
}

/* Print error context. */
void VG_(init_pp_SkinError)(void (*func)(Error* err))
{
	if (func == NULL)
		func = missing_tool_pp_SkinError;
	if (VG_(defined_pp_SkinError)())
		VG_(printf)("Warning tool is redefining pp_SkinError\n");
	if (func == SK_(pp_SkinError))
		VG_(printf)("Warning tool is defining pp_SkinError recursively\n");
	VG_(tool_interface).tool_pp_SkinError = func;
}

/* Should fill in any details that could be postponed until after the
   decision whether to ignore the error (ie. details not affecting the
   result of SK_(eq_SkinError)()).  This saves time when errors are ignored.
   Yuk.

   Return value: must be the size of the `extra' part in bytes -- used by
   the core to make a copy.
 */
void VG_(init_update_extra)(UInt (*func)(Error* err))
{
	if (func == NULL)
		func = missing_tool_update_extra;
	if (VG_(defined_update_extra)())
		VG_(printf)("Warning tool is redefining update_extra\n");
	if (func == SK_(update_extra))
		VG_(printf)("Warning tool is defining update_extra recursively\n");
	VG_(tool_interface).tool_update_extra = func;
}

/* Return value indicates recognition.  If recognised, must set skind using
   VG_(set_supp_kind)().
 */
void VG_(init_recognised_suppression)(Bool (*func)(Char* name, Supp* su))
{
	if (func == NULL)
		func = missing_tool_recognised_suppression;
	if (VG_(defined_recognised_suppression)())
		VG_(printf)("Warning tool is redefining recognised_suppression\n");
	if (func == SK_(recognised_suppression))
		VG_(printf)("Warning tool is defining recognised_suppression recursively\n");
	VG_(tool_interface).tool_recognised_suppression = func;
}

/* Read any extra info for this suppression kind.  Most likely for filling
   in the `extra' and `string' parts (with VG_(set_supp_{extra, string})())
   of a suppression if necessary.  Should return False if a syntax error
   occurred, True otherwise.
 */
void VG_(init_read_extra_suppression_info)(Bool (*func)(Int fd, Char* buf, Int nBuf, Supp* su))
{
	if (func == NULL)
		func = missing_tool_read_extra_suppression_info;
	if (VG_(defined_read_extra_suppression_info)())
		VG_(printf)("Warning tool is redefining read_extra_suppression_info\n");
	if (func == SK_(read_extra_suppression_info))
		VG_(printf)("Warning tool is defining read_extra_suppression_info recursively\n");
	VG_(tool_interface).tool_read_extra_suppression_info = func;
}

/* This should just check the kinds match and maybe some stuff in the
   `string' and `extra' field if appropriate (using VG_(get_supp_*)() to
   get the relevant suppression parts).
 */
void VG_(init_error_matches_suppression)(Bool (*func)(Error* err, Supp* su))
{
	if (func == NULL)
		func = missing_tool_error_matches_suppression;
	if (VG_(defined_error_matches_suppression)())
		VG_(printf)("Warning tool is redefining error_matches_suppression\n");
	if (func == SK_(error_matches_suppression))
		VG_(printf)("Warning tool is defining error_matches_suppression recursively\n");
	VG_(tool_interface).tool_error_matches_suppression = func;
}

/* This should return the suppression name, for --gen-suppressions, or NULL
   if that error type cannot be suppressed.  This is the inverse of
   SK_(recognised_suppression)().
 */
void VG_(init_get_error_name)(Char* (*func)(Error* err))
{
	if (func == NULL)
		func = missing_tool_get_error_name;
	if (VG_(defined_get_error_name)())
		VG_(printf)("Warning tool is redefining get_error_name\n");
	if (func == SK_(get_error_name))
		VG_(printf)("Warning tool is defining get_error_name recursively\n");
	VG_(tool_interface).tool_get_error_name = func;
}

/* This should print any extra info for the error, for --gen-suppressions,
   including the newline.  This is the inverse of
   SK_(read_extra_suppression_info)().
 */
void VG_(init_print_extra_suppression_info)(void (*func)(Error* err))
{
	if (func == NULL)
		func = missing_tool_print_extra_suppression_info;
	if (VG_(defined_print_extra_suppression_info)())
		VG_(printf)("Warning tool is redefining print_extra_suppression_info\n");
	if (func == SK_(print_extra_suppression_info))
		VG_(printf)("Warning tool is defining print_extra_suppression_info recursively\n");
	VG_(tool_interface).tool_print_extra_suppression_info = func;
}


/* ------------------------------------------------------------------
   VG_(needs).basic_block_discards

   Should discard any information that pertains to specific basic blocks
   or instructions within the address range given.
 */
void VG_(init_discard_basic_block_info)(void (*func)(Addr a, UInt size))
{
	if (func == NULL)
		func = missing_tool_discard_basic_block_info;
	if (VG_(defined_discard_basic_block_info)())
		VG_(printf)("Warning tool is redefining discard_basic_block_info\n");
	if (func == SK_(discard_basic_block_info))
		VG_(printf)("Warning tool is defining discard_basic_block_info recursively\n");
	VG_(tool_interface).tool_discard_basic_block_info = func;
}


/* ------------------------------------------------------------------
   VG_(needs).shadow_regs

   No functions must be defined, but the post_reg[s]_write_* events should
   be tracked.

   ------------------------------------------------------------------
   VG_(needs).command_line_options

   Return True if option was recognised.  Presumably sets some state to
   record the option as well.
 */
void VG_(init_process_cmd_line_option)(Bool (*func)(Char* argv))
{
	if (func == NULL)
		func = missing_tool_process_cmd_line_option;
	if (VG_(defined_process_cmd_line_option)())
		VG_(printf)("Warning tool is redefining process_cmd_line_option\n");
	if (func == SK_(process_cmd_line_option))
		VG_(printf)("Warning tool is defining process_cmd_line_option recursively\n");
	VG_(tool_interface).tool_process_cmd_line_option = func;
}

/* Print out command line usage for options for normal skin operation. */
void VG_(init_print_usage)(void (*func)(void))
{
	if (func == NULL)
		func = missing_tool_print_usage;
	if (VG_(defined_print_usage)())
		VG_(printf)("Warning tool is redefining print_usage\n");
	if (func == SK_(print_usage))
		VG_(printf)("Warning tool is defining print_usage recursively\n");
	VG_(tool_interface).tool_print_usage = func;
}

/* Print out command line usage for options for debugging the skin. */
void VG_(init_print_debug_usage)(void (*func)(void))
{
	if (func == NULL)
		func = missing_tool_print_debug_usage;
	if (VG_(defined_print_debug_usage)())
		VG_(printf)("Warning tool is redefining print_debug_usage\n");
	if (func == SK_(print_debug_usage))
		VG_(printf)("Warning tool is defining print_debug_usage recursively\n");
	VG_(tool_interface).tool_print_debug_usage = func;
}

/* ------------------------------------------------------------------
   VG_(needs).client_requests

   If using client requests, the number of the first request should be equal
   to VG_USERREQ_SKIN_BASE('X', 'Y'), where 'X' and 'Y' form a suitable two
   character identification for the string.  The second and subsequent
   requests should follow.

   This function should use the VG_IS_SKIN_USERREQ macro (in
   include/valgrind.h) to first check if it's a request for this skin.  Then
   should handle it if it's recognised (and return True), or return False if
   not recognised.  arg_block[0] holds the request number, any further args
   from the request are in arg_block[1..].  'ret' is for the return value...
   it should probably be filled, if only with 0.
 */
void VG_(init_handle_client_request)(Bool (*func)(ThreadId tid, UInt* arg_block, UInt* ret))
{
	if (func == NULL)
		func = missing_tool_handle_client_request;
	if (VG_(defined_handle_client_request)())
		VG_(printf)("Warning tool is redefining handle_client_request\n");
	if (func == SK_(handle_client_request))
		VG_(printf)("Warning tool is defining handle_client_request recursively\n");
	VG_(tool_interface).tool_handle_client_request = func;
}


/* ------------------------------------------------------------------
   VG_(needs).extends_UCode

   'X' prefix indicates eXtended UCode.
 */
void VG_(init_get_Xreg_usage)(Int (*func)(UInstr* u, Tag tag, Int* regs, Bool* isWrites))
{
	if (func == NULL)
		func = missing_tool_get_Xreg_usage;
	if (VG_(defined_get_Xreg_usage)())
		VG_(printf)("Warning tool is redefining get_Xreg_usage\n");
	if (func == SK_(get_Xreg_usage))
		VG_(printf)("Warning tool is defining get_Xreg_usage recursively\n");
	VG_(tool_interface).tool_get_Xreg_usage = func;
}
void VG_(init_emit_XUInstr)(void (*func)(UInstr* u, RRegSet regs_live_before))
{
	if (func == NULL)
		func = missing_tool_emit_XUInstr;
	if (VG_(defined_emit_XUInstr)())
		VG_(printf)("Warning tool is redefining emit_XUInstr\n");
	if (func == SK_(emit_XUInstr))
		VG_(printf)("Warning tool is defining emit_XUInstr recursively\n");
	VG_(tool_interface).tool_emit_XUInstr = func;
}
void VG_(init_sane_XUInstr)(Bool (*func)(Bool beforeRA, Bool beforeLiveness, UInstr* u))
{
	if (func == NULL)
		func = missing_tool_sane_XUInstr;
	if (VG_(defined_sane_XUInstr)())
		VG_(printf)("Warning tool is redefining sane_XUInstr\n");
	if (func == SK_(sane_XUInstr))
		VG_(printf)("Warning tool is defining sane_XUInstr recursively\n");
	VG_(tool_interface).tool_sane_XUInstr = func;
}
void VG_(init_name_XUOpcode)(Char * (*func)(Opcode opc))
{
	if (func == NULL)
		func = missing_tool_name_XUOpcode;
	if (VG_(defined_name_XUOpcode)())
		VG_(printf)("Warning tool is redefining name_XUOpcode\n");
	if (func == SK_(name_XUOpcode))
		VG_(printf)("Warning tool is defining name_XUOpcode recursively\n");
	VG_(tool_interface).tool_name_XUOpcode = func;
}
void VG_(init_pp_XUInstr)(void (*func)(UInstr* u))
{
	if (func == NULL)
		func = missing_tool_pp_XUInstr;
	if (VG_(defined_pp_XUInstr)())
		VG_(printf)("Warning tool is redefining pp_XUInstr\n");
	if (func == SK_(pp_XUInstr))
		VG_(printf)("Warning tool is defining pp_XUInstr recursively\n");
	VG_(tool_interface).tool_pp_XUInstr = func;
}


/* ------------------------------------------------------------------
   VG_(needs).syscall_wrapper

   If either of the pre_ functions malloc() something to return, the
   corresponding post_ function had better free() it!

 */
void VG_(init_pre_syscall)(void * (*func)(ThreadId tid, UInt syscallno, Bool is_blocking))
{
	if (func == NULL)
		func = missing_tool_pre_syscall;
	if (VG_(defined_pre_syscall)())
		VG_(printf)("Warning tool is redefining pre_syscall\n");
	if (func == SK_(pre_syscall))
		VG_(printf)("Warning tool is defining pre_syscall recursively\n");
	VG_(tool_interface).tool_pre_syscall = func;
}
void VG_(init_post_syscall)(void (*func)(ThreadId tid, UInt syscallno, void* pre_result, Int res, Bool is_blocking))
{
	if (func == NULL)
		func = missing_tool_post_syscall;
	if (VG_(defined_post_syscall)())
		VG_(printf)("Warning tool is redefining post_syscall\n");
	if (func == SK_(post_syscall))
		VG_(printf)("Warning tool is defining post_syscall recursively\n");
	VG_(tool_interface).tool_post_syscall = func;
}


/* ---------------------------------------------------------------------
     VG_(needs).sanity_checks

   Can be useful for ensuring a skin's correctness.  SK_(cheap_sanity_check)
   is called very frequently;  SK_(expensive_sanity_check) is called less
   frequently and can be more involved.
 */
void VG_(init_cheap_sanity_check)(Bool (*func)(void))
{
	if (func == NULL)
		func = missing_tool_cheap_sanity_check;
	if (VG_(defined_cheap_sanity_check)())
		VG_(printf)("Warning tool is redefining cheap_sanity_check\n");
	if (func == SK_(cheap_sanity_check))
		VG_(printf)("Warning tool is defining cheap_sanity_check recursively\n");
	VG_(tool_interface).tool_cheap_sanity_check = func;
}
void VG_(init_expensive_sanity_check)(Bool (*func)(void))
{
	if (func == NULL)
		func = missing_tool_expensive_sanity_check;
	if (VG_(defined_expensive_sanity_check)())
		VG_(printf)("Warning tool is redefining expensive_sanity_check\n");
	if (func == SK_(expensive_sanity_check))
		VG_(printf)("Warning tool is defining expensive_sanity_check recursively\n");
	VG_(tool_interface).tool_expensive_sanity_check = func;
}


/* ================================================================================
   Event tracking functions

   Events happening in core to track.  To be notified, pass a callback
   function to the appropriate function.  To ignore an event, don't do
   anything (default is for events to be ignored).

   Note that most events aren't passed a ThreadId.  To find out the ThreadId
   of the affected thread, use VG_(get_current_or_recent_tid)().  For the
   ones passed a ThreadId, use that instead, since
   VG_(get_current_or_recent_tid)() might not give the right ThreadId in
   that case.

   Memory events (Nb: to track heap allocation/freeing, a skin must replace
   malloc() et al.  See above how to do this.)

   These ones occur at startup, upon some signals, and upon some syscalls
 */
void VG_(init_new_mem_startup)(void (*func)(Addr a, UInt len, Bool rr, Bool ww, Bool xx))
{
	if (func == NULL)
		func = missing_track_new_mem_startup;
	if (VG_(defined_new_mem_startup)())
		VG_(printf)("Warning tool is redefining new_mem_startup\n");
	if (func == SK_(new_mem_startup))
		VG_(printf)("Warning tool is defining new_mem_startup recursively\n");
	VG_(tool_interface).track_new_mem_startup = func;
}
void VG_(init_new_mem_stack_signal)(void (*func)(Addr a, UInt len))
{
	if (func == NULL)
		func = missing_track_new_mem_stack_signal;
	if (VG_(defined_new_mem_stack_signal)())
		VG_(printf)("Warning tool is redefining new_mem_stack_signal\n");
	if (func == SK_(new_mem_stack_signal))
		VG_(printf)("Warning tool is defining new_mem_stack_signal recursively\n");
	VG_(tool_interface).track_new_mem_stack_signal = func;
}
void VG_(init_new_mem_brk)(void (*func)(Addr a, UInt len))
{
	if (func == NULL)
		func = missing_track_new_mem_brk;
	if (VG_(defined_new_mem_brk)())
		VG_(printf)("Warning tool is redefining new_mem_brk\n");
	if (func == SK_(new_mem_brk))
		VG_(printf)("Warning tool is defining new_mem_brk recursively\n");
	VG_(tool_interface).track_new_mem_brk = func;
}
void VG_(init_new_mem_mmap)(void (*func)(Addr a, UInt len, Bool rr, Bool ww, Bool xx))
{
	if (func == NULL)
		func = missing_track_new_mem_mmap;
	if (VG_(defined_new_mem_mmap)())
		VG_(printf)("Warning tool is redefining new_mem_mmap\n");
	if (func == SK_(new_mem_mmap))
		VG_(printf)("Warning tool is defining new_mem_mmap recursively\n");
	VG_(tool_interface).track_new_mem_mmap = func;
}

void VG_(init_copy_mem_remap)(void (*func)(Addr from, Addr to, UInt len))
{
	if (func == NULL)
		func = missing_track_copy_mem_remap;
	if (VG_(defined_copy_mem_remap)())
		VG_(printf)("Warning tool is redefining copy_mem_remap\n");
	if (func == SK_(copy_mem_remap))
		VG_(printf)("Warning tool is defining copy_mem_remap recursively\n");
	VG_(tool_interface).track_copy_mem_remap = func;
}
void VG_(init_change_mem_mprotect)(void (*func)(Addr a, UInt len, Bool rr, Bool ww, Bool xx))
{
	if (func == NULL)
		func = missing_track_change_mem_mprotect;
	if (VG_(defined_change_mem_mprotect)())
		VG_(printf)("Warning tool is redefining change_mem_mprotect\n");
	if (func == SK_(change_mem_mprotect))
		VG_(printf)("Warning tool is defining change_mem_mprotect recursively\n");
	VG_(tool_interface).track_change_mem_mprotect = func;
}
void VG_(init_die_mem_stack_signal)(void (*func)(Addr a, UInt len))
{
	if (func == NULL)
		func = missing_track_die_mem_stack_signal;
	if (VG_(defined_die_mem_stack_signal)())
		VG_(printf)("Warning tool is redefining die_mem_stack_signal\n");
	if (func == SK_(die_mem_stack_signal))
		VG_(printf)("Warning tool is defining die_mem_stack_signal recursively\n");
	VG_(tool_interface).track_die_mem_stack_signal = func;
}
void VG_(init_die_mem_brk)(void (*func)(Addr a, UInt len))
{
	if (func == NULL)
		func = missing_track_die_mem_brk;
	if (VG_(defined_die_mem_brk)())
		VG_(printf)("Warning tool is redefining die_mem_brk\n");
	if (func == SK_(die_mem_brk))
		VG_(printf)("Warning tool is defining die_mem_brk recursively\n");
	VG_(tool_interface).track_die_mem_brk = func;
}
void VG_(init_die_mem_munmap)(void (*func)(Addr a, UInt len))
{
	if (func == NULL)
		func = missing_track_die_mem_munmap;
	if (VG_(defined_die_mem_munmap)())
		VG_(printf)("Warning tool is redefining die_mem_munmap\n");
	if (func == SK_(die_mem_munmap))
		VG_(printf)("Warning tool is defining die_mem_munmap recursively\n");
	VG_(tool_interface).track_die_mem_munmap = func;
}

/* These ones are called when %esp changes.  A skin could track these itself
   (except for ban_mem_stack) but it's much easier to use the core's help.

   The specialised ones are called in preference to the general one, if they
   are defined.  These functions are called a lot if they are used, so
   specialising can optimise things significantly.  If any of the
   specialised cases are defined, the general case must be defined too.

   Nb: they must all use the __attribute__((regparm(n))) attribute.
 */
void VG_(init_new_mem_stack_4)(void (*func)(Addr new_ESP))
{
	if (func == NULL)
		func = missing_track_new_mem_stack_4;
	if (VG_(defined_new_mem_stack_4)())
		VG_(printf)("Warning tool is redefining new_mem_stack_4\n");
	if (func == SK_(new_mem_stack_4))
		VG_(printf)("Warning tool is defining new_mem_stack_4 recursively\n");
	VG_(tool_interface).track_new_mem_stack_4 = func;
}
void VG_(init_new_mem_stack_8)(void (*func)(Addr new_ESP))
{
	if (func == NULL)
		func = missing_track_new_mem_stack_8;
	if (VG_(defined_new_mem_stack_8)())
		VG_(printf)("Warning tool is redefining new_mem_stack_8\n");
	if (func == SK_(new_mem_stack_8))
		VG_(printf)("Warning tool is defining new_mem_stack_8 recursively\n");
	VG_(tool_interface).track_new_mem_stack_8 = func;
}
void VG_(init_new_mem_stack_12)(void (*func)(Addr new_ESP))
{
	if (func == NULL)
		func = missing_track_new_mem_stack_12;
	if (VG_(defined_new_mem_stack_12)())
		VG_(printf)("Warning tool is redefining new_mem_stack_12\n");
	if (func == SK_(new_mem_stack_12))
		VG_(printf)("Warning tool is defining new_mem_stack_12 recursively\n");
	VG_(tool_interface).track_new_mem_stack_12 = func;
}
void VG_(init_new_mem_stack_16)(void (*func)(Addr new_ESP))
{
	if (func == NULL)
		func = missing_track_new_mem_stack_16;
	if (VG_(defined_new_mem_stack_16)())
		VG_(printf)("Warning tool is redefining new_mem_stack_16\n");
	if (func == SK_(new_mem_stack_16))
		VG_(printf)("Warning tool is defining new_mem_stack_16 recursively\n");
	VG_(tool_interface).track_new_mem_stack_16 = func;
}
void VG_(init_new_mem_stack_32)(void (*func)(Addr new_ESP))
{
	if (func == NULL)
		func = missing_track_new_mem_stack_32;
	if (VG_(defined_new_mem_stack_32)())
		VG_(printf)("Warning tool is redefining new_mem_stack_32\n");
	if (func == SK_(new_mem_stack_32))
		VG_(printf)("Warning tool is defining new_mem_stack_32 recursively\n");
	VG_(tool_interface).track_new_mem_stack_32 = func;
}
void VG_(init_new_mem_stack)(void (*func)(Addr a, UInt len))
{
	if (func == NULL)
		func = missing_track_new_mem_stack;
	if (VG_(defined_new_mem_stack)())
		VG_(printf)("Warning tool is redefining new_mem_stack\n");
	if (func == SK_(new_mem_stack))
		VG_(printf)("Warning tool is defining new_mem_stack recursively\n");
	VG_(tool_interface).track_new_mem_stack = func;
}

void VG_(init_die_mem_stack_4)(void (*func)(Addr die_ESP))
{
	if (func == NULL)
		func = missing_track_die_mem_stack_4;
	if (VG_(defined_die_mem_stack_4)())
		VG_(printf)("Warning tool is redefining die_mem_stack_4\n");
	if (func == SK_(die_mem_stack_4))
		VG_(printf)("Warning tool is defining die_mem_stack_4 recursively\n");
	VG_(tool_interface).track_die_mem_stack_4 = func;
}
void VG_(init_die_mem_stack_8)(void (*func)(Addr die_ESP))
{
	if (func == NULL)
		func = missing_track_die_mem_stack_8;
	if (VG_(defined_die_mem_stack_8)())
		VG_(printf)("Warning tool is redefining die_mem_stack_8\n");
	if (func == SK_(die_mem_stack_8))
		VG_(printf)("Warning tool is defining die_mem_stack_8 recursively\n");
	VG_(tool_interface).track_die_mem_stack_8 = func;
}
void VG_(init_die_mem_stack_12)(void (*func)(Addr die_ESP))
{
	if (func == NULL)
		func = missing_track_die_mem_stack_12;
	if (VG_(defined_die_mem_stack_12)())
		VG_(printf)("Warning tool is redefining die_mem_stack_12\n");
	if (func == SK_(die_mem_stack_12))
		VG_(printf)("Warning tool is defining die_mem_stack_12 recursively\n");
	VG_(tool_interface).track_die_mem_stack_12 = func;
}
void VG_(init_die_mem_stack_16)(void (*func)(Addr die_ESP))
{
	if (func == NULL)
		func = missing_track_die_mem_stack_16;
	if (VG_(defined_die_mem_stack_16)())
		VG_(printf)("Warning tool is redefining die_mem_stack_16\n");
	if (func == SK_(die_mem_stack_16))
		VG_(printf)("Warning tool is defining die_mem_stack_16 recursively\n");
	VG_(tool_interface).track_die_mem_stack_16 = func;
}
void VG_(init_die_mem_stack_32)(void (*func)(Addr die_ESP))
{
	if (func == NULL)
		func = missing_track_die_mem_stack_32;
	if (VG_(defined_die_mem_stack_32)())
		VG_(printf)("Warning tool is redefining die_mem_stack_32\n");
	if (func == SK_(die_mem_stack_32))
		VG_(printf)("Warning tool is defining die_mem_stack_32 recursively\n");
	VG_(tool_interface).track_die_mem_stack_32 = func;
}
void VG_(init_die_mem_stack)(void (*func)(Addr a, UInt len))
{
	if (func == NULL)
		func = missing_track_die_mem_stack;
	if (VG_(defined_die_mem_stack)())
		VG_(printf)("Warning tool is redefining die_mem_stack\n");
	if (func == SK_(die_mem_stack))
		VG_(printf)("Warning tool is defining die_mem_stack recursively\n");
	VG_(tool_interface).track_die_mem_stack = func;
}

/* Used for redzone at end of thread stacks */
void VG_(init_ban_mem_stack)(void (*func)(Addr a, UInt len))
{
	if (func == NULL)
		func = missing_track_ban_mem_stack;
	if (VG_(defined_ban_mem_stack)())
		VG_(printf)("Warning tool is redefining ban_mem_stack\n");
	if (func == SK_(ban_mem_stack))
		VG_(printf)("Warning tool is defining ban_mem_stack recursively\n");
	VG_(tool_interface).track_ban_mem_stack = func;
}

/* These ones occur around syscalls, signal handling, etc */
void VG_(init_pre_mem_read)(void (*func)(CorePart part, ThreadId tid, Char* s, Addr a, UInt size))
{
	if (func == NULL)
		func = missing_track_pre_mem_read;
	if (VG_(defined_pre_mem_read)())
		VG_(printf)("Warning tool is redefining pre_mem_read\n");
	if (func == SK_(pre_mem_read))
		VG_(printf)("Warning tool is defining pre_mem_read recursively\n");
	VG_(tool_interface).track_pre_mem_read = func;
}
void VG_(init_pre_mem_read_asciiz)(void (*func)(CorePart part, ThreadId tid, Char* s, Addr a))
{
	if (func == NULL)
		func = missing_track_pre_mem_read_asciiz;
	if (VG_(defined_pre_mem_read_asciiz)())
		VG_(printf)("Warning tool is redefining pre_mem_read_asciiz\n");
	if (func == SK_(pre_mem_read_asciiz))
		VG_(printf)("Warning tool is defining pre_mem_read_asciiz recursively\n");
	VG_(tool_interface).track_pre_mem_read_asciiz = func;
}
void VG_(init_pre_mem_write)(void (*func)(CorePart part, ThreadId tid, Char* s, Addr a, UInt size))
{
	if (func == NULL)
		func = missing_track_pre_mem_write;
	if (VG_(defined_pre_mem_write)())
		VG_(printf)("Warning tool is redefining pre_mem_write\n");
	if (func == SK_(pre_mem_write))
		VG_(printf)("Warning tool is defining pre_mem_write recursively\n");
	VG_(tool_interface).track_pre_mem_write = func;
}
/* Not implemented yet -- have to add in lots of places, which is a
   pain.  Won't bother unless/until there's a need.
   void (*post_mem_read)  ( ThreadState* tst, Char* s, Addr a, UInt size );
 */
void VG_(init_post_mem_write)(void (*func)(Addr a, UInt size))
{
	if (func == NULL)
		func = missing_track_post_mem_write;
	if (VG_(defined_post_mem_write)())
		VG_(printf)("Warning tool is redefining post_mem_write\n");
	if (func == SK_(post_mem_write))
		VG_(printf)("Warning tool is defining post_mem_write recursively\n");
	VG_(tool_interface).track_post_mem_write = func;
}


/* Register events -- if `shadow_regs' need is set, all should probably be
   used.  Use VG_(set_thread_shadow_archreg)() to set the shadow of the
   changed register.

   Use VG_(set_shadow_archreg)() to set the eight general purpose regs,
   and use VG_(set_shadow_eflags)() to set eflags.
 */
void VG_(init_post_regs_write_init)(void (*func)(void))
{
	if (func == NULL)
		func = missing_track_post_regs_write_init;
	if (VG_(defined_post_regs_write_init)())
		VG_(printf)("Warning tool is redefining post_regs_write_init\n");
	if (func == SK_(post_regs_write_init))
		VG_(printf)("Warning tool is defining post_regs_write_init recursively\n");
	VG_(tool_interface).track_post_regs_write_init = func;
}

/* Use VG_(set_thread_shadow_archreg)() to set the shadow regs for these
   events.
 */
void VG_(init_post_reg_write_syscall_return)(void (*func)(ThreadId tid, UInt reg))
{
	if (func == NULL)
		func = missing_track_post_reg_write_syscall_return;
	if (VG_(defined_post_reg_write_syscall_return)())
		VG_(printf)("Warning tool is redefining post_reg_write_syscall_return\n");
	if (func == SK_(post_reg_write_syscall_return))
		VG_(printf)("Warning tool is defining post_reg_write_syscall_return recursively\n");
	VG_(tool_interface).track_post_reg_write_syscall_return = func;
}
void VG_(init_post_reg_write_deliver_signal)(void (*func)(ThreadId tid, UInt reg))
{
	if (func == NULL)
		func = missing_track_post_reg_write_deliver_signal;
	if (VG_(defined_post_reg_write_deliver_signal)())
		VG_(printf)("Warning tool is redefining post_reg_write_deliver_signal\n");
	if (func == SK_(post_reg_write_deliver_signal))
		VG_(printf)("Warning tool is defining post_reg_write_deliver_signal recursively\n");
	VG_(tool_interface).track_post_reg_write_deliver_signal = func;
}
void VG_(init_post_reg_write_pthread_return)(void (*func)(ThreadId tid, UInt reg))
{
	if (func == NULL)
		func = missing_track_post_reg_write_pthread_return;
	if (VG_(defined_post_reg_write_pthread_return)())
		VG_(printf)("Warning tool is redefining post_reg_write_pthread_return\n");
	if (func == SK_(post_reg_write_pthread_return))
		VG_(printf)("Warning tool is defining post_reg_write_pthread_return recursively\n");
	VG_(tool_interface).track_post_reg_write_pthread_return = func;
}
void VG_(init_post_reg_write_clientreq_return)(void (*func)(ThreadId tid, UInt reg))
{
	if (func == NULL)
		func = missing_track_post_reg_write_clientreq_return;
	if (VG_(defined_post_reg_write_clientreq_return)())
		VG_(printf)("Warning tool is redefining post_reg_write_clientreq_return\n");
	if (func == SK_(post_reg_write_clientreq_return))
		VG_(printf)("Warning tool is defining post_reg_write_clientreq_return recursively\n");
	VG_(tool_interface).track_post_reg_write_clientreq_return = func;
}
/* This one is called for malloc() et al if they are replaced by a skin. */
void VG_(init_post_reg_write_clientcall_return)(void (*func)(ThreadId tid, UInt reg, Addr f))
{
	if (func == NULL)
		func = missing_track_post_reg_write_clientcall_return;
	if (VG_(defined_post_reg_write_clientcall_return)())
		VG_(printf)("Warning tool is redefining post_reg_write_clientcall_return\n");
	if (func == SK_(post_reg_write_clientcall_return))
		VG_(printf)("Warning tool is defining post_reg_write_clientcall_return recursively\n");
	VG_(tool_interface).track_post_reg_write_clientcall_return = func;
}


/* Scheduler events (not exhaustive) */
void VG_(init_thread_run)(void (*func)(ThreadId tid))
{
	if (func == NULL)
		func = missing_track_thread_run;
	if (VG_(defined_thread_run)())
		VG_(printf)("Warning tool is redefining thread_run\n");
	if (func == SK_(thread_run))
		VG_(printf)("Warning tool is defining thread_run recursively\n");
	VG_(tool_interface).track_thread_run = func;
}


/* Thread events (not exhaustive)

   Called during thread create, before the new thread has run any
   instructions (or touched any memory).
 */
void VG_(init_post_thread_create)(void (*func)(ThreadId tid, ThreadId child))
{
	if (func == NULL)
		func = missing_track_post_thread_create;
	if (VG_(defined_post_thread_create)())
		VG_(printf)("Warning tool is redefining post_thread_create\n");
	if (func == SK_(post_thread_create))
		VG_(printf)("Warning tool is defining post_thread_create recursively\n");
	VG_(tool_interface).track_post_thread_create = func;
}
void VG_(init_post_thread_join)(void (*func)(ThreadId joiner, ThreadId joinee))
{
	if (func == NULL)
		func = missing_track_post_thread_join;
	if (VG_(defined_post_thread_join)())
		VG_(printf)("Warning tool is redefining post_thread_join\n");
	if (func == SK_(post_thread_join))
		VG_(printf)("Warning tool is defining post_thread_join recursively\n");
	VG_(tool_interface).track_post_thread_join = func;
}


/* Mutex events (not exhaustive)
   "void *mutex" is really a pthread_mutex *

   Called before a thread can block while waiting for a mutex (called
   regardless of whether the thread will block or not).
 */
void VG_(init_pre_mutex_lock)(void (*func)(ThreadId tid, void* mutex))
{
	if (func == NULL)
		func = missing_track_pre_mutex_lock;
	if (VG_(defined_pre_mutex_lock)())
		VG_(printf)("Warning tool is redefining pre_mutex_lock\n");
	if (func == SK_(pre_mutex_lock))
		VG_(printf)("Warning tool is defining pre_mutex_lock recursively\n");
	VG_(tool_interface).track_pre_mutex_lock = func;
}
/* Called once the thread actually holds the mutex (always paired with
   pre_mutex_lock).
 */
void VG_(init_post_mutex_lock)(void (*func)(ThreadId tid, void* mutex))
{
	if (func == NULL)
		func = missing_track_post_mutex_lock;
	if (VG_(defined_post_mutex_lock)())
		VG_(printf)("Warning tool is redefining post_mutex_lock\n");
	if (func == SK_(post_mutex_lock))
		VG_(printf)("Warning tool is defining post_mutex_lock recursively\n");
	VG_(tool_interface).track_post_mutex_lock = func;
}
/* Called after a thread has released a mutex (no need for a corresponding
   pre_mutex_unlock, because unlocking can't block).
 */
void VG_(init_post_mutex_unlock)(void (*func)(ThreadId tid, void* mutex))
{
	if (func == NULL)
		func = missing_track_post_mutex_unlock;
	if (VG_(defined_post_mutex_unlock)())
		VG_(printf)("Warning tool is redefining post_mutex_unlock\n");
	if (func == SK_(post_mutex_unlock))
		VG_(printf)("Warning tool is defining post_mutex_unlock recursively\n");
	VG_(tool_interface).track_post_mutex_unlock = func;
}

/* Signal events (not exhaustive)

   ... pre_send_signal, post_send_signal ...

   Called before a signal is delivered;  `alt_stack' indicates if it is
   delivered on an alternative stack. 
 */
void VG_(init_pre_deliver_signal)(void (*func)(ThreadId tid, Int sigNo, Bool alt_stack))
{
	if (func == NULL)
		func = missing_track_pre_deliver_signal;
	if (VG_(defined_pre_deliver_signal)())
		VG_(printf)("Warning tool is redefining pre_deliver_signal\n");
	if (func == SK_(pre_deliver_signal))
		VG_(printf)("Warning tool is defining pre_deliver_signal recursively\n");
	VG_(tool_interface).track_pre_deliver_signal = func;
}
/* Called after a signal is delivered.  Nb: unfortunately, if the signal
   handler longjmps, this won't be called.
 */
void VG_(init_post_deliver_signal)(void (*func)(ThreadId tid, Int sigNo))
{
	if (func == NULL)
		func = missing_track_post_deliver_signal;
	if (VG_(defined_post_deliver_signal)())
		VG_(printf)("Warning tool is redefining post_deliver_signal\n");
	if (func == SK_(post_deliver_signal))
		VG_(printf)("Warning tool is defining post_deliver_signal recursively\n");
	VG_(tool_interface).track_post_deliver_signal = func;
}


/* Others... condition variable...
   ...

   Shadow memory management
 */
void VG_(init_init_shadow_page)(void (*func)(Addr p))
{
	if (func == NULL)
		func = missing_track_init_shadow_page;
	if (VG_(defined_init_shadow_page)())
		VG_(printf)("Warning tool is redefining init_shadow_page\n");
	if (func == SK_(init_shadow_page))
		VG_(printf)("Warning tool is defining init_shadow_page recursively\n");
	VG_(tool_interface).track_init_shadow_page = func;
}

/* ================================================================================
   malloc and friends
 */
void VG_(init_malloc)(void* (*func)(Int n))
{
	if (func == NULL)
		func = missing_malloc_malloc;
	if (VG_(defined_malloc)())
		VG_(printf)("Warning tool is redefining malloc\n");
	if (func == SK_(malloc))
		VG_(printf)("Warning tool is defining malloc recursively\n");
	VG_(tool_interface).malloc_malloc = func;
}
void VG_(init___builtin_new)(void* (*func)(Int n))
{
	if (func == NULL)
		func = missing_malloc___builtin_new;
	if (VG_(defined___builtin_new)())
		VG_(printf)("Warning tool is redefining __builtin_new\n");
	if (func == SK_(__builtin_new))
		VG_(printf)("Warning tool is defining __builtin_new recursively\n");
	VG_(tool_interface).malloc___builtin_new = func;
}
void VG_(init___builtin_vec_new)(void* (*func)(Int n))
{
	if (func == NULL)
		func = missing_malloc___builtin_vec_new;
	if (VG_(defined___builtin_vec_new)())
		VG_(printf)("Warning tool is redefining __builtin_vec_new\n");
	if (func == SK_(__builtin_vec_new))
		VG_(printf)("Warning tool is defining __builtin_vec_new recursively\n");
	VG_(tool_interface).malloc___builtin_vec_new = func;
}
void VG_(init_memalign)(void* (*func)(Int align, Int n))
{
	if (func == NULL)
		func = missing_malloc_memalign;
	if (VG_(defined_memalign)())
		VG_(printf)("Warning tool is redefining memalign\n");
	if (func == SK_(memalign))
		VG_(printf)("Warning tool is defining memalign recursively\n");
	VG_(tool_interface).malloc_memalign = func;
}
void VG_(init_calloc)(void* (*func)(Int nmemb, Int n))
{
	if (func == NULL)
		func = missing_malloc_calloc;
	if (VG_(defined_calloc)())
		VG_(printf)("Warning tool is redefining calloc\n");
	if (func == SK_(calloc))
		VG_(printf)("Warning tool is defining calloc recursively\n");
	VG_(tool_interface).malloc_calloc = func;
}
void VG_(init_free)(void (*func)(void* p))
{
	if (func == NULL)
		func = missing_malloc_free;
	if (VG_(defined_free)())
		VG_(printf)("Warning tool is redefining free\n");
	if (func == SK_(free))
		VG_(printf)("Warning tool is defining free recursively\n");
	VG_(tool_interface).malloc_free = func;
}
void VG_(init___builtin_delete)(void (*func)(void* p))
{
	if (func == NULL)
		func = missing_malloc___builtin_delete;
	if (VG_(defined___builtin_delete)())
		VG_(printf)("Warning tool is redefining __builtin_delete\n");
	if (func == SK_(__builtin_delete))
		VG_(printf)("Warning tool is defining __builtin_delete recursively\n");
	VG_(tool_interface).malloc___builtin_delete = func;
}
void VG_(init___builtin_vec_delete)(void (*func)(void* p))
{
	if (func == NULL)
		func = missing_malloc___builtin_vec_delete;
	if (VG_(defined___builtin_vec_delete)())
		VG_(printf)("Warning tool is redefining __builtin_vec_delete\n");
	if (func == SK_(__builtin_vec_delete))
		VG_(printf)("Warning tool is defining __builtin_vec_delete recursively\n");
	VG_(tool_interface).malloc___builtin_vec_delete = func;
}
void VG_(init_realloc)(void* (*func)(void* p, Int size))
{
	if (func == NULL)
		func = missing_malloc_realloc;
	if (VG_(defined_realloc)())
		VG_(printf)("Warning tool is redefining realloc\n");
	if (func == SK_(realloc))
		VG_(printf)("Warning tool is defining realloc recursively\n");
	VG_(tool_interface).malloc_realloc = func;
}
/* Generated by "gen_toolint.pl initdlsym" */
#include <dlfcn.h>
void VG_(tool_init_dlsym)(void *dlhandle)
{
   void *ret;

   ret = dlsym(dlhandle, "vgSkin_post_clo_init");
   if (ret != NULL)
      VG_(init_post_clo_init)((void (*)())ret);

   ret = dlsym(dlhandle, "vgSkin_instrument");
   if (ret != NULL)
      VG_(init_instrument)((UCodeBlock* (*)(UCodeBlock*, Addr))ret);

   ret = dlsym(dlhandle, "vgSkin_fini");
   if (ret != NULL)
      VG_(init_fini)((void (*)(Int))ret);

   ret = dlsym(dlhandle, "vgSkin_eq_SkinError");
   if (ret != NULL)
      VG_(init_eq_SkinError)((Bool (*)(VgRes, Error*, Error*))ret);

   ret = dlsym(dlhandle, "vgSkin_pp_SkinError");
   if (ret != NULL)
      VG_(init_pp_SkinError)((void (*)(Error*))ret);

   ret = dlsym(dlhandle, "vgSkin_update_extra");
   if (ret != NULL)
      VG_(init_update_extra)((UInt (*)(Error*))ret);

   ret = dlsym(dlhandle, "vgSkin_recognised_suppression");
   if (ret != NULL)
      VG_(init_recognised_suppression)((Bool (*)(Char*, Supp*))ret);

   ret = dlsym(dlhandle, "vgSkin_read_extra_suppression_info");
   if (ret != NULL)
      VG_(init_read_extra_suppression_info)((Bool (*)(Int, Char*, Int, Supp*))ret);

   ret = dlsym(dlhandle, "vgSkin_error_matches_suppression");
   if (ret != NULL)
      VG_(init_error_matches_suppression)((Bool (*)(Error*, Supp*))ret);

   ret = dlsym(dlhandle, "vgSkin_get_error_name");
   if (ret != NULL)
      VG_(init_get_error_name)((Char* (*)(Error*))ret);

   ret = dlsym(dlhandle, "vgSkin_print_extra_suppression_info");
   if (ret != NULL)
      VG_(init_print_extra_suppression_info)((void (*)(Error*))ret);

   ret = dlsym(dlhandle, "vgSkin_discard_basic_block_info");
   if (ret != NULL)
      VG_(init_discard_basic_block_info)((void (*)(Addr, UInt))ret);

   ret = dlsym(dlhandle, "vgSkin_process_cmd_line_option");
   if (ret != NULL)
      VG_(init_process_cmd_line_option)((Bool (*)(Char*))ret);

   ret = dlsym(dlhandle, "vgSkin_print_usage");
   if (ret != NULL)
      VG_(init_print_usage)((void (*)())ret);

   ret = dlsym(dlhandle, "vgSkin_print_debug_usage");
   if (ret != NULL)
      VG_(init_print_debug_usage)((void (*)())ret);

   ret = dlsym(dlhandle, "vgSkin_handle_client_request");
   if (ret != NULL)
      VG_(init_handle_client_request)((Bool (*)(ThreadId, UInt*, UInt*))ret);

   ret = dlsym(dlhandle, "vgSkin_get_Xreg_usage");
   if (ret != NULL)
      VG_(init_get_Xreg_usage)((Int (*)(UInstr*, Tag, Int*, Bool*))ret);

   ret = dlsym(dlhandle, "vgSkin_emit_XUInstr");
   if (ret != NULL)
      VG_(init_emit_XUInstr)((void (*)(UInstr*, RRegSet))ret);

   ret = dlsym(dlhandle, "vgSkin_sane_XUInstr");
   if (ret != NULL)
      VG_(init_sane_XUInstr)((Bool (*)(Bool, Bool, UInstr*))ret);

   ret = dlsym(dlhandle, "vgSkin_name_XUOpcode");
   if (ret != NULL)
      VG_(init_name_XUOpcode)((Char * (*)(Opcode))ret);

   ret = dlsym(dlhandle, "vgSkin_pp_XUInstr");
   if (ret != NULL)
      VG_(init_pp_XUInstr)((void (*)(UInstr*))ret);

   ret = dlsym(dlhandle, "vgSkin_pre_syscall");
   if (ret != NULL)
      VG_(init_pre_syscall)((void * (*)(ThreadId, UInt, Bool))ret);

   ret = dlsym(dlhandle, "vgSkin_post_syscall");
   if (ret != NULL)
      VG_(init_post_syscall)((void (*)(ThreadId, UInt, void*, Int, Bool))ret);

   ret = dlsym(dlhandle, "vgSkin_cheap_sanity_check");
   if (ret != NULL)
      VG_(init_cheap_sanity_check)((Bool (*)())ret);

   ret = dlsym(dlhandle, "vgSkin_expensive_sanity_check");
   if (ret != NULL)
      VG_(init_expensive_sanity_check)((Bool (*)())ret);

   ret = dlsym(dlhandle, "vgSkin_new_mem_startup");
   if (ret != NULL)
      VG_(init_new_mem_startup)((void (*)(Addr, UInt, Bool, Bool, Bool))ret);

   ret = dlsym(dlhandle, "vgSkin_new_mem_stack_signal");
   if (ret != NULL)
      VG_(init_new_mem_stack_signal)((void (*)(Addr, UInt))ret);

   ret = dlsym(dlhandle, "vgSkin_new_mem_brk");
   if (ret != NULL)
      VG_(init_new_mem_brk)((void (*)(Addr, UInt))ret);

   ret = dlsym(dlhandle, "vgSkin_new_mem_mmap");
   if (ret != NULL)
      VG_(init_new_mem_mmap)((void (*)(Addr, UInt, Bool, Bool, Bool))ret);

   ret = dlsym(dlhandle, "vgSkin_copy_mem_remap");
   if (ret != NULL)
      VG_(init_copy_mem_remap)((void (*)(Addr, Addr, UInt))ret);

   ret = dlsym(dlhandle, "vgSkin_change_mem_mprotect");
   if (ret != NULL)
      VG_(init_change_mem_mprotect)((void (*)(Addr, UInt, Bool, Bool, Bool))ret);

   ret = dlsym(dlhandle, "vgSkin_die_mem_stack_signal");
   if (ret != NULL)
      VG_(init_die_mem_stack_signal)((void (*)(Addr, UInt))ret);

   ret = dlsym(dlhandle, "vgSkin_die_mem_brk");
   if (ret != NULL)
      VG_(init_die_mem_brk)((void (*)(Addr, UInt))ret);

   ret = dlsym(dlhandle, "vgSkin_die_mem_munmap");
   if (ret != NULL)
      VG_(init_die_mem_munmap)((void (*)(Addr, UInt))ret);

   ret = dlsym(dlhandle, "vgSkin_new_mem_stack_4");
   if (ret != NULL)
      VG_(init_new_mem_stack_4)((void (*)(Addr))ret);

   ret = dlsym(dlhandle, "vgSkin_new_mem_stack_8");
   if (ret != NULL)
      VG_(init_new_mem_stack_8)((void (*)(Addr))ret);

   ret = dlsym(dlhandle, "vgSkin_new_mem_stack_12");
   if (ret != NULL)
      VG_(init_new_mem_stack_12)((void (*)(Addr))ret);

   ret = dlsym(dlhandle, "vgSkin_new_mem_stack_16");
   if (ret != NULL)
      VG_(init_new_mem_stack_16)((void (*)(Addr))ret);

   ret = dlsym(dlhandle, "vgSkin_new_mem_stack_32");
   if (ret != NULL)
      VG_(init_new_mem_stack_32)((void (*)(Addr))ret);

   ret = dlsym(dlhandle, "vgSkin_new_mem_stack");
   if (ret != NULL)
      VG_(init_new_mem_stack)((void (*)(Addr, UInt))ret);

   ret = dlsym(dlhandle, "vgSkin_die_mem_stack_4");
   if (ret != NULL)
      VG_(init_die_mem_stack_4)((void (*)(Addr))ret);

   ret = dlsym(dlhandle, "vgSkin_die_mem_stack_8");
   if (ret != NULL)
      VG_(init_die_mem_stack_8)((void (*)(Addr))ret);

   ret = dlsym(dlhandle, "vgSkin_die_mem_stack_12");
   if (ret != NULL)
      VG_(init_die_mem_stack_12)((void (*)(Addr))ret);

   ret = dlsym(dlhandle, "vgSkin_die_mem_stack_16");
   if (ret != NULL)
      VG_(init_die_mem_stack_16)((void (*)(Addr))ret);

   ret = dlsym(dlhandle, "vgSkin_die_mem_stack_32");
   if (ret != NULL)
      VG_(init_die_mem_stack_32)((void (*)(Addr))ret);

   ret = dlsym(dlhandle, "vgSkin_die_mem_stack");
   if (ret != NULL)
      VG_(init_die_mem_stack)((void (*)(Addr, UInt))ret);

   ret = dlsym(dlhandle, "vgSkin_ban_mem_stack");
   if (ret != NULL)
      VG_(init_ban_mem_stack)((void (*)(Addr, UInt))ret);

   ret = dlsym(dlhandle, "vgSkin_pre_mem_read");
   if (ret != NULL)
      VG_(init_pre_mem_read)((void (*)(CorePart, ThreadId, Char*, Addr, UInt))ret);

   ret = dlsym(dlhandle, "vgSkin_pre_mem_read_asciiz");
   if (ret != NULL)
      VG_(init_pre_mem_read_asciiz)((void (*)(CorePart, ThreadId, Char*, Addr))ret);

   ret = dlsym(dlhandle, "vgSkin_pre_mem_write");
   if (ret != NULL)
      VG_(init_pre_mem_write)((void (*)(CorePart, ThreadId, Char*, Addr, UInt))ret);

   ret = dlsym(dlhandle, "vgSkin_post_mem_write");
   if (ret != NULL)
      VG_(init_post_mem_write)((void (*)(Addr, UInt))ret);

   ret = dlsym(dlhandle, "vgSkin_post_regs_write_init");
   if (ret != NULL)
      VG_(init_post_regs_write_init)((void (*)())ret);

   ret = dlsym(dlhandle, "vgSkin_post_reg_write_syscall_return");
   if (ret != NULL)
      VG_(init_post_reg_write_syscall_return)((void (*)(ThreadId, UInt))ret);

   ret = dlsym(dlhandle, "vgSkin_post_reg_write_deliver_signal");
   if (ret != NULL)
      VG_(init_post_reg_write_deliver_signal)((void (*)(ThreadId, UInt))ret);

   ret = dlsym(dlhandle, "vgSkin_post_reg_write_pthread_return");
   if (ret != NULL)
      VG_(init_post_reg_write_pthread_return)((void (*)(ThreadId, UInt))ret);

   ret = dlsym(dlhandle, "vgSkin_post_reg_write_clientreq_return");
   if (ret != NULL)
      VG_(init_post_reg_write_clientreq_return)((void (*)(ThreadId, UInt))ret);

   ret = dlsym(dlhandle, "vgSkin_post_reg_write_clientcall_return");
   if (ret != NULL)
      VG_(init_post_reg_write_clientcall_return)((void (*)(ThreadId, UInt, Addr))ret);

   ret = dlsym(dlhandle, "vgSkin_thread_run");
   if (ret != NULL)
      VG_(init_thread_run)((void (*)(ThreadId))ret);

   ret = dlsym(dlhandle, "vgSkin_post_thread_create");
   if (ret != NULL)
      VG_(init_post_thread_create)((void (*)(ThreadId, ThreadId))ret);

   ret = dlsym(dlhandle, "vgSkin_post_thread_join");
   if (ret != NULL)
      VG_(init_post_thread_join)((void (*)(ThreadId, ThreadId))ret);

   ret = dlsym(dlhandle, "vgSkin_pre_mutex_lock");
   if (ret != NULL)
      VG_(init_pre_mutex_lock)((void (*)(ThreadId, void*))ret);

   ret = dlsym(dlhandle, "vgSkin_post_mutex_lock");
   if (ret != NULL)
      VG_(init_post_mutex_lock)((void (*)(ThreadId, void*))ret);

   ret = dlsym(dlhandle, "vgSkin_post_mutex_unlock");
   if (ret != NULL)
      VG_(init_post_mutex_unlock)((void (*)(ThreadId, void*))ret);

   ret = dlsym(dlhandle, "vgSkin_pre_deliver_signal");
   if (ret != NULL)
      VG_(init_pre_deliver_signal)((void (*)(ThreadId, Int, Bool))ret);

   ret = dlsym(dlhandle, "vgSkin_post_deliver_signal");
   if (ret != NULL)
      VG_(init_post_deliver_signal)((void (*)(ThreadId, Int))ret);

   ret = dlsym(dlhandle, "vgSkin_init_shadow_page");
   if (ret != NULL)
      VG_(init_init_shadow_page)((void (*)(Addr))ret);

   ret = dlsym(dlhandle, "vgSkin_malloc");
   if (ret != NULL)
      VG_(init_malloc)((void* (*)(Int))ret);

   ret = dlsym(dlhandle, "vgSkin___builtin_new");
   if (ret != NULL)
      VG_(init___builtin_new)((void* (*)(Int))ret);

   ret = dlsym(dlhandle, "vgSkin___builtin_vec_new");
   if (ret != NULL)
      VG_(init___builtin_vec_new)((void* (*)(Int))ret);

   ret = dlsym(dlhandle, "vgSkin_memalign");
   if (ret != NULL)
      VG_(init_memalign)((void* (*)(Int, Int))ret);

   ret = dlsym(dlhandle, "vgSkin_calloc");
   if (ret != NULL)
      VG_(init_calloc)((void* (*)(Int, Int))ret);

   ret = dlsym(dlhandle, "vgSkin_free");
   if (ret != NULL)
      VG_(init_free)((void (*)(void*))ret);

   ret = dlsym(dlhandle, "vgSkin___builtin_delete");
   if (ret != NULL)
      VG_(init___builtin_delete)((void (*)(void*))ret);

   ret = dlsym(dlhandle, "vgSkin___builtin_vec_delete");
   if (ret != NULL)
      VG_(init___builtin_vec_delete)((void (*)(void*))ret);

   ret = dlsym(dlhandle, "vgSkin_realloc");
   if (ret != NULL)
      VG_(init_realloc)((void* (*)(void*, Int))ret);

}
/* Generated by "gen_toolint.pl structdef" */
#include "vg_toolint.h"
VgToolInterface VG_(tool_interface) = {

   /* These are the parameterised functions in the core.  The default definitions
      are overridden by LD_PRELOADed skin version.  At the very least, a skin
      must define the fundamental template functions.  Depending on what needs
      are set, extra template functions will be used too.  Functions are
      grouped under the needs that govern their use.
   
      ------------------------------------------------------------------
      Fundamental template functions
   
      Do initialisation that can only be done after command line processing.
    */
   .tool_post_clo_init = missing_tool_post_clo_init,

   /* Instrument a basic block.  Must be a true function, ie. the same input
      always results in the same output, because basic blocks can be
      retranslated.  Unless you're doing something really strange...
      'orig_addr' is the address of the first instruction in the block.
    */
   .tool_instrument = missing_tool_instrument,

   /* Finish up, print out any results, etc.  `exitcode' is program's exit
      code.  The shadow (if the `shadow_regs' need is set) can be found with
      VG_(get_shadow_archreg)(R_EBX), since %ebx holds the argument to the
      exit() syscall.
    */
   .tool_fini = missing_tool_fini,


   /* ------------------------------------------------------------------
      VG_(needs).core_errors
   
      (none needed)
   
      ------------------------------------------------------------------
      VG_(needs).skin_errors
   
      Identify if two errors are equal, or equal enough.  `res' indicates how
      close is "close enough".  `res' should be passed on as necessary, eg. if
      the Error's `extra' part contains an ExeContext, `res' should be
      passed to VG_(eq_ExeContext)() if the ExeContexts are considered.  Other
      than that, probably don't worry about it unless you have lots of very
      similar errors occurring.
    */
   .tool_eq_SkinError = missing_tool_eq_SkinError,

   /* Print error context. */
   .tool_pp_SkinError = missing_tool_pp_SkinError,

   /* Should fill in any details that could be postponed until after the
      decision whether to ignore the error (ie. details not affecting the
      result of SK_(eq_SkinError)()).  This saves time when errors are ignored.
      Yuk.
   
      Return value: must be the size of the `extra' part in bytes -- used by
      the core to make a copy.
    */
   .tool_update_extra = missing_tool_update_extra,

   /* Return value indicates recognition.  If recognised, must set skind using
      VG_(set_supp_kind)().
    */
   .tool_recognised_suppression = missing_tool_recognised_suppression,

   /* Read any extra info for this suppression kind.  Most likely for filling
      in the `extra' and `string' parts (with VG_(set_supp_{extra, string})())
      of a suppression if necessary.  Should return False if a syntax error
      occurred, True otherwise.
    */
   .tool_read_extra_suppression_info = missing_tool_read_extra_suppression_info,

   /* This should just check the kinds match and maybe some stuff in the
      `string' and `extra' field if appropriate (using VG_(get_supp_*)() to
      get the relevant suppression parts).
    */
   .tool_error_matches_suppression = missing_tool_error_matches_suppression,

   /* This should return the suppression name, for --gen-suppressions, or NULL
      if that error type cannot be suppressed.  This is the inverse of
      SK_(recognised_suppression)().
    */
   .tool_get_error_name = missing_tool_get_error_name,

   /* This should print any extra info for the error, for --gen-suppressions,
      including the newline.  This is the inverse of
      SK_(read_extra_suppression_info)().
    */
   .tool_print_extra_suppression_info = missing_tool_print_extra_suppression_info,


   /* ------------------------------------------------------------------
      VG_(needs).basic_block_discards
   
      Should discard any information that pertains to specific basic blocks
      or instructions within the address range given.
    */
   .tool_discard_basic_block_info = missing_tool_discard_basic_block_info,


   /* ------------------------------------------------------------------
      VG_(needs).shadow_regs
   
      No functions must be defined, but the post_reg[s]_write_* events should
      be tracked.
   
      ------------------------------------------------------------------
      VG_(needs).command_line_options
   
      Return True if option was recognised.  Presumably sets some state to
      record the option as well.
    */
   .tool_process_cmd_line_option = missing_tool_process_cmd_line_option,

   /* Print out command line usage for options for normal skin operation. */
   .tool_print_usage = missing_tool_print_usage,

   /* Print out command line usage for options for debugging the skin. */
   .tool_print_debug_usage = missing_tool_print_debug_usage,

   /* ------------------------------------------------------------------
      VG_(needs).client_requests
   
      If using client requests, the number of the first request should be equal
      to VG_USERREQ_SKIN_BASE('X', 'Y'), where 'X' and 'Y' form a suitable two
      character identification for the string.  The second and subsequent
      requests should follow.
   
      This function should use the VG_IS_SKIN_USERREQ macro (in
      include/valgrind.h) to first check if it's a request for this skin.  Then
      should handle it if it's recognised (and return True), or return False if
      not recognised.  arg_block[0] holds the request number, any further args
      from the request are in arg_block[1..].  'ret' is for the return value...
      it should probably be filled, if only with 0.
    */
   .tool_handle_client_request = missing_tool_handle_client_request,


   /* ------------------------------------------------------------------
      VG_(needs).extends_UCode
   
      'X' prefix indicates eXtended UCode.
    */
   .tool_get_Xreg_usage = missing_tool_get_Xreg_usage,
   .tool_emit_XUInstr = missing_tool_emit_XUInstr,
   .tool_sane_XUInstr = missing_tool_sane_XUInstr,
   .tool_name_XUOpcode = missing_tool_name_XUOpcode,
   .tool_pp_XUInstr = missing_tool_pp_XUInstr,


   /* ------------------------------------------------------------------
      VG_(needs).syscall_wrapper
   
      If either of the pre_ functions malloc() something to return, the
      corresponding post_ function had better free() it!
   
    */
   .tool_pre_syscall = missing_tool_pre_syscall,
   .tool_post_syscall = missing_tool_post_syscall,


   /* ---------------------------------------------------------------------
        VG_(needs).sanity_checks
   
      Can be useful for ensuring a skin's correctness.  SK_(cheap_sanity_check)
      is called very frequently;  SK_(expensive_sanity_check) is called less
      frequently and can be more involved.
    */
   .tool_cheap_sanity_check = missing_tool_cheap_sanity_check,
   .tool_expensive_sanity_check = missing_tool_expensive_sanity_check,


   /* ================================================================================
      Event tracking functions
   
      Events happening in core to track.  To be notified, pass a callback
      function to the appropriate function.  To ignore an event, don't do
      anything (default is for events to be ignored).
   
      Note that most events aren't passed a ThreadId.  To find out the ThreadId
      of the affected thread, use VG_(get_current_or_recent_tid)().  For the
      ones passed a ThreadId, use that instead, since
      VG_(get_current_or_recent_tid)() might not give the right ThreadId in
      that case.
   
      Memory events (Nb: to track heap allocation/freeing, a skin must replace
      malloc() et al.  See above how to do this.)
   
      These ones occur at startup, upon some signals, and upon some syscalls
    */
   .track_new_mem_startup = missing_track_new_mem_startup,
   .track_new_mem_stack_signal = missing_track_new_mem_stack_signal,
   .track_new_mem_brk = missing_track_new_mem_brk,
   .track_new_mem_mmap = missing_track_new_mem_mmap,

   .track_copy_mem_remap = missing_track_copy_mem_remap,
   .track_change_mem_mprotect = missing_track_change_mem_mprotect,
   .track_die_mem_stack_signal = missing_track_die_mem_stack_signal,
   .track_die_mem_brk = missing_track_die_mem_brk,
   .track_die_mem_munmap = missing_track_die_mem_munmap,

   /* These ones are called when %esp changes.  A skin could track these itself
      (except for ban_mem_stack) but it's much easier to use the core's help.
   
      The specialised ones are called in preference to the general one, if they
      are defined.  These functions are called a lot if they are used, so
      specialising can optimise things significantly.  If any of the
      specialised cases are defined, the general case must be defined too.
   
      Nb: they must all use the __attribute__((regparm(n))) attribute.
    */
   .track_new_mem_stack_4 = missing_track_new_mem_stack_4,
   .track_new_mem_stack_8 = missing_track_new_mem_stack_8,
   .track_new_mem_stack_12 = missing_track_new_mem_stack_12,
   .track_new_mem_stack_16 = missing_track_new_mem_stack_16,
   .track_new_mem_stack_32 = missing_track_new_mem_stack_32,
   .track_new_mem_stack = missing_track_new_mem_stack,

   .track_die_mem_stack_4 = missing_track_die_mem_stack_4,
   .track_die_mem_stack_8 = missing_track_die_mem_stack_8,
   .track_die_mem_stack_12 = missing_track_die_mem_stack_12,
   .track_die_mem_stack_16 = missing_track_die_mem_stack_16,
   .track_die_mem_stack_32 = missing_track_die_mem_stack_32,
   .track_die_mem_stack = missing_track_die_mem_stack,

   /* Used for redzone at end of thread stacks */
   .track_ban_mem_stack = missing_track_ban_mem_stack,

   /* These ones occur around syscalls, signal handling, etc */
   .track_pre_mem_read = missing_track_pre_mem_read,
   .track_pre_mem_read_asciiz = missing_track_pre_mem_read_asciiz,
   .track_pre_mem_write = missing_track_pre_mem_write,
   /* Not implemented yet -- have to add in lots of places, which is a
      pain.  Won't bother unless/until there's a need.
      void (*post_mem_read)  ( ThreadState* tst, Char* s, Addr a, UInt size );
    */
   .track_post_mem_write = missing_track_post_mem_write,


   /* Register events -- if `shadow_regs' need is set, all should probably be
      used.  Use VG_(set_thread_shadow_archreg)() to set the shadow of the
      changed register.
   
      Use VG_(set_shadow_archreg)() to set the eight general purpose regs,
      and use VG_(set_shadow_eflags)() to set eflags.
    */
   .track_post_regs_write_init = missing_track_post_regs_write_init,

   /* Use VG_(set_thread_shadow_archreg)() to set the shadow regs for these
      events.
    */
   .track_post_reg_write_syscall_return = missing_track_post_reg_write_syscall_return,
   .track_post_reg_write_deliver_signal = missing_track_post_reg_write_deliver_signal,
   .track_post_reg_write_pthread_return = missing_track_post_reg_write_pthread_return,
   .track_post_reg_write_clientreq_return = missing_track_post_reg_write_clientreq_return,
   /* This one is called for malloc() et al if they are replaced by a skin. */
   .track_post_reg_write_clientcall_return = missing_track_post_reg_write_clientcall_return,


   /* Scheduler events (not exhaustive) */
   .track_thread_run = missing_track_thread_run,


   /* Thread events (not exhaustive)
   
      Called during thread create, before the new thread has run any
      instructions (or touched any memory).
    */
   .track_post_thread_create = missing_track_post_thread_create,
   .track_post_thread_join = missing_track_post_thread_join,


   /* Mutex events (not exhaustive)
      "void *mutex" is really a pthread_mutex *
   
      Called before a thread can block while waiting for a mutex (called
      regardless of whether the thread will block or not).
    */
   .track_pre_mutex_lock = missing_track_pre_mutex_lock,
   /* Called once the thread actually holds the mutex (always paired with
      pre_mutex_lock).
    */
   .track_post_mutex_lock = missing_track_post_mutex_lock,
   /* Called after a thread has released a mutex (no need for a corresponding
      pre_mutex_unlock, because unlocking can't block).
    */
   .track_post_mutex_unlock = missing_track_post_mutex_unlock,

   /* Signal events (not exhaustive)
   
      ... pre_send_signal, post_send_signal ...
   
      Called before a signal is delivered;  `alt_stack' indicates if it is
      delivered on an alternative stack. 
    */
   .track_pre_deliver_signal = missing_track_pre_deliver_signal,
   /* Called after a signal is delivered.  Nb: unfortunately, if the signal
      handler longjmps, this won't be called.
    */
   .track_post_deliver_signal = missing_track_post_deliver_signal,


   /* Others... condition variable...
      ...
   
      Shadow memory management
    */
   .track_init_shadow_page = missing_track_init_shadow_page,

   /* ================================================================================
      malloc and friends
    */
   .malloc_malloc = missing_malloc_malloc,
   .malloc___builtin_new = missing_malloc___builtin_new,
   .malloc___builtin_vec_new = missing_malloc___builtin_vec_new,
   .malloc_memalign = missing_malloc_memalign,
   .malloc_calloc = missing_malloc_calloc,
   .malloc_free = missing_malloc_free,
   .malloc___builtin_delete = missing_malloc___builtin_delete,
   .malloc___builtin_vec_delete = missing_malloc___builtin_vec_delete,
   .malloc_realloc = missing_malloc_realloc,
};
