/*-*- c -*- ----------------------------------------------------------*/
/*---                                          powerpc/tool_arch.h ---*/
/*--------------------------------------------------------------------*/

/*
   This file is part of Valgrind, an extensible protected-mode
   emulator for monitoring program execution on Linux.

   Copyright (C) 2004 Paul Mackerras
      paulus@samba.org

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307, USA.

   The GNU General Public License is contained in the file COPYING.
*/

#ifndef __PPC_TOOL_ARCH_H
#define __PPC_TOOL_ARCH_H

#define REGPARM(n)

/* All instructions are 4 bytes long */
#define MIN_INSTR_SIZE	4
#define MAX_INSTR_SIZE	4

/* Total number of integer registers available for allocation: r10 - r19. */
#define VG_MAX_REALREGS 10

/* PowerPC encodings */

/* Condition encodings */
typedef
   enum{
      CondIfClear = 0,	/* Jump if CR bit is 0 */
      CondIfSet   = 32,	/* Jump if CR bit is 1 */
      CondAlways  = 64
   }
   Condcode;

/* We use the "flags" values to track some of the bits in the XER */
#define FlagSO	8
#define FlagOV	4
#define FlagCA	2

#define FlagsALL	(FlagSO|FlagOV|FlagCA)
#define FlagsEmpty	0

/* Register numbers 0 to 31 are used for the general registers */
#define R_GPR0	0
#define R_GPR1	1
#define R_ESP	1
#define R_GPR3	3
#define R_CR	32
#define R_LR	33
#define R_CTR	34
#define R_XER	35

// Interesting register numbers
#define R_STACK_PTR	1
#define R_FRAME_PTR	1

#define FIRST_ARCH_REG	R_GPR0
#define LAST_ARCH_REG	R_XER

/* Number of ArchRegs that can be accessed with GET and PUT */
#define N_ARCH_REGS	36

/* Various PowerPC instruction formats... */
#define DFORM(op, rd, ra, d)		\
	(((op) << 26) | ((rd) << 21) | ((ra) << 16) | (d))
#define XLFORM(bo, bi, mo, lk)		\
	((19 << 26) | ((bo) << 21) | ((bi) << 16) | ((mo) << 1) | (lk))
#define XFORM19(rd, ra, rb, mo)	\
	((19<<26) | ((rd)<<21) | ((ra)<<16) | ((rb)<<11) | ((mo)<<1))
#define XFORM31(rd, ra, rb, mo, rc)	\
	((31<<26) | ((rd)<<21) | ((ra)<<16) | ((rb)<<11) | ((mo)<<1) | (rc))
#define XFORM63(rd, ra, rb, mo, rc)	\
	((63U<<26) | ((rd)<<21) | ((ra)<<16) | ((rb)<<11) | ((mo)<<1) | (rc))
#define MFORM(op, rs, ra, sh, mb, me, rc)		\
	(((op) << 26) | ((rs) << 21) | ((ra) << 16)	\
	 | ((sh) << 11) | ((mb) << 6) | ((me) << 1) | (rc))
#define BFORM(op, bo, bi, bd, aalk)	\
	(((op) << 26) | ((bo) << 21) | ((bi) << 16) | ((bd) << 2) | (aalk))

/* PPC opcode values */
#define MULLI	7U
#define CMPI	11U
#define ADDIC	12U
#define ADDI	14U
#define ADDIS	15U
#define BC	16U
#define RLWIMI	20U
#define RLWINM	21U
#define RLWNM	23U
#define ORI	24U
#define ORIS	25U
#define XORI	26U
#define XORIS	27U
#define ANDIR	28U
#define LWZ	32U
#define LBZ	34U
#define STW	36U
#define STB	38U
#define LHZ	40U
#define STH	44U
#define LFS	48U
#define LFD	50U
#define STFS	52U
#define STFD	54U

/* PPC minor opcode values for major = 19 (XLFORM) */
#define BCLR	16
#define BCCTR	528
#define CRANDC	129
#define CROR	449

/* PPC minor opcode values for major = 31 (XFORM) */
#define MO_CMP		0
#define MO_LVSL		6
#define MO_LVEBX	7
#define MO_SUBFC	8
#define MO_MULHWU	11
#define MO_ADDC		10
#define MO_MFCR		19
#define MO_LWARX	20
#define MO_SLW		24
#define MO_CNTLZW	26
#define MO_AND		28
#define MO_CMPL		32
#define MO_LVSR		38
#define MO_LVEHX	39
#define MO_SUBF		40
#define MO_ANDC		60
#define MO_LVEWX	71
#define MO_MULHW	75
#define MO_LVX		103
#define MO_NEG		104
#define MO_NOR		124
#define MO_STVEBX	135
#define MO_SUBFE	136
#define MO_ADDE		138
#define MO_MTCRF	144
#define MO_STWCX	150
#define MO_STVEHX	167
#define MO_STVEWX	199
#define MO_ADDZE	202
#define MO_STVX		231
#define MO_ADDME	234
#define MO_MULLW	235
#define MO_ADD		266
#define MO_XOR		316
#define MO_MFSPR	339
#define MO_MFTB		371
#define MO_ORC		412
#define MO_OR		444
#define MO_MTSPR	467
#define MO_DIVWU	459
#define MO_DIVW		491
#define MO_SRW		536
#define MO_LSWI		597
#define MO_STSWI	725
#define MO_SRAW		792
#define MO_SRAWI	824
#define MO_EXTSH	922
#define MO_EXTSB	954

/* PPC minor opcode values for major = 63 (XFORM) */
#define MO_FCMPU	0
#define MO_FCMPO	32
#define MO_MFFS		583
#define MO_MTFSF	711

/* SPR (special purpose register) numbers */
#define SPRN_XER	1
#define SPRN_LR		8
#define SPRN_CTR	9

/* Interesting registers */
#define BB	31		/* r31 points to baseBlock */

#endif /* __PPC_TOOL_ARCH_H */
