
/*
   This file is part of Valgrind, an extensible
   emulator for monitoring program execution on Unixes.

   Copyright (C) 2004 Paul Mackerras <paulus@samba.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307, USA.

   The GNU General Public License is contained in the file COPYING.
*/

#include "ume_arch.h"

/* This jumps to PC after setting the stack pointer to SP. */
/* It would probably be easier to do this in assembly. */
void ume_go(addr_t pc, addr_t sp)
{
    asm volatile ("mtctr %0\n\t"
		  "mr 1,%1\n\t"
		  "li 0,0\n\t"
		  "li 3,0\n\t"
		  "li 4,0\n\t"
		  "li 5,0\n\t"
		  "li 6,0\n\t"
		  "li 7,0\n\t"
		  "li 8,0\n\t"
		  "li 9,0\n\t"
		  "li 10,0\n\t"
		  "li 11,0\n\t"
		  "li 12,0\n\t"
		  "li 13,0\n\t"
		  "li 14,0\n\t"
		  "li 15,0\n\t"
		  "li 16,0\n\t"
		  "li 17,0\n\t"
		  "li 18,0\n\t"
		  "li 19,0\n\t"
		  "li 20,0\n\t"
		  "li 21,0\n\t"
		  "li 22,0\n\t"
		  "li 23,0\n\t"
		  "li 24,0\n\t"
		  "li 25,0\n\t"
		  "li 26,0\n\t"
		  "li 27,0\n\t"
		  "li 28,0\n\t"
		  "li 29,0\n\t"
		  "li 30,0\n\t"
		  "li 31,0\n\t"
		  "mtlr 0\n\t"
		  "mtxer 0\n\t"
		  "mtcr 0\n\t"
		  "bctr\n\t"
		  : : "r" (pc), "r" (sp));
    for (;;)
	asm volatile("trap");
}

void call_on_stack(void (*func)(void), addr_t sp)
{
    sp &= ~0xf;			/* align the stack pointer */
    sp -= 16;			/* make a stack frame */
    *(unsigned int *)sp = 0;
    ume_go((addr_t)func, sp);
}
