/*
 * tools/lib/vg_check_exist.c
 *
 * Copyright (C) 1997 - 1999  Heinz Mauelshagen, Germany
 *
 * March, November 1997
 *
 *
 * This LVM library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This LVM library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this LVM library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA
 *
 */

/*
 * Changelog
 *
 *    11/09/97 - added error code in vg_check_exist for invalid
 *               structure version
 *
 */

#include <liblvm.h>

int vg_check_exist ( char *vg_name) {
   int pv_count = 0;
   int p = 0;
   int ret = 0;
   vg_t *vg = NULL;
   pv_t **pv = NULL;

#ifdef DEBUG
   debug ( "vg_check_exist -- CALLED with %s\n", vg_name);
#endif

   if ( vg_name == NULL || vg_check_name ( vg_name) < 0) return -LVM_EPARAM;

   if ( ( ret = vg_read ( vg_name, &vg)) < 0) return ret;
#ifdef DEBUG
   debug ( "vg_check_exist -- before pv_read_all_pv_of_vg\n");
#endif
   if ( ( ret = pv_read_all_pv_of_vg ( vg_name, &pv, TRUE)) < 0) return ret;

   for ( p = 0; pv != NULL && pv[p] != NULL; p++) {
      if ( system_id_check_exported ( pv[p]->system_id) == TRUE)
         pv[p]->vg_name[strlen(pv[p]->vg_name)-strlen(EXPORTED)] = 0;
      if ( strcmp ( vg_name, pv[p]->vg_name) == 0) {
         pv_count++;
         if ( pv[p]->version != LVM_STRUCT_VERSION)
            return -LVM_EVG_READ_LVM_STRUCT_VERSION;
         if ( system_id_check_exported ( pv[p]->system_id) == TRUE)
            return -LVM_EPV_READ_PV_EXPORTED;
      }
   }

#ifdef DEBUG
   debug ( "vg_check_exist -- before vg->pv_cur check with "
            "vg->pv_cur: %lu  pv_count: %d\n", vg->pv_cur, pv_count);
#endif
   if ( vg->pv_cur != pv_count) return -LVM_EVG_CHECK_EXIST_PV_COUNT;

#ifdef DEBUG
   debug ( "vg_check_exist -- LEAVING\n");
#endif
   return TRUE;
}


char **vg_check_exist_all_vg ( void) {
   int v = 0;
   int nv = 0;
   int ret = 0;
   char vg_name[NAME_LEN] = { 0, };
   char **vg_name_ptr_sav = NULL;
   static char **vg_name_ptr = NULL;

#ifdef DEBUG
   debug ( "vg_check_exist_all_vg -- CALLED\n");
#endif

   if ( vg_name_ptr != NULL) {
      for ( v = 0; vg_name_ptr[v] != NULL; v++) free ( vg_name_ptr[v]);
      free ( vg_name_ptr);
      vg_name_ptr = NULL;
   }

   nv = 0;
   for ( v = 0; v <= ABS_MAX_VG; v++) {
      sprintf ( vg_name, "vg%02d%c", v, 0);
#ifdef DEBUG
      debug ( "vg_check_exist_all_vg -- checking vg_name: %s\n", vg_name);
#endif
      if ( ( ret = vg_check_exist ( vg_name)) == TRUE) {
#ifdef DEBUG
         debug ( "vg_check_exist_all_vg -- HIT vg_name: %s\n", vg_name);
#endif
         vg_name_ptr_sav = vg_name_ptr;
         if ( ( vg_name_ptr = realloc ( vg_name_ptr,
                                        ( nv +2) * sizeof ( char*))) == NULL) {
            fprintf ( stderr, "realloc error in %s [line %d]\n",
                              __FILE__, __LINE__);
            if ( vg_name_ptr_sav != NULL)
               for ( v = 0; vg_name_ptr_sav[v] != NULL; v++)
                  free ( vg_name_ptr_sav[v]);
            return NULL;
         }
         if ( ( vg_name_ptr[nv] = malloc ( strlen ( vg_name) + 1)) == NULL) {
            fprintf ( stderr, "malloc error in %s [line %d]\n",
                              __FILE__, __LINE__);
            for ( v = 0; vg_name_ptr[v] != NULL; v++)
               free ( vg_name_ptr[v]);
            free ( vg_name_ptr);
            vg_name_ptr = NULL;
            return NULL;
         }
         strcpy ( vg_name_ptr[nv], vg_name);
#ifdef DEBUG
         debug ( "vg_check_exist_all_vg -- vg_name_ptr[nv]: %s\n",
                  vg_name_ptr[nv]);
#endif
         nv++;
         vg_name_ptr[nv] = NULL;
      } else {
#ifdef DEBUG
         debug ( "vg_check_exist_all_vg -- vg_check_exist returned %d\n", ret);
#endif
      }
   }

#ifdef DEBUG
   debug ( "vg_check_exist_all_vg -- LEAVING\n");
#endif
   return vg_name_ptr;
}
