/*
 * tools/lib/lv_create_kdev_t.c
 *
 * Copyright (C) 1997 - 1999  Heinz Mauelshagen, Germany
 *
 * March 1997
 *
 *
 * This LVM library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This LVM library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this LVM library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA
 *
 */

/*
 * Changelog
 *
 *    11/01/1998 - changed to use number_from_name functions
 *                 for free logical volume names
 *    29/04/1998 - rewritten to avoid lv_name usage
 *    02/08/1998 - used official LVM block major
 *
 */

#include <liblvm.h>

kdev_t lv_create_kdev_t ( ulong vg_number, ulong lv_number) {

#ifdef DEBUG
   debug ( "lv_create_kdev_t -- CALLED vg_number: %d  lv_number: %d\n",
            vg_number, lv_number);
#endif

   if ( vg_number < 0 || vg_number > ABS_MAX_VG ||
        lv_number < 1 || lv_number > ABS_MAX_LV) return 0;

#ifdef DEBUG
   debug ( "lv_create_kdev_t -- LEAVING\n");
#endif
   return ( LVM_BLOCK_MAJOR << LVM_MINORBITS) +
            ( vg_number << VG_BITSHIFT) + lv_number;
}
