/*
 * tools/lib/vg_create_dir_and_group.c
 *
 * Copyright (C) 1997 - 2000  Heinz Mauelshagen, Sistina Software
 *
 * May 1997
 * January,December 1998
 * January,February 1999
 * January 2000
 *
 *
 * This LVM library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This LVM library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this LVM library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA
 *
 */

/*
 *
 * Changelog
 *
 *    11/01/1998 - added deletion of volume group special file directory
 *    13/12/1998 - corrected flow
 *    26/01/1999 - made volume group directory prefix a preprocessor option
 *    16/02/1999 - changed special generation to new scheme
 *    08/02/2000 - use debug_enter()/debug_leave()
 *
 */

#include <liblvm.h>

int vg_create_dir_and_group ( vg_t *vg) {
   int gid = 0;
   int ret = 0;
   struct group *grent = NULL;
   char buffer[NAME_LEN];

#ifdef DEBUG
   debug_enter ( "vg_create_dir_and_group -- CALLED\n");
#endif

   if ( vg == NULL || vg_check_name ( vg->vg_name) < 0) ret = -LVM_EPARAM;
   else {
      vg_remove_dir_and_group_and_nodes ( vg->vg_name);
      mkdir ( LVM_DIR_PREFIX, 0555);
      sprintf ( buffer, LVM_DIR_PREFIX "%s%c", vg->vg_name, 0);
      if ( mkdir ( buffer, 0555) == -1)
         ret = -LVM_EVG_CREATE_DIR_AND_GROUP_MKDIR;
      else {
         if ( chmod ( buffer, 0555) == -1)
            ret = -LVM_EVG_CREATE_DIR_AND_GROUP_CHMOD_DIR;
         else {
            strcat ( buffer, "/group");
            if ( ( grent = getgrnam ( "disk")) != NULL) gid = grent->gr_gid;
            if ( mknod ( buffer, S_IFCHR | S_IRUSR | S_IWUSR | S_IRGRP,
                         ( LVM_CHAR_MAJOR << MINORBITS) +
                         vg->vg_number) == -1)
               ret = -LVM_EVG_CREATE_DIR_AND_GROUP_MKNOD;
            else if ( chmod ( buffer, 0640) == -1) 
                    ret = -LVM_EVG_CREATE_DIR_AND_GROUP_CHMOD_GROUP;
            else if ( chown ( buffer, 0, gid) == -1)
                    ret = -LVM_EVG_CREATE_DIR_AND_GROUP_CHOWN_GROUP;
         }
      }
   }

#ifdef DEBUG
   debug_leave ( "vg_create_dir_and_group -- LEAVING with ret: %d\n", ret);
#endif
   return ret;
}
