/*
 * tools/lib/pv_read_uuidlist.c
 *
 * Copyright (C) 1997 - 2000  Heinz Mauelshagen, Sistina Software
 *
 * March-May,October-November 1997
 * May,August,November 1998
 * February,March,October 2000
 *
 *
 * This LVM library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This LVM library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this LVM library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA
 *
 */

/*
 * Changelog
 *
 *    08/02/2000 - use debug_enter()/debug_leave()
 *    07/03/2000 - renamed function from
 *                 pv_read_namelist() to pv_read_uuidlist()
 *    17/03/2000 - changed namelist to uuidlist
 *    30/10/2000 - make PV uuidlist a continuous array
 *
 */
  
#include <liblvm.h>


int pv_read_uuidlist ( char *pv_name, char **pv_uuidlist) {
   int pv_handle = -1;
   int ret = 0, i = 0;
   ulong size = 0;
   pv_t *pv_this_ptr = NULL;
   char *ptr = NULL;
   static char *this_pv_uuidlist = NULL;

#ifdef DEBUG
   debug_enter ( "pv_read_uuidlist -- CALLED with %s\n", pv_name);
#endif

   if ( this_pv_uuidlist != NULL) {
      free ( this_pv_uuidlist);
      this_pv_uuidlist = NULL;
   }

   if ( pv_name == NULL ||
        pv_check_name ( pv_name) < 0 ||
        pv_uuidlist == NULL) {
      ret = -LVM_EPARAM;
   } else {
      if ( ( ret = pv_read ( pv_name, &pv_this_ptr, NULL)) == 0) {
         if ( ( pv_handle = open ( pv_name, O_RDONLY)) == -1)
            ret = -LVM_EPV_READ_UUIDLIST_OPEN;
         else if ( lseek ( pv_handle,
                           pv_this_ptr->pv_uuidlist_on_disk.base,
                           SEEK_SET) !=
                   pv_this_ptr->pv_uuidlist_on_disk.base)
            ret = -LVM_EPV_READ_UUIDLIST_LSEEK;
         else {
            size = ABS_MAX_PV * NAME_LEN;
            if ( ( this_pv_uuidlist = malloc ( size)) == NULL) {
               fprintf ( stderr, "%s -- malloc error in %s [line %d]\n",
                                 cmd, __FILE__, __LINE__);
               ret = -LVM_EPV_READ_UUIDLIST_MALLOC;
            } else {
               memset ( this_pv_uuidlist, 0, size);
               if ( read ( pv_handle, this_pv_uuidlist, size) !=
                    size) {
                  free ( this_pv_uuidlist);
                  this_pv_uuidlist = NULL;
                  ret = -LVM_EPV_READ_UUIDLIST_READ;
               } else {
                  for ( i = 0; i < ABS_MAX_PV; i++) {
                     ptr = this_pv_uuidlist + i * NAME_LEN;
                     if ( lvm_check_uuid ( ptr) < 0) {
                        memset ( ptr, 0, NAME_LEN);
                     }
                  }
               }
               for ( i = 0; i < ABS_MAX_PV - 1; i++) {
                  ptr = this_pv_uuidlist + i * NAME_LEN;
                  if ( ptr[0] == 0) {
                     memmove ( ptr,
                               ptr + NAME_LEN,
                               ( ABS_MAX_PV - i - 1) * NAME_LEN);
                  }
               }
            }
         }
      }
   
      if ( pv_handle != -1) close ( pv_handle);
      if ( ret == 0) {
         *pv_uuidlist = this_pv_uuidlist;
         for ( i = 0; i < ABS_MAX_PV; i++) {
            if ( this_pv_uuidlist[i*NAME_LEN] == 0) break;
            if ( lvm_check_uuid ( &this_pv_uuidlist[i*NAME_LEN]) == 0) ret++;
         }
      }

   }

#ifdef DEBUG
   debug_leave ( "pv_read_uuidlist -- LEAVING with ret: %d\n", ret);
#endif
   return ret;
}
