/*
 * tools/lvmsadc.c
 *
 * Copyright (C) 1998 - 1999  Heinz Mauelshagen, Germany
 *
 * July,September 1998
 * February 1999
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with LVM; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

/*
 * Changelog
 *
 *    21/02/1999 - removed LVM_LOCK and LVM_UNLOCK
 *
 */

#include <lvm_user.h>

char *cmd = NULL;
#ifdef DEBUG
   int opt_d = 0;
#endif

int main ( int argc, char **argv) {
   int c = 0;
   int l = 0;
   int le = 0;
   int opt_v = 0;
   int ret = 0;
   int v = 0;
#ifdef DEBUG
   char *options = "dh?v";
#else
   char *options = "h?v";
#endif
   char *logfile = NULL;
   char *vg_name = NULL;
   char **vg_name_ptr = NULL;
   vg_t *vg = NULL;
   FILE *log = NULL;

   cmd = basename ( argv[0]);

   SUSER_CHECK;
   LVMTAB_CHECK;

   while ( ( c = getopt ( argc, argv, options)) != EOF) {
      switch ( c) {
#ifdef DEBUG
         case 'd':
            if ( opt_d > 0) {
               fprintf ( stderr, "%s -- d option already given\n\n", cmd);
               return LVM_EINVALID_CMD_LINE;
            }
            opt_d++;
            break;
#endif

         case 'h':
         case '?':
            printf ( "\n%s\n\n%s -- Logical Volume Manager System "
                     "Activity Data Collector\n\n"
                     "Synopsis:\n"
                     "---------\n\n"
                     "%s\n"
#ifdef DEBUG
                     "\t[-d]\n"
#endif
                     "\t[-h/-?]\n"
                     "\t[-v]\n"
                     "\tLogFilePath\n\n",
                     lvm_version, cmd, cmd);
            return 0;
            break;

         case 'v':
            if ( opt_v > 0) {
               fprintf ( stderr, "%s -- v option already given\n\n", cmd);
               return LVM_EINVALID_CMD_LINE;
            }
            opt_v++;
            break;

         default:
            fprintf ( stderr, "%s -- invalid command line option \"%c\"\n\n",
                      cmd, c);
            return LVM_EINVALID_CMD_LINE;
      }
   }

   CMD_MINUS_CHK;
   LVM_CHECK_IOP;


   if ( argc - optind != 1) {
      fprintf ( stderr, "%s -- please enter an activity data log file\n\n",
                        cmd);
      return LVM_ELVMSADC_NO_LOG_FILE;
   } else logfile = argv[optind];

   if ( opt_v > 0) printf ( "%s -- opening logfile \"%s\"\n", cmd, logfile);
   if ( ( log = fopen ( logfile, "a")) == NULL) {
      fprintf ( stderr, "%s -- ERROR %d opening \"%s\" for append\n\n",
                        cmd, errno, logfile);
      return LVM_ELVMSADC_FOPEN;
   }
   chmod ( logfile, 0640);

   if ( opt_v > 0) printf ( "%s -- finding all volume group(s)\n", cmd);
   vg_name_ptr = lvm_tab_vg_check_exist_all_vg ();
   argc = 0;
   if ( vg_name_ptr != NULL) for ( v = 0; vg_name_ptr[v] != NULL; v++) argc++;
   argv = vg_name_ptr;
   optind = 0;

   if ( opt_v > 0) printf ( "%s -- checking for found volume groups\n", cmd);
   if ( argc == 0) {
      printf ( "%s -- no volume groups found\n\n", cmd);
      return LVM_ELVMSADC_NO_VGS;
   }

   fprintf ( log, "%lu\n", time ( NULL));

   /* work on all given/found volume groups */
   for ( ; optind < argc; optind++) {
      vg_name = argv[optind];
      if ( vg_check_active ( vg_name) != TRUE) continue;
      if ( ( ret = vg_status_with_pv_and_lv ( vg_name, &vg, TRUE)) == 0) {
         for ( l = 0; l < vg->lv_max; l++) {
            if ( vg->lv[l] != NULL) {
               fprintf ( log, "%s %d\n",
                              vg->lv[l]->lv_name,
                              vg->lv[l]->lv_allocated_le);
               for ( le = 0; le < vg->lv[l]->lv_allocated_le; le++) {
                  fprintf ( log, "%d %d %d\n",
                                 le,
                                 vg->lv[l]->lv_current_pe[le].reads,
                                 vg->lv[l]->lv_current_pe[le].writes);
               }
            }
         }
      }
   }

   if ( opt_v > 0) printf ( "%s -- closing logfile \"%s\"\n", cmd, logfile);
   if ( fclose ( log) < 0) {
      fprintf ( stderr, "%s -- ERROR %d closing \"%s\"\n\n",
                        cmd, errno, logfile);
      return LVM_ELVMSADC_FCLOSE;
   }

   return 0;
}
