/*
 * tools/lib/pv_check_name.c
 *
 * Copyright (C) 1997 - 2000  Heinz Mauelshagen, Germany
 *
 * March 1997
 * May,September 1998
 * January,March,April,July 1999
 * February 2000
 *
 *
 * This LVM library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This LVM library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this LVM library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA
 *
 */

/*
 * Changelog
 *
 *    03/05/1998 - added multiple device checking
 *               - changed checking to use MAJOR numbers instead of file names
 *    17/05/1998 - added /dev/dsk checking
 *    06/09/1998 - checked PV name with new lvm_check_chars()
 *    23/01/1999 - corrected devfs name space checking to /dev/sd etc.
 *    17/03/1999 - added loop device support
 *    22/04/1999 - DAC960 (/dev/rd/) support by Matthew Taylor
 *                 <M.Taylor@rbgkew.org.uk>
 *    23/07/1999 - added support for Compac Smart Array controller
 *    31/01/2000 - use debug_enter()/debug_leave()
 *
 */

#include <liblvm.h>

int pv_check_name ( char *pv_name) {
   int ret = 0;
   struct stat stat_b;

#ifdef DEBUG
   debug_enter ( "pv_check_name -- CALLED eith \"%s\"\n", pv_name);
#endif

   if ( pv_name == NULL) ret = -LVM_EPARAM;
   else if ( strncmp ( pv_name, "/dev/", 5) != 0) ret = -LVM_EPV_CHECK_NAME;
   else if ( lvm_check_chars ( pv_name) < 0) ret = -LVM_EPV_CHECK_NAME;
   else {
      if ( stat ( pv_name, &stat_b) == -1) ret = -LVM_EPV_CHECK_NAME_STAT;
      else if ( lvm_check_dev ( &stat_b, TRUE) == FALSE)
         ret = -LVM_EPV_CHECK_NAME;
   }

#ifdef DEBUG
   debug_leave ( "pv_check_name -- LEAVING with ret: %d\n", ret);
#endif
   return ret;
}
