/*
 * tools/lvmchange.c
 *
 * Copyright (C) 1997 - 1999  Heinz Mauelshagen, Germany
 *
 * March-May 1997
 * June,August 1998
 * February 1999
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

/*
 * Changelog
 *
 *    12/06/1998 - enhanced checking numbers in option arguments
 *    04/09/1998 - corrected some messages
 *    06/02/1999 - fixed lvm_check_number() usage
 *    11/02/1999 - removed obsolete -r support (read ahead sectors)
 *    21/02/1999 - removed LVM_LOCK and LVM_UNLOCK
 *
 */

#include <lvm_user.h>

char *cmd = NULL;

#ifdef DEBUG
int opt_d = 0;
#endif

int main ( int argc, char **argv) {
   int c = 0;
   int c1 = 0;
   int lvm = -1;
   int opt_f = 0;
   int opt_R = 0;
   int opt_v = 0;
   int ret = 0;
#ifdef DEBUG
   char *options = "dfh?Rv";
#else
   char *options = "fh?Rv";
#endif

   cmd = basename ( argv[0]);

   SUSER_CHECK;

   while ( ( c = getopt ( argc, argv, options)) != EOF) {
      switch ( c) {
#ifdef DEBUG
         case 'd':
            if ( opt_d > 0) {
               fprintf ( stderr, "%s -- d option already given\n\n", cmd);
               return LVM_EINVALID_CMD_LINE;
            }
            opt_d++;
            break;
#endif

         case 'f':
            if ( opt_f > 0) {
               fprintf ( stderr, "%s -- f option already given\n\n", cmd);
               return LVM_EINVALID_CMD_LINE;
            }
            opt_f++;
            break;

         case 'h':
         case '?':
            printf ( "\n%s\n\n%s -- Logical Volume Manager Change\n\n"
                     "Synopsis:\n"
                     "---------\n\n"
                     "%s\n"
#ifdef DEBUG
                     "\t[-d]\n"
#endif
                     "\t[-f]\n"
                     "\t[-h/-?]\n"
                     "\t[-R]\n"
                     "\t[-v]\n\n",
                     lvm_version, cmd, cmd);
            return 0;
            break;

         case 'R':
            if ( opt_R > 0) {
               fprintf ( stderr, "%s -- R option already given\n\n", cmd);
               return LVM_EINVALID_CMD_LINE;
            }
            opt_R++;
            break;

         case 'v':
            if ( opt_v > 0) {
               fprintf ( stderr, "%s -- v option already given\n\n", cmd);
               return LVM_EINVALID_CMD_LINE;
            }
            opt_v++;
            break;

         default:
            fprintf ( stderr, "%s -- invalid command line option \"%c\"\n\n",
                      cmd, c);
            return LVM_EINVALID_CMD_LINE;
      }
   }
  
   CMD_MINUS_CHK;

   if ( opt_R == 0) {
      fprintf ( stderr, "%s -- please give the R option\n\n", cmd);
      return LVM_EINVALID_CMD_LINE;
   }

   if ( optind < argc) {
      fprintf ( stderr, "%s -- error on command line\n\n", cmd);
      return LVM_EINVALID_CMD_LINE;
   }

   LVM_CHECK_IOP;
   lvm_dont_interrupt ( 0);

   if ( ( lvm = open ( LVM_DEV, O_RDONLY)) == -1) {
      fprintf ( stderr, "%s -- ERROR opening device special \"%s\"\n\n",
                        cmd, LVM_DEV);
      return LVM_ELVMCHANGE_OPEN;
   }

   if ( opt_f == 0) {
      c = 0;
      while ( c != 'y' && c != 'n') {
         if ( c == '\n' || c == 0)
            printf ( "%s -- do you want to reset LVM [y/n]? ", cmd);
         c = tolower ( getchar ());
      }
   } else c = 'y';
   c1 = c;
   while ( c != '\n') c = tolower ( getchar ());
   if ( c1 == 'n') {
      printf ( "%s -- NOT resetting LVM\n\n", cmd);
      ret = 0;
   } else {
      if ( opt_v > 0) printf ( "%s -- resetting LVM ...\n", cmd);
      if ( ( ret = ioctl ( lvm, LVM_RESET, &cmd)) < 0) {
         fprintf ( stderr, "%s -- ERROR %d doing reset ioctl\n", cmd, ret);
         ret = LVM_ELVMCHANGE_RESET;
      } else {
         printf ( "%s -- LVM has been reset\n", cmd);
      }
   }

   lvm_interrupt ();
   close ( lvm);

   printf ( "\n");
   return ret;
}
