/*
 * Author: Heinz Mauelshagen, Germany
 *
 * March 1997
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

#include <liblvm.h>

int lv_check_consistency ( lv_t *lv) {

#ifdef DEBUG
   debug ( "lv_check_consistency -- CALLED\n");
#endif

   if ( lv == NULL)                              return -LVM_EPARA;
   if ( lv_check_name ( lv->lv_name) != 0)       return -LVM_ELV_LVNAME;
   if ( vg_check_name ( lv->vg_name) != 0)       return -LVM_ELV_VGNAME;
   if ( lv->lv_access != LV_READ &&
        lv->lv_access != ( LV_READ | LV_WRITE))  return -LVM_ELV_ACCESS;
   if ( ! ( lv->lv_status == LV_ACTIVE ||
            lv->lv_status == 0))                 return -LVM_ELV_STATUS;
/* TEST
   if ( lv->lv_dev != lv_create_kdev_t ( vg_number_from_name ( lv->vg_name),
                                         lv->lv_number))
                                                 return -LVM_ELV_DEV;
*/
   if ( lv->lv_open > MAX_LV)                    return -LVM_ELV_OPEN;
   if ( lv->lv_mirror_copies > LVM_MAX_MIRRORS)  return -LVM_ELV_MIRROR_COPIES;
   if ( lv->lv_recovery != 0 &&
        lv->lv_recovery != LV_BADBLOCK_ON)       return -LVM_ELV_RECOVERY;

   if ( lv->lv_schedule != 0)                    return -LVM_ELV_SCHEDULE;
   if ( lv->lv_size > LVM_MAX_SIZE)              return -LVM_ELV_SIZE;
   if ( lv->lv_current_le > LVM_MAX_SIZE / LVM_MIN_PE_SIZE)
                                                 return -LVM_ELV_CURRENT_LE;
   if ( lv->lv_allocated_le > lv->lv_current_le) return -LVM_ELV_ALLOCATED_LE;
   if ( lv->lv_stripes > MAX_PV)                 return -LVM_ELV_STRIPES;
   if ( lv->lv_stripesize != 0 && 
        lv->lv_stripesize < LVM_MIN_STRIPE_SIZE &&
        lv->lv_stripesize > LVM_MAX_STRIPE_SIZE) return -LVM_ELV_STRIPESIZE;
   if ( lv->lv_badblock != 0 && lv->lv_badblock != LV_BADBLOCK_ON)
                                                 return -LVM_ELV_BADBLOCK;
   if ( lv->lv_allocation != 0 &&
        lv->lv_allocation != LV_STRICT &&
        lv->lv_allocation != LV_CONTIGUOUS &&
        lv->lv_allocation != ( LV_STRICT | LV_CONTIGUOUS))
                                                 return -LVM_ELV_ALLOCATION;
   if ( lv->lv_io_timeout > 120)                 return -LVM_ELV_TIMEOUT;

#ifdef DEBUG
   debug ( "lv_check_consistency -- LEAVING\n");
#endif
   return 0;
}


int lv_check_consistency_all_lv ( vg_t *vg) {
   int l = 0;
   int ret = 0;

   if ( vg == NULL) return -LVM_EPARA;

#ifdef DEBUG
   debug ( "lv_check_consistency_all_lv -- CALLED vg->lv_max: %lu\n",
           vg->lv_max);
#endif
   for ( l = 0; l < vg->lv_max; l++) {
#ifdef DEBUG
      debug ( "lv_check_consistency_all_lv -- vg->lv[%d]: %X\n",
               l, ( uint) vg->lv[l]);
#endif
      if ( vg->lv[l] != NULL)
         if ( ( ret = lv_check_consistency ( vg->lv[l])) < 0) return ret;
   }
#ifdef DEBUG
   debug ( "lv_check_consistency_all_lv -- LEAVING\n");
#endif
   return 0;
}
