/*
 * Author: Heinz Mauelshagen, Germany
 *
 * March-June 1997
 *
 * liblvm is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * liblvm is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

#ifndef _LIBLVM_H_INCLUDE
#define _LIBLVM_H_INCLUDE

#include <fcntl.h>
#include <dirent.h>
#include <malloc.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include <sys/ioctl.h>
#if ( OS_Major > 1) && ( OS_Minor > 0)
#  define _I386_STAT_H
#endif
#include <sys/stat.h>
#include <linux/genhd.h>
#include <linux/major.h>
#include <linux/msdos_fs.h>
#include <lvm.h>


#define	VGCFG_WRITE( handle, what, size, file_name) ( { \
      if ( write ( handle, what, size) != size) { \
         fprintf ( stderr, "%s -- ERROR %d writing volume group backup " \
                           "file %s in %s [line %d]\n", \
                           cmd, errno, file_name, __FILE__, __LINE__); \
         close ( handle); \
         unlink ( file_name); \
         ret = -LVM_EVG_CFGBACKUP_WRITE; \
         goto vg_cfgbackup_end; \
      }; \
} )

#define	VGCFG_READ( handle, what, size, file_name) ( { \
      if ( read ( handle, what, size) != size) { \
         fprintf ( stderr, "%s -- ERROR %d reading volume group backup " \
                           "file %s in %s [ line %d]\n",\
                           cmd, errno, file_name, __FILE__, __LINE__); \
         close ( handle); \
         ret = -LVM_EVG_CFGRESTORE_READ; \
         goto vg_cfgrestore_end; \
      }; \
} )

extern int errno;

#ifdef DEBUG
extern int opt_d;
#endif

/* for show_size () */
typedef	enum { SHORT, LONG} size_len_t;

/* for pv_check_free () */
typedef	enum {
   NEXT_FREE,
   LINEAR,
   LINEAR_CONTIGUOUS,
   STRIPED,
   STRIPED_CONTIGUOUS}
alloc_t;

/* for lvm_dir_cache () */
typedef struct {
   char *dev_name;
   short st_rdev;
   short st_mode;
} dir_cache_t;


/* VG functions */
int  vg_cfgbackup ( char *, char *, char *, int, vg_t *);
int  vg_cfgrestore ( char *, char *, char *, int, vg_t *);
int  vg_check_active ( char *);
int  vg_check_exist ( char *);
char ** vg_check_exist_all_vg ( void);
int  vg_check_name ( char *);
int  vg_check_consistency ( vg_t *);
int  vg_check_consistency_with_pv_and_lv ( vg_t *);
int  vg_check_online_all_pv ( vg_t*, pv_t***, pv_t***);
int  vg_check_pe_size ( ulong);
char ** vg_check_active_all_vg ( void);
int  vg_create ( char *, vg_t *);
int  vg_create_dir_and_group ( vg_t *);
int  vg_create_dir_and_group_and_nodes ( vg_t *, char *, int);
int  vg_remove_dir_and_group_and_nodes ( char *);
int  vg_extend ( char *, pv_t *, vg_t *);
char *vg_name_of_lv ( char *);
int  vg_remove ( char *);
int  vg_read ( char *, vg_t **);
int  vg_read_from_pv ( char *, vg_t **);
int  vg_read_with_pv_and_lv ( char *, vg_t **);
int  vg_reduce ( char *, pv_t *, vg_t *);
int  vg_set_extendable ( char*);
int  vg_clear_extendable ( char*);
int  vg_setup_for_create ( char *, vg_t *, pv_t **, int, ulong, ulong);
void vg_show ( vg_t *);
void vg_show_with_pv_and_lv ( vg_t *);
int  vg_write ( char*, pv_t *, vg_t *);
int  vg_write_with_pv_and_lv ( vg_t *);
int  vg_status ( char *, vg_t **);
int  vg_status_get_count ( void);
int  vg_status_get_namelist ( char *);
int  vg_status_with_pv_and_lv ( char *, vg_t **, int);


/* PV functions */
int    pe_lock ( char *, kdev_t, ulong, ushort, ushort);
int    pe_unlock ( char *);
int    pv_change ( char *, pv_t *);
int    pv_change_all_pv_of_vg ( char *, vg_t *);
int    pv_change_all_pv_for_lv_of_vg ( char *, char *, vg_t *);
int    pv_check_active ( char *, char *);
int    pv_check_active_in_all_vg ( char *);
int    pv_check_free ( pv_t *, ulong, ulong *);
int    pv_check_free_contiguous ( pv_t *, ulong, ulong *);
int    pv_check_in_vg ( vg_t *, char *);
int    pv_check_new ( pv_t *);
int    pv_check_consistency ( pv_t *);
int    pv_check_consistency_all_pv ( vg_t *);
int    pv_check_name ( char *);
int    pv_check_number ( pv_t **, int);
int    pv_check_part ( char *);
int    pv_check_volume ( char *, pv_t *);
char   **pv_find_all_pv_names ( void);
kdev_t pv_create_kdev_t ( char *);
char   *pv_create_name_from_kdev_t ( kdev_t);
int    pv_find_vg ( char *, char **);
int    pv_flush ( char *);
int    pv_get_index_by_kdev_t ( vg_t *, kdev_t);
int    pv_get_index_by_name ( vg_t *, char *);
int    pv_get_size ( char *, struct partition *);
int    pv_move_pes ( vg_t*, char*, char**, int, int, char *, int, int);
int    pv_move_pe ( vg_t*, char*, long, long, long, long,
                    char *, int, int, int, int);
int    pv_read ( char *, pv_t **, int *);
int    pv_read_pe ( pv_t *, disk_pe_t **);
int    pv_read_all_pv ( pv_t ***, int);
int    pv_read_all_pv_of_vg ( char *, pv_t ***, int);
int    pv_read_all_pe_of_vg ( char *, disk_pe_t ***, int);
int    pv_read_namelist ( char *, vg_t *, char **);
int    pv_release_pe ( vg_t *, disk_pe_t *, uint *, uint);
int    pv_reserve_pe ( pv_t *, disk_pe_t *, uint *, pe_t *, uint, int);
int    pv_setup_for_create ( char *, pv_t *, uint);
void   pv_show ( pv_t *);
void   pv_show_short ( pv_t *);
void   pv_show_all_pv_of_vg ( vg_t *);
void   pv_show_all_pv_of_vg_short ( vg_t *);
void   pv_show_pe ( pv_t *, disk_pe_t *, int);
int    pv_show_pe_text ( pv_t *, disk_pe_t *, int);
int    pv_status ( char *, char *, pv_t **);
int    pv_status_all_pv_of_vg ( char *, pv_t ***, int);
int    pv_write ( char*, pv_t *);
int    pv_write_all_pv_of_vg ( vg_t *);
int    pv_write_namelist ( char *, vg_t *);
int    pv_write_pe ( char*, pv_t *);
int    pv_write_with_pe ( char*, pv_t *);


/* LV functions */
char   *lv_change_vgname ( char *, char *);
int    lv_check_active ( char *, char *);
int    lv_check_on_pv ( pv_t *, int);
int    lv_check_contiguous ( vg_t *, int);
int    lv_check_consistency ( lv_t *);
int    lv_check_consistency_all_lv ( vg_t *);
int    lv_check_exist ( char *);
int    lv_check_name ( char *);
int    lv_check_stripesize ( int);
int    lv_count_pe ( pv_t *, int);
int    lv_create ( vg_t *, lv_t *, char *);
int    lv_create_name ( char *, char *, int);
int    lv_create_node ( char *, unsigned long, unsigned long);
kdev_t lv_create_kdev_t ( ulong, ulong);
int    lv_extend ( vg_t *, lv_t *, char *);
int    lv_get_index_by_kdev_t ( vg_t *, kdev_t);
int    lv_get_index_by_name ( vg_t *, char *);
int    lv_get_le_on_pv ( pv_t *, int);
char   *lv_get_name ( vg_t*, int);
int    lv_number_from_name_in_vg ( char *, vg_t *);
int    lv_le_remap ( vg_t*, le_remap_req_t*);
int    lv_read ( char *, char *, lv_t **);
int    lv_read_byindex ( char *vg_name, ulong lv_index, lv_t **lv);
int    lv_read_with_pe ( char *, char *, lv_t **);
int    lv_read_all_lv_of_vg ( char *, lv_t ***, int);
int    lv_reduce ( vg_t *, lv_t *, char *);
int    lv_release ( vg_t *, char *);
int    lv_remove ( vg_t *, lv_t *, char *);
int    lv_setup_for_create ( char *, vg_t **, char *, int *,
                             uint, uint, uint, uint, uint, uint, char **);
int    lv_setup_for_extend ( char *, vg_t *, char *, uint, char **);
int    lv_setup_for_reduce ( char *, vg_t *, char *, uint);
void   lv_show ( lv_t *);
void   lv_show_all_lv_of_vg ( vg_t *);
void   lv_show_current_pe ( lv_t *);
int    lv_show_current_pe_text ( lv_t *);
int    lv_status_byname ( char *, char *, lv_t **);
int    lv_status_byindex ( char *, ulong, lv_t **);
int    lv_status_with_pe ( char *, char *, lv_t **);
int    lv_status_all_lv_of_vg ( char *, vg_t *, lv_t ***, int);
int    lv_write ( char *, vg_t *, lv_t *, int);
int    lv_write_all_pv ( vg_t *, int);
int    lv_write_all_lv_of_vg ( char*, vg_t *);


/* print debug info on stderr */
void debug ( const char *, ...);

/* show partition table */
void partition_show ( struct partition *);

/* show file status */
void stat_show ( struct stat *);

/* generate nice KB/MB/... strings */
char *show_size ( ulong, size_len_t);

/* get the basename (no slashes) of a path */
char *basename ( char *);

/* system identifier handling */
int system_id_set ( char *);
int system_id_set_exported ( char *);
int system_id_set_imported ( char *);
int system_id_check_exported ( char *);
int system_id_check_imported ( char *);

/* LVM locking / interrupt masking etc. */
int    lvm_check_dev ( struct stat*, int);
int    lvm_dir_cache ( dir_cache_t**);
int    lvm_filetype_show ( ushort, char*, char*);
int    lvm_lock ( void);
int    lvm_unlock ( void);
void   lvm_interrupt ( void);
void   lvm_dont_interrupt ( int);
ushort lvm_get_iop_version ( void);

/* LVMTAB based functions */
int  lvm_tab_get_free_vg_number ( void);
int  lvm_tab_lv_check_exist ( char *);
int  lvm_tab_vg_insert ( char *);
int  lvm_tab_vg_read_with_pv_and_lv ( char *, vg_t **);
int  lvm_tab_vg_read ( char *, vg_t **);
int  lvm_tab_vg_remove ( char *);
int  lvm_tab_vg_check_exist ( char *, vg_t **);
char **lvm_tab_vg_check_exist_all_vg ( void);


/* error return codes */
#define	LVM_EPARA					99
#define	LVM_EVG_READ_VG_EXPORTED			100
#define	LVM_EVG_READ_LSEEK				101
#define	LVM_EVG_READ_OPEN				102
#define	LVM_EVG_READ_READ				103
#define LVM_ESIZE		      			104
#define	LVM_ELV_LVNAME					105
#define	LVM_ELV_VGNAME					106
#define	LVM_ELV_ACCESS					107
#define	LVM_ELV_STATUS					108
#define	LVM_ELV_DEV					109
#define	LVM_ELV_OPEN					110
#define	LVM_ELV_MIRROR_COPIES				111
#define	LVM_ELV_RECOVERY				112
#define	LVM_ELV_SCHEDULE				113
#define	LVM_ELV_SIZE					114
#define	LVM_ELV_CURRENT_LE				115
#define	LVM_ELV_ALLOCATED_LE				116
#define	LVM_ELV_STRIPES					117
#define	LVM_ELV_STRIPESIZE				118
#define	LVM_ELV_BADBLOCK				119
#define	LVM_ELV_ALLOCATION				120
#define	LVM_ELV_TIMEOUT					121
#define	LVM_ELV_CREATE_MODE_MKNOD			122
#define	LVM_ELV_CREATE_MODE_CHMOD			122
#define	LVM_ELV_CREATE_REMOVE_OPEN			123
#define	LVM_EVG_CHECK_EXIST_PV_COUNT			124
#define	LVM_EVG_READ_WITH_PV_AND_LV_PV_CUR		125
#define	LVM_EVG_READ_WITH_PV_AND_LV_MALLOC		126
#define	LVM_EVG_READ_WITH_PV_AND_LV_LV_ALLOCATED_LE	127
#define	LVM_EPV_READ_STAT				128
#define	LVM_EPV_READ_MAJOR				129
#define	LVM_EPV_READ_RDEV				130
#define	LVM_EPV_READ_OPEN				131
#define	LVM_EPV_READ_READ				132
#define	LVM_EPV_READ_ALL_PV_MALLOC			133
#define	LVM_EPV_READ_ALL_PV_OF_VG_NP			134
#define	LVM_EPV_READ_PE_SIZE				135
#define	LVM_EPV_READ_PE_OPEN				136
#define	LVM_EPV_READ_PE_LSEEK				137
#define	LVM_EPV_READ_PE_MALLOC				138
#define	LVM_EPV_READ_PE_READ		 		139
#define LVM_ELV_READ_ALL_LV_OF_VG_OPEN			140
#define LVM_ELV_READ_ALL_LV_OF_VG_LSEEK			141
#define LVM_ELV_READ_ALL_LV_OF_VG_READ			142
#define	LVM_ELV_READ_VG_NAME				143
#define	LVM_ELV_READ_LV_NAME				144
#define	LVM_ELV_READ_ALL_LV_OF_VG_MALLOC		145
#define	LVM_ELV_READ_ALL_LV_OF_VG_NL			146
#define	LVM_EPV_READ_VG_STAT				147
#define	LVM_EPV_READ_VG_MAJOR				148
#define	LVM_EPV_READ_VG_RDEV				149
#define	LVM_EPV_READ_VG_OPEN				150
#define	LVM_EPV_READ_VG_READ				151
#define	LVM_EPV_READ_VG_LSEEK				152
#define	LVM_ELV_EXTEND_REDUCE_OPEN			153
#define	LVM_ELV_CHECK_NAME_VG_NAME			154
#define	LVM_ELV_CHECK_NAME_LV_NAME			155
#define	LVM_ELV_CHECK_NAME_LV_NUM			156
#define	LVM_ELV_RELEASE_LV_NUM				157
#define	LVM_ELV_SETUP_FOR_CREATE_LV_MAX			158
#define	LVM_ELV_SETUP_FOR_CREATE_MALLOC			159
#define	LVM_ELV_SETUP_FOR_CREATE_PE			160
#define	LVM_ELV_SETUP_FOR_CREATE_STRIPES		161
#define	LVM_ELV_SETUP_FOR_EXTEND_LV_INDEX		162
#define	LVM_ELV_SETUP_FOR_EXTEND_STRIPES		163
#define	LVM_ELV_SETUP_FOR_REDUCE_LV_INDEX		162
#define	LVM_ELV_SETUP_FOR_REDUCE_MALLOC			163
#define	LVM_ELV_SHOW_CURRENT_PE_TEXT_LV_INDEX		164
#define	LVM_ELV_STATUS_INTERNAL_OPEN			165
#define	LVM_ELV_STATUS_WITH_PE_MALLOC			166
#define	LVM_ELV_STATUS_ALL_LV_OF_VG_MALLOC		167
#define	LVM_ELV_STORE_OPEN				168
#define	LVM_ELV_STORE_LSEEK				169
#define	LVM_ELV_STORE_WRITE				170
#define	LVM_ELV_STORE_ALL_LV_OF_VG_MALLOC		171
#define LVM_ELV_STORE_ALL_LV_OF_VG_OPEN			172
#define LVM_ELV_STORE_ALL_LV_OF_VG_LSEEK		173
#define LVM_ELV_STORE_ALL_LV_OF_VG_WRITE		174
#define	LVM_EPV_CHANGE_OPEN				175
#define	LVM_EPV_CHANGE_ALL_PV_FOR_LV_OF_VG_LV_NUM	176
#define	LVM_EPV_CHECK_CONSISTENCY_PV_NAME		177
#define	LVM_EPV_CHECK_CONSISTENCY_VG_NAME		178
#define	LVM_EPV_CHECK_CONSISTENCY_MAJOR			179
#define	LVM_EPV_CHECK_CONSISTENCY_PV_STATUS		180
#define	LVM_EPV_CHECK_CONSISTENCY_PV_ALLOCATABLE	181
#define	LVM_EPV_CHECK_CONSISTENCY_PV_SIZE		182
#define	LVM_EPV_CHECK_CONSISTENCY_LV_CUR		183
#define	LVM_EPV_CHECK_CONSISTENCY_PE_SIZE		184
#define	LVM_EPV_CHECK_CONSISTENCY_PE_TOTAL		185
#define	LVM_EPV_CHECK_CONSISTENCY_PE_ALLOCATED		186
#define	LVM_EPV_CHECK_CONSISTENCY_PE_STALE		187
#define	LVM_EPV_CHECK_DEV_NAME				188
#define	LVM_EPV_CHECK_PART				189
#define	LVM_EPV_GET_SIZE_OPEN				190
#define	LVM_EPV_GET_SIZE_READ				191
#define	LVM_EPV_GET_SIZE_PART				192
#define	LVM_EPV_CHECK_NAME				193
#define	LVM_EPV_READ_ALL_PV_OF_VG_PV_NUMBER		194
#define	LVM_EPV_READ_ALL_PV_OF_VG_MALLOC		195
#define	LVM_PV_READ_ALL_PE_OF_VG_MALLOC			196
#define	LVM_EPV_RESERVE_PE_LV				197
#define	LVM_EPV_RELEASE_PE_REALLOC			198
#define	LVM_EPV_STATUS_OPEN				199
#define	LVM_EPV_STATUS_ALL_PV_OF_VG_MALLOC		200
#define	LVM_EPV_STATUS_ALL_PV_OF_VG_NP			201
#define	LVM_EPV_STORE_OPEN				202
#define	LVM_EPV_STORE_WRITE				203
#define	LVM_EPV_STORE_PE_SIZE				204
#define	LVM_EPV_STORE_PE_OPEN				205
#define	LVM_EPV_STORE_PE_LSEEK				206
#define	LVM_EPV_STORE_PE_WRITE				207
#define	LVM_EVG_CHECK_CONSISTENCY_VG_NAME		208
#define	LVM_EVG_CHECK_CONSISTENCY_VG_ACCESS		209
#define	LVM_EVG_CHECK_CONSISTENCY_VG_STATUS		210
#define	LVM_EVG_CHECK_CONSISTENCY_LV_CUR		211
#define	LVM_EVG_CHECK_CONSISTENCY_PV_CUR		212
#define	LVM_EVG_CHECK_CONSISTENCY_PV_ACT		213
#define	LVM_EVG_CHECK_CONSISTENCY_SIZE			214
#define	LVM_EVG_CHECK_CONSISTENCY_MAX_PE_PER_PV		215
#define	LVM_EVG_CHECK_CONSISTENCY_VGDA			216
#define	LVM_EVG_CHECK_CONSISTENCY_PE_ALLOCATED		217
#define	LVM_EVG_CHECK_CONSISTENCY_PE_TOTAL		218
#define	LVM_EVG_CHECK_CONSISTENCY_PVG_TOTAL		219
#define	LVM_EVG_CREATE_DIR_AND_GROUP_MKDIR		220
#define	LVM_EVG_CREATE_DIR_AND_GROUP_CHMOD_DIR		221
#define	LVM_EVG_CREATE_DIR_AND_GROUP_MKNOD		222
#define	LVM_EVG_CREATE_DIR_AND_GROUP_CHMOD_GROUP	223
#define	LVM_EVG_CREATE_REMOVE_OPEN			224
#define	LVM_EVG_EXTEND_REDUCE_OPEN			225
#define	LVM_EVG_CHECK_NAME				226
#define	LVM_EVG_STATUS_OPEN				227
#define	LVM_ESYSTEM_ID_SET_UNAME			228
#define	LVM_EVG_STORE_OPEN				229
#define	LVM_EVG_STORE_LSEEK				230
#define	LVM_EVG_STORE_WRITE				231
#define	LVM_EPV_READ_PV_EXPORTED			232
#define	LVM_ELV_SETUP_FOR_CREATE_STRIPESIZE		233
#define	LVM_ELV_READ_ALL_LV_OF_VG_VGREAD		234
#define	LVM_EPV_READ_ID_INVALID				235
#define	LVM_EVG_CHECK_PE_SIZE				236
#define	LVM_ELV_CHECK_STRIPE_SIZE			237
#define	LVM_EPV_SHOW_PE_TEXT_MALLOC			238
#define	LVM_EPV_STORE_LSEEK				239
#define	LVM_EPV_STORE_NAMELIST_OPEN			240
#define	LVM_EPV_STORE_NAMELIST_LSEEK			241
#define	LVM_EPV_STORE_NAMELIST_WRITE			242
#define	LVM_EPV_STORE_NAMELIST_MALLOC			243
#define	LVM_EVG_READ_PV					244
#define	LVM_ELVM_LOCK_YET_LOCKED                        245
#define	LVM_ELVM_UNLOCK					246
#define	LVM_EVG_SETUP_FOR_CREATE_MALLOC			247
#define	LVM_EPV_READ_LVM_STRUCT_VERSION			248
#define	LVM_EVG_READ_LVM_STRUCT_VERSION			249
#define	LVM_EPE_LOCK                                    250
#define	LVM_EPV_READ_PV_FLUSH				251
#define	LVM_EPV_FLUSH_OPEN				252
#define	LVM_EPV_GET_SIZE_LLSEEK                         253
#define	LVM_EPV_GET_SIZE_NO_PRIMARY                     254
#define	LVM_EPV_GET_SIZE_NO_EXTENDED                    255
#define	LVM_EPV_READ_NAMELIST_OPEN                      256
#define	LVM_EPV_READ_NAMELIST_LSEEK                     257
#define	LVM_EPV_READ_NAMELIST_READ                      258
#define	LVM_EPV_READ_NAMELIST_MALLOC                    259
#define LVM_EPV_CHECK_NUMBER_MAX_NUMBER                 260
#define LVM_EPV_CHECK_NUMBER_MALLOC                     261
#define LVM_EPV_CHECK_NUMBER_PV_NUMBER                  262
#define LVM_EPV_READ_ALL_PE_OF_VG_PV_NUMBER             263
#define	LVM_EPV_READ_ALL_PV_OF_VG_NP_SORT               264
#define LVM_ELV_LE_REMAP_OPEN                           265
#define LVM_ELVM_TAB_READ_OPEN                          266
#define LVM_ELVM_TAB_READ_FSTAT                         267
#define LVM_ELVM_TAB_READ_SIZE                          268
#define LVM_ELVM_TAB_READ_MALLOC                        269
#define LVM_ELVM_TAB_READ_READ                          270
#define LVM_ELVM_TAB_READ_PV_CHECK_NAME                 271
#define LVM_ELVM_TAB_READ_VG_CHECK_NAME                 272
#define LVM_ELVM_TAB_STORE_OPEN                         273
#define LVM_ELVM_TAB_STORE_WRITE                        274
#define LVM_ELVM_TAB_STORE_FCHMOD                       275
#define LVM_ELVM_TAB_VG_INSERT_VG_EXISTS                276
#define LVM_ELVM_TAB_VG_REMOVE_NOT_EXISTS               277
#define LVM_EVG_CFGRESTORE_OPEN                         278
#define LVM_ELVM_TAB_VG_CHECK_EXIST_ALL_VG_REALLOC      279
#define LVM_EVG_CHECK_ACTIVE_ALL_VG_COUNT               280
#define LVM_EVG_CHECK_ACTIVE_ALL_VG_MALLOC              281
#define LVM_EVG_CHECK_ACTIVE_ALL_VG_NAMELIST            282
#define LVM_EVG_STATUS_GET_COUNT_OPEN                   283
#define LVM_EVG_STATUS_GET_NAMELIST_OPEN                284
#define LVM_ELVM_TAB_VG_INSERT_REALLOC                  285
#define LVM_EVG_CFGRESTORE_MALLOC                       286
#define LVM_ELVM_IOP_VERSION_OPEN                       287
#define LVM_EVG_READ_FROM_PV_PV_READ                    288
#define LVM_EVG_READ_FROM_PV_READ                       289
#define LVM_EVG_READ_FROM_PV_CHECK_CONSISTENCY          290
#define LVM_EVG_READ_FROM_PV_OPEN                       291
#define LVM_EVG_READ_FROM_PV_LSEEK                      292
#define LVM_EVG_READ_FROM_PV_LVM_STRUCT_VERSION         293
#define LVM_EPV_FIND_ALL_PV_PV_READ                     294
#define LVM_ELVM_FIND_VG_REALLOC                        295
#define LVM_EVG_SETUP_FOR_CREATE_VG_NUMBER		296
#define LVM_ELV_STATUS_NL				297
#define LVM_ELV_READ_VGREAD				298
#define LVM_ELV_READ_LV_READ_ALL_LV_OF_VG		299
#define LV_READ_LV					300
#define LVM_ELV_READ_BYINDEX_VGREAD			301
#define LVM_ELV_READ_BYINDEX_LV_READ_ALL_LV_OF_VG	302
#define LVM_ELV_READ_BYINDEX_VG_NAME			303
#define	LVM_EPV_SHOW_PE_TEXT_REALLOC			304
#define LVM_ELVM_TAB_GET_FREE_VG_NUMBER_MALLOC		305
#define LVM_EPV_READ_ALL_PV_LVM_DIR_CACHE		306
#define LVM_EPV_STATUS_ALL_PV_LVM_DIR_CACHE		307
#define LVM_EPV_CHECK_NAME_STAT				308
#define LVM_EPV_GET_SIZE_IOCTL				309
#define LVM_EVG_CHECK_ONLINE_ALL_PV			310
#define LVM_EVG_SET_CLEAR_EXTENDABLE_OPEN		311
#define LVM_EPV_READ_MD_DEVICE            		312
#define LVM_EVG_CHECK_ONLINE_ALL_PV_MALLOC		313
#define LVM_ELVM_READ_DEV_RDEV				314
#define LVM_ELVM_READ_DEV_MAJOR				315
#define LVM_ELVM_READ_DEV_READ				316
#define LVM_ELVM_READ_DEV_STAT				317
#define LVM_ELVM_READ_DEV_OPEN				318
#define	LVM_EVG_CFGBACKUP_VG_CHECK_EXIST		319
#define	LVM_EVG_CFGBACKUP_VG_READ_WITH_PV_AND_LV	320
#define	LVM_EVG_CHECK_CONSISTENCY			321
#define	LVM_EVG_CFGBACKUP_OPEN				322
#define LVM_EPV_MOVE_PES_REALLOC			323
#define LVM_EPV_MOVE_PES_NO_PES				324
#define LVM_EPV_MOVE_PES_NO_SPACE			325
#define LVM_EPE_MOVE_PE_OPEN_IN				326
#define LVM_EPE_MOVE_PE_LV_GET_NAME			327
#define LVM_EPE_MOVE_PE_LOCK				328
#define LVM_EPE_MOVE_PE_OPEN				329
#define LVM_EPE_MOVE_PE_LLSEEK_IN			330
#define LVM_EPE_MOVE_PE_READ_IN				331
#define LVM_EPE_MOVE_PE_LLSEEK_OUT			332
#define LVM_EPE_MOVE_PE_WRITE_OUT			333
#define LVM_EPE_MOVE_LV_LE_REMAP			334
#define LVM_EPE_MOVE_PE_UNLOCK				335
#define LVM_EPE_MOVE_PV_CHANGE_SRC			336
#define LVM_EPE_MOVE_PV_CHANGE_DEST			337
#define LVM_EPE_MOVE_PV_PV_STORE_WITH_PE_SRC		338
#define LVM_EPE_MOVE_PV_PV_STORE_WITH_PE_DEST		339
#define LVM_EVG_CFGBACKUP_FILE_EXISTS			340
#define LVM_EVG_CFGRESTORE_FILE_EXISTS			341
#define LVM_EVG_CFGBACKUP_READ				342
#define LVM_EVG_CFGBACKUP_WRITE				343
#define LVM_EVG_CFGBACKUP_RENAME			344
#define LVM_EVG_CFGBACKUP_UNLINK			345
#define LVM_EVG_CFGBACKUP_TMP_FILE			346
#define LVM_EVG_CFGBACKUP_MALLOC			347
#define LVM_EVG_CFGRESTORE_READ				348
#define LVM_EVG_CFGRESTORE_VG_CHECK_CONSISTENCY		349
#define LVM_EVG_CFGRESTORE_PV_CHECK_CONSISTENCY		350
#define LVM_EVG_CFGRESTORE_LV_CHECK_CONSISTENCY		351
#define LVM_EVG_CFGRESTORE_VG_CHECK_CONSISTENCY_WITH_PV_AND_LV		352
#define LVM_EPV_SHOW_PE_TEXT_VG_READ_WITH_PV_AND_LV	353
#define LVM_EPV_CHECK_CONSISTENCY_LVM_ID		354
#define LVM_ELV_SETUP_FOR_EXTEND_REALLOC		355
#define LVM_EPV_RELEASE_PE_NO_PV			356

#endif /* #ifndef _LIBLVM_H_INCLUDE */
