/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.transform;

import java.io.Reader;
import java.io.StringReader;
import javax.xml.transform.sax.SAXSource;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.output.SAXOutputter;
import org.jdom.output.XMLOutputter;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;

public class JDOMSource
extends SAXSource {
    public static final String JDOM_FEATURE = "http://org.jdom.transform.JDOMSource/feature";
    private XMLFilter xmlFilter = null;

    public JDOMSource(Document document) {
        this.setDocument(document);
    }

    public Document getDocument() {
        return ((JDOMInputSource)this.getInputSource()).getDocument();
    }

    public XMLReader getXMLReader() {
        XMLReader xMLReader = new DocumentReader();
        if (this.xmlFilter != null) {
            XMLFilter xMLFilter = this.xmlFilter;
            while (xMLFilter.getParent() instanceof XMLFilter) {
                xMLFilter = (XMLFilter)xMLFilter.getParent();
            }
            xMLFilter.setParent(xMLReader);
            xMLReader = this.xmlFilter;
        }
        return xMLReader;
    }

    public void setDocument(Document document) {
        super.setInputSource(new JDOMInputSource(document));
    }

    public void setInputSource(InputSource inputSource) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void setXMLReader(XMLReader xMLReader) throws UnsupportedOperationException {
        if (!(xMLReader instanceof XMLFilter)) {
            throw new UnsupportedOperationException();
        }
        this.xmlFilter = (XMLFilter)xMLReader;
    }

    private static class JDOMInputSource
    extends InputSource {
        private Document document = null;

        public JDOMInputSource(Document document) {
            this.setDocument(document);
        }

        public Reader getCharacterStream() {
            Document document = this.getDocument();
            StringReader stringReader = null;
            if (document != null) {
                stringReader = new StringReader(new XMLOutputter().outputString(document));
            }
            return stringReader;
        }

        public Document getDocument() {
            return this.document;
        }

        public void setCharacterStream(Reader reader) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        public void setDocument(Document document) {
            if (document == null) {
                throw new NullPointerException("source");
            }
            this.document = document;
        }
    }

    private static class DocumentReader
    extends SAXOutputter
    implements XMLReader {
        public void parse(String string) throws SAXNotSupportedException {
            throw new SAXNotSupportedException("Only JDOM Documents are supported as input");
        }

        public void parse(InputSource inputSource) throws SAXException {
            if (inputSource instanceof JDOMInputSource) {
                try {
                    this.output(((JDOMInputSource)inputSource).getDocument());
                }
                catch (JDOMException jDOMException) {
                    throw new SAXException(jDOMException.getMessage(), jDOMException);
                }
            } else {
                throw new SAXNotSupportedException("Only JDOM Documents are supported as input");
            }
        }
    }
}

