/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.Serializable;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.IllegalDataException;
import org.jdom.Verifier;

public class Text
implements Serializable,
Cloneable {
    private static final String CVS_ID = "@(#) $RCSfile: Text.java,v $ $Revision: 1.11 $ $Date: 2002/03/12 07:11:39 $ $Name: jdom_1_0_b8 $";
    private static final String EMPTY_STRING = "";
    protected String value;
    protected Object parent;

    protected Text() {
    }

    public Text(String string) {
        this.setText(string);
    }

    public void append(String string) {
        if (string == null) {
            return;
        }
        String string2 = Verifier.checkCharacterData(string);
        if (string2 != null) {
            throw new IllegalDataException(string, "character content", string2);
        }
        this.value = string == EMPTY_STRING ? string : String.valueOf(this.value) + string;
    }

    public void append(Text text) {
        if (text == null) {
            return;
        }
        this.value = String.valueOf(this.value) + text.getText();
    }

    public Object clone() {
        Text text = null;
        try {
            text = (Text)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        text.parent = null;
        text.value = this.value;
        return text;
    }

    public Text detach() {
        if (this.parent != null) {
            ((Element)this.parent).removeContent(this);
        }
        this.parent = null;
        return this;
    }

    public final boolean equals(Object object) {
        return this == object;
    }

    public Document getDocument() {
        if (this.parent != null) {
            return ((Element)this.parent).getDocument();
        }
        return null;
    }

    public Element getParent() {
        return (Element)this.parent;
    }

    public String getText() {
        return this.value;
    }

    public String getTextNormalize() {
        return Text.normalizeString(this.getText());
    }

    public String getTextTrim() {
        return this.getText().trim();
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public static String normalizeString(String string) {
        if (string == null) {
            return EMPTY_STRING;
        }
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[cArray.length];
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            if (" \t\n\r".indexOf(cArray[n2]) != -1) {
                if (!bl) {
                    cArray2[n++] = 32;
                    bl = true;
                }
            } else {
                cArray2[n++] = cArray[n2];
                bl = false;
            }
            ++n2;
        }
        if (bl && n > 0) {
            --n;
        }
        return new String(cArray2, 0, n);
    }

    protected Text setParent(Element element) {
        this.parent = element;
        return this;
    }

    public Text setText(String string) {
        if (string == null) {
            this.value = EMPTY_STRING;
            return this;
        }
        String string2 = Verifier.checkCharacterData(string);
        if (string2 != null) {
            throw new IllegalDataException(string, "character content", string2);
        }
        this.value = string;
        return this;
    }

    public String toString() {
        return new StringBuffer(64).append("[Text: ").append(this.getText()).append("]").toString();
    }
}

