/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import de.hunsicker.antlr.collections.AST;
import de.hunsicker.jalopy.language.JavaNode;
import de.hunsicker.jalopy.printer.Marker;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.OperatorPrinter;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.printer.TestNodeWriter;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

final class TernaryIfElsePrinter
extends OperatorPrinter {
    private static final Printer INSTANCE = new TernaryIfElsePrinter();

    private TernaryIfElsePrinter() {
    }

    public static final Printer getInstance() {
        return INSTANCE;
    }

    public void print(AST node, NodeWriter out) throws IOException {
        Marker marker = out.state.markers.add();
        AST secondOperand = this.printOperand(node.getFirstChild(), marker, out);
        Marker m = this.printQuestionMark(node, secondOperand, out);
        JavaNode colon = (JavaNode)this.printOperand(secondOperand, marker, out);
        this.printColon(colon, m, out);
        this.printOperand(colon.getNextSibling(), marker, out);
        out.state.markers.remove(marker);
    }

    private JavaNode getNextOperand(AST node) {
        block3: for (AST child = node; child != null; child = child.getNextSibling()) {
            switch (child.getType()) {
                case 84: {
                    continue block3;
                }
                default: {
                    return (JavaNode)child;
                }
            }
        }
        throw new IllegalArgumentException("not part of operand -- " + node);
    }

    private boolean needParentheses(JavaNode node) {
        switch (node.getType()) {
            case 35: 
            case 36: 
            case 70: 
            case 89: 
            case 91: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: {
                return true;
            }
        }
        return false;
    }

    private void printColon(JavaNode colon, Marker marker, NodeWriter out) throws IOException {
        boolean wrapLines = settings.getBoolean(ConventionKeys.LINE_WRAP, true) && out.mode == 1;
        boolean wrapBeforeColon = settings.getBoolean(ConventionKeys.ALIGN_TERNARY_VALUES, false);
        if (out.newline) {
            this.printIndentation(marker, out);
        } else if (wrapBeforeColon) {
            out.printNewline();
            if (marker == null) {
                this.printIndentation(out);
            } else {
                this.printIndentation(marker, out);
            }
        } else if (wrapLines) {
            TestNodeWriter tester = out.testers.get();
            JavaNode thirdOp = this.getNextOperand(colon.getNextSibling());
            PrinterFactory.create(thirdOp).print(thirdOp, tester);
            if (tester.length + out.column > settings.getInt(ConventionKeys.LINE_LENGTH, 80)) {
                out.printNewline();
                if (marker == null) {
                    this.printIndentation(out);
                } else {
                    this.printIndentation(marker, out);
                }
            } else {
                out.print(" ", out.last);
            }
            out.testers.release(tester);
        } else {
            out.print(" ", out.last);
        }
        out.print(":", 91);
        if (!this.printCommentsAfter(colon, false, true, out) && !out.newline) {
            out.print(" ", 91);
        }
    }

    private AST printOperand(AST node, Marker marker, NodeWriter out) throws IOException {
        boolean parentheses = false;
        block6: for (AST child = node; child != null; child = child.getNextSibling()) {
            switch (child.getType()) {
                case 84: {
                    parentheses = true;
                    PrinterFactory.create(child).print(child, out);
                    continue block6;
                }
                default: {
                    if (parentheses || node.getFirstChild() == child) {
                        PrinterFactory.create(child).print(child, out);
                    } else if (settings.getBoolean(ConventionKeys.INSERT_EXPRESSION_PARENTHESIS, true) && this.needParentheses((JavaNode)child)) {
                        JavaNode operator = (JavaNode)child;
                        if (out.mode == 1) {
                            this.addParentheses(operator);
                            JavaNode leftParen = operator.getPreviousSibling();
                            PrinterFactory.create(leftParen).print(leftParen, out);
                            PrinterFactory.create(child).print(child, out);
                        } else {
                            out.print("(", out.last);
                            PrinterFactory.create(child).print(child, out);
                        }
                    } else {
                        PrinterFactory.create(child).print(child, out);
                    }
                    block7: for (child = child.getNextSibling(); child != null; child = child.getNextSibling()) {
                        switch (child.getType()) {
                            case 85: {
                                PrinterFactory.create(child).print(child, out);
                                continue block7;
                            }
                            default: {
                                return child;
                            }
                        }
                    }
                    return null;
                }
            }
        }
        throw new IllegalStateException();
    }

    private Marker printQuestionMark(AST node, AST secondOperand, NodeWriter out) throws IOException {
        boolean wrapLines = settings.getBoolean(ConventionKeys.LINE_WRAP, true) && out.mode == 1;
        boolean wrapBeforeQuestion = settings.getBoolean(ConventionKeys.ALIGN_TERNARY_EXPRESSION, false);
        if (out.newline) {
            this.printIndentation(out);
        } else if (wrapBeforeQuestion) {
            out.printNewline();
            this.printIndentation(out);
        } else if (wrapLines) {
            TestNodeWriter tester = out.testers.get();
            JavaNode secondOp = this.getNextOperand(secondOperand);
            PrinterFactory.create(secondOp).print(secondOp, tester);
            if (tester.length + out.column + 3 > settings.getInt(ConventionKeys.LINE_LENGTH, 80)) {
                out.printNewline();
                this.printIndentation(out);
            } else {
                out.print(" ", out.last);
            }
            out.testers.release(tester);
        } else {
            out.print(" ", out.last);
        }
        Marker marker = null;
        if (settings.getBoolean(ConventionKeys.ALIGN_TERNARY_OPERATOR, true) && (wrapLines || wrapBeforeQuestion)) {
            marker = out.state.markers.add();
        }
        out.print("?", 119);
        if (!this.printCommentsAfter(node, false, true, out) && !out.newline) {
            out.print(" ", 91);
        }
        return marker;
    }
}

