/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.language;

import de.hunsicker.antlr.collections.AST;
import de.hunsicker.jalopy.language.ExtendedToken;
import de.hunsicker.jalopy.language.JavaNode;
import de.hunsicker.jalopy.language.JavaNodeHelper;
import de.hunsicker.jalopy.language.Node;
import de.hunsicker.jalopy.language.Transformation;
import de.hunsicker.jalopy.language.TransformationException;
import de.hunsicker.jalopy.language.TreeWalker;
import de.hunsicker.jalopy.storage.Loggers;
import de.hunsicker.util.Helper;
import java.io.ObjectStreamClass;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;

final class SerializableTransformation
extends TreeWalker
implements Transformation {
    private static final String SERIAL_VERSION_UID = "serialVersionUID";
    private static final String SERIALIZABLE = "Serializable";
    private static final String EXTERNALIZABLE = "Externalizable";
    private ClassDefInfo _curClassDef;
    private List _classDefs = new ArrayList(5);
    private String _packageName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(AST tree) throws TransformationException {
        try {
            this.walkNode(tree);
            int size = this._classDefs.size();
            for (int i = 0; i < size; ++i) {
                ClassDefInfo info = (ClassDefInfo)this._classDefs.get(i);
                if (!info.serializable || info.serialver) continue;
                try {
                    Class clazz = Helper.loadClass(info.name, this);
                    ObjectStreamClass oclazz = ObjectStreamClass.lookup(clazz);
                    long serialVersionUID = oclazz.getSerialVersionUID();
                    this.insertSerialVer(tree, info, serialVersionUID);
                    continue;
                }
                catch (ClassNotFoundException ex) {
                    Object[] args = new Object[]{tree.getText(), info.name};
                    Loggers.TRANSFORM.l7dlog((Priority)Level.WARN, "TRANS_SERIALIZABLE_CLASS_NOT_FOUND", args, (Throwable)ex);
                }
            }
        }
        finally {
            this.cleanup();
        }
    }

    public void visit(AST node) {
        block3: for (AST child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            switch (child.getType()) {
                case 68: {
                    if (!child.getText().equals(SERIAL_VERSION_UID)) break block3;
                    this._curClassDef.serialver = true;
                    break block3;
                }
                default: {
                    continue block3;
                }
            }
        }
    }

    protected void walkNode(AST node) {
        if (node != null) {
            switch (node.getType()) {
                case 10: 
                case 49: {
                    this.walkNode(node.getFirstChild());
                    break;
                }
                case 20: {
                    this._packageName = JavaNodeHelper.getDottedName(node.getFirstChild());
                }
                case 7: 
                case 9: 
                case 12: 
                case 13: 
                case 15: 
                case 16: 
                case 19: 
                case 22: 
                case 23: 
                case 34: 
                case 68: {
                    this.walkNode(node.getNextSibling());
                    break;
                }
                case 18: {
                    this._curClassDef = this.addToClassList(node);
                    if (this._curClassDef.serializable) {
                        this.walkNode(node.getFirstChild());
                    }
                    this.walkNode(node.getNextSibling());
                    break;
                }
                case 14: {
                    if (this._curClassDef.serializable && !this._curClassDef.serialver) {
                        this.visit(node);
                    }
                    this.walkNode(node.getNextSibling());
                    break;
                }
            }
        }
    }

    private static boolean isClassSerializable(AST node) {
        AST clauses = JavaNodeHelper.getFirstChild(node, 23);
        for (AST clause = clauses.getFirstChild(); clause != null; clause = clause.getNextSibling()) {
            String name = clause.getText();
            if (!SERIALIZABLE.equals(name) && !EXTERNALIZABLE.equals(name)) continue;
            return true;
        }
        return false;
    }

    private ClassDefInfo addToClassList(AST node) {
        int count = this._classDefs.size();
        String ident = null;
        ident = this._packageName + "." + JavaNodeHelper.getFirstChild(node, 68).getText();
        if (count > 0) {
            int size = this._classDefs.size();
            for (int i = 0; i < size; ++i) {
                ClassDefInfo previousInfo = (ClassDefInfo)this._classDefs.get(i);
                if (!previousInfo.node.contains((JavaNode)node)) continue;
                ident = previousInfo.name + "$" + JavaNodeHelper.getFirstChild(node, 68).getText();
                break;
            }
        }
        ClassDefInfo info = new ClassDefInfo(node, ident);
        this._classDefs.add(info);
        return info;
    }

    private void cleanup() {
        this._classDefs.clear();
        this._curClassDef = null;
        this._packageName = null;
        this._curClassDef = null;
    }

    private void insertSerialVer(AST tree, ClassDefInfo info, long serialverUID) {
        JavaNode serialver = new JavaNode(Integer.MAX_VALUE, 1, Integer.MAX_VALUE, 1);
        serialver.setType(14);
        serialver.setText("VARIABLE_DEF");
        JavaNode modifiers = new JavaNode(9, "MODIFIERS");
        JavaNode privatemod = new JavaNode(71, "private");
        JavaNode finalmod = new JavaNode(43, "final");
        JavaNode staticmod = new JavaNode(74, "static");
        modifiers.addChild(privatemod);
        modifiers.addChild(finalmod);
        modifiers.addChild(staticmod);
        JavaNode type = new JavaNode(17, "TYPE");
        JavaNode typevalue = new JavaNode(66, "long");
        type.addChild(typevalue);
        JavaNode ident = new JavaNode(68, SERIAL_VERSION_UID);
        JavaNode assign = new JavaNode(89, "=");
        JavaNode expr = new JavaNode(32, "EXPR");
        JavaNode assignvalue = new JavaNode(151, serialverUID + "L");
        expr.addChild(assignvalue);
        assign.addChild(expr);
        JavaNode semi = new JavaNode(55, ";");
        serialver.addChild(modifiers);
        serialver.addChild(type);
        serialver.addChild(ident);
        serialver.addChild(assign);
        serialver.addChild(semi);
        Node description = new Node();
        description.setType(40);
        description.setText("Use serialVersionUID for interoperability.");
        Node comment = new Node(6, "/** Use serialVersionUID for interoperability. */");
        comment.addChild(description);
        ExtendedToken token = new ExtendedToken(6, "/** Use serialVersionUID for interoperability. */");
        token.comment = comment;
        serialver.setHiddenBefore(token);
        JavaNode objblock = (JavaNode)JavaNodeHelper.getFirstChild(info.node, 10);
        JavaNode lcurly = (JavaNode)objblock.getFirstChild();
        JavaNode next = (JavaNode)lcurly.getNextSibling();
        lcurly.setNextSibling(serialver);
        serialver.setParent(objblock);
        serialver.setPreviousSibling(lcurly);
        serialver.setNextSibling(next);
        if (next != null) {
            next.setPreviousSibling(serialver);
        }
        Object[] args = new Object[]{tree.getText(), info.name};
        Loggers.TRANSFORM.l7dlog((Priority)Level.INFO, "TRANS_SERIALIZABLE_ADD", args, null);
    }

    private static final class ClassDefInfo {
        public JavaNode node;
        public String name;
        public boolean serializable;
        public boolean serialver;

        public ClassDefInfo(AST node, String name) {
            this.node = (JavaNode)node;
            this.name = name;
            this.serializable = SerializableTransformation.isClassSerializable(node);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append('[');
            buf.append(this.node);
            buf.append(", name=");
            buf.append(this.name);
            buf.append(", hasField=");
            buf.append(this.serialver);
            buf.append(']');
            return buf.toString();
        }
    }
}

