/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import de.hunsicker.antlr.collections.AST;
import de.hunsicker.jalopy.language.JavaNode;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

final class TryCatchFinallyPrinter
extends AbstractPrinter {
    private static final Printer INSTANCE = new TryCatchFinallyPrinter();

    protected TryCatchFinallyPrinter() {
    }

    public static final Printer getInstance() {
        return INSTANCE;
    }

    public void print(AST node, NodeWriter out) throws IOException {
        this.printCommentsBefore(node, out);
        out.print("try", 105);
        this.printCommentsAfter(node, false, false, out);
        block5: for (AST child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            switch (child.getType()) {
                case 11: {
                    PrinterFactory.create(child).print(child, out);
                    continue block5;
                }
                case 106: {
                    this.printCatch(child, out);
                    continue block5;
                }
                case 107: {
                    this.printFinallyPart(child, out);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("illegal type -- " + child);
                }
            }
        }
        out.last = 8;
    }

    private void printCatch(AST node, NodeWriter out) throws IOException {
        this.printCommentsBefore(node, out);
        this.logIssues(node, out);
        if (!out.newline) {
            out.print(out.getString(settings.getInt(ConventionKeys.INDENT_SIZE_BRACE_RIGHT_AFTER, 1)), 153);
        }
        out.print("catch", 106);
        if (settings.getBoolean(ConventionKeys.SPACE_BEFORE_STATEMENT_PAREN, true)) {
            out.print(" ", 106);
        }
        AST lparen = node.getFirstChild();
        PrinterFactory.create(lparen).print(lparen, out);
        AST parameters = lparen.getNextSibling();
        PrinterFactory.create(parameters).print(parameters, out);
        AST rparen = parameters.getNextSibling();
        PrinterFactory.create(rparen).print(rparen, out);
        JavaNode body = (JavaNode)rparen.getNextSibling();
        PrinterFactory.create(body).print(body, out);
    }

    private void printFinallyPart(AST node, NodeWriter out) throws IOException {
        this.printCommentsBefore(node, out);
        this.logIssues(node, out);
        if (!out.newline) {
            out.print(out.getString(settings.getInt(ConventionKeys.INDENT_SIZE_BRACE_RIGHT_AFTER, 1)), 153);
        }
        out.print("finally", 107);
        this.printCommentsAfter(node, out);
        JavaNode body = (JavaNode)node.getFirstChild();
        PrinterFactory.create(body).print(body, out);
    }
}

