/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.language;

import de.hunsicker.antlr.ASTPair;
import de.hunsicker.antlr.collections.AST;
import de.hunsicker.jalopy.language.ClassRepository;
import de.hunsicker.jalopy.language.JavaNode;
import de.hunsicker.jalopy.language.JavaNodeFactory;
import de.hunsicker.jalopy.language.JavaNodeHelper;
import de.hunsicker.jalopy.language.Transformation;
import de.hunsicker.jalopy.language.TransformationException;
import de.hunsicker.jalopy.language.TreeWalker;
import de.hunsicker.jalopy.storage.Convention;
import de.hunsicker.jalopy.storage.ConventionDefaults;
import de.hunsicker.jalopy.storage.ConventionKeys;
import de.hunsicker.jalopy.storage.ImportPolicy;
import de.hunsicker.jalopy.storage.Loggers;
import de.hunsicker.util.StringHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.oro.text.perl.Perl5Util;

final class ImportTransformation
extends TreeWalker
implements Transformation {
    private static final JavaNodeFactory _fab = new JavaNodeFactory();
    private static final Comparator COMP_LINE = new NodeLineComparator();
    private static final Comparator COMP_ON_DEMAND_SINGLE = new NodeOnDemandSingleComparator();
    private static final Comparator COMP_TEXT = new NodeStringComparator();
    private static final int DEFAULT_PACKAGE = -99;
    private static final JavaNode[] EMPTY_NODE_ARRAY = new JavaNode[0];
    private static final String MARKER = "#";
    private static final String EMPTY_STRING = "".intern();
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String PACKAGE_JAVA_LANG = "java.lang.";
    private static final String STAR = "*";
    static final String DOT = ".";
    private static final String DELIMETER_ENTRY = "|";
    private static final Object[] _args = new Object[4];
    private final ImportNodeComparator COMP_IMPORT = new ImportNodeComparator();
    private AST _class;
    private JavaNode _packageNameNode;
    private List _onDemandImports = new ArrayList();
    private final List _qualIdents;
    private AST _root;
    private List _singleTypeImports = new ArrayList();
    private final List _unqualIdents;
    private String _filename;
    private String _packageName = EMPTY_STRING;
    private boolean _sortImports = true;
    private int _line;
    private static final Perl5Util REGEX_ENGINE = new Perl5Util();

    public ImportTransformation(List qualIdents, List unqualIdents) {
        this._qualIdents = qualIdents;
        this._unqualIdents = unqualIdents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(AST tree) throws TransformationException {
        try {
            Convention settings = Convention.getInstance();
            ImportPolicy importPolicy = ImportPolicy.valueOf(settings.get(ConventionKeys.IMPORT_POLICY, ConventionDefaults.IMPORT_POLICY));
            boolean expand = importPolicy == ImportPolicy.EXPAND;
            boolean collapse = importPolicy == ImportPolicy.COLLAPSE;
            this._sortImports = settings.getBoolean(ConventionKeys.IMPORT_SORT, true);
            if (!ClassRepository.getInstance().isEmpty()) {
                if (expand) {
                    this.walk(tree);
                    this.expand();
                } else if (collapse) {
                    this.walk(tree);
                    this.collapse();
                } else if (this._sortImports) {
                    this.walk(tree);
                    this.updateTree(this._onDemandImports, this._singleTypeImports);
                }
            } else if (this._sortImports) {
                this.walk(tree);
                this.updateTree(this._onDemandImports, this._singleTypeImports);
            }
        }
        finally {
            this.cleanup();
        }
    }

    public void visit(AST node) {
        String identifier = JavaNodeHelper.getDottedName(node.getFirstChild());
        JavaNode importNode = (JavaNode)node;
        if (this._line == 0) {
            this._line = importNode.getStartLine();
        }
        if (identifier.endsWith(STAR)) {
            String packageName;
            importNode.text = packageName = identifier.substring(0, identifier.length() - 2);
            if (this._onDemandImports.contains(importNode)) {
                ImportTransformation._args[0] = this._root.getText();
                ImportTransformation._args[1] = new Integer(importNode.startLine);
                ImportTransformation._args[2] = identifier;
                ImportTransformation._args[3] = new Integer(((JavaNode)this._onDemandImports.get((int)this._onDemandImports.indexOf((Object)importNode))).startLine);
                Loggers.TRANSFORM.l7dlog((Priority)Level.INFO, "TRANS_IMP_REMOVE_DUPLICATE", _args, null);
            } else {
                this._onDemandImports.add(importNode);
            }
        } else {
            importNode.text = identifier;
            if (this._singleTypeImports.contains(importNode)) {
                ImportTransformation._args[0] = this._root.getText();
                ImportTransformation._args[1] = new Integer(importNode.startLine);
                ImportTransformation._args[2] = identifier;
                ImportTransformation._args[3] = new Integer(((JavaNode)this._singleTypeImports.get((int)this._singleTypeImports.indexOf((Object)importNode))).startLine);
                Loggers.TRANSFORM.l7dlog((Priority)Level.INFO, "TRANS_IMP_REMOVE_DUPLICATE", _args, null);
            } else {
                this._singleTypeImports.add(importNode);
            }
        }
    }

    protected void walkNode(AST node) {
        switch (node.getType()) {
            case 49: {
                this._root = node;
                this._filename = node.getText();
                AST first = node.getFirstChild();
                if (first == null) break;
                this.walkNode(first);
                break;
            }
            case 20: {
                this._packageName = JavaNodeHelper.getDottedName(node.getFirstChild());
                this._packageNameNode = (JavaNode)node;
                AST next = node.getNextSibling();
                if (next == null) break;
                this.walkNode(next);
                break;
            }
            case 34: {
                this.visit(node);
                AST next = node.getNextSibling();
                if (next == null) break;
                this.walkNode(next);
                break;
            }
            case 55: {
                this.walkNode(node.getNextSibling());
                break;
            }
            case 18: 
            case 19: {
                this._class = node;
                if (this._packageNameNode != null) {
                    this._packageNameNode.setNextSibling(node);
                } else {
                    this._root.setFirstChild(node);
                }
                return;
            }
        }
    }

    private boolean isDefaultPackage(String name, String packageName) {
        boolean result = false;
        if (packageName != null) {
            int pos = name.lastIndexOf(46);
            if (pos != -1) {
                result = name.substring(0, pos).equals(packageName);
            }
        } else {
            result = name.indexOf(46) == -1;
        }
        return result;
    }

    private List getExpandable(List onDemandImports) {
        ArrayList<JavaNode> result = new ArrayList<JavaNode>(onDemandImports.size());
        int size = onDemandImports.size();
        for (int i = 0; i < size; ++i) {
            JavaNode node = (JavaNode)onDemandImports.get(i);
            result.add(node);
        }
        JavaNode defaultPckg = new JavaNode(-99, 1, -99, 2);
        defaultPckg.text = this._packageName;
        defaultPckg.type = 34;
        result.add(defaultPckg);
        return result;
    }

    private static int getIndex(List identifiers, String packageName) {
        int size = identifiers.size();
        for (int i = 0; i < size; ++i) {
            if (!packageName.startsWith((String)identifiers.get(i))) continue;
            return i;
        }
        return -1;
    }

    private boolean isLangPackage(String name) {
        return name.startsWith(PACKAGE_JAVA_LANG) && name.lastIndexOf(46) == 9;
    }

    private List getPackageTypes(String packageName) {
        if (packageName == null) {
            return Collections.EMPTY_LIST;
        }
        Object[] content = ClassRepository.getInstance().getContent();
        if (content.length == 0) {
            return Collections.EMPTY_LIST;
        }
        int startOffset = Arrays.binarySearch(content, packageName + '#');
        ArrayList<String> result = new ArrayList<String>(20);
        if (startOffset > -1) {
            int depth = StringHelper.occurs('.', packageName) + 1;
            for (int i = startOffset + 1; i < content.length && ((String)content[i]).startsWith(packageName); ++i) {
                if (StringHelper.occurs('.', (String)content[i]) != depth) continue;
                result.add(StringHelper.getClassName((String)content[i]));
            }
        }
        return result;
    }

    private List getPossibleSingleTypeImports(List identifiers, List singleTypeImports) {
        int i;
        int length = identifiers.size();
        ArrayList result = new ArrayList(length);
        for (i = 0; i < length; ++i) {
            result.add(identifiers.get(i));
        }
        int size = singleTypeImports.size();
        for (i = 0; i < size; ++i) {
            for (int j = 0; j < length; ++j) {
                JavaNode node = (JavaNode)singleTypeImports.get(i);
                if (!node.text.endsWith('.' + (String)identifiers.get(j))) continue;
                result.remove(identifiers.get(j));
            }
        }
        return result;
    }

    private List getPossibleTypes(List identifiers) {
        Object[] contents = ClassRepository.getInstance().getContent();
        ArrayList<String> result = new ArrayList<String>();
        int size = identifiers.size();
        for (int i = 0; i < size; ++i) {
            String ident = (String)identifiers.get(i);
            if (Arrays.binarySearch(contents, ident) <= -1) continue;
            result.add(ident);
        }
        return result;
    }

    private boolean isUsed(String identifier, List types) {
        String type;
        int i;
        int size = types.size();
        for (i = 0; i < size; ++i) {
            type = (String)types.get(i);
            if (!type.equals(identifier)) continue;
            return true;
        }
        size = this._qualIdents.size();
        for (i = 0; i < size; ++i) {
            type = StringHelper.getClassName((String)this._qualIdents.get(i));
            if (!type.equals(identifier)) continue;
            return true;
        }
        size = this._unqualIdents.size();
        for (i = 0; i < size; ++i) {
            type = (String)this._unqualIdents.get(i);
            if (!type.endsWith(identifier)) continue;
            return true;
        }
        return false;
    }

    private void addComments(JavaNode source, JavaNode target) {
    }

    private void cleanup() {
        this._onDemandImports.clear();
        this._singleTypeImports.clear();
        this._packageName = EMPTY_STRING;
        this._packageNameNode = null;
        this._class = null;
        this._root = null;
        this._filename = null;
        this._line = 0;
    }

    private void collapse() {
        if (this._singleTypeImports.size() > 0) {
            List singleTypeImports = this._singleTypeImports;
            ArrayList<JavaNode> newOnDemandImports = new ArrayList<JavaNode>(singleTypeImports.size());
            newOnDemandImports.addAll(this._onDemandImports);
            JavaNode defaultPackage = new JavaNode(34, this._packageName);
            defaultPackage.startLine = -99;
            newOnDemandImports.add(defaultPackage);
            int size = singleTypeImports.size();
            for (int i = 0; i < size; ++i) {
                JavaNode singleType = (JavaNode)singleTypeImports.get(i);
                String packageName = StringHelper.getPackageName(singleType.text);
                if (EMPTY_STRING.equals(packageName)) continue;
                JavaNode onDemand = new JavaNode(34, packageName);
                onDemand.setFirstChild(singleType.getFirstChild());
                if (singleType.hasCommentsBefore()) {
                    // empty if block
                }
                if (singleType.hasCommentsAfter()) {
                    // empty if block
                }
                if (!newOnDemandImports.contains(onDemand)) {
                    newOnDemandImports.add(onDemand);
                    continue;
                }
                this.addComments(onDemand, (JavaNode)newOnDemandImports.get(newOnDemandImports.indexOf(onDemand)));
            }
            HashMap<String, List> allTypes = new HashMap<String, List>(newOnDemandImports.size());
            ArrayList<JavaNode> retainedOnDemandImports = new ArrayList<JavaNode>();
            JavaNode template = new JavaNode(34, EMPTY_STRING);
            int packages = newOnDemandImports.size();
            for (int j = 0; j < packages; ++j) {
                JavaNode path = (JavaNode)newOnDemandImports.get(j);
                List packageTypes = this.getPackageTypes(path.text);
                allTypes.put(path.text, packageTypes);
            }
            HashSet<String> conflicts = new HashSet<String>(5);
            List defaultTypes = this.getPackageTypes(this._packageName);
            Iterator firstPackages = allTypes.entrySet().iterator();
            while (firstPackages.hasNext()) {
                Map.Entry firstPackageData = firstPackages.next();
                String firstPackageName = (String)firstPackageData.getKey();
                List firstPackageTypes = (List)firstPackageData.getValue();
                Iterator secondPackages = allTypes.entrySet().iterator();
                while (secondPackages.hasNext()) {
                    Map.Entry secondPackageData = secondPackages.next();
                    String secondPackageName = (String)secondPackageData.getKey();
                    if (conflicts.contains(firstPackageName) || secondPackageName.equals(firstPackageName)) continue;
                    List secondPackageTypes = (List)secondPackageData.getValue();
                    int size2 = firstPackageTypes.size();
                    for (int i = 0; i < size2; ++i) {
                        String type = (String)firstPackageTypes.get(i);
                        if (type.endsWith(MARKER) || !secondPackageTypes.contains(type) || !this.isUsed(type, defaultTypes)) continue;
                        conflicts.add(firstPackageName);
                        template.text = firstPackageName;
                        int index = 0;
                        index = newOnDemandImports.indexOf(template);
                        if (index <= -1) continue;
                        JavaNode importNode = (JavaNode)newOnDemandImports.remove(index);
                        if (this._onDemandImports.contains(template)) {
                            importNode.text = template.text;
                            importNode.setNextSibling(null);
                            importNode.setPreviousSibling(null);
                            retainedOnDemandImports.add(importNode);
                            continue;
                        }
                        if (!Loggers.TRANSFORM.isDebugEnabled()) continue;
                        Loggers.TRANSFORM.debug((Object)(this._filename + ":0:0: cannot unqualify " + firstPackageName + " due to conflict between " + firstPackageName + '.' + type + " and " + secondPackageName + '.' + type + " (Check 3)"));
                    }
                }
            }
            newOnDemandImports.remove(defaultPackage);
            Collections.sort(newOnDemandImports, COMP_TEXT);
            int size3 = singleTypeImports.size();
            for (int i = 0; i < size3; ++i) {
                JavaNode node = (JavaNode)singleTypeImports.get(i);
                if (Collections.binarySearch(newOnDemandImports, node, COMP_ON_DEMAND_SINGLE) <= -1) continue;
                JavaNode singleType = (JavaNode)singleTypeImports.remove(i);
                --size3;
                --i;
                singleType.setFirstChild(null);
                singleType.setParent(null);
                singleType.setPreviousSibling(null);
                singleType.setNextSibling(null);
            }
            newOnDemandImports.addAll(retainedOnDemandImports);
            this.updateTree(newOnDemandImports, singleTypeImports);
        } else {
            this.updateTree(this._onDemandImports, Collections.EMPTY_LIST);
        }
    }

    private JavaNode createImportNode(JavaNode node) {
        ArrayList parts = new ArrayList(6);
        REGEX_ENGINE.split(parts, "/([.])/", node.text, 0);
        ASTPair curAST = new ASTPair();
        AST last = _fab.create(68, (String)parts.remove(0));
        _fab.addASTChild(curAST, last);
        int size = parts.size();
        for (int i = 0; i < size; ++i) {
            String next = (String)parts.remove(0);
            if (next.equals(DOT)) {
                last = _fab.create(69, next);
                _fab.makeASTRoot(curAST, last);
                continue;
            }
            last = _fab.create(68, next);
            _fab.addASTChild(curAST, last);
        }
        JavaNode identifierNode = (JavaNode)node.getFirstChild();
        JavaNode semi = (JavaNode)identifierNode.getNextSibling();
        JavaNode newIdentifierNode = (JavaNode)curAST.root;
        newIdentifierNode.setNextSibling(semi);
        newIdentifierNode.setParent(node);
        semi.setPreviousSibling(newIdentifierNode);
        node.setFirstChild(newIdentifierNode);
        identifierNode.setParent(null);
        identifierNode.setPreviousSibling(null);
        ++this._line;
        return node;
    }

    private void createImportNodes(JavaNode[] imports) {
        JavaNode imp;
        int i;
        if (imports.length == 0) {
            return;
        }
        Convention settings = Convention.getInstance();
        ImportPolicy importPolicy = ImportPolicy.valueOf(Convention.getInstance().get(ConventionKeys.IMPORT_POLICY, ConventionDefaults.IMPORT_POLICY));
        boolean report = importPolicy == ImportPolicy.EXPAND;
        String filename = this._root.getText();
        JavaNode node = this._packageNameNode;
        boolean showWarnings = !ClassRepository.getInstance().isEmpty();
        for (i = 0; imports.length > 0 && i < 1; ++i) {
            imp = this.createImportNode(imports[i]);
            switch (imp.getType()) {
                case 34: {
                    break;
                }
                default: {
                    throw new RuntimeException("" + imp);
                }
            }
            if (report && imports[i].text.endsWith(STAR)) {
                ImportTransformation._args[0] = filename;
                ImportTransformation._args[1] = new Integer(imports[i].startLine);
                ImportTransformation._args[2] = imports[i].text;
                if (showWarnings) {
                    Loggers.TRANSFORM.l7dlog((Priority)Level.WARN, "TRANS_IMP_NOT_POSSIBLE", _args, null);
                }
            }
            if (node == null) {
                this._root.setFirstChild(imp);
                this._packageNameNode = imp.prevSibling = (imp.parent = (JavaNode)this._root);
            } else {
                node.setNextSibling(imp);
                imp.prevSibling = node;
                imp.parent = this._packageNameNode;
            }
            node = imp;
        }
        for (i = 1; i < imports.length; ++i) {
            imp = this.createImportNode(imports[i]);
            switch (imp.getType()) {
                case 34: {
                    break;
                }
                default: {
                    throw new RuntimeException("2 " + imp);
                }
            }
            if (report && imports[i].text.endsWith(STAR)) {
                ImportTransformation._args[0] = filename;
                ImportTransformation._args[1] = new Integer(imports[i].startLine);
                ImportTransformation._args[2] = imports[i].text;
                if (showWarnings) {
                    Loggers.TRANSFORM.l7dlog((Priority)Level.WARN, "TRANS_IMP_NOT_POSSIBLE", _args, null);
                }
            }
            node.setNextSibling(imp);
            imp.prevSibling = node;
            imp.parent = node;
            node = imp;
        }
        node.setNextSibling(this._class);
    }

    private List decodeGroupingInfo(String info) {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(info, DELIMETER_ENTRY);
        while (tokens.hasMoreElements()) {
            String pair = tokens.nextToken();
            String name = pair.substring(0, pair.indexOf(58));
            result.add(name);
        }
        return result;
    }

    private void expand() {
        List expandableImports = this.getExpandable(this._onDemandImports);
        ArrayList identifiers = new ArrayList(this._unqualIdents);
        identifiers.addAll(this._qualIdents);
        List expandedImports = this.expandImports(identifiers, this._singleTypeImports, expandableImports);
        expandedImports.addAll(this.removeObsoleteImports(this._singleTypeImports, this._qualIdents, this._unqualIdents));
        List unexpandedImports = this._onDemandImports;
        unexpandedImports.removeAll(expandableImports);
        this.updateTree(unexpandedImports, expandedImports);
    }

    private List expandImports(List identifiers_, List singleTypeImports, List expandableImports) {
        int i;
        List identifiers = this.getPossibleSingleTypeImports(identifiers_, singleTypeImports);
        if (identifiers.isEmpty()) {
            return new ArrayList();
        }
        StringBuffer buf = new StringBuffer(50);
        String defaultPackageName = this._packageName;
        JavaNode template = new JavaNode(34, EMPTY_STRING);
        Object[] repository = ClassRepository.getInstance().getContent();
        ArrayList<JavaNode> result = new ArrayList<JavaNode>(20);
        HashMap<String, JavaNode> conflicts = new HashMap<String, JavaNode>(20);
        int size = expandableImports.size();
        for (i = 0; i < size; ++i) {
            int tempSize = identifiers.size();
            block1: for (int j = 0; j < tempSize; ++j) {
                String unresolvedIdent = (String)identifiers.get(j);
                JavaNode resolvableImport = (JavaNode)expandableImports.get(i);
                buf.append(resolvableImport.text);
                buf.append('.');
                buf.append(unresolvedIdent);
                template.text = buf.toString();
                buf.setLength(0);
                if (Arrays.binarySearch(repository, template.text) <= -1 || singleTypeImports.contains(template) || result.contains(template)) continue;
                JavaNode node = new JavaNode(34, template.text);
                node.startLine = resolvableImport.startLine;
                node.parent = resolvableImport.parent;
                node.setFirstChild(resolvableImport.getFirstChild());
                node.setNextSibling(resolvableImport.getNextSibling());
                node.setHiddenBefore(resolvableImport.getHiddenBefore());
                node.setHiddenAfter(resolvableImport.getHiddenAfter());
                resolvableImport.setHiddenBefore(null);
                resolvableImport.setHiddenAfter(null);
                JavaNode other = conflicts.put(unresolvedIdent, node);
                if (other == null) {
                    result.add(node);
                } else if (this.isDefaultPackage(node.text, defaultPackageName)) {
                    result.remove(other);
                    result.add(node);
                } else if (!this.isDefaultPackage(node.text, defaultPackageName)) {
                    if (Loggers.TRANSFORM.isDebugEnabled()) {
                        Loggers.TRANSFORM.debug((Object)(this._filename + ":0:0: cannot expand due to unresolvable conflict -- " + node + " " + other));
                    }
                    return Collections.EMPTY_LIST;
                }
                int s = this._qualIdents.size();
                for (int k = 0; k < s; ++k) {
                    String name;
                    String type = (String)this._qualIdents.get(k);
                    if (!node.text.endsWith(type) || Arrays.binarySearch(repository, name = node.text.substring(0, node.text.indexOf(type)) + type.substring(0, type.lastIndexOf(46))) <= -1) continue;
                    node.text = name;
                    continue block1;
                }
            }
        }
        size = result.size();
        for (i = 0; i < size; ++i) {
            JavaNode node = (JavaNode)result.get(i);
            if (node.startLine == -99) {
                result.remove(i);
                --size;
                --i;
                continue;
            }
            if (this.isLangPackage(node.text) || this.isDefaultPackage(node.text, defaultPackageName)) {
                result.remove(i);
                --size;
                --i;
                continue;
            }
            ImportTransformation._args[0] = this._root.getText();
            ImportTransformation._args[1] = new Integer(node.startLine);
            ImportTransformation._args[2] = node.text;
            Loggers.TRANSFORM.l7dlog((Priority)Level.INFO, "TRANS_IMP_EXPAND_ON_DEMAND", _args, null);
        }
        return result;
    }

    private List removeObsoleteImports(List singleTypeImports, List qualIdents, List unqualIdents) {
        ArrayList<JavaNode> result = new ArrayList<JavaNode>();
        String packageName = this._packageName;
        StringBuffer buf = new StringBuffer(100);
        int size = singleTypeImports.size();
        for (int i = 0; i < size; ++i) {
            JavaNode node = (JavaNode)singleTypeImports.get(i);
            if (this.isLangPackage(node.text) || this.isDefaultPackage(node.text, packageName)) {
                ImportTransformation._args[0] = this._root.getText();
                ImportTransformation._args[1] = new Integer(node.startLine);
                ImportTransformation._args[2] = node.text;
                Loggers.TRANSFORM.l7dlog((Priority)Level.INFO, "TRANS_IMP_REMOVE_OBSOLETE", _args, null);
                continue;
            }
            String path = StringHelper.getPackageName(node.text);
            boolean furtherCheck = true;
            int s = qualIdents.size();
            block1: for (int j = 0; j < s; ++j) {
                String type = (String)qualIdents.get(j);
                int lastdot = type.lastIndexOf(46);
                while (lastdot > -1) {
                    type = type.substring(0, lastdot);
                    buf.setLength(0);
                    buf.append(path);
                    buf.append('.');
                    buf.append(type);
                    if (node.text.equals(buf.toString())) {
                        result.add(node);
                        furtherCheck = false;
                        break block1;
                    }
                    lastdot = type.lastIndexOf(46);
                }
            }
            if (!furtherCheck) continue;
            if (!unqualIdents.contains(StringHelper.getClassName(node.text))) {
                ImportTransformation._args[0] = this._root.getText();
                ImportTransformation._args[1] = new Integer(node.startLine);
                ImportTransformation._args[2] = node.text;
                Loggers.TRANSFORM.l7dlog((Priority)Level.INFO, "TRANS_IMP_REMOVE_UNUSED", _args, null);
                continue;
            }
            result.add(node);
        }
        return result;
    }

    private void updateTree(List onDemandImports, List singleTypeImports) {
        ArrayList<JavaNode> imports = new ArrayList<JavaNode>(onDemandImports.size() + singleTypeImports.size());
        int size = onDemandImports.size();
        for (int i = 0; i < size; ++i) {
            JavaNode node = (JavaNode)onDemandImports.get(i);
            node.text = node.text + ".*";
            imports.add(node);
        }
        imports.addAll(singleTypeImports);
        if (this._sortImports) {
            List info;
            this.COMP_IMPORT.identifiers = info = this.decodeGroupingInfo(Convention.getInstance().get(ConventionKeys.IMPORT_GROUPING, "*:0|gnu:2|java:2|javax:2"));
            Collections.sort(imports, this.COMP_IMPORT);
        } else {
            Collections.sort(imports, COMP_LINE);
        }
        this.createImportNodes(imports.toArray(EMPTY_NODE_ARRAY));
    }

    private static final class NodeStringComparator
    implements Comparator {
        private NodeStringComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            JavaNode n1 = (JavaNode)o1;
            JavaNode n2 = (JavaNode)o2;
            return n1.text.compareTo(n2.text);
        }
    }

    private static final class NodeOnDemandSingleComparator
    implements Comparator {
        private NodeOnDemandSingleComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            JavaNode packagePath = (JavaNode)o1;
            JavaNode importNode = (JavaNode)o2;
            return packagePath.text.compareTo(StringHelper.getPackageName(importNode.text));
        }
    }

    private static final class NodeLineComparator
    implements Comparator {
        private NodeLineComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            JavaNode n1 = (JavaNode)o1;
            JavaNode n2 = (JavaNode)o2;
            if (n1.startLine == n2.startLine) {
                return n1.text.compareTo(n2.text);
            }
            if (n1.startLine > n2.startLine) {
                return 1;
            }
            if (n1.startLine < n2.startLine) {
                return -1;
            }
            return 0;
        }
    }

    private static final class ImportNodeComparator
    implements Comparator {
        List identifiers;

        private ImportNodeComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            JavaNode n1 = (JavaNode)o1;
            JavaNode n2 = (JavaNode)o2;
            int i1 = ImportTransformation.getIndex(this.identifiers, n1.text);
            int i2 = ImportTransformation.getIndex(this.identifiers, n2.text);
            if (i1 > -1) {
                if (i2 > -1) {
                    if (i1 > i2) {
                        return 1;
                    }
                    if (i2 > i1) {
                        return -1;
                    }
                } else {
                    i2 = ImportTransformation.getIndex(this.identifiers, ImportTransformation.STAR);
                    if (i1 > i2) {
                        return 1;
                    }
                    if (i2 > i1) {
                        return -1;
                    }
                }
            } else if (i2 > -1) {
                i1 = ImportTransformation.getIndex(this.identifiers, ImportTransformation.STAR);
                if (i1 > i2) {
                    return 1;
                }
                if (i2 > i1) {
                    return -1;
                }
            }
            return n1.text.compareTo(n2.text);
        }
    }
}

