// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_PANGO_CONTEXT_H_
#define _INTI_PANGO_CONTEXT_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <pango/pango-context.h>
#include <inti/object.h>
#include <inti/utf-string.h>
#include <vector>

namespace Inti
{  
  namespace Pango
  {
    namespace Private
    {
      class ContextClass;
    }; // namespace Private

    class FontDescription;

    typedef enum
    {
      DIRECTION_LTR = PANGO_DIRECTION_LTR,
      DIRECTION_RTL = PANGO_DIRECTION_RTL,
      DIRECTION_TTB_LTR = PANGO_DIRECTION_TTB_LTR,
      DIRECTION_TTB_RTL = PANGO_DIRECTION_TTB_RTL
    } Direction;
    
    class Context : public Object
    {
    public:
      PangoContext * pango_context () const { return (PangoContext*)g_object (); }

      Context ();
      
      /* fontmap and font stuff not wrapped */

      vector<FontDescription> list_fonts (const char * family);
      vector<FontDescription> list_fonts (const ustring & family);
      vector<FontDescription> list_fonts ();
      vector<ustring> list_font_families ();
      
      void set_font_description (const FontDescription & desc);
      FontDescription font_description () const;

      void set_language (const char * lang);
      void set_language (const ustring & lang);
      ustring language () const;

      void set_base_direction (Direction d);
      Direction base_direction () const;

      // FIXME pango_itemize() not wrapped
      
    protected:
      friend class Private::ContextClass;
      virtual ~Context ();
      Context (PangoContext * src, PangoContextClass * orig);
      
    private:
      Context (const Context&);
      Context& operator=(const Context&);

    }; // class Context
    
  }; // namespace Pango
  
}; // namespace Inti

#endif // _INTI_PANGO_CONTEXT_H_
