// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_GTK_STATUSBAR_H_
#define _INTI_GTK_STATUSBAR_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <inti/gtk/box.h>
#include <gtk/gtkstatusbar.h>
#include <string>

/*$ doc header
  $short The #Inti::Gtk::Statusbar widget
  $*/

namespace Inti
{
  namespace Gtk
  {
    namespace Private
    {
      class StatusbarClass;
    };

    class Statusbar : public HBox
    {
    public:
      /*$ doc class Statusbar
        $short an application statusbar widget

        $copy none
        $memory floating

        $long

        <para>

        </para>

        <para>

        </para>

        $*/

      GtkStatusbar * gtk_statusbar () const
      {
        return (GtkStatusbar*)g_object ();
      }

      /*$ doc constructor
        $short Construct a new statusbar
        $long

        <para>

        </para>

        $*/
      Statusbar ();

      unsigned int push (const ustring & text);
      unsigned int push (const char * text);
      void pop ();
      void remove (unsigned int id);

    protected:
      typedef WrapSignal1<void,const ustring&> TextPushedSignalType;
      static const TextPushedSignalType text_pushed_signal;

    public:
      typedef SignalProxy<Object,TextPushedSignalType> TextPushedProxyType;
      const TextPushedProxyType sig_text_pushed ()
      {
        return TextPushedProxyType (this, &text_pushed_signal);
      }
    protected:
      typedef WrapSignal1<void,const ustring&> TextPoppedSignalType;
      static const TextPoppedSignalType text_popped_signal;

    public:
      typedef SignalProxy<Object,TextPoppedSignalType> TextPoppedProxyType;
      const TextPoppedProxyType sig_text_popped ()
      {
        return TextPoppedProxyType (this, &text_popped_signal);
      }

    protected:
      friend class Private::StatusbarClass;

      explicit Statusbar (GtkStatusbar *src, GtkStatusbarClass* orig);
      virtual ~Statusbar ();

      virtual void text_pushed_impl (const ustring & text);
      virtual void text_popped_impl (const ustring & text);

      virtual void on_text_pushed (const ustring & text);
      virtual void on_text_popped (const ustring & text);

    private:
      Statusbar(const Statusbar&);
      Statusbar& operator=(const Statusbar&);

      static void text_pushed_proxy (GtkStatusbar * statusbar,
                                     guint id, const gchar * text);

      static void text_popped_proxy (GtkStatusbar * statusbar,
                                     guint id, const gchar * text);

    }; // class Statusbar

  }; // namespace Gtk

}; // namespace Inti

#endif // _INTI_GTK_STATUSBAR_H_
