// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This source file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
#include "scale.h"
#include "scale-class.h"
#include "adjustment.h"
#include <inti/private-util.h>
#include <inti/gtk/marshal.h>

Inti::Gtk::Scale::Scale ()
  : Range ((GtkRange*)Private::ScaleClass::make_proxy(),
           (GtkRangeClass*)Private::ScaleClass::original_class())
{
  
}

Inti::Gtk::Scale::Scale (Adjustment * adj)
  : Range ((GtkRange*)Private::ScaleClass::make_proxy(),
           (GtkRangeClass*)Private::ScaleClass::original_class())
{
  set_adjustment (adj);
}

Inti::Gtk::Scale::Scale (GtkScale *obj,
                            GtkScaleClass *orig)
  : Range ((GtkRange*)obj,
           (GtkRangeClass*)orig)
{
  
}

Inti::Gtk::Scale::~Scale ()
{

}

void
Inti::Gtk::Scale::set_decimal_places (int digits)
{
  gtk_scale_set_digits (gtk_scale (), digits);
}

int
Inti::Gtk::Scale::decimal_places () const
{
  return gtk_range ()->digits;
}

void
Inti::Gtk::Scale::set_draws_value (bool setting)
{
  gtk_scale_set_draw_value (gtk_scale (), setting); 
}

bool
Inti::Gtk::Scale::draws_value () const
{
  return gtk_scale ()->draw_value;
}

void
Inti::Gtk::Scale::set_value_position (PositionType pos)
{
  gtk_scale_set_value_pos (gtk_scale (), (GtkPositionType) pos);
}

Inti::Gtk::PositionType
Inti::Gtk::Scale::value_position () const
{
  return (PositionType) gtk_scale ()->value_pos;
}

Inti::Gtk::HScale::HScale ()
  : Scale ((GtkScale*)Private::HScaleClass::make_proxy(),
           (GtkScaleClass*)Private::HScaleClass::original_class())
{
  
}

Inti::Gtk::HScale::HScale (Adjustment * adj)
  : Scale ((GtkScale*)Private::HScaleClass::make_proxy(),
           (GtkScaleClass*)Private::HScaleClass::original_class())
{
  set_adjustment (adj);
}

Inti::Gtk::HScale::HScale (float lower, float upper)
  : Scale ((GtkScale*)Private::HScaleClass::make_proxy(),
           (GtkScaleClass*)Private::HScaleClass::original_class())
{
  float delta = upper - lower;
  if (delta < 0)
    delta = - delta;
  adjustment ()->set_range (lower, upper,
                            delta * 0.1, delta * 0.2,
                            0.0);
}

Inti::Gtk::HScale::HScale (GtkHScale *obj,
                              GtkHScaleClass *orig)
  : Scale ((GtkScale*)obj,
           (GtkScaleClass*)orig)
{
  
}

Inti::Gtk::HScale::~HScale ()
{

}

Inti::Gtk::VScale::VScale ()
  : Scale ((GtkScale*)Private::VScaleClass::make_proxy(),
           (GtkScaleClass*)Private::VScaleClass::original_class())
{
  
}

Inti::Gtk::VScale::VScale (Adjustment * adj)
  : Scale ((GtkScale*)Private::VScaleClass::make_proxy(),
           (GtkScaleClass*)Private::VScaleClass::original_class())
{
  set_adjustment (adj);
}

Inti::Gtk::VScale::VScale (float lower, float upper)
  : Scale ((GtkScale*)Private::VScaleClass::make_proxy(),
           (GtkScaleClass*)Private::VScaleClass::original_class())
{
  float delta = upper - lower;
  if (delta < 0)
    delta = - delta;
  adjustment ()->set_range (lower, upper,
                            delta * 0.1, delta * 0.2,
                            0.0);  
}

Inti::Gtk::VScale::VScale (GtkVScale *obj,
                            GtkVScaleClass *orig)
  : Scale ((GtkScale*)obj,
           (GtkScaleClass*)orig)
{
  
}

Inti::Gtk::VScale::~VScale ()
{

}




/////////// Everything below here is machine-generated
