// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This source file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
#include "progressbar.h"
#include "progressbar-class.h"
#include <inti/private-util.h>

Inti::Gtk::ProgressBar::ProgressBar ()
  : Widget ((GtkWidget*)Private::ProgressBarClass::make_proxy (),
            (GtkWidgetClass*) Private::ProgressBarClass::original_class ())
{

}

Inti::Gtk::ProgressBar::ProgressBar (Orientation o)
  : Widget ((GtkWidget*)Private::ProgressBarClass::make_proxy (),
            (GtkWidgetClass*) Private::ProgressBarClass::original_class ())
{
  set_orientation (o);
}

Inti::Gtk::ProgressBar::ProgressBar (GtkProgressBar *obj, GtkProgressBarClass * orig)
  : Widget ((GtkWidget*)obj,
            (GtkWidgetClass*)orig)
{
  
}

Inti::Gtk::ProgressBar::~ProgressBar ()
{
  
}

void
Inti::Gtk::ProgressBar::pulse ()
{
  gtk_progress_bar_pulse (gtk_progress_bar ());
}

void
Inti::Gtk::ProgressBar::set_pulse_step (float fraction)
{
  gtk_progress_bar_set_pulse_step (gtk_progress_bar (), fraction);
}

float
Inti::Gtk::ProgressBar::pulse_step () const
{
  return gtk_progress_bar ()->pulse_fraction;
}

void
Inti::Gtk::ProgressBar::set_fraction (float fraction)
{
  gtk_progress_bar_set_fraction (gtk_progress_bar (), fraction);
}

float
Inti::Gtk::ProgressBar::fraction () const
{
  return gtk_progress_get_current_percentage (GTK_PROGRESS (gtk_progress_bar ()));
}

void
Inti::Gtk::ProgressBar::set_text (const char *text)
{
  gtk_progress_bar_set_text (gtk_progress_bar (), text);
}

void
Inti::Gtk::ProgressBar::set_text (const ustring &text)
{
  set_text (text.c_str ());
}

Inti::ustring
Inti::Gtk::ProgressBar::text () const
{
  char *txt = GTK_PROGRESS (gtk_progress_bar ())->format;
  if (txt)
    return ustring (txt);
  else
    return ustring ("");
}

void
Inti::Gtk::ProgressBar::set_orientation (Orientation o)
{
  gtk_progress_bar_set_orientation (gtk_progress_bar (),
                                    (GtkProgressBarOrientation) o);
}

Inti::Gtk::ProgressBar::Orientation
Inti::Gtk::ProgressBar::orientation () const
{
  return (Orientation) gtk_progress_bar ()->orientation;
}




/////////// Everything below here is machine-generated
