// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_GTK_MENUITEM_H_
#define _INTI_GTK_MENUITEM_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <inti/gtk/item.h>
#include <inti/gtk/gtkbase.h>
#include <inti/gtk/activatable.h>
#include <gtk/gtkmenuitem.h>
#include <string>

/*$ doc header
  $short FIXME
  $*/

namespace Inti
{  
  namespace Gtk
  {
    namespace Private
    {
      class MenuItemClass;
    };

    class Menu;
    
    class MenuItem : public Item, public Activatable
    {
    public:
      /*$ doc class MenuItem
        $short FIXME

        $copy none
        $memory floating
        
        $long

        <para>

        </para>
        
        $*/
        
      GtkMenuItem * gtk_menu_item () const
      {
        return (GtkMenuItem*)g_object ();
      }

      /*$ doc constructor
        $short Construct a new MenuItem
        $long

        <para>

        </para>
        
        $*/
      MenuItem ();

      MenuItem (const ustring & text);
      MenuItem (const char * text);
      
    protected:
      typedef WrapSignal0<void> ActivateSignalType;
      static const ActivateSignalType activate_signal;

    public:
      typedef SignalProxy<Object,ActivateSignalType> ActivateProxyType;
      const ActivateProxyType sig_activate ()
      {
        return ActivateProxyType (this, &activate_signal);
      }
    protected:
      typedef WrapSignal0<void> ActivateItemSignalType;
      static const ActivateItemSignalType activate_item_signal;

    public:
      typedef SignalProxy<Object,ActivateItemSignalType> ActivateItemProxyType;
      const ActivateItemProxyType sig_activate_item ()
      {
        return ActivateItemProxyType (this, &activate_item_signal);
      }

      void set_submenu (Menu * menu);
      Menu * submenu () const;
      
      void set_right_justified (bool setting);
      bool right_justified () const;

      // Activatable
      virtual void activate ();
      
    protected:
      friend class Private::MenuItemClass;
      
      explicit MenuItem (GtkMenuItem *src, GtkMenuItemClass *orig);
      virtual ~MenuItem ();

      virtual void activate_impl ();
      virtual void activate_item_impl ();

      virtual void on_activate ();
      virtual void on_activate_item ();
      
    private:
      MenuItem(const MenuItem&);
      MenuItem& operator=(const MenuItem&);

      static void activate_proxy (GtkMenuItem * mi);
      static void activate_item_proxy (GtkMenuItem * mi);
      
    }; // class MenuItem

    class SeparatorMenuItem : public MenuItem
    {
    public:
      SeparatorMenuItem ();

    protected:
      virtual ~SeparatorMenuItem ();

    private:
      SeparatorMenuItem(const SeparatorMenuItem&);
      SeparatorMenuItem& operator=(const SeparatorMenuItem&);      
    }; // class SeparatorMenuItem
    
  }; // namespace Gtk
  
}; // namespace Inti

#endif // _INTI_GTK_MENUITEM_H_
