// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_GTK_GTK_SIGNALS_H_
#define _INTI_GTK_GTK_SIGNALS_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <inti/signal-system.h>

/*$ doc header
  $short Signals that wrap a native GTK+ signal (you only care about this
  if you are wrapping a widget written in C)
  $*/

namespace Inti
{
  class Object;
  
  namespace Gtk
  {
    namespace Private
    {
      typedef void (* SignalFunc) (...);

    }; // namespace Private
    
    class WrapSignal : public Signal
    {
    public:
      WrapSignal (const char * name, Private::SignalFunc callback)
        : name_(name), callback_(callback)
      {
      }
      
      ~WrapSignal ()
      {
      }

      const char * name () const { return name_; }
      
    protected:
      Connection real_connect (Object * object,
                               Slot * slot,
                               DestroyNotifier * alive_object) const;
      
    private:
      WrapSignal (const WrapSignal&);
      WrapSignal& operator= (const WrapSignal&);

      const char * const name_;
      const Private::SignalFunc callback_;
    };


    // Signal wrapping a GTK signal with 0 argument(s)
    template <class ReturnType>
    class WrapSignal0 : public WrapSignal
    {
    public:
      typedef Slot0<ReturnType> SlotType;

      WrapSignal0 (const char * name, Private::SignalFunc callback)
      : WrapSignal (name, callback)
      {
      }

      ~WrapSignal0 ()
      {
      }
      
      Connection connect (Object * object,
                          SlotType * slot,
                          DestroyNotifier * alive_object = 0) const
      {
        return real_connect (object, slot, alive_object);
      }
      
    private:
      WrapSignal0(const WrapSignal0 &);
      WrapSignal0 & operator=(const WrapSignal0 &);
    }; // class WrapSignal0

    // Signal wrapping a GTK signal with 1 argument(s)
    template <class ReturnType, class Arg1Type>
    class WrapSignal1 : public WrapSignal
    {
    public:
      typedef Slot1<ReturnType, Arg1Type> SlotType;

      WrapSignal1 (const char * name, Private::SignalFunc callback)
      : WrapSignal (name, callback)
      {
      }

      ~WrapSignal1 ()
      {
      }
      
      Connection connect (Object * object,
                          SlotType * slot,
                          DestroyNotifier * alive_object = 0) const
      {
        return real_connect (object, slot, alive_object);
      }
      
    private:
      WrapSignal1(const WrapSignal1 &);
      WrapSignal1 & operator=(const WrapSignal1 &);
    }; // class WrapSignal1

    // Signal wrapping a GTK signal with 2 argument(s)
    template <class ReturnType, class Arg1Type, class Arg2Type>
    class WrapSignal2 : public WrapSignal
    {
    public:
      typedef Slot2<ReturnType, Arg1Type, Arg2Type> SlotType;

      WrapSignal2 (const char * name, Private::SignalFunc callback)
      : WrapSignal (name, callback)
      {
      }

      ~WrapSignal2 ()
      {
      }
      
      Connection connect (Object * object,
                          SlotType * slot,
                          DestroyNotifier * alive_object = 0) const
      {
        return real_connect (object, slot, alive_object);
      }
      
    private:
      WrapSignal2(const WrapSignal2 &);
      WrapSignal2 & operator=(const WrapSignal2 &);
    }; // class WrapSignal2

    // Signal wrapping a GTK signal with 3 argument(s)
    template <class ReturnType, class Arg1Type, class Arg2Type, class Arg3Type>
    class WrapSignal3 : public WrapSignal
    {
    public:
      typedef Slot3<ReturnType, Arg1Type, Arg2Type, Arg3Type> SlotType;

      WrapSignal3 (const char * name, Private::SignalFunc callback)
      : WrapSignal (name, callback)
      {
      }

      ~WrapSignal3 ()
      {
      }
      
      Connection connect (Object * object,
                          SlotType * slot,
                          DestroyNotifier * alive_object = 0) const
      {
        return real_connect (object, slot, alive_object);
      }
      
    private:
      WrapSignal3(const WrapSignal3 &);
      WrapSignal3 & operator=(const WrapSignal3 &);
    }; // class WrapSignal3

    // Signal wrapping a GTK signal with 4 argument(s)
    template <class ReturnType, class Arg1Type, class Arg2Type, class Arg3Type, class Arg4Type>
    class WrapSignal4 : public WrapSignal
    {
    public:
      typedef Slot4<ReturnType, Arg1Type, Arg2Type, Arg3Type, Arg4Type> SlotType;

      WrapSignal4 (const char * name, Private::SignalFunc callback)
      : WrapSignal (name, callback)
      {
      }

      ~WrapSignal4 ()
      {
      }
      
      Connection connect (Object * object,
                          SlotType * slot,
                          DestroyNotifier * alive_object = 0) const
      {
        return real_connect (object, slot, alive_object);
      }
      
    private:
      WrapSignal4(const WrapSignal4 &);
      WrapSignal4 & operator=(const WrapSignal4 &);
    }; // class WrapSignal4

    // Signal wrapping a GTK signal with 5 argument(s)
    template <class ReturnType, class Arg1Type, class Arg2Type, class Arg3Type, class Arg4Type, class Arg5Type>
    class WrapSignal5 : public WrapSignal
    {
    public:
      typedef Slot5<ReturnType, Arg1Type, Arg2Type, Arg3Type, Arg4Type, Arg5Type> SlotType;

      WrapSignal5 (const char * name, Private::SignalFunc callback)
      : WrapSignal (name, callback)
      {
      }

      ~WrapSignal5 ()
      {
      }
      
      Connection connect (Object * object,
                          SlotType * slot,
                          DestroyNotifier * alive_object = 0) const
      {
        return real_connect (object, slot, alive_object);
      }
      
    private:
      WrapSignal5(const WrapSignal5 &);
      WrapSignal5 & operator=(const WrapSignal5 &);
    }; // class WrapSignal5

    // Signal wrapping a GTK signal with 6 argument(s)
    template <class ReturnType, class Arg1Type, class Arg2Type, class Arg3Type, class Arg4Type, class Arg5Type, class Arg6Type>
    class WrapSignal6 : public WrapSignal
    {
    public:
      typedef Slot6<ReturnType, Arg1Type, Arg2Type, Arg3Type, Arg4Type, Arg5Type, Arg6Type> SlotType;

      WrapSignal6 (const char * name, Private::SignalFunc callback)
      : WrapSignal (name, callback)
      {
      }

      ~WrapSignal6 ()
      {
      }
      
      Connection connect (Object * object,
                          SlotType * slot,
                          DestroyNotifier * alive_object = 0) const
      {
        return real_connect (object, slot, alive_object);
      }
      
    private:
      WrapSignal6(const WrapSignal6 &);
      WrapSignal6 & operator=(const WrapSignal6 &);
    }; // class WrapSignal6
    
    namespace Private
    {
      class ConnectionImpl
        : public Inti::Private::ConnectionImpl,
          public Inti::DestroyListener
      {
      public:
        // abstract interface
        virtual ~ConnectionImpl ();
        virtual void disconnect ();
        virtual void block ();
        virtual void unblock ();
      
        ConnectionImpl (const WrapSignal * signal,
                        Inti::Object * object,
                        Slot * slot,
                        DestroyNotifier * alive_object,
                        Private::SignalFunc callback);

        Inti::Object * object () const { return object_; }
      
        // DestroyListener
        virtual void notifier_destroyed (const DestroyNotifier * notifier);

        Slot * slot () { return slot_; }
        
      private:
        Slot * slot_;
        Inti::Object * object_;
        DestroyNotifier * alive_object_;
        unsigned int connection_id_;
      };
      
    }; // namespace Private
    
  }; // namespace Gtk
  
}; // namespace Inti

#endif // _INTI_GTK_GTK_SIGNALS_H_
