// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This source file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
#include "button.h"
#include "button-class.h"
#include "label.h"
#include "marshal.h"
#include <inti/proxies.h>
#include <inti/private-util.h>

Inti::Gtk::Button::Button ()
  : Bin ((GtkBin*)Private::ButtonClass::make_proxy (),
         (GtkBinClass*) Private::ButtonClass::original_class ())
{

}

Inti::Gtk::Button::Button (const ustring & text)
  : Bin ((GtkBin*)Private::ButtonClass::make_proxy (),
         (GtkBinClass*) Private::ButtonClass::original_class ())
{
  Label * l = new Label (text);
  l->show ();
  add (l);
}

Inti::Gtk::Button::Button (const char * text)
  : Bin ((GtkBin*)Private::ButtonClass::make_proxy (),
         (GtkBinClass*) Private::ButtonClass::original_class ())
{
  Label * l = new Label (text);
  l->show ();
  add (l);
}

Inti::Gtk::Button::Button (GtkButton *obj, GtkButtonClass * orig)
  : Bin ((GtkBin*)obj,
         (GtkBinClass*)orig)
{

}

Inti::Gtk::Button::~Button ()
{

}

Inti::Gtk::ReliefStyle
Inti::Gtk::Button::relief () const
{
  return (ReliefStyle) gtk_button_get_relief (gtk_button ());
}

void
Inti::Gtk::Button::activate ()
{
  gtk_widget_activate (gtk_widget ());
}

void
Inti::Gtk::Button::button_clicked_proxy (GtkButton * button)
{
  Inti::Private::proxy_implementation_0 (button,
                                            &Button::clicked_impl,
                                            &Button::on_clicked);
}

void
Inti::Gtk::Button::button_pressed_proxy (GtkButton * button)
{
  Inti::Private::proxy_implementation_0 (button,
                                            &Button::pressed_impl,
                                            &Button::on_pressed);
}

void
Inti::Gtk::Button::button_released_proxy (GtkButton * button)
{
  Inti::Private::proxy_implementation_0 (button,
                                            &Button::released_impl,
                                            &Button::on_released);
}

void
Inti::Gtk::Button::button_enter_proxy (GtkButton * button)
{
  Inti::Private::proxy_implementation_0 (button,
                                            &Button::enter_impl,
                                            &Button::on_enter);
}

void
Inti::Gtk::Button::button_leave_proxy (GtkButton * button)
{
  Inti::Private::proxy_implementation_0 (button,
                                            &Button::leave_impl,
                                            &Button::on_leave);
}

void
Inti::Gtk::Button::clicked_impl ()
{
  GtkButtonClass * orig =
    (GtkButtonClass *) original_class();

  if (orig->clicked)
    (* orig->clicked) (gtk_button ());
}

void
Inti::Gtk::Button::pressed_impl ()
{
  GtkButtonClass * orig =
    (GtkButtonClass *) original_class();

  if (orig->pressed)
    (* orig->pressed) (gtk_button ());
}

void
Inti::Gtk::Button::released_impl ()
{
  GtkButtonClass * orig =
    (GtkButtonClass *) original_class();

  if (orig->released)
    (* orig->released) (gtk_button ());
}

void
Inti::Gtk::Button::enter_impl ()
{
  GtkButtonClass * orig =
    (GtkButtonClass *) original_class();

  if (orig->enter)
    (* orig->enter) (gtk_button ());
}

void
Inti::Gtk::Button::leave_impl ()
{
  GtkButtonClass * orig =
    (GtkButtonClass *) original_class();

  if (orig->leave)
    (* orig->leave) (gtk_button ());
}


void
Inti::Gtk::Button::on_clicked ()
{
  // nothing
}

void
Inti::Gtk::Button::on_pressed ()
{
  // nothing
}

void
Inti::Gtk::Button::on_released ()
{
  // nothing
}

void
Inti::Gtk::Button::on_enter ()
{
  // nothing
}

void
Inti::Gtk::Button::on_leave ()
{
  // nothing
}




/////////// Everything below here is machine-generated
const Inti::Gtk::Button::ClickedSignalType
Inti::Gtk::Button::clicked_signal ("clicked", (Private::SignalFunc)Private::slot0_void_callback);

const Inti::Gtk::Button::PressedSignalType
Inti::Gtk::Button::pressed_signal ("pressed", (Private::SignalFunc)Private::slot0_void_callback);

const Inti::Gtk::Button::ReleasedSignalType
Inti::Gtk::Button::released_signal ("released", (Private::SignalFunc)Private::slot0_void_callback);

const Inti::Gtk::Button::EnterSignalType
Inti::Gtk::Button::enter_signal ("enter", (Private::SignalFunc)Private::slot0_void_callback);

const Inti::Gtk::Button::LeaveSignalType
Inti::Gtk::Button::leave_signal ("leave", (Private::SignalFunc)Private::slot0_void_callback);

void
Inti::Gtk::Button::set_relief (Gtk::ReliefStyle newstyle)
{
   gtk_button_set_relief (gtk_button (), (GtkReliefStyle) newstyle);
}
