// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_BASE_CONNECTION_H_
#define _INTI_BASE_CONNECTION_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <inti/destroy-notify.h>

/*$ doc header
  $short Connection class, used to disconnect/block/unblock a connection
  $*/

namespace Inti
{
  //////////// Connection
  
  namespace Private
  {
    // virtual class that implements a Connection
    class ConnectionImpl
    {
    public:
      ConnectionImpl ();
      
      virtual ~ConnectionImpl ();
      virtual void disconnect () = 0;
      virtual void block () = 0;
      virtual void unblock () = 0;
      void ref () { ref_count_ += 1; }
      void unref ();

      bool disconnected () const { return disconnected_; }

      void set_disconnected (bool setting) { disconnected_ = setting; }
      
    private:
      unsigned int ref_count_;
      bool disconnected_;

    };
  };
  
  class Connection
  {
  public:
    Connection ()
      : impl_(0)
    {
    }

    explicit Connection (Private::ConnectionImpl * impl);

    Connection (const Connection & src);

    ~Connection ();

    Connection& operator=(const Connection& src);
    
    void disconnect ();

    void block ();
    void unblock ();
    
  private:
    Private::ConnectionImpl * impl_;
  };
  
}; // namespace Inti

#endif // _INTI_BASE_CONNECTION_H_
