// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_BASE_BIND_H_
#define _INTI_BASE_BIND_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <inti/slot.h>

/*$ doc header
  $short Binding adaptors (objects that allow you to convert between slot types)
  $*/

namespace Inti
{


  // slot with 0 argument(s) created from a slot with 1 argument(s)
  template <class ReturnType, class Arg1Type>
  class BoundSlot0_1: public Slot0<ReturnType>
  {
  public:
    BoundSlot0_1 (Slot1<ReturnType, Arg1Type> * slot, Arg1Type arg1)
      : original_slot_(slot), arg1_(arg1)
    {
      original_slot_->ref ();
      original_slot_->sink ();
    }

    virtual ReturnType invoke () const
    {
      return original_slot_->invoke (arg1_);
    }
  protected:
    virtual ~BoundSlot0_1 ()
    {
      original_slot_->unref ();
    }
  private:
    Slot1<ReturnType, Arg1Type> * original_slot_;
    Arg1Type arg1_;
  }; // class BoundSlot0_1

  // convenience function that creates a BoundSlot
  template <class ReturnType, class Arg1Type>
  inline Slot0<ReturnType> *
  bind (Slot1<ReturnType, Arg1Type> * s, Arg1Type arg1)
  {
    return new BoundSlot0_1<ReturnType, Arg1Type> (s, arg1);
  }

  // slot with 1 argument(s) created from a slot with 2 argument(s)
  template <class ReturnType, class Arg1Type, class Arg2Type>
  class BoundSlot1_2: public Slot1<ReturnType, Arg1Type>
  {
  public:
    BoundSlot1_2 (Slot2<ReturnType, Arg1Type, Arg2Type> * slot, Arg2Type arg2)
      : original_slot_(slot), arg2_(arg2)
    {
      original_slot_->ref ();
      original_slot_->sink ();
    }

    virtual ReturnType invoke (Arg1Type arg1) const
    {
      return original_slot_->invoke (arg1, arg2_);
    }
  protected:
    virtual ~BoundSlot1_2 ()
    {
      original_slot_->unref ();
    }
  private:
    Slot2<ReturnType, Arg1Type, Arg2Type> * original_slot_;
    Arg2Type arg2_;
  }; // class BoundSlot1_2

  // convenience function that creates a BoundSlot
  template <class ReturnType, class Arg1Type, class Arg2Type>
  inline Slot1<ReturnType, Arg1Type> *
  bind (Slot2<ReturnType, Arg1Type, Arg2Type> * s, Arg2Type arg2)
  {
    return new BoundSlot1_2<ReturnType, Arg1Type, Arg2Type> (s, arg2);
  }

  // slot with 2 argument(s) created from a slot with 3 argument(s)
  template <class ReturnType, class Arg1Type, class Arg2Type, class Arg3Type>
  class BoundSlot2_3: public Slot2<ReturnType, Arg1Type, Arg2Type>
  {
  public:
    BoundSlot2_3 (Slot3<ReturnType, Arg1Type, Arg2Type, Arg3Type> * slot, Arg3Type arg3)
      : original_slot_(slot), arg3_(arg3)
    {
      original_slot_->ref ();
      original_slot_->sink ();
    }

    virtual ReturnType invoke (Arg1Type arg1, Arg2Type arg2) const
    {
      return original_slot_->invoke (arg1, arg2, arg3_);
    }
  protected:
    virtual ~BoundSlot2_3 ()
    {
      original_slot_->unref ();
    }
  private:
    Slot3<ReturnType, Arg1Type, Arg2Type, Arg3Type> * original_slot_;
    Arg3Type arg3_;
  }; // class BoundSlot2_3

  // convenience function that creates a BoundSlot
  template <class ReturnType, class Arg1Type, class Arg2Type, class Arg3Type>
  inline Slot2<ReturnType, Arg1Type, Arg2Type> *
  bind (Slot3<ReturnType, Arg1Type, Arg2Type, Arg3Type> * s, Arg3Type arg3)
  {
    return new BoundSlot2_3<ReturnType, Arg1Type, Arg2Type, Arg3Type> (s, arg3);
  }

  // slot with 3 argument(s) created from a slot with 4 argument(s)
  template <class ReturnType, class Arg1Type, class Arg2Type, class Arg3Type, class Arg4Type>
  class BoundSlot3_4: public Slot3<ReturnType, Arg1Type, Arg2Type, Arg3Type>
  {
  public:
    BoundSlot3_4 (Slot4<ReturnType, Arg1Type, Arg2Type, Arg3Type, Arg4Type> * slot, Arg4Type arg4)
      : original_slot_(slot), arg4_(arg4)
    {
      original_slot_->ref ();
      original_slot_->sink ();
    }

    virtual ReturnType invoke (Arg1Type arg1, Arg2Type arg2, Arg3Type arg3) const
    {
      return original_slot_->invoke (arg1, arg2, arg3, arg4_);
    }
  protected:
    virtual ~BoundSlot3_4 ()
    {
      original_slot_->unref ();
    }
  private:
    Slot4<ReturnType, Arg1Type, Arg2Type, Arg3Type, Arg4Type> * original_slot_;
    Arg4Type arg4_;
  }; // class BoundSlot3_4

  // convenience function that creates a BoundSlot
  template <class ReturnType, class Arg1Type, class Arg2Type, class Arg3Type, class Arg4Type>
  inline Slot3<ReturnType, Arg1Type, Arg2Type, Arg3Type> *
  bind (Slot4<ReturnType, Arg1Type, Arg2Type, Arg3Type, Arg4Type> * s, Arg4Type arg4)
  {
    return new BoundSlot3_4<ReturnType, Arg1Type, Arg2Type, Arg3Type, Arg4Type> (s, arg4);
  }

  // slot with 4 argument(s) created from a slot with 5 argument(s)
  template <class ReturnType, class Arg1Type, class Arg2Type, class Arg3Type, class Arg4Type, class Arg5Type>
  class BoundSlot4_5: public Slot4<ReturnType, Arg1Type, Arg2Type, Arg3Type, Arg4Type>
  {
  public:
    BoundSlot4_5 (Slot5<ReturnType, Arg1Type, Arg2Type, Arg3Type, Arg4Type, Arg5Type> * slot, Arg5Type arg5)
      : original_slot_(slot), arg5_(arg5)
    {
      original_slot_->ref ();
      original_slot_->sink ();
    }

    virtual ReturnType invoke (Arg1Type arg1, Arg2Type arg2, Arg3Type arg3, Arg4Type arg4) const
    {
      return original_slot_->invoke (arg1, arg2, arg3, arg4, arg5_);
    }
  protected:
    virtual ~BoundSlot4_5 ()
    {
      original_slot_->unref ();
    }
  private:
    Slot5<ReturnType, Arg1Type, Arg2Type, Arg3Type, Arg4Type, Arg5Type> * original_slot_;
    Arg5Type arg5_;
  }; // class BoundSlot4_5

  // convenience function that creates a BoundSlot
  template <class ReturnType, class Arg1Type, class Arg2Type, class Arg3Type, class Arg4Type, class Arg5Type>
  inline Slot4<ReturnType, Arg1Type, Arg2Type, Arg3Type, Arg4Type> *
  bind (Slot5<ReturnType, Arg1Type, Arg2Type, Arg3Type, Arg4Type, Arg5Type> * s, Arg5Type arg5)
  {
    return new BoundSlot4_5<ReturnType, Arg1Type, Arg2Type, Arg3Type, Arg4Type, Arg5Type> (s, arg5);
  }

  // slot with 5 argument(s) created from a slot with 6 argument(s)
  template <class ReturnType, class Arg1Type, class Arg2Type, class Arg3Type, class Arg4Type, class Arg5Type, class Arg6Type>
  class BoundSlot5_6: public Slot5<ReturnType, Arg1Type, Arg2Type, Arg3Type, Arg4Type, Arg5Type>
  {
  public:
    BoundSlot5_6 (Slot6<ReturnType, Arg1Type, Arg2Type, Arg3Type, Arg4Type, Arg5Type, Arg6Type> * slot, Arg6Type arg6)
      : original_slot_(slot), arg6_(arg6)
    {
      original_slot_->ref ();
      original_slot_->sink ();
    }

    virtual ReturnType invoke (Arg1Type arg1, Arg2Type arg2, Arg3Type arg3, Arg4Type arg4, Arg5Type arg5) const
    {
      return original_slot_->invoke (arg1, arg2, arg3, arg4, arg5, arg6_);
    }
  protected:
    virtual ~BoundSlot5_6 ()
    {
      original_slot_->unref ();
    }
  private:
    Slot6<ReturnType, Arg1Type, Arg2Type, Arg3Type, Arg4Type, Arg5Type, Arg6Type> * original_slot_;
    Arg6Type arg6_;
  }; // class BoundSlot5_6

  // convenience function that creates a BoundSlot
  template <class ReturnType, class Arg1Type, class Arg2Type, class Arg3Type, class Arg4Type, class Arg5Type, class Arg6Type>
  inline Slot5<ReturnType, Arg1Type, Arg2Type, Arg3Type, Arg4Type, Arg5Type> *
  bind (Slot6<ReturnType, Arg1Type, Arg2Type, Arg3Type, Arg4Type, Arg5Type, Arg6Type> * s, Arg6Type arg6)
  {
    return new BoundSlot5_6<ReturnType, Arg1Type, Arg2Type, Arg3Type, Arg4Type, Arg5Type, Arg6Type> (s, arg6);
  }
  
}; // namespace Inti

#endif // _INTI_BASE_BIND_H_
