// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
// Example/test code using Inti slots
/*
  The following license applies to this example code, but not to
  the Inti library itself:
  
    Permission is hereby granted, free of charge, to any person obtaining
    a copy of this software and associated documentation files (the
    "Software"), to deal in the Software without restriction, including
    without limitation the rights to use, copy, modify, merge, publish,
    distribute, sublicense, and/or sell copies of the Software, and to
    permit persons to whom the Software is furnished to do so, subject to
    the following conditions:

    The above copyright notice and this permission notice shall be
    included in all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
    NONINFRINGEMENT.  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
    DISTRIBUTOR OF THE SOFTWARE BE LIABLE FOR ANY CLAIM, DAMAGES OR
    OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
    OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
    OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include <inti/slot.h>
#include <inti/bind.h>
#include <string>
#include <iostream>

using namespace Inti;

class A
{
public:
  void nothing ()
  {
    cout << "A::nothing called" << endl;
  }
  
  void frobate (int i, string & s)
  {
    cout << "A::frobate called with int: " << i << " string: " << s << endl;
  }
  
  string foo (int i)
  {
    cout << "A::foo called with int: " << i << " (returning 'foo')" << endl;
    return "foo";
  }
  
  int bar (int* q, const char *s)
  {
    cout << "A::bar called with int: " << *q << " string: " << s << endl;
    cout << " (returning 14 and filling out param with 17)" << endl;
    *q = 17;
    return 14;
  }
};

void nothing ()
{
  cout << "function nothing() called" << endl;
}

void frobate (int i, string & s)
{
  cout << "function frobate() called with int: " << i << " string: " << s << endl;
}
  
string foo (int i)
{
  cout << "function foo() called with int: " << i << " (returning 'bar')" << endl;
  return "bar";
}
  
int bar (int* q, const char *s)
{
  cout << "function bar() called with int: " << *q << " string: " << s << endl;
  cout << " (returning 5 and filling out param with 7)" << endl;
  *q = 7;
  return 5;
}

int
main (int argc, char **argv)
{
  A* obj = new A;

  string hello = "Hello";
  int i = 0;

  // Method slots
  Slot0<void> * a = slot (obj, &A::nothing);
  Slot2<void,int,string&> *b = slot (obj, &A::frobate);
  Slot1<string,int> *c = slot (obj, &A::foo);
  Slot2<int,int*,const char*> *d = slot (obj, &A::bar);

  a->invoke();
  b->invoke (32, hello);
  cout << "Result of invocation: " << c->invoke(10) << endl;
  cout << "Result of invocation: " << d->invoke (&i, "FooBar") << endl;
  cout << "   i: " << i << endl;

  // Binding
  Slot0<string> * bound_slot = bind (c, 37);
  Slot0<string> * bound_slot2 = bind (slot (obj, &A::foo), 52);
  
  cout << "Result of bound slot invocation: " << bound_slot->invoke() << endl;
  cout << "Result of bound slot invocation: " << bound_slot2->invoke() << endl;

  a->unref ();
  b->unref ();
  c->unref ();
  d->unref ();
  bound_slot->unref ();
  bound_slot2->unref ();
  
  return 0;
}

