// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This source file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
#include "signal-system.h"

///////////////////////////

namespace Inti
{
  namespace Private
  {
    class NativeConnectionImpl
      : public Inti::Private::ConnectionImpl,
        public Inti::DestroyListener
    {
    public:
      // abstract interface
      virtual ~NativeConnectionImpl ();
      virtual void disconnect ();
      virtual void block ();
      virtual void unblock ();
      
      NativeConnectionImpl (const Signal * signal,
                            SignalEmitterBase * emitter_object,
                            Slot * slot,
                            DestroyNotifier * alive_object);
      
      bool blocked () const { return block_count_ > 0; }
      
      void * emitter () const { return emitter_; }
      
      // DestroyListener
      virtual void notifier_destroyed (const DestroyNotifier * notifier);

      Slot * slot () const { return slot_; }
      const Signal * signal () const { return signal_; }
      
    private:
      const Signal * const signal_;
      Slot * slot_;
      unsigned int block_count_;
      SignalEmitterBase * emitter_;
      DestroyNotifier * alive_object_;
    };
    
  }; // namespace Private

}; // namespace Inti

Inti::Private::NativeConnectionImpl::NativeConnectionImpl (const Signal * signal,
                                                              SignalEmitterBase * emitter_object,
                                                              Slot * slot,
                                                              DestroyNotifier * alive_object)
  : signal_ (signal),
    slot_ (slot),
    block_count_ (0),
    emitter_ (emitter_object),
    alive_object_ (alive_object)
{
  slot_->ref ();
  slot_->sink ();
  
  if (alive_object_)
    alive_object_->add_destroy_listener (this);
}

Inti::Private::NativeConnectionImpl::~NativeConnectionImpl ()
{
  // mop this up, if it didn't happen (typically it doesn't happen
  // if you destroy a SignalEmitter, which sets the disconnected
  // flag but doesn't call disconnect ())
  if (alive_object_)
    alive_object_->remove_destroy_listener (this);

  slot_->unref ();
}

void
Inti::Private::NativeConnectionImpl::disconnect ()
{
  if (disconnected ())
    return;

  ref ();
  
  set_disconnected (true);
  emitter_->remove_signal_connection (this);

  if (alive_object_)
    {
      alive_object_->remove_destroy_listener (this);
      alive_object_ = 0;
    }

  unref ();
}

void
Inti::Private::NativeConnectionImpl::block ()
{
  block_count_ += 1;
}

void
Inti::Private::NativeConnectionImpl::unblock ()
{
  block_count_ -= 1;
}

void
Inti::Private::NativeConnectionImpl::notifier_destroyed (const DestroyNotifier * notifier)
{
  alive_object_ = 0;
  disconnect ();
}

/////////////////////////////////

Inti::Signal::Signal ()
{
  

}

Inti::Signal::~Signal ()
{
  
  
}

////////////////////////////////

Inti::SignalEmitterBase::~SignalEmitterBase ()
{

}

void
Inti::SignalEmitterBase::add_to_connection_list (ConnectionList * list,
                                                    Private::NativeConnectionImpl * impl)
{
  list->push_back (impl);
  impl->ref ();
}

void
Inti::SignalEmitterBase::get_from_connection_list (ConnectionList * list,
                                                      const Signal * signal,
                                                      ConnectionList * connections)
{
  ConnectionList::iterator i = list->begin ();
  ConnectionList::iterator end = list->end ();

  while (i != end)
    {
      if ((*i)->signal () == signal)
        {
          (*i)->ref ();
          connections->push_back (*i);
        }

      ++i;
    }
}

void
Inti::SignalEmitterBase::remove_from_connnection_list (ConnectionList * list,
                                                          Private::NativeConnectionImpl * impl)
{
  
  ConnectionList::iterator i = list->begin ();
  ConnectionList::iterator end = list->end ();

  while (i != end)
    {
      if (*i == impl)
        break;

      ++i;
    }

  if (i != end)
    {
      impl->unref ();

      list->erase (i);
    }
}

void
Inti::SignalEmitterBase::free_connection_list (ConnectionList * list)
{
  ConnectionList::iterator i = list->begin ();
  ConnectionList::iterator end = list->end ();
  while (i != end)
    {
      // we flag it disconnected, for the benefit of in-progress
      // emissions. We basically abort those emissions
      // by marking all the connections disconnected.

      // however we don't call disconnect() because it
      // would try to hose the list we are iterating over.
      (*i)->set_disconnected (true);
      (*i)->unref ();
      
      ++i;
    }

  delete list;
}

Inti::SignalEmitter::SignalEmitter ()
  : list_(0)
{
}

Inti::SignalEmitter::~SignalEmitter ()
{
  if (list_)
    free_connection_list (list_);
}

void
Inti::SignalEmitter::add_signal_connection (Private::NativeConnectionImpl * impl)
{
  if (list_ == 0)
    list_ = new ConnectionList;

  add_to_connection_list (list_, impl);
}

void
Inti::SignalEmitter::get_signal_connections (const Signal * signal,
                                                ConnectionList * connections)
{
  if (list_ == 0)
    return;

  get_from_connection_list (list_, signal, connections);
}

void
Inti::SignalEmitter::remove_signal_connection (Private::NativeConnectionImpl * impl)
{
  if (list_ == 0)
    return;

  remove_from_connnection_list (list_, impl);
  
  if (list_->empty ())
    {
      // this was the last connection
      delete list_;
      list_ = 0;
    }
}

//////////////////////////////

Inti::NativeSignal::NativeSignal ()
{
  

}

Inti::NativeSignal::~NativeSignal ()
{

}

Inti::Connection
Inti::NativeSignal::real_connect (SignalEmitterBase * emitter_object,
                                     Slot * slot,
                                     DestroyNotifier * alive_object) const
{

  Private::NativeConnectionImpl * impl =
    new Private::NativeConnectionImpl (this,
                                       emitter_object,
                                       slot,
                                       alive_object);

  emitter_object->add_signal_connection (impl);
  impl->unref (); // emitter_object holds a ref now

  return Connection (impl);
}

//////////////

Inti::NativeSignal::Emission::Emission (const NativeSignal * signal,
                                           SignalEmitterBase * emitter)
{
  emitter->get_signal_connections (signal, &connections_);
  next_ = connections_.begin ();
  end_ = connections_.end ();
}

Inti::NativeSignal::Emission::~Emission ()
{
  ConnectionList::iterator i = connections_.begin ();
  while (i != end_)
    {
      (*i)->unref ();

      ++i;
    }
}

Inti::Slot *
Inti::NativeSignal::Emission::next ()
{
  // Skip anything that's blocked or disconnected
  while ( next_ != end_ &&
          ((*next_)->blocked () ||
           (*next_)->disconnected () ) )
    ++next_;

  // Return next slot if any
  if (next_ == end_)
    return 0;
  else
    {
      Slot * s = (*next_)->slot ();
      ++next_;
      return s;
    }
}

/////////// Everything below here is machine-generated
