// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This source file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
#include "window.h"
#include "window-class.h"
#include <inti/private-util.h>
#include <inti/gtk/marshal.h>
#include <inti/gdk/window.h>

/////////// Object

Inti::Gtk::Window::Window ()
  : Bin ((GtkBin*)Private::WindowClass::make_proxy (),
         (GtkBinClass*) Private::WindowClass::original_class ())
{
  gtk_window ()->type = GTK_WINDOW_TOPLEVEL;
}

Inti::Gtk::Window::Window (Window::Type type)
  : Bin ((GtkBin*)Private::WindowClass::make_proxy (),
         (GtkBinClass*) Private::WindowClass::original_class ())
{
  gtk_window ()->type = (GtkWindowType) type;
}

Inti::Gtk::Window::Window (GtkWindow *obj, GtkWindowClass * orig)
  : Bin ((GtkBin*)obj,
         (GtkBinClass*)orig)
{
  
}

Inti::Gtk::Window::~Window ()
{

}


void
Inti::Gtk::Window::set_position (Position pos)
{
  gtk_window_set_position (gtk_window (),
                           (GtkWindowPosition) pos);
}

bool
Inti::Gtk::Window::activate_focus ()
{
  return gtk_window_activate_focus (gtk_window ());
}

bool
Inti::Gtk::Window::activate_default ()
{
  return gtk_window_activate_default (gtk_window ());
}

void
Inti::Gtk::Window::set_transient_for (Window * parent)
{
  gtk_window_set_transient_for (gtk_window (), parent->gtk_window ());
}

void
Inti::Gtk::Window::set_geometry_hints (Widget * geometry_widget,
                                          const Gdk::Geometry & geometry)
{
  gtk_window_set_geometry_hints (gtk_window (),
                                 geometry_widget->gtk_widget (),
                                 geometry.gdk_geometry (),
                                 geometry.gdk_window_hints ());
}

void
Inti::Gtk::Window::set_default_width (int width)
{
  set_default_size (width, -1);
}

void
Inti::Gtk::Window::set_default_height (int height)
{
  set_default_size (-1, height);
}

Inti::ustring
Inti::Gtk::Window::title () const
{
  if (gtk_window ()->title)
    return ustring (gtk_window ()->title);
  else
    return ustring ("");
}

string
Inti::Gtk::Window::wmclass_name () const
{
  return string (gtk_window ()->wmclass_name);
}

string
Inti::Gtk::Window::wmclass_class () const
{
  return string (gtk_window ()->wmclass_class);
}     

Inti::Gtk::Window *
Inti::Gtk::Window::transient_for () const
{
  Window * parent =
    dynamic_cast<Window*>(Object::wrap((GObject*)gtk_window ()->transient_parent));

  return parent;
}

Inti::Gtk::Widget *
Inti::Gtk::Window::focus_widget () const
{
  Widget * w =
    dynamic_cast<Widget*>(Object::wrap((GObject*)gtk_window ()->focus_widget));

  return w;
}

Inti::Gtk::Widget *
Inti::Gtk::Window::default_widget () const
{
  Widget * w =
    dynamic_cast<Widget*>(Object::wrap((GObject*)gtk_window ()->default_widget));

  return w;
}

vector<Inti::Gtk::Widget*>
Inti::Gtk::Window::list_toplevels ()
{
  GList * children;
  GList * iter;
  vector<Widget*> retval;

  children = gtk_window_list_toplevels ();

  iter = children;
  while (iter != 0)
    {
      Widget * child = dynamic_cast<Widget*>(Object::wrap ((GObject*)iter->data));
      retval.push_back (child);

      iter = g_list_next (iter);
    }

  g_list_free (children);

  return retval;
}

void
Inti::Gtk::Window::set_focus_proxy (GtkWindow * window,
                                       GtkWidget * focus_widget)
{
  Window * win = dynamic_cast<Window*>(Object::wrap((GObject*)window));
  Widget * w = dynamic_cast<Widget*>(Object::wrap((GObject*)focus_widget));

  win->set_focus_impl (w);
  win->on_set_focus (w);
}

void
Inti::Gtk::Window::set_focus_impl (Widget * focus_widget)
{
  GtkWindowClass * orig =
    (GtkWindowClass *) original_class();

  if (orig->set_focus)  
    return (* orig->set_focus) (gtk_window (), focus_widget->gtk_widget ());
}

void
Inti::Gtk::Window::on_set_focus (Widget * focus_widget)
{
  // nothing
}

/////////// Everything below here is machine-generated
void
Inti::Gtk::Window::set_title (const std::string& title)
{
   gtk_window_set_title (gtk_window (), title.c_str ());
}
void
Inti::Gtk::Window::set_wmclass (const std::string& wmclass_name, const std::string& wmclass_class)
{
   gtk_window_set_wmclass (gtk_window (), wmclass_name.c_str (), wmclass_class.c_str ());
}
void
Inti::Gtk::Window::set_default_size (int width, int height)
{
   gtk_window_set_default_size (gtk_window (), width, height);
}
void
Inti::Gtk::Window::set_modal (bool modal)
{
   gtk_window_set_modal (gtk_window (), modal);
}
const Inti::Gtk::Window::SetFocusSignalType
Inti::Gtk::Window::set_focus_signal ("set_focus", (Private::SignalFunc)Private::slot1_void_widget_callback);

