// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This source file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
#include "rc.h"
#include "rc-class.h"
#include "widget.h"
#include <inti/private-util.h>
#include <inti/gdk/color.h>
#include <inti/gdk/pixmap.h>
#include <inti/gdk/window.h>
#include <inti/pango/font.h>

Inti::Gtk::RcStyle::RcStyle ()
  : Object (Private::RcStyleClass::make_proxy (),
            Private::RcStyleClass::original_class ()), font_desc_ (0)
{

}

Inti::Gtk::RcStyle::RcStyle (GtkRcStyle *obj,
                             GtkRcStyleClass * orig)
  : Object ((GObject*)obj,
            (GObjectClass*)orig), font_desc_ (0)
{
  
}

Inti::Gtk::RcStyle::~RcStyle ()
{
  if (font_desc_)
    delete font_desc_;
}

Inti::ustring
Inti::Gtk::RcStyle::name () const
{
  if (gtk_rc_style ()->name == 0)
    g_warning ("RcStyle name is unset!");
      
  return ustring (gtk_rc_style ()->name);
}

void
Inti::Gtk::RcStyle::set_name (const string & namex)
{
  set_name (namex.c_str ());
}

void
Inti::Gtk::RcStyle::set_name (const char * namex)
{
  if (gtk_rc_style ()->name)
    g_free (gtk_rc_style ()->name);

  gtk_rc_style ()->name = namex ? g_strdup (namex) : 0;
}

bool
Inti::Gtk::RcStyle::name_set () const
{
  return gtk_rc_style ()->name != 0;
}

void
Inti::Gtk::RcStyle::unset_name ()
{
  set_name ((const char *)0);
}

Inti::ustring
Inti::Gtk::RcStyle::bg_pixmap_name (StateType state) const
{
  if (gtk_rc_style ()->bg_pixmap_name [state] == 0)
    g_warning ("RcStyle background pixmap name is unset!");

  return ustring (gtk_rc_style ()->bg_pixmap_name [state]);
}

void
Inti::Gtk::RcStyle::set_bg_pixmap_name (StateType state,
                                        const string & namex)
{
  set_bg_pixmap_name (state, namex.c_str ());
}

void
Inti::Gtk::RcStyle::set_bg_pixmap_name (StateType state,
                                        const char * namex)
{
  if (gtk_rc_style ()->bg_pixmap_name [state])
    g_free (gtk_rc_style ()->bg_pixmap_name [state]);

  gtk_rc_style ()->bg_pixmap_name [state] = namex ? g_strdup (namex) : 0;
}

bool
Inti::Gtk::RcStyle::bg_pixmap_set (StateType state) const
{
  return gtk_rc_style ()->bg_pixmap_name [state] != 0;
}

void
Inti::Gtk::RcStyle::unset_bg_pixmap (StateType state)
{
  set_bg_pixmap_name (state, (const char*) 0);
}
      
const Inti::Pango::FontDescription &
Inti::Gtk::RcStyle::font_description () const
{
  if (gtk_rc_style ()->font_desc == 0)
    g_warning ("RcStyle font description is unset!");

  if (font_desc_ == 0)
    font_desc_ = new Pango::FontDescription (gtk_rc_style ()->font_desc);
  else
    font_desc_->set (gtk_rc_style ()->font_desc);

  return *font_desc_;
}

void
Inti::Gtk::RcStyle::set_font_description (const Pango::FontDescription & desc)
{
  if (gtk_rc_style ()->font_desc)
    pango_font_description_free (gtk_rc_style ()->font_desc);

  gtk_rc_style ()->font_desc = pango_font_description_copy (desc.pango_font_description ());
}

bool
Inti::Gtk::RcStyle::font_description_set () const
{
  return gtk_rc_style ()->font_desc != 0;
}

void
Inti::Gtk::RcStyle::unset_font_description ()
{
  if (gtk_rc_style ()->font_desc)
    {
      pango_font_description_free (gtk_rc_style ()->font_desc);
      
      gtk_rc_style ()->font_desc = 0;
    }
}

const Inti::Gdk::Color &
Inti::Gtk::RcStyle::fg (StateType state) const
{
  return * (Gdk::Color*) & gtk_rc_style ()->fg[state];
}


const Inti::Gdk::Color &
Inti::Gtk::RcStyle::bg (StateType state) const
{
  return * (Gdk::Color*) & gtk_rc_style ()->bg[state];
}

const Inti::Gdk::Color &
Inti::Gtk::RcStyle::text (StateType state) const
{
  return * (Gdk::Color*) & gtk_rc_style ()->text[state];
}

const Inti::Gdk::Color &
Inti::Gtk::RcStyle::base (StateType state) const
{
  return * (Gdk::Color*) & gtk_rc_style ()->base[state];
}

void
Inti::Gtk::RcStyle::set_fg (StateType state, const Gdk::Color & color)
{
  gtk_rc_style ()->fg[state] =  * (GdkColor*) &color;
  ((int&) gtk_rc_style ()->color_flags[state]) |= int (GTK_RC_FG);
}

void
Inti::Gtk::RcStyle::set_bg (StateType state, const Gdk::Color & color)
{
  gtk_rc_style ()->bg[state] = * (GdkColor*) &color;
  ((int&) gtk_rc_style ()->color_flags[state]) |= int (GTK_RC_BG);
}

void
Inti::Gtk::RcStyle::set_text (StateType state, const Gdk::Color & color)
{
  gtk_rc_style ()->text[state] = * (GdkColor*) &color; 
  ((int&) gtk_rc_style ()->color_flags[state]) |= int (GTK_RC_TEXT);
}

void
Inti::Gtk::RcStyle::set_base (StateType state, const Gdk::Color & color)
{
  gtk_rc_style ()->base[state] = * (GdkColor*) &color;
  ((int&) gtk_rc_style ()->color_flags[state]) |= int (GTK_RC_BASE);
}

bool
Inti::Gtk::RcStyle::fg_set (StateType state) const
{
  return (int (gtk_rc_style ()->color_flags[state]) & GTK_RC_FG) != 0;
}
bool
Inti::Gtk::RcStyle::bg_set (StateType state) const
{
  return (int (gtk_rc_style ()->color_flags[state]) & GTK_RC_BG) != 0;
}

bool
Inti::Gtk::RcStyle::text_set (StateType state) const
{
  return (int (gtk_rc_style ()->color_flags[state]) & GTK_RC_TEXT) != 0;
}

bool
Inti::Gtk::RcStyle::base_set (StateType state) const
{
  return (int (gtk_rc_style ()->color_flags[state]) & GTK_RC_BASE) != 0;
}

void
Inti::Gtk::RcStyle::unset_fg (StateType state)
{
  ((int&)gtk_rc_style ()->color_flags[state]) &= ~ int (GTK_RC_FG);
}

void
Inti::Gtk::RcStyle::unset_bg (StateType state)
{
  ((int&) gtk_rc_style ()->color_flags[state]) &= ~ int (GTK_RC_BG);
}

void
Inti::Gtk::RcStyle::unset_text (StateType state)
{
  ((int&) gtk_rc_style ()->color_flags[state]) &= ~ int (GTK_RC_TEXT);
}

void
Inti::Gtk::RcStyle::unset_base (StateType state)
{
  ((int&) gtk_rc_style ()->color_flags[state]) &= ~ int (GTK_RC_BASE);
}

/////////// Everything below here is machine-generated
