// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_GDK_IMAGE_H_
#define _INTI_GDK_IMAGE_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gdk/gdkimage.h>
#include <inti/object.h>
#include <inti/gdk/gdkbase.h>

namespace Inti
{  
  namespace Gdk
  {
    class Visual;    
    class Colormap;
    
    namespace Private
    {
      class ImageClass;
    }; // namespace Private
    
    class Image : public Object
    {
    public:
      typedef enum
      {
        IMAGE_NORMAL = GDK_IMAGE_NORMAL,
        IMAGE_SHARED = GDK_IMAGE_SHARED,
        IMAGE_FASTEST = GDK_IMAGE_FASTEST,
        IMAGE_SHARED_PIXMAP = GDK_IMAGE_SHARED_PIXMAP
      } Type;
      
      GdkImage * gdk_image () const { return (GdkImage*) g_object (); }

      Image (Type t, const Visual & visual, int width, int height);
      // FIXME gdk_image_new_bitmap ?

      void set_pixel (int x, int y, guint32 pixel);
      guint32 pixel (int x, int y) const;

      const Visual & visual () const;
      
      ByteOrder byte_order () const { return (ByteOrder) gdk_image ()->byte_order; }
      int width () const { return gdk_image ()->width; }
      int height () const { return gdk_image ()->width; }
      int depth () const { return gdk_image ()->depth; }
      int bits_per_pixel () const { return gdk_image ()->bpp; }
      int bytes_per_line () const { return gdk_image ()->bpl; }
      
      void * mem () { return gdk_image ()->mem; }
      const void * mem () const { return gdk_image ()->mem; }
      
    protected:
      virtual ~Image ();
      Image (GdkImage * src, GdkImageClass * orig);
      
    private:
      Image (const Image&);
      Image& operator=(const Image&);

      friend class Private::ImageClass;
      
    };
    
  }; // namespace Gdk
  
}; // namespace Inti

#endif // _INTI_GDK_IMAGE_H_
