// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This source file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
#include "drawable.h"
#include "window.h"
#include "bitmap.h"
#include "visual.h"
#include "gc.h"
#include "drawable-class.h"
#include "colormap.h"
#include "image.h"
#include <inti/private-util.h>
#include <algorithm>

Inti::Gdk::Drawable::Drawable ()
  : Object (Private::DrawableClass::make_proxy (),
            Private::DrawableClass::original_class ())
{

}

Inti::Gdk::Drawable::Drawable (GdkDrawable * src, GdkDrawableClass * orig)
  : Object ((GObject*) src, (GObjectClass*) orig)
{

}

Inti::Gdk::Drawable::~Drawable ()
{

}

int
Inti::Gdk::Drawable::width () const
{
  int w = 0;
  get_size (&w, 0);
  return w;
}

int
Inti::Gdk::Drawable::height () const
{
  int h = 0;
  get_size (0, &h);
  return h;
}

void
Inti::Gdk::Drawable::get_size (int * width, int * height) const
{
  gdk_drawable_get_size (gdk_drawable (), width, height);
}

const Inti::Gdk::Visual &
Inti::Gdk::Drawable::visual () const
{
  return * Visual::wrap (gdk_drawable_get_visual (gdk_drawable ()));
}

int
Inti::Gdk::Drawable::depth () const
{
  return gdk_drawable_get_depth (gdk_drawable ());
}

void
Inti::Gdk::Drawable::set_colormap (Colormap * cmap)
{
  gdk_drawable_set_colormap (gdk_drawable (),
                             cmap->gdk_colormap ());
  cmap->sink ();
}

Inti::Gdk::Colormap *
Inti::Gdk::Drawable::colormap () const
{
  GdkColormap * cmap =
    gdk_drawable_get_colormap (gdk_drawable ());

  return dynamic_cast<Colormap*>(Object::_private_wrap ((GObject*)cmap, false));
}

Inti::Gdk::Image *
Inti::Gdk::Drawable::get_image (int x, int y,
                                   int width, int height) const
{
  GdkImage * img;

  img = gdk_image_get (gdk_drawable (),
                       x, y, width, height);

  // return a floating object
  return dynamic_cast<Image*>(Object::wrap ((GObject*)img));
}

Inti::Gdk::GC *
Inti::Gdk::Drawable::create_gc () const
{
  GdkGC * gc;

  gc = gdk_gc_new (gdk_drawable ());

  // return a floating object
  return dynamic_cast<GC*>(Object::wrap ((GObject*)gc));
}

Inti::Gdk::GC *
Inti::Gdk::Drawable::create_gc (const GC::Values & values) const
{
  GdkGC * gc;

  gc = gdk_gc_new_with_values (gdk_drawable (),
                               values.gdk_gc_values (),
                               values.gdk_gc_values_mask ());

  // return a floating object
  return dynamic_cast<GC*>(Object::wrap ((GObject*)gc));
}

void
Inti::Gdk::Drawable::draw_point (GC * gc, int x, int y)
{
  gdk_draw_point (gdk_drawable (),
                  gc->gdk_gc (),
                  x, y);
}

void
Inti::Gdk::Drawable::draw_point (GC * gc, const Point & point)
{
  gdk_draw_point (gdk_drawable (),
                  gc->gdk_gc (),
                  point.x (), point.y ());
}

void
Inti::Gdk::Drawable::draw_points (GC * gc,
                                  const vector<Point> & points)
{
  g_return_if_fail (!points.empty ());

  Point * array = new Point[points.size ()];

  copy (points.begin (), points.end (), array);

  draw_points (gc, array, points.size ());

  delete [] array;
}

void
Inti::Gdk::Drawable::draw_points (GC * gc,
                                  const Point * points_array,
                                  unsigned int points_array_length)
{
  gdk_draw_points (gdk_drawable (),
                   gc->gdk_gc (),
                   (GdkPoint*)points_array,
                   points_array_length);
}
      
void
Inti::Gdk::Drawable::draw_line (GC * gc,
                                int x1, int y1, int x2, int y2)
{
  gdk_draw_line (gdk_drawable (),
                 gc->gdk_gc (),
                 x1, y1, x2, y2);
}

void
Inti::Gdk::Drawable::draw_line (GC * gc,
                                const Point & point1,
                                const Point & point2)
{
  gdk_draw_line (gdk_drawable (),
                 gc->gdk_gc (),
                 point1.x (), point1.y (),
                 point2.x (), point2.y ());
}
      
void
Inti::Gdk::Drawable::draw_lines (GC * gc,
                                 const vector<Point> & points)
{
  g_return_if_fail (!points.empty ());

  Point * array = new Point[points.size ()];

  copy (points.begin (), points.end (), array);

  draw_lines (gc, array, points.size ());
  
  delete [] array;
}

void
Inti::Gdk::Drawable::draw_lines (GC * gc,
                                 const Point * points_array,
                                 unsigned int points_array_length)
{
  gdk_draw_lines (gdk_drawable (),
                  gc->gdk_gc (),
                  (GdkPoint*)points_array,
                  points_array_length);
}
      
void
Inti::Gdk::Drawable::draw_segments (GC * gc,
                                    const vector<Segment> & segments)
{
  g_return_if_fail (!segments.empty ());

  Segment * array = new Segment[segments.size ()];

  copy (segments.begin (), segments.end (), array);

  draw_segments (gc, array, segments.size ());
  
  delete [] array;
}

void
Inti::Gdk::Drawable::draw_segments (GC * gc,
                                    const Segment * segments_array,
                                    unsigned int segments_array_length)
{
  gdk_draw_segments (gdk_drawable (),
                     gc->gdk_gc (),
                     (GdkSegment*) segments_array,
                     segments_array_length);
}
      
void
Inti::Gdk::Drawable::draw_rectangle (GC * gc,
                                     bool filled,
                                     int x, int y, int width, int height)
{
  gdk_draw_rectangle (gdk_drawable (),
                      gc->gdk_gc (),
                      filled,
                      x, y, width, height);
}

void
Inti::Gdk::Drawable::draw_rectangle (GC * gc,
                                     bool filled,
                                     const Gdk::Rectangle & rect)
{
  gdk_draw_rectangle (gdk_drawable (),
                      gc->gdk_gc (),
                      filled,
                      rect.x (), rect.y (),
                      rect.width (), rect.height ());
}

void
Inti::Gdk::Drawable::draw_arc (GC * gc,
                               bool filled,
                               int x, int y, int width, int height,
                               int angle1, int angle2)
{
  gdk_draw_arc (gdk_drawable (),
                gc->gdk_gc (),
                filled,
                x, y, width, height,
                angle1, angle2);
}

void
Inti::Gdk::Drawable::draw_polygon (GC * gc,
                                   bool filled,
                                   const vector<Point> & points)
{
  g_return_if_fail (!points.empty ());

  Point * array = new Point[points.size ()];

  copy (points.begin (), points.end (), array);

  draw_polygon (gc, filled, array, points.size ());

  delete [] array;
}

void
Inti::Gdk::Drawable::draw_polygon (GC * gc,
                                   bool filled,
                                   const Point * points_array,
                                   unsigned int points_array_length)
{
  gdk_draw_polygon (gdk_drawable (),
                    gc->gdk_gc (),
                    filled,
                    (GdkPoint*) points_array,
                    points_array_length);
}

void
Inti::Gdk::Drawable::draw_drawable (GC * gc,
                                    Drawable * src,
                                    int src_x, int src_y,
                                    int dest_x, int dest_y,
                                    int width, int height)
{
  gdk_draw_drawable (gdk_drawable (),
                     gc->gdk_gc (),
                     src->gdk_drawable (),
                     src_x, src_y,
                     dest_x, dest_y,
                     width, height);
}

void
Inti::Gdk::Drawable::draw_image (GC * gc,
                                 Image * src,
                                 int src_x, int src_y,
                                 int dest_x, int dest_y,
                                 int width, int height)
{
  gdk_draw_image (gdk_drawable (),
                  gc->gdk_gc (),
                  src->gdk_image (),
                  src_x, src_y,
                  dest_x, dest_y,
                  width, height);
}

Inti::Gdk::GC *
Inti::Gdk::Drawable::create_gc_impl ()
{
  GdkDrawableClass * orig =
    (GdkDrawableClass *) original_class ();

  if (orig->create_gc)
    {
      GdkGC * gc;
      
      gc = (* orig->create_gc) (gdk_drawable (), NULL,
                                (GdkGCValuesMask)0);

      // return floating object
      return dynamic_cast<GC*>(Object::wrap ((GObject*)gc));
    }
  else
    return 0;
}

Inti::Gdk::GC *
Inti::Gdk::Drawable::create_gc_impl (const GC::Values & values)
{
  GdkDrawableClass * orig =
    (GdkDrawableClass *) original_class ();

  if (orig->create_gc)
    {
      GdkGC * gc;
      
      gc = (* orig->create_gc) (gdk_drawable (),
                                values.gdk_gc_values (),
                                values.gdk_gc_values_mask ());

      // return floating object
      return dynamic_cast<GC*>(Object::wrap ((GObject*)gc));
    }
  else
    return 0;
}

void
Inti::Gdk::Drawable::draw_rectangle_impl (GC * gc,
                                          bool filled,
                                          int x, int y,
                                          int width, int height)
{
  GdkDrawableClass * orig =
    (GdkDrawableClass *) original_class ();

  if (orig->draw_rectangle)
    (* orig->draw_rectangle) (gdk_drawable (), gc->gdk_gc (),
                              filled, x, y, width, height);
}

void
Inti::Gdk::Drawable::draw_arc_impl (GC * gc,
                                    bool filled,
                                    int x, int y,
                                    int width, int height,
                                    int angle1, int angle2)
{
  GdkDrawableClass * orig =
    (GdkDrawableClass *) original_class ();

  if (orig->draw_arc)
    (* orig->draw_arc) (gdk_drawable (),
                        gc->gdk_gc (),
                        filled,
                        x, y, width, height,
                        angle1, angle2);
}

void
Inti::Gdk::Drawable::draw_polygon_impl (GC * gc,
                                        bool filled,
                                        const Point * points_array,
                                        unsigned int points_array_length)
{
  GdkDrawableClass * orig =
    (GdkDrawableClass *) original_class ();
  
  if (orig->draw_polygon)
    (* orig->draw_polygon) (gdk_drawable (), gc->gdk_gc (),
                            filled, (GdkPoint*)points_array,
                            points_array_length);
}

void
Inti::Gdk::Drawable::draw_drawable_impl (GC * gc,
                                         Drawable * drawable,
                                         int src_x, int src_y,
                                         int dest_x, int dest_y,
                                         int width, int height)
{
  GdkDrawableClass * orig =
    (GdkDrawableClass *) original_class ();

  if (orig->draw_drawable)
    (* orig->draw_drawable) (gdk_drawable (), gc->gdk_gc (),
                             drawable->gdk_drawable (),
                             src_x, src_y,
                             dest_x, dest_y,
                             width, height);
}

void
Inti::Gdk::Drawable::draw_image_impl (GC * gc,
                                      Image * image,
                                      int src_x, int src_y,
                                      int dest_x, int dest_y,
                                      int width, int height)
{
  GdkDrawableClass * orig =
    (GdkDrawableClass *) original_class ();

  if (orig->draw_image)
    (* orig->draw_image) (gdk_drawable (), gc->gdk_gc (),
                          image->gdk_image (),
                          src_x, src_y,
                          dest_x, dest_y,
                          width, height);
}

void
Inti::Gdk::Drawable::draw_points_impl (GC * gc,
                                       const Point * points_array,
                                       unsigned int points_array_length)
{
  GdkDrawableClass * orig =
    (GdkDrawableClass *) original_class ();

  if (orig->draw_points)
    (* orig->draw_points) (gdk_drawable (), gc->gdk_gc (),
                           (GdkPoint*) points_array,
                           points_array_length);
}

void
Inti::Gdk::Drawable::draw_segments_impl (GC * gc,
                                         const Segment * segments_array,
                                         unsigned int segments_array_length)
{
  GdkDrawableClass * orig =
    (GdkDrawableClass *) original_class ();

  if (orig->draw_segments)
    (* orig->draw_segments) (gdk_drawable (),
                             gc->gdk_gc (),
                             (GdkSegment*) segments_array,
                             segments_array_length);
}

void
Inti::Gdk::Drawable::draw_lines_impl (GC * gc,
                                      const Point * points_array,
                                      unsigned int points_array_length)
{
  GdkDrawableClass * orig =
    (GdkDrawableClass *) original_class ();

  if (orig->draw_lines)
    (* orig->draw_lines) (gdk_drawable (),
                          gc->gdk_gc (),
                          (GdkPoint*) points_array,
                          points_array_length);
}

int
Inti::Gdk::Drawable::depth_impl ()
{
  GdkDrawableClass * orig =
    (GdkDrawableClass *) original_class ();

  if (orig->get_depth)
    return (* orig->get_depth) (gdk_drawable ());
  else
    return 0;
}
void
Inti::Gdk::Drawable::get_size_impl (int * width, int * height)
{
  GdkDrawableClass * orig =
    (GdkDrawableClass *) original_class ();

  if (orig->get_size)
    (* orig->get_size) (gdk_drawable (), width, height);
  else
    {
      *width = 0;
      *height = 0;
    }
}

void
Inti::Gdk::Drawable::set_colormap_impl (Colormap * cmap)
{
  GdkDrawableClass * orig =
    (GdkDrawableClass *) original_class ();

  if (orig->set_colormap)
    (* orig->set_colormap) (gdk_drawable (), cmap->gdk_colormap ());
}

Inti::Gdk::Colormap *
Inti::Gdk::Drawable::colormap_impl ()
{
  GdkDrawableClass * orig =
    (GdkDrawableClass *) original_class ();

  if (orig->get_colormap)
    {
      GdkColormap *cmap;
      
      cmap = (* orig->get_colormap) (gdk_drawable ());

      return dynamic_cast<Colormap*>(Object::_private_wrap ((GObject*)cmap, false));
    }
  else
    return 0;
}

const Inti::Gdk::Visual &
Inti::Gdk::Drawable::visual_impl ()
{
  GdkDrawableClass * orig =
    (GdkDrawableClass *) original_class ();

  if (orig->get_visual)
    {
      GdkVisual * visual = (* orig->get_visual) (gdk_drawable ());
      return * Visual::wrap (visual);
    }
  else
    {
      g_error ("Didn't override Drawable::visual_impl(), you should do so if you plan to call Drawable::visual ()");
      return *Visual::system ();
    }
}


/////// Proxies

GdkGC *
Inti::Gdk::Drawable::create_gc_proxy (GdkDrawable *drawable,
                                      GdkGCValues *values,
                                      GdkGCValuesMask mask)
{
  Drawable * o =
    dynamic_cast<Drawable*> (Object::_private_wrap ((GObject*)drawable, false));

  if (values)
    {
      GC::Values vals;
      vals.fill_from_gdk_gc_values (values, mask);
      return o->create_gc_impl (vals)->gdk_gc ();
    }
  else
    {
      return o->create_gc_impl ()->gdk_gc ();
    }
}

void
Inti::Gdk::Drawable::draw_rectangle_proxy (GdkDrawable  *drawable,
                                           GdkGC *gc,
                                           gint filled,
                                           gint x,
                                           gint y,
                                           gint width,
                                           gint height)
{
  Drawable * o =
    dynamic_cast<Drawable*> (Object::_private_wrap ((GObject*)drawable, false));
  GC * ogc =
    dynamic_cast<GC*> (Object::_private_wrap ((GObject*)gc, false));
  
  o->draw_rectangle_impl (ogc, filled, x, y, width, height);
}

void
Inti::Gdk::Drawable::draw_arc_proxy (GdkDrawable  *drawable,
                                     GdkGC *gc,
                                     gint filled,
                                     gint x,
                                     gint y,
                                     gint width,
                                     gint height,
                                     gint angle1,
                                     gint angle2)
{
  Drawable * o =
    dynamic_cast<Drawable*> (Object::_private_wrap ((GObject*)drawable, false));
  GC * ogc =
    dynamic_cast<GC*> (Object::_private_wrap ((GObject*)gc, false));

  o->draw_arc_impl (ogc, filled, x, y, width, height, angle1, angle2);
}

void
Inti::Gdk::Drawable::draw_polygon_proxy (GdkDrawable  *drawable,
                                         GdkGC *gc,
                                         gint filled,
                                         GdkPoint *points,
                                         gint npoints)
{
  Drawable * o =
    dynamic_cast<Drawable*> (Object::_private_wrap ((GObject*)drawable, false));
  GC * ogc =
    dynamic_cast<GC*> (Object::_private_wrap ((GObject*)gc, false));

  o->draw_polygon_impl (ogc, filled, (Point*)points, npoints);
}

void
Inti::Gdk::Drawable::draw_drawable_proxy (GdkDrawable *drawable,
                                          GdkGC *gc,
                                          GdkDrawable *src,
                                          gint xsrc,
                                          gint ysrc,
                                          gint xdest,
                                          gint ydest,
                                          gint width,
                                          gint height)
{
  Drawable * o =
    dynamic_cast<Drawable*> (Object::_private_wrap ((GObject*)drawable, false));
  GC * ogc =
    dynamic_cast<GC*> (Object::_private_wrap ((GObject*)gc, false));
  Drawable * osrc =
    dynamic_cast<Drawable*> (Object::_private_wrap ((GObject*)src, false));
  
  o->draw_drawable_impl (ogc, osrc, xsrc, ysrc, xdest, ydest, width, height);
}

void
Inti::Gdk::Drawable::draw_points_proxy (GdkDrawable *drawable,
                                        GdkGC *gc,
                                        GdkPoint *points,
                                        gint npoints)
{
  Drawable * o =
    dynamic_cast<Drawable*> (Object::_private_wrap ((GObject*)drawable, false));
  GC * ogc =
    dynamic_cast<GC*> (Object::_private_wrap ((GObject*)gc, false));

  o->draw_points_impl (ogc, (Point*) points, npoints);
}

void
Inti::Gdk::Drawable::draw_segments_proxy (GdkDrawable *drawable,
                                          GdkGC *gc,
                                          GdkSegment *segs,
                                          gint nsegs)
{
  Drawable * o =
    dynamic_cast<Drawable*> (Object::_private_wrap ((GObject*)drawable, false));
  GC * ogc =
    dynamic_cast<GC*> (Object::_private_wrap ((GObject*)gc, false));

  o->draw_segments_impl (ogc, (Segment*) segs, nsegs);
}

void
Inti::Gdk::Drawable::draw_lines_proxy (GdkDrawable *drawable,
                                       GdkGC *gc,
                                       GdkPoint *points,
                                       gint npoints)
{
  Drawable * o =
    dynamic_cast<Drawable*> (Object::_private_wrap ((GObject*)drawable, false));
  GC * ogc =
    dynamic_cast<GC*> (Object::_private_wrap ((GObject*)gc, false));

  o->draw_lines_impl (ogc, (Point*) points, npoints);
}

void
Inti::Gdk::Drawable::draw_image_proxy (GdkDrawable *drawable,
                                       GdkGC *gc,
                                       GdkImage *image,
                                       gint xsrc,
                                       gint ysrc,
                                       gint xdest,
                                       gint ydest,
                                       gint width,
                                       gint height)
{
  Drawable * o =
    dynamic_cast<Drawable*> (Object::_private_wrap ((GObject*)drawable, false));
  GC * ogc =
    dynamic_cast<GC*> (Object::_private_wrap ((GObject*)gc, false));

  Image * oimg =
    dynamic_cast<Image*> (Object::_private_wrap ((GObject*)image, false));
  
  o->draw_image_impl (ogc, oimg, xsrc, ysrc, xdest, ydest, width, height);
}

gint
Inti::Gdk::Drawable::get_depth_proxy (GdkDrawable *drawable)
{
  Drawable * o =
    dynamic_cast<Drawable*> (Object::_private_wrap ((GObject*)drawable, false));

  return o->depth_impl ();
}

void
Inti::Gdk::Drawable::get_size_proxy (GdkDrawable *drawable,
                                     gint *width,
                                     gint *height)
{
  Drawable * o =
    dynamic_cast<Drawable*> (Object::_private_wrap ((GObject*)drawable, false));

  o->get_size_impl (width, height);
}

void
Inti::Gdk::Drawable::set_colormap_proxy (GdkDrawable *drawable,
                                         GdkColormap *cmap)
{
  Drawable * o =
    dynamic_cast<Drawable*> (Object::_private_wrap ((GObject*)drawable, false));

  Colormap * ocmap =
    dynamic_cast<Colormap*> (Object::_private_wrap ((GObject*)cmap, false));
  
  o->set_colormap (ocmap);
}
      
GdkColormap*
Inti::Gdk::Drawable::get_colormap_proxy (GdkDrawable *drawable)
{
  Drawable * o =
    dynamic_cast<Drawable*> (Object::_private_wrap ((GObject*)drawable, false));

  Colormap * cmap = o->colormap_impl ();
  return cmap->gdk_colormap ();
}

GdkVisual*
Inti::Gdk::Drawable::get_visual_proxy (GdkDrawable *drawable)
{
  Drawable * o =
    dynamic_cast<Drawable*> (Object::_private_wrap ((GObject*)drawable, false));

  const Visual & visual (o->visual_impl ());

  return visual.gdk_visual ();  
}

/////////// Everything below here is machine-generated
