// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
// Example/test hello world program
/*
  The following license applies to this example code, but not to
  the Inti library itself:
  
    Permission is hereby granted, free of charge, to any person obtaining
    a copy of this software and associated documentation files (the
    "Software"), to deal in the Software without restriction, including
    without limitation the rights to use, copy, modify, merge, publish,
    distribute, sublicense, and/or sell copies of the Software, and to
    permit persons to whom the Software is furnished to do so, subject to
    the following conditions:

    The above copyright notice and this permission notice shall be
    included in all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
    NONINFRINGEMENT.  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
    DISTRIBUTOR OF THE SOFTWARE BE LIABLE FOR ANY CLAIM, DAMAGES OR
    OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
    OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
    OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include <inti/gtk/window.h>
#include <inti/gtk/button.h>
#include <inti/ptr.h>
#include <inti/main.h>
#include <iostream>

using namespace Inti;

class HelloWindow : public Gtk::Window
{
public:
  HelloWindow ();
  
protected:
  ~HelloWindow ();
  
  virtual void on_destroy ();

private:
  ptr<Gtk::Button> button_;
  
  void on_button_clicked ();

};

HelloWindow::HelloWindow ()
  : button_(new Gtk::Button ("Hello, World!"))
{
  add (button_);
  button_->show ();

  button_->sig_clicked ().connect (this,
                                   &HelloWindow::on_button_clicked);
}

HelloWindow::~HelloWindow ()
{

}

void
HelloWindow::on_destroy ()
{
  if (Main::primary ())
    Main::primary ()->quit ();
}

void
HelloWindow::on_button_clicked ()
{
  cout << "Button was clicked!" << endl;
  destroy ();
}

int
main (int argc, char **argv)
{
  using namespace Gtk;
  
  init (&argc, &argv);

  HelloWindow * hw = new HelloWindow;

  hw->set_title ("Hello World");
  
  hw->show ();

  Main::Loop loop;
  
  loop.run ();
  
  return 0;
}
