/* Ask the server what type of submitter someone is.
   Copyright (C) 1994, 1995 Free Software Foundation, Inc.
   Contributed by Brendan Kehoe (brendan@cygnus.com).

This file is part of GNU GNATS.

GNU GNATS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU GNATS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU GNATS; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111, USA.  */

#include "config.h"
#include "gnats.h"
#include "query.h"
#include "db_conf.h"

/* If 1, we're running the daemon.  */
int is_daemon = 0;

/* If 1, we're running a network client.  */
int is_client = 1;

/* The hostname and port of the GNATS server.  */
char *host_name;
int port;

/* The name this program was run with.  */
char *program_name;

/* If 1, send information as we make the query.  */
int debug = 0;

struct option long_options[] =
{
  {"host", 1, NULL, 'H'},
  {"user", 1, NULL, 'v'},
  {"passwd", 1, NULL, 'w'},
  {"directory", 1, NULL, 'd'},
  {"debug", 0, NULL, 'D'},
  {"help", 0, NULL, 'h'},
  {"version", 0, NULL, 'V'},
  {NULL, 0, NULL, 0},
};

void usage (), version ();

int
main (argc, argv)
     int argc;
     char **argv;
{
  int optc;
  char *user = "anonymous", *passwd = "guest";

  program_name = basename (argv[0]);
  if (argc == 1)
    usage (1);

  host_name = gnats_server;

  while ((optc = getopt_long (argc, argv, "VDhd:H:v:w:",
			      long_options, (int *) 0)) != EOF)
    {
      switch (optc)
	{
	case 'd':
	  gnats_root = optarg;
	  break;

	case 'H':
	  host_name = optarg;
	  break;

        case 'v':
          user = optarg;
          break;

        case 'w':
          passwd = optarg;
          break;

	case 'V':
	  version ();
	  exit (0);
	  break;

	case 'D':
	  debug = 1;
	  break;

	case 'h':
	  usage (0);

	default:
	  usage (1);
	}
    }

  if (! argv[optind])
    usage ();

  client_init_gnats (user, passwd);

  if (debug)
    fprintf (stderr, "%s: writing `TYPE %s'\n", program_name,
	     argv[optind]);
  fprintf (serv_write, "TYPE %s\r\n", argv[optind]);
  get_reply ();

  client_exit ();

  exit (0);
}

void
usage (status)
     int status;
{
  FILE *out = stderr;
  fprintf (out, "\
Usage: %s [--version] [--host=host] [-H host]\n\
          [--directory=gnats_root] [-d gnats_root]\n\
          [--user=userid] [--passwd=password] submitter\n", program_name);
  exit (status);
}

void
version ()
{
  printf ("sub-type %s\n", version_string);
}

