/* Return the address for a person in the GNATS responsible file.
   Copyright (C) 1994, 1995 Free Software Foundation, Inc.
   Contributed by Rick Macdonald (rickm@vsl.com).

This file is part of GNU GNATS.

GNU GNATS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU GNATS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU GNATS; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111, USA.  */

#include "config.h"
#include "gnats.h"
#include "query.h"

#define BY_PR		1
#define BY_CATEGORY	2
#define BY_SUBMITTER	3

/* If 1, we're running the daemon.  */
int is_daemon = 0;

/* If 1, we're running a network client.  */
int is_client = 1;

/* The name this program was run with.  */
char *program_name;

/* The name and port of the GNATS server.  */
char *host_name;
int port = -1;

/* If 1, send information as we make the query.  */
int debug = 0;

struct option long_options[] =
{
  {"debug", 0, NULL, 'D'},
  {"directory", 1, NULL, 'd'},
  {"host", 1, NULL, 'H'},
  {"port", 1, NULL, 'P'},
  {"user", 1, NULL, 'v'},
  {"passwd", 1, NULL, 'w'},
  {"help", 0, NULL, 'h'},
  {"version", 0, NULL, 'V'},
  {"full", 0, NULL, 'F'},
  {"strict", 0, NULL, 's'},
  {NULL, 0, NULL, 0},
};

void usage (), version ();


int
main (argc, argv)
     int argc;
     char **argv;
{
  Responsible *r;
  int optc;
  int full = 0, strict = 0;
  char *address, *name, *fname = (char *)NULL;
  char *user = "anonymous", *passwd = "guest";
  
  program_name = basename (argv[0]);
  host_name = gnats_server;
  
  if (argc == 1)
    usage (1);

  host_name = gnats_server;

  while ((optc = getopt_long (argc, argv, "DVhFsd:P:H:v:w:",
			      long_options, (int *) 0)) != EOF)
    {
      switch (optc)
	{
	case 'd':
	  gnats_root = optarg;
	  break;
 
        case 'F':
	  full = 1;
          break;

        case 's':
	  strict = 1;
	  break;

	case 'H':
	  host_name = optarg;
	  break;

	case 'P':
	  port = atoi (optarg);
	  break;

        case 'v':
          user = optarg;
          break;

        case 'w':
          passwd = optarg;
          break;

	case 'V':
	  version ();
	  exit (0);
	  break;

	case 'D':
	  debug = 1;
	  break;

	case 'h':
	  usage (0);

	default:
	  usage (1);
	}
    }

  if (optind != argc - 1)
    {
      usage ();
      return 3;
    }

  name = argv[optind];
  if (*name == '\0')
    {
      fprintf (stderr, "%s: name must be non-null\n", program_name);
      return 3;
    }

  client_init_gnats (user, passwd);

  if (debug)
    fprintf (stderr, "%s: writing `MLRS %d %d %s'\n", program_name, full, strict, name);
  fprintf (serv_write, "MLRS %d %d %s\r\n", full, strict, name);
  get_reply ();

  client_exit ();

  exit (0);
}

void
usage (status)
     int status;
{
  fprintf (stderr, "\
Usage: %s [-F|--full] [-s|--strict] [-V|--version] [-h|--help] [-D|--debug]\n\
                [-d|--directory=dbalias] [-H|--host=host] [-P|--port=port]\n\
                [-v|--userid=userid] [-w|--password=passwd] name\n",
        program_name);
  exit (status);
}

void
version ()
{
  printf ("npr-addr %s\n", version_string);
}
