'\"
'\" Copyright (c) 1993 The Regents of the University of California.
'\" Copyright (c) 1994 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" @(#) while.n 1.2 94/12/17 16:19:14
'\" 
.so man.macros
.HS while tcl
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
while \- Execute script repeatedly as long as a condition is met
.SH SYNOPSIS
\fBwhile \fItest body
.BE

.SH DESCRIPTION
.PP
The \fIwhile\fR command evaluates \fItest\fR as an expression
(in the same way that \fBexpr\fR evaluates its argument).
The value of the expression must a proper boolean
value; if it is a true value
then \fIbody\fR is executed by passing it to the Tcl interpreter.
Once \fIbody\fR has been executed then \fItest\fR is evaluated
again, and the process repeats until eventually \fItest\fR
evaluates to a false boolean value.  \fBContinue\fR
commands may be executed inside \fIbody\fR to terminate the current
iteration of the loop, and \fBbreak\fR
commands may be executed inside \fIbody\fR to cause immediate
termination of the \fBwhile\fR command.  The \fBwhile\fR command
always returns an empty string.

.SH KEYWORDS
boolean value, loop, test, while
