/*                    Caveat Emptor

   This file uses many undocumented functions and interfaces to
   support garbage collection of multithread programs. It is next
   to impossible to collect MT programs without resorting to these
   tricks.

   You are not expected to use any of these in your code. HP is
   under no obligation to retain, maintain or enhance these interfaces
   in future releases.

   As a matter of fact the division that owns these interfaces is not
   under any obligation to maintain these interfaces even for us : the
   HP debugger team. They can surprise us by pulling the plug any
   time ....

   So if you are curious about using these in other situations,
   do what I do, don't.
   
*/

#define _PSTAT64

#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>
#include <dl.h>
#include <assert.h>
#include <sys/shm.h>
#include <string.h>
#include <strings.h>
#include <unistd.h>
#include <alloca.h>
#include <time.h>
#include <dl.h>
#include <dlfcn.h>
#include <limits.h>
#include <sys/mman.h>
#include <fcntl.h>
#ifndef HPUX_1020
#define _KERNEL_THREADS
#include <threads/rec_mutex.h>
#endif
#include "defs.h"
#include "rtc.h"

#include <sys/pstat.h>

#define NEW_DETERMINE_STACK_BASE 1
#include <sys/pstat.h>
#include <sys/time.h>

#ifdef HP_IA64
#include "machine/sys/inline.h" /* _Asm_get_rp */
#endif

/* This is a bug in the include files.  Should be defined by
 * string.h/strings.h
 */

char *strtok_r(char *s1, const char *s2, char **last);

int __rtc_version_major = 1;
int __rtc_version_minor = 0;

#define HEAP_INFO 1
#define BOUNDS_INFO 2

int __rtc_bounds_or_heap = HEAP_INFO;


int __rtc_scramble_blocks = 0;
int __rtc_check_bounds = 0;
int __rtc_check_leaks = 0;
int __rtc_check_heap = 0;

int __rtc_check_free = 0;

int __rtc_frame_count = DEFAULT_FRAME_COUNT;

int __rtc_min_leak_size = DEFAULT_MIN_LEAK_SIZE;
void * __rtc_watch_address = 0;
int __rtc_big_block_size = 0;
int __rtc_heap_growth_size = 0;

static char heap_info_filename[100];

/* interval related defs */
static void heap_interval_check();
static int  write_interval_data();

struct {
struct timespec start;
struct timespec end;
} interval;

int __rtc_check_heap_interval = 0;
int __rtc_check_heap_repeat = DEFAULT_REPEAT_CNT;
int __rtc_check_heap_reset = 0;

static int repeat_count = 0;
static int interval_in_progress = 0;
static char heap_interval_filename[100];
static char heap_interval_idxfile[100];

/* Defined in target specific files. */
extern int get_frame_pc_list (void **);
#if !defined(HP_IA64) && !defined(GDB_TARGET_IS_HPPA_20W)
extern void libcl_stuff ();
#endif

/* When the program is multithreaded, we need to scan the registers
   associated with all the threads. We will allocate a buffer to 
   hold the register values here. GDB is responsible for copying the
   registers over.
*/

char * __rtc_register_file; /* To be set by gdb. */
static int register_file_size; 

/* Baskar, When heap-debugging enabled & rtc-not-started/initialized, gdb
couldn't entertain command-line calls to memory allocators like malloc,
since U_get_previous_frame_x fails on dummy-frame pushed by gdb (It expects
unwind descriptor). So use libc-malloc instead of librtc's. */

int command_line_call = 0;

#if !defined(HP_IA64) && !defined(GDB_TARGET_IS_HPPA_20W)
/* JAGaf15615: Enable heap-analysis on attach,from the time the process starts in PA-32*/
void __rtc_init_leaks();
void __rtc__exit(int);
void __rtc__start (int , char **, char ** ); /*JAGaf37695*/ 
#endif


/* Baskar, JAGae68100 */
#ifndef HPUX_1020
__thread_once_t init_once = __THREAD_ONCE_INIT;
#endif

/* How big the register spill area be per thread ?
   defined by RTC_REGISTER_BUFFER_SIZE in target dep files. */

#ifdef REGISTER_STACK_ENGINE_FP
char *__rtc_RSE_file; /* To be set by gdb */
static int __rtc_RSE_file_size;
#define RSE_BUFFER_SIZE 16 /* for rse top/bottom. */
#endif /* REGISTER_STACK_ENGINE_FP */

#define OBTAIN_BACKDOOR_ENTRY() if (!libc_malloc) obtain_backdoor_entry ()
#define MONITOR_HEAP_GROWTH __rtc_heap_growth_size
#define HEAP_GROWTH_THRESHOLD __rtc_heap_growth_size

/* If __rtc_check_bounds is set to true, then we would allocate extra
   bytes at both ends of the block and fill it up with a known pattern.
   We could then check to verify if the pattern is intact when the
   block is being freed. As things stand now, this only tells there is
   a black sheep in the herd and doesn't say which one. Expect some
   aid in future in this space.
*/
    
#define PADDED_BLOCK     1
#define NON_PADDED_BLOCK 0

#define MAGIC_COOKIE  0xfeedface

#define FOOTER_SIZE  1

#if defined(GDB_TARGET_IS_HPPA_20W) || defined(HP_IA64)
#define HEADER_SIZE 16
#else 
#define HEADER_SIZE 8
#endif


#define HEAP_BLOCK 1
#define NON_HEAP_BLOCK 0
/*
 * Identifies recorded heap blocks which were allocated even
 * before the first malloc was called by find_mmaps_in_startup
 */
#define NON_HEAP_PREINIT_BLOCK 2

extern rtc_chunk_info * __rtc_leaks_info ();
extern int __rtc_heap_info ();
extern int __rtc_heap_interval_info ();

rtc_chunk_info * (*leaks_info_plabel) () = __rtc_leaks_info;
int (*heap_info_plabel) () = __rtc_heap_info;
int (*interval_info_plabel) () = __rtc_heap_interval_info;

/* Local cache of dld list. We cannot ask for this while GC is in
   progress. We will update this list once at start up and afterwards
   when a library gets loaded or unloaded. GDB will notify us when our
   list is invalid by setting the variable `shlib_info_invalid'.
*/
   
#define SHLIB_INFO_INIT_SIZE 1024
static struct shlib_info {
    void * data_start;
    void * data_end;
    void * text_start; /* JAGae73849: Added to skip text mmaps    */
    void * text_end;   /*  found by find_mmaps_in_startup         */
} * shlib_info = 0;
static int shlib_info_count = 0;
static int shlib_info_size = SHLIB_INFO_INIT_SIZE;
/* JAGaf15615: Turn off Optimization for shlib_info_invalid wherever it 
 * is used. */
#pragma OPTIMIZE OFF
volatile int shlib_info_invalid = 0;  /* Unless gdb instructs otherwise ... */
#pragma OPTIMIZE ON
/* srikanth, 991001, Run Time Checking (RTC) module for the Wildebeest.
   As of Dec 99, this module allows gdb to track and report memory
   leaks, double frees, bad frees, bad realloc(), heap overflows and
   underflows. In future this would be extended so that uninitialized
   memory reads and unallocated memory accesses would be trapped too.

   Here is a rough overview of how things work :

   o The user has to first of all link his or her application against
     librtc (the shared library version of this file.) The program
     must also be linked against the shared version of libc.
     Now, users need not link explicity against librtc. gdb sets the
     LD_PRELOAD environment variable which instructs the linker to
     load this library.

   o The user then should invoke gdb as `gdb -leaks a.out'.
     Alternatively, a user may enable RTC mode by using the 
     `set heap-check' command. In the latter case, the command must be
     issued before the inferior starts running (the corrolary is that
     if you attach to a running process, you cannot ask for a leak
     report.)
   
   o The wrappers in this module use a backdoor mechanism to fall back
     on the C standard library for the actual implementation of the
     allocation or deallocation. In addition these routines update
     suitable data structures to capture allocation specific
     information. Since librtc is the first library that is loaded
     all the calls to allocation/deallocation routines of libc will
     now go directly to the wrappers in this module.

   o When the user wants a leak report, he or she uses the new gdb
     command `info leaks'. In response to this command, the debugger
     calls the function __rtc_leaks_info() exported by this library in
     the context of the debuggee. This routine scans all the program
     context and returns a leak list.

   o The debugger walks this list, downloads the data and presents
     it to the user.

   o When the user wants a heap report,  he or she uses the new gdb
     command `info heap'. In response to this command, the debugger
     calls the functions __rtc_heap_info() exported by this library 
     This routine writes the heap repost in /tmp/__heap_info file.

   Thus most of the work gets done in the a.out and gdb's role is
   limited to supervision.

   For more details, see http://cllweb.cup.hp.com/~srikanth/arm.html
*/

/* The following pragmas are to guarantee that these functions can
   be called directly from other load modules, without having to go
   through the export stubs. This is done to reduce the overhead of
   the snoop on the heap. This is applicable only to PA32 and is a
   NOP for PA64 and IA64 as these runtimes do not use export stubs.

   We need to bypass the export stub for debugger callable functions
   too (leaks_info & heap_info.) Currently on PA32, when we make a
   command line call to a function from a shared library, we actually
   make two calls. The first one is to locate the external plabel
   via shl_findsym. When garbage collecting a threaded program, this is
   a dangerous thing to do, as this call acquires a mutex and a dead
   lock would result if some other thread is holding the mutex.
*/

#pragma HP_NO_RELOCATION __rtc_malloc, __rtc_calloc, __rtc_valloc
#pragma HP_NO_RELOCATION __rtc_realloc, __rtc_free, __rtc_mmap, __rtc_munmap
#pragma HP_NO_RELOCATION __rtc_sbrk, __rtc_brk, __rtc_shmat, __rtc_shmdt
#pragma HP_NO_RELOCATION __rtc_mprotect
#pragma HP_NO_RELOCATION __rtc_shl_unload, __rtc_dlclose
#pragma HP_NO_RELOCATION __rtc_leaks_info
#pragma HP_NO_RELOCATION __rtc_heap_info
#pragma HP_NO_RELOCATION __rtc_heap_interval_info


#pragma HP_LONG_RETURN __rtc_malloc, __rtc_calloc, __rtc_valloc
#pragma HP_LONG_RETURN __rtc_realloc,__rtc_free, __rtc_mmap, __rtc_munmap
#pragma HP_LONG_RETURN __rtc_sbrk, __rtc_brk, __rtc_shmat, __rtc_shmdt
#pragma HP_LONG_RETURN __rtc_mprotect
#pragma HP_LONG_RETURN __rtc_shl_unload, __rtc_dlclose
#pragma HP_LONG_RETURN __rtc_leaks_info
#pragma HP_LONG_RETURN __rtc_heap_info
#pragma HP_LONG_RETURN __rtc_heap_interval_info

#define DEBUG(x)

#ifdef GDB_TARGET_IS_HPPA
/* Data structures for stack unwind mechanism */

typedef struct cframe_info {
  unsigned long cur_frsize; /* frame size */
  unsigned long cursp; /* stack pointer */
#ifndef GDB_TARGET_IS_HPPA_20W
  unsigned long currls; /* PC-space of CALLING routine */
#endif
  unsigned long currlo; /* PC-offset of CALLING routine */
  unsigned long curdp; /* data pointer */
  unsigned long toprp; /* return pointer */
  unsigned long topmrp; /* millicode return pointer */
#ifndef GDB_TARGET_IS_HPPA_20W
  unsigned long topsr0; /* sr0 */
  unsigned long topsr4; /* sr4 */
#endif
  unsigned long r3; /* gr3 */
#ifndef GDB_TARGET_IS_HPPA_20W
  unsigned long cur_r19; /* linkage-table pointer (gr19) - for PIC code */
#endif
  unsigned long r4; /* gr4 */ /* Added for alloca unwind interface */
#ifdef GDB_TARGET_IS_HPPA_20W
  unsigned long reserved[4];
#else
  unsigned long reserved[8];  /* Added for alloca unwind interface */
#endif
} cframe_info;


typedef struct pframe_info {
  unsigned long prev_frsize; /* frame size */
  unsigned long prevsp; /* stack pointer */
#ifndef GDB_TARGET_IS_HPPA_20W
  unsigned long prevrls; /* PC-space of CALLING routine */
#endif
  unsigned long prevrlo; /* PC-offset of CALLING routine */
  unsigned long prevdp; /* data pointer */
  unsigned int udescr0; /* first half of unwind descriptor */
  unsigned int udescr1; /* second half of unwind descriptor */
  unsigned int ustart; /* start of the unwind region */
  unsigned int uend; /* end of the unwind region */
  unsigned long uw_index; /* index into the unwind table */
#ifndef GDB_TARGET_IS_HPPA_20W
  unsigned long prev_r19; /* linkage-table pointer (gr19) - for PIC code */
#endif
  unsigned long PFIinitR3;  /* Added for alloca unwind interface */
  unsigned long PFIinitR4;  /* Added for alloca unwind interface */
#ifdef GDB_TARGET_IS_HPPA_20W
  unsigned long reserved[4];
#else 
  unsigned long reserved[8];
#endif
} pframe_info;

extern int U_get_previous_frame_x(struct cframe_info*, struct pframe_info*, int size);
extern void U_prep_frame_rec_for_unwind(struct cframe_info*);
extern void U_init_frame_record(struct cframe_info*);
#endif /* GDB_TARGET_IS_HPPA */


#define RETURN(val)  do { \
                        inside_librtc = 0; \
                        return (val); \
                      } while (0)

#define CHUNK_INFO_LOT_SIZE 4096

#define PAGE_FROM_POINTER(pointer) \
           ((((unsigned long) (pointer)) & 0xfffffffful) >> 12)


/* The RTC module will use these function pointers to reach into
   the standard C library mallocator. These are initialized suitably
   by obtain_backdoor_entry().
*/

/* JAGaf15615 */
#if !defined(HP_IA64) && !defined(GDB_TARGET_IS_HPPA_20W)
static void (*libc__start)  (int argc, char **argv, char **envp); /*JAGaf37695*/
static void (*libc__exit) (int);
#endif

void * (*libc_malloc)  (size_t size);
static void   (*libc_free)    (void * pointer);
static void * (*libc_calloc)  (size_t nelem, size_t size);
static void * (*libc_realloc) (void *pointer, size_t size);
static void * (*libc_valloc)  (size_t size);

static void * (*libc_mmap)  (void *, size_t, int, int, int, off_t);
static int (*libc_munmap) (void *, size_t);
static int (*libc_mprotect)  (void *addr, size_t len, int prot);
static int (*libdld_shl_unload) (shl_t handle);
static int (*libdld_dlclose) (void * handle);

static void * (*libc_sbrk) (int);
static int  (*libc_brk) (char *);

static void * (*libc_shmat) (int, void *, int);
static int (*libc_shmdt) (void *);

#ifdef GDB_TARGET_IS_HPPA
/* On PA32, we end up triggering a nasty bug in libcl that causes the
   process stack to grow arbitrarily. (Search for probe in this file
   for a description of the problem.) As a result we need to intercept
   and sanitize a few calls to libcl unwind routines. Under the
   LD_PRELOAD mechanism we cannot call the libcl functions by name as
   the calls would end up right within this module leading to infinite
   recursion. So we need to materialize pointers using shl_findsym.
*/
typedef struct unwind_info {
    void * unw_start;
    void * unw_end;
} unwind_info;

typedef struct rtable
{
  void * start;
  void * end;
} rtable;

static void * (*libcl_U_get_shLib_text_addr) (char *);
static unwind_info (*libcl_U_get_shLib_unw_tbl) (char *);
static rtable (*libcl_U_get_shLib_recv_tbl) (char *);
#endif

static void (*libc_exit) (int);
static FILE * log_file;

static char * heap_base = 0;

static void rtc_record_malloc (char *, size_t, int, int);

/* Under the LD_PRELOAD mechanism we get the very first call to malloc
   and free. This is a little inconvenient as libc and libpthread are
   not initialized yet and we are witnessing the birth of the process
   from too close quarters. Various calls/operations fail since libc
   and lipthread have not been initialized. As a workaround we will use
   this flag to decide whether we should truly intercept calls or simply
   deflect them to libc. This flag will be cleared by gdb after the
   libraries have been loaded and threads subsystem has been initialized.
   (When program runs upto _start on PA32 and main on PA64/IA64.
*/
int __pthreads_not_ready = 1; /* will be cleared by gdb */

char * stack_base = 0;
static char * stack_end = 0;

static char * real_heap_base;

int rtc_started = 0;
int rtc_disabled = 0;

static long page_size;
static long total_pages;

/* In order to quickly locate the chunk_info associated with an
   address, we scatter the chunk_infos into a hash table based
   on the page number of the block. There would be one hash table
   entry for each page in the program's address space and that 
   entry would point to a linked list of chunk_infos for all 
   blocks from the same page.

   The hash table is allocated assuming a page size of 4096 bytes
   and a total addressible space of 4 GB. Thus there would be
   1 million slots in it. For PA64, page i from every 4 GB segment
   would get mapped to the same slot.
*/
static rtc_chunk_info ** chunks_in_page;

/* In the previous version, a fixed number of stack frames (PC values)
   were collected and stored in place within the rtc_chunk_info.
   This is highly wasteful of space, as there could be many tens of
   thousands of allocations from a given place. Now we factor out the
   stack trace and store a unique copy for each unique call stack.

   This is accomplished as follows : The `stack_trace_hash_table'
   points to STACK_TRACE_HASH_SLOTS number of (initially empty)
   link lists. Once a new stack trace is collected, we apply a
   hash function to decide which of the linked list the current stack 
   trace should belong in and add it if it already not there. Also used
   are a couple of buffers for storing the pc array and such much.
*/

#define STACK_TRACE_HASH_SLOTS 0x10000

typedef struct stack_trace_info {
    void ** pc;
    struct stack_trace_info * next;
} stack_trace_hash_entry;

static stack_trace_hash_entry * stack_trace_hash_table [STACK_TRACE_HASH_SLOTS];

#define STACK_TRACE_LOT_SIZE 1024
static void ** stack_trace_buffer; /* To hold the pc lists. */
static struct stack_trace_info * stack_trace_info_buffer;
/* We allocate STACK_TRACE_LOT_SIZE of stack_trace_info each time
   and use from this pool when ever we want to get a new stack_trace_info
   allocated. __rtc_stack_trace_count keeps track of how many are available
   in the allocated lot. */
int __rtc_stack_trace_count = 0;

/* We want to record allocation attempts made by the program.
   Sometimes, a single request from the program could result 
   in a cascade of requests internally. (realloc could call
   malloc and free for example.) We want to ignore these internal
   allocations. The boolean `inside_librtc' tracks whether
   a request originated from the application. The first call is
   always from the application.
*/  

#ifdef HPUX_1020
#define __thread
#endif

/* We don't support threaded program's in batch mode. So the variables
   `inside_librtc' and `old_cancel_state' need not be thread private.
   As a matter of fact, if they are thread private, there is the
   possibility that the first call to malloc may happen before the
   thread subsystem is initialized. In this case, CR27 will have
   a bogus value and references to these variables will generate a
   segfault  -- srikanth, 000328
*/
   
#ifdef RTC_BATCH_MODE
#define __thread
#endif

__thread int inside_librtc;
__thread int old_cancel_state;


/* Pointer to head of a linked list of free chunk_infos. This is
   to allow for quick recycling.
 */
static rtc_chunk_info * free_chunk_info = 0;

static int scanned_this_time = 0;

/* Batch RTC related changes */
#define MAX_RTC_FILES 100
enum {
    RTC_CWD,		/* idx for current working dir */
    RTC_CONFIG_FILE,    /* idx for configuration file rtcconfig */
    RTC_START_TIME,     /* idx for keeping start time for batch RTC */
    RTC_FILE,           /* idx for list of file names to be traced */
    RTC_OUTPUT_DIR,     /* idx for output dir  */
    RTC_LAST            /* last element of enum struct */
};
    
static int file_included = 0;  /* set if current executable is being traced */

char *rtcenv[RTC_LAST + 1];    /* keeps all configs and their values */
char *rtcfiles[MAX_RTC_FILES]; /* keeps all of interest */

static void librtc_callback(unsigned int, struct dld_hook_param *);
static int is_file_included(char *);
static int init_config(char *);
static int process_config();
static int print_batch_info();

/* malloc  null-check related changes */
#define DEFAULT_NULL_CHECK_RANDOM_RANGE  100
#define DEFAULT_NULL_CHECK_SEED_VALUE    5 
#define NULL_CHECK_ASSERT()   (( __rtc_null_check_count >= 0 \
			       && __rtc_null_check_size == 0) \
                            || (__rtc_null_check_count == -1 \
                               && __rtc_null_check_size > 0))
#define NULL_CHECK_RANDOM()   (__rtc_null_check_count == 0)
#define NULL_CHECK_ENABLED()  (__rtc_null_check_count >= 0 \
                            || __rtc_null_check_size > 0)
#define NULL_CHECK_EXCEEDED() ((current_null_check_size > \
                              __rtc_null_check_size) \
                            || (current_null_check_count > \
                                __rtc_null_check_count))
#define RESET_NULL_CHECK_VARS() {\
                                    current_null_check_count = -1;\
				    current_null_check_size = -1;\
                                }
/* -1 if not using null check; 0 if using random */
int __rtc_null_check_count = -1; 

/* specified in bytes; -1 if not using null_check_size */
int __rtc_null_check_size = -1;  

int __rtc_catch_nomem = 0;
int __rtc_null_check_random_range = DEFAULT_NULL_CHECK_RANDOM_RANGE;
int __rtc_null_check_seed_value = DEFAULT_NULL_CHECK_SEED_VALUE;
static int current_null_check_count = -1;
static int current_null_check_size = -1;

void
_rtc_library_initializer ()
{
  /* The user needs to define BATCH_RTC to switch batch rtc on/off */
   if (getenv("BATCH_RTC") == NULL) {
#if defined(GDB_TARGET_IS_HPPA_20W) || defined(HP_IA64)
     if (dlhook(DL_LOAD_POST_INIT, librtc_callback) != 0)
       perror("librtc dlhook initialization failed"); /* no RTC info */
#endif
     return;
   }

#if defined(GDB_TARGET_IS_HPPA_20W) || defined(HP_IA64)
  if (dlhook(DL_LOAD_POST_INIT | DL_UNLOAD_POST_FINI, librtc_callback) != 0)
    perror("librtc dlhook initialization failed"); /* no RTC info */
#endif

  return;
}

/* Free up all resources and shutdown the runtime checking system. The
   wrapper routines will continue to get called as the PLT entries 
   stand patched, but they will simply deflect all action elsewhere.
*/
   
static int 
disable_rtc ()
{
  rtc_disabled = 1;

  /* Resources will be freed in version 2.0 of RTC :-) */

  return 0;
}

/* When the program is multithreaded, we need to make sure that
   the different threads don't step on each others toes in the
   process of updating the chunk_info data structures. We employ
   a mutex for this. While we hold the mutex, we cannot allow the
   thread to be cancelled. So we will disable cancellation
   temporarily.
*/

#ifdef HPUX_1020
#define mutex_lock(x)
#define mutex_trylock(x) 0
#define mutex_tryunlock(x)
#define mutex_unlock(x)
#define __mutex_lock(x)
#define __mutex_unlock(x)
#define __mutex_trylock(x)
#define __rec_mutex_init(x)
#define __thread_atfork(x,y,z)
#define __ismt 0
#else

REC_MUTEX mutex, unmap_mutex;

#define mutex_trylock(x) __mutex_trylock(x)
#define mutex_tryunlock(x) __mutex_unlock(x)

static void
mutex_lock (REC_MUTEX * mutex)
{
  __thread_setcancelstate (__THREAD_CANCEL_DISABLE, &old_cancel_state);
  __mutex_lock (mutex);
}

static void
mutex_unlock (REC_MUTEX * mutex)
{
  int bogus;
  __mutex_unlock (mutex);
  __thread_setcancelstate (old_cancel_state, &bogus);
}

/* pre-fork handler in the about to deliver parent */

static void
do_a_down ()
{
    __mutex_lock (&mutex);
}

/* post-fork handler for the whole family */

static void
do_an_up ()
{
  __mutex_unlock (&mutex);
}

#endif



/* __rtc_event() : When the leak detector module finds something amiss,
   it calls this routine. The debugger is presumed to have a breakpoint
   here. Errors could be "internal" errors such as out of memory, 
   failure to find the stack, or some other assertion failure. Or it 
   could be a program error such as a bad free, bad realloc etc.
   The pointer parameter is applicable only in a few cases based on
   the event code.

   When running under the debugger, the error reporting will be
   undertaken by GDB and there is little that needs to be done here.
*/

extern void
__rtc_event (enum rtc_event ecode, void * pointer, void *pclist, size_t size)
{
  switch (ecode)
    {
    case RTC_NO_MEMORY      :  /* May day, May day, May day ...  */
    case RTC_SBRK_NEGATIVE  :
    case RTC_STACK_MISSING  :
      disable_rtc ();
      break;
    case RTC_MALLOC_MISSING :
      exit (1);    /* impossible to proceed */
      break;
    default : 
      break;
  }
}
#pragma OPTIMIZE OFF
extern void
__rtc_nomem_event (enum rtc_event ecode, void * pointer)
{
  switch (ecode)
    {
    default : 
      break;
    }
}
#pragma OPTIMIZE ON

/* Put in the magic_cookie in the about to free memory. */
static void
scramble_block (unsigned int * pointer, size_t size)
{
    char * cp;
    int i;

    for (i = 0; size >= sizeof (int); i++, size -= sizeof (int))
      pointer[i] = MAGIC_COOKIE;

    cp = (char *) (pointer + i);
    i = 0;
    while (size > 0ul)
      {
        cp[i++] = 0xff;
        size--;
      }
}

#pragma OPTIMIZE OFF
/* Check if the header and footer of the memory block is what we 
   have put in. */
static void
check_bounds (int * pointer, size_t size, void *pclist)
{
  unsigned char * block;

  if (pointer[-1] != MAGIC_COOKIE || pointer[-2] != MAGIC_COOKIE)
    __rtc_event (RTC_BAD_HEADER, pointer, pclist, size);

  block = (unsigned char *) pointer;

  if (block[size] != (unsigned char) 0xff)
    __rtc_event (RTC_BAD_FOOTER, pointer, pclist, size);
}
#pragma OPTIMIZE ON

/* The trap and unwind facility in libcl.sl hides some of the
   routines in the PA32 incarnation. For reasons not obvious to
   me. Here is a local version donated by Dennis Handly.
*/

#ifdef NEW_DETERMINE_STACK_BASE
/* Two reasons to have this new function !!!

   1) U_get_previous_frame_x expects "save_sp" bit to be on in the unwind
      descriptor - to check whether the stack is unwound completely
 
      Since this bit is set only for "$START", and if we try to calculate 
      stack_base from a non main-thread, (inner-most frame will be
      __pthread_create_system) U_get_previous_frame_x fails.

   2) Even, if we ignore U_get_previous_frame_x failure,
      whatever the stack-base we calculate is that of the thread that made the
      first call to [de]alloctor - that might not be the actual stack-base of
      that process if that thread is a non main-thread.

   Hence it would be better to use pstat functions (pstat_getprocvm)
   to calculate stack-base. 
   Hacked from libcl.sl U_get_stack_base_n_length() !!!!
*/
static void * determine_stack_base ()
{
   struct pst_vm_status buf;
   int count = 0;
   int i = 0;
   long stk_base = 0;

   count = pstat_getprocvm (&buf, sizeof(buf), 0, i);
   while ( (count > 0) && (buf.pst_type != PS_STACK) ) 
     {
       count = pstat_getprocvm (&buf, sizeof(buf), 0, i);
       i++;
     }

   if (count > 0)
     return ((void *) (unsigned long) buf.pst_vaddr); 
   else
     {
       __rtc_event (RTC_STACK_MISSING, 0, 0, 0);
       return 0;
     }
}

#else  /* NEW_DETERMINE_STACK_BASE */

static void * determine_stack_base ()
{
  cframe_info curr_frame;
  pframe_info prev_frame;
  int error;

#ifndef HPUX_1020

  U_init_frame_record(&curr_frame);
  U_prep_frame_rec_for_unwind(&curr_frame);

#ifndef GDB_TARGET_IS_HPPA_20W

  curr_frame.topsr0 = 0;
  curr_frame.topsr4 = 0;

#endif

#else
  U_get_frame_info(&curr_frame);
#endif

  while (curr_frame.currlo)
    {
      error = U_get_previous_frame_x (&curr_frame,
                                      &prev_frame,
                                      sizeof(cframe_info));
      if (error)
        {
           __rtc_event (RTC_STACK_MISSING, 0, 0, 0);
           return 0;
	}
      U_copy_frame_info (&curr_frame, &prev_frame);
     }


  return (void *) ((curr_frame.cursp - curr_frame.cur_frsize) & ~3L);
}

#endif /* NEW_DETERMINE_STACK_BASE */


/* Get the pointers to the libc's alloctaion/deallocation routines. */
void
obtain_backdoor_entry (void)
{
  struct shl_descriptor *desc;

  /* Locate the C library's mallocator for our own use. It is quite
     likely the application does not use this mallocator but for the
     purposes of detecting leaks, it should not matter.
  */

  int index = 1;
  while (shl_get (index, &desc) != -1)
    {
      index++;

      if (strstr (desc->filename, "/libc."))
        {
/* JAGaf15615 */
#if !defined(HP_IA64) && !defined(GDB_TARGET_IS_HPPA_20W)

          if (!libc__start)
            shl_findsym (&desc -> handle, "_start", TYPE_PROCEDURE, 
                                                         &libc__start);
          if (!libc__exit)
            shl_findsym (&desc -> handle, "_exit", TYPE_PROCEDURE,
                                                          &libc__exit);
#endif      
          if (!libc_malloc)
            shl_findsym (&desc->handle, "malloc", TYPE_PROCEDURE, 
                                                        &libc_malloc);
          if (!libc_free)
            shl_findsym (&desc->handle, "free", TYPE_PROCEDURE, 
                                                        &libc_free);
          if (!libc_calloc)
            shl_findsym (&desc->handle, "calloc", TYPE_PROCEDURE, 
                                                        &libc_calloc);
          if (!libc_realloc)
            shl_findsym (&desc->handle, "realloc", TYPE_PROCEDURE,
                                                        &libc_realloc);
          if (!libc_valloc)
            shl_findsym (&desc->handle, "valloc", TYPE_PROCEDURE,
                                                        &libc_valloc);
          if (!libc_mmap)
            shl_findsym (&desc->handle, "mmap", TYPE_PROCEDURE,
                                                        &libc_mmap);
          if (!libc_munmap)
            shl_findsym (&desc->handle, "munmap", TYPE_PROCEDURE,
                                                        &libc_munmap);
          if (!libc_mprotect)
            shl_findsym (&desc->handle, "mprotect", TYPE_PROCEDURE,
                                                        &libc_mprotect);
          if (!libc_sbrk)
            shl_findsym (&desc->handle, "sbrk", TYPE_PROCEDURE,
                                                        &libc_sbrk);
          if (!libc_brk)
            shl_findsym (&desc->handle, "brk", TYPE_PROCEDURE,
                                                        &libc_brk);
          if (!libc_shmat)
            shl_findsym (&desc->handle, "shmat", TYPE_PROCEDURE,
                                                        &libc_shmat);
          if (!libc_shmdt)
            shl_findsym (&desc->handle, "shmdt", TYPE_PROCEDURE,
                                                        &libc_shmdt);

          if (!libc_exit)
            shl_findsym (&desc->handle, "exit", TYPE_PROCEDURE,
                                                        &libc_exit);

          /* Just to be sure this is not some junky library with
             the name libc, ping for an entry point. Surely if we
             saw a library with a definition of shmdt(), we have
             seen libc ! 
          */
          if (libc_shmdt)
            break;
        }
    }

  index = 1;
  while (shl_get(index, &desc) != -1)
    {
      index++;

      if (strstr(desc->filename, "/libdl.") || strstr(desc->filename,"/libdld."))
        {
          shl_findsym (&desc -> handle, "shl_unload",
                       TYPE_PROCEDURE, &libdld_shl_unload);
          shl_findsym (&desc -> handle, "dlclose",
                       TYPE_PROCEDURE, &libdld_dlclose);
          if (libdld_shl_unload)
            break;
        }
    }

/* JAGaf15615 */
#if !defined(HP_IA64) && !defined(GDB_TARGET_IS_HPPA_20W)
  /* Now lookup the libcl entry points of interest. This is done to
     avoid a nasty libcl/OS bug with probe instruction. Search for
     probe in hppa-rtc.c file for details. We do not need this on PA64/IA64.
  */
  libcl_stuff (); /* Defined in hppa-rtc.c */
#endif /* !HP_IA64 && !GDB_TARGET_IS_HPPA_20W */
}


/* Whenever we are asked to allocate a chunk, we will allocate a bunch
   of them (CHUNK_INFO_LOT_SIZE) and put the remaining in the free list.
   When we are asked to allocate the next time, we can just return from
   the free list. */

static rtc_chunk_info *
allocate_chunk_info (void)
{
  rtc_chunk_info * chunk;
  int i;

  if (free_chunk_info)
    { 
      chunk = free_chunk_info;
      free_chunk_info = free_chunk_info->next;
      return chunk; 
    }

  chunk = libc_calloc (CHUNK_INFO_LOT_SIZE, sizeof (rtc_chunk_info));

  if (!chunk)
    {
      __rtc_event (RTC_NO_MEMORY, 0, 0, 0);
      return 0;
    }
  
  /* Link them into a list ... */

  for (i=0; i < CHUNK_INFO_LOT_SIZE - 1; i++)
    chunk[i].next = &chunk[i+1];
  chunk[i].next = 0;
  free_chunk_info = chunk->next;
  return chunk;
}

/* Just add it to the free list. */
static void 
deallocate_chunk_info (rtc_chunk_info * c_i)
{
    c_i->next = free_chunk_info;
    free_chunk_info = c_i;
}

/* allocate STACK_TRACE_LOT_SIZE of stack_trace_buffer and 
   stack_trace_info_buffer. 
   stack_trace_buffer holds the lists of pc values seperated by 0
   between each list. list size is __rtc_frame_count. */
static void
allocate_stack_trace_buffers (void)
{
  /* The stack trace buffer is a permanent data structure. We can
     never free it as there could be many different pointers into
     it from several stack_trace_info structures. So it is alright
     if the initial pointer is sacrificed.
  */

  stack_trace_buffer = libc_calloc (STACK_TRACE_LOT_SIZE,
                                    (__rtc_frame_count + 1) *
                                       sizeof (void *));
  if (!stack_trace_buffer)
    {
      __rtc_event (RTC_NO_MEMORY, 0, 0, 0);
      return;
    } 

  /* allocate stack_trace_info_buffer */
  stack_trace_info_buffer = libc_calloc (STACK_TRACE_LOT_SIZE,
                                             sizeof (struct stack_trace_info));
  if (!stack_trace_info_buffer)
    {
      __rtc_event (RTC_NO_MEMORY, 0, 0, 0);
      return;
    } 
  __rtc_stack_trace_count = STACK_TRACE_LOT_SIZE;
}

/*
 * JAGae73849:	
 * This function records all mmmaps (PS_MMF) done by a process at the time
 * this function was called. The function is called in __rtc_initialize to
 * capture mmaps done by pthread library even before librtc gets initialized.
 */

static void
find_mmaps_in_startup ()
{
   long len = 0;
   int i = 0, count = 0;
   struct pst_static pst;
   struct pst_vm_status buf;

   if (pstat_getstatic(&pst, sizeof(pst), (size_t)1, 0) == -1)
     perror("pstat_getstatic");

   count = pstat_getprocvm (&buf, sizeof(buf), 0, i);

   while (count > 0) 
     {
       if (buf.pst_vaddr != NULL && buf.pst_type == PS_MMF)
         {
#if 0
           /* Following changes will be allowed once we get the
              kernel patch and is available for building librtc.
              At that point of time we should unifdef this piece 
              of code. Remove this comment. Once the patch is 
              available we need to make sure it works for PA and
              IA.
           */
           /* kernel does not give size correctly if there
              is hole in mmapped segment because of partial
              munmap earlier.
            */
           if (buf.pst_flags & PS_HOLES)
              continue; 
#endif
           /* pstat_getprocvm returns size in the native page size */
	   len = buf.pst_length * pst.page_size;

           rtc_record_malloc (((char *) (unsigned long) buf.pst_vaddr), len, 
	     NON_HEAP_PREINIT_BLOCK, NON_PADDED_BLOCK);
         }

       i++;
       count = pstat_getprocvm (&buf, sizeof(buf), 0, i);
     } /* while */
}

/* Baskar, JAGae68100
   One-Time initialization routine... called by rtc_initialize
*/
static void
__rtc_initialize (void)
{
  int i;
  struct shl_descriptor *shl_desc = 0;

  heap_base = (void *) libc_sbrk(0);

  /* Determine the real heap base; the one we captured above is the
     heap base now. But malloc calls from shared library initializers
     could have resulted in the adjustment of the break value. What
     was the real base of heap when the program started ?
  */
  shl_get (0, &shl_desc); 
  real_heap_base = (char *) shl_desc->dend;

  page_size = getpagesize ();
        
  total_pages = 0x00100000;
  chunks_in_page =  (rtc_chunk_info **)
                     libc_calloc (total_pages, sizeof (rtc_chunk_info *));
  if (!chunks_in_page)
    {
      __rtc_event (RTC_NO_MEMORY, 0, 0, 0);
      return;
    } 

  stack_base = determine_stack_base ();

  /* Create and initialize a mutex for regulating access to our
     data structures. We may be linked with a threaded program
     and if we are, there could be concurrent calls to malloc ()
     from the different threads. We don't want them to step on
     each other's toes ...
  */
  __rec_mutex_init (&mutex);
  __rec_mutex_init (&unmap_mutex);

  /* Install a fork handler : If a thread calls forks, in the
     child it will be the only thread. So if in the parent,
     some other thread had locked and held the mutex, then the
     mutex will be locked in the forked copy. However the thread
     that locked the mutex is not running in the child to unlock
     it, leading quickly to a deadlock! The fork handler
     mechanism allows the forking thread to obtain a lock on
     the mutex and unlock it in both the parent and the child.

       -- srikanth, 000222.
  */
  __thread_atfork (do_a_down, do_an_up, do_an_up);

  if (__ismt)
    {
      __rtc_register_file = libc_calloc (RTC_REGISTER_BUFFER_SIZE,
                                             RTC_MAX_THREADS);
      register_file_size = RTC_REGISTER_BUFFER_SIZE * RTC_MAX_THREADS;

#ifdef REGISTER_STACK_ENGINE_FP
      __rtc_RSE_file = libc_calloc (RTC_MAX_THREADS, RSE_BUFFER_SIZE);
      __rtc_RSE_file_size = RTC_MAX_THREADS * RSE_BUFFER_SIZE;
#endif /* REGISTER_STACK_ENGINE_FP */
    }
  else 
    { 
      __rtc_register_file = libc_calloc (RTC_REGISTER_BUFFER_SIZE, 1);
      register_file_size = RTC_REGISTER_BUFFER_SIZE;
#ifdef REGISTER_STACK_ENGINE_FP
      __rtc_RSE_file = libc_calloc (1, RSE_BUFFER_SIZE);
      __rtc_RSE_file_size = 1 * RSE_BUFFER_SIZE;
#endif /* REGISTER_STACK_ENGINE_FP */
    }

  if (!__rtc_register_file)
    {
      __rtc_event (RTC_NO_MEMORY, 0, 0, 0);
      return;
    }

  shlib_info = libc_calloc (sizeof (struct shlib_info), shlib_info_size);
  if (!shlib_info)
    {
      __rtc_event (RTC_NO_MEMORY, 0, 0, 0);
      return;
    }

 /* JAGae73849	*/
 /* Till we get a fix from kernel team, we will skip the following
    call if _SKIP_INITIALIZER_MMAP=1. Once we get the fix from kernel, this
    flag will have not be needed.
    The defect kernel has is that it does not give you the updated
    mmap size and starting address if the mmap is partially 
    munmapped earlier.
 */

  if (!getenv("_SKIP_INITIALIZER_MMAP"))
     find_mmaps_in_startup();

  rtc_started = 1;
  sprintf (heap_info_filename, "/tmp/__heap_info");
  sprintf (heap_interval_filename, "/tmp/__heap_interval_info");
  sprintf (heap_interval_idxfile, "/tmp/__heap_interval_info.idx");

  DEBUG(printf("__rtc_initialize done\n");)
}

static void 
rtc_initialize (void)
{

#ifdef RTC_BATCH_MODE

  /* The batch mode is simply not intelligent enough to figure out
     all the thread registers. One could argue that we should still
     proceed ignoring the thread registers. But it is further
     complicated by the fact that if we were to go ahead, we have to
     run the collector in the context of the thread calling exit,
     and its stack may not be big enough for the levels of recursion
     that mark () can get into. Added to that, it may not be safe
     to do file I/O at the point the GC kicks in.

     We'll defer this until we see an enhancement request or forever
     if there is no interest among users.
  */

#ifdef HPUX_1020
  extern int _tepv;

  if (_tepv)
#else
  if (__ismt)
#endif
    {
      char msg [] = "Batch mode leak detection cannot be used with "
                             "threaded programs\n";
      write (2, msg, strlen (msg));
      _exit (1);
    }
#endif

  /* Baskar, JAGae68100,
     calling one-time initialization routine..
     I guess __thread_once is an atomic operation

     __thread_once calls the initialization routine only
     if __ismt is non-zero and so the "if (__ismt)" condition
  */

#ifndef HPUX_1020
  if (__ismt)
     __thread_once (&init_once, __rtc_initialize);
  else
#endif
     __rtc_initialize ();	

}

/* Save this pc list in the stack trace buffer. */
static struct stack_trace_info *
preserve_stack_trace (void **pc)
{
  int i;
  struct stack_trace_info * retval;

  if (__rtc_stack_trace_count == 0) /* no room */
    allocate_stack_trace_buffers ();
         
  for (i=0; i < __rtc_frame_count; i++)
    stack_trace_buffer[i] = pc[i];

  stack_trace_buffer[i] = 0;

  retval = stack_trace_info_buffer;
  retval->pc = stack_trace_buffer;
  
  __rtc_stack_trace_count --;
  stack_trace_info_buffer++;
  stack_trace_buffer += __rtc_frame_count + 1;

  return retval;
}

/* cached_stack_trace () : given a stack trace of __rtc_frame_count # of
   pc values, retrieve a pointer to an identical trace if one is 
   present. Store the trace and return a pointer otherwise.
*/

static void *
cached_stack_trace (void **pc)
{
  long hash_val;
  struct stack_trace_info * stk_trc;
  int i;

  if (pc == 0 || pc[0] == 0)
    return 0;

  /* hash key is obtained by adding all the PCs and getting the bottom 
     16 bits. */
  hash_val = 0;
  for (i=0; i < __rtc_frame_count; i++)
    hash_val += (long) pc[i];
  hash_val &= 0xffff;

  stk_trc  = stack_trace_hash_table [hash_val];

  while (stk_trc != 0)
    {
      /* Be sure not to over run the old and new traces, as the frame
         count value changes during a run. When we preserve a trace we
         always terminate it with a zero.
      */
      for (i=0; stk_trc->pc[i] && i < __rtc_frame_count; i++)
        if (stk_trc->pc[i] != pc[i])
          break;
      
      if (i == __rtc_frame_count || stk_trc->pc[i] == pc[i])
        return stk_trc->pc;
      else
        stk_trc = stk_trc->next;
    }

   /* Looks like this stack trace is unknown thus far : Add it to the
      head of the linked list.
   */

   stk_trc = preserve_stack_trace (pc);
   stk_trc->next = stack_trace_hash_table [hash_val];
   stack_trace_hash_table [hash_val] = stk_trc;
   return stk_trc->pc;
}

#pragma OPTIMIZE OFF
/* This function is called after gdb notifies the librtc that the current
   shlib information is invalid (when the shlib gets loaded). Update it. */
static void
update_shlib_info ()
{
  int i, j;
  struct shl_descriptor shl_desc;

  for (i=0, j=0; shl_get_r (i, &shl_desc) != -1; i++)
    {
      if (!strstr (shl_desc.filename, "/librtc"))
         /* We don't need to save the info about librtc as we are not
	    going to do memory checking on this. */
        {
          if (j == shlib_info_size)
            {
              shlib_info  = libc_realloc (shlib_info,
                  sizeof (struct shlib_info) * (shlib_info_size *= 2));
              if (shlib_info == 0)
                {
                  __rtc_event (RTC_NO_MEMORY, 0, 0, 0);
                  return;
                }
            }      
          shlib_info[j].data_start = (void *) shl_desc.dstart;
          shlib_info[j].data_end = (void *) shl_desc.dend;
 	  shlib_info[j].text_start = (void *) shl_desc.tstart;
          shlib_info[j].text_end = (void *) shl_desc.tend;
          j++;
        }
     }
  shlib_info_count = j;
  shlib_info_invalid = 0;
}


/* This function saves the information about the currently allocated
   block in our data structures. */
static void
rtc_record_malloc (char * pointer, size_t size, int heap_block,
                                                int padded)
{
  int level = 0;
  struct rtc_chunk_info c_info, *new_c_i, * c_i = &c_info;
#ifdef GDB_TARGET_IS_HPPA
  cframe_info curr_frame;
  pframe_info prev_frame;
  int i;
#endif
  int error;
  int j;
  long page_no;
  void ** pc_list;

    if (rtc_disabled || pointer == 0)
      return;

    heap_interval_check ();

    /* If a watched block is allocated, report. */
    if (((char *)__rtc_watch_address) >= pointer &&
        ((char *) __rtc_watch_address) < (pointer + size))
      __rtc_event (RTC_ALLOCATED_WATCHED_BLOCK, pointer, 0, 0);

    /* If the allocated block is bigger a certain size, report. */
    if (__rtc_big_block_size && size >= __rtc_big_block_size)
      __rtc_event (RTC_HUGE_BLOCK, pointer, 0, 0);

    page_no = PAGE_FROM_POINTER (pointer);

    c_i->padded_block = padded;

    if (heap_block == NON_HEAP_BLOCK || heap_block == HEAP_BLOCK)
      {
        c_i->heap_block = heap_block;
        c_i->preinit_mmap = 0;
      }
    else if (heap_block == NON_HEAP_PREINIT_BLOCK) 
      {
        c_i->heap_block = NON_HEAP_BLOCK;;
        c_i->preinit_mmap = 1;
      } 
    
    c_i->base = pointer;
    c_i->end = pointer + size;
    c_i->next_leak = 0;
    c_i->old_leak = 0;
    c_i->scanned = scanned_this_time;
    c_i->pc = 0;  /* for now */

    if (interval_in_progress)
      c_i->new = 1; /* new allocation */
    else
      c_i->new = 0; /* ignore */

    if (__rtc_frame_count)
      pc_list = alloca (__rtc_frame_count * sizeof (void *));
    else
      pc_list = 0;

    /* Do not bother collecting the stack trace, if the size of this
       block is smaller than the user specified minimum leak size. We
       will still be able to report leaks smaller than this, but without
       a stack trace.
    */

    if ((size >= (size_t) __rtc_min_leak_size) && 
                           (__rtc_frame_count != 0))
      {
        /* Let's do the unwinding and get the pc list. */
        level = get_frame_pc_list (pc_list);
      }
#ifdef GDB_TARGET_IS_HPPA
    else
      goto beat_it_quick;

#ifndef HPUX_1020

    U_init_frame_record (&curr_frame);
    U_prep_frame_rec_for_unwind (&curr_frame);

#if !defined(HP_IA64) && !defined(GDB_TARGET_IS_HPPA_20W)

    curr_frame.topsr0 = 0;
    curr_frame.topsr4 = 0;

#endif

#else
    U_get_frame_info(&curr_frame);
#endif

  /* At this point curr_frame is pointing to the frame corresponding
     to rtc_record_malloc (), which is called by rtc_*alloc() which
     is called by the application. Pop two levels above to reach into
     user space code ...
   */ 

  i = 0;
  for (j=0; j < 2; j++)
    {
      error = U_get_previous_frame_x (&curr_frame,
                                      &prev_frame,
                                      sizeof(cframe_info));
      if (error)
        goto beat_it_quick;

      U_copy_frame_info (&curr_frame, &prev_frame);
    }

  /* curr_frame has the stack frame details pertaining to 
     the caller of rtc_*alloc : record __rtc_frame_count number of
     frames from there. 
  */

  do 
    {
      if (curr_frame.currlo)
        {
          /* U_get_previous_frame_x () has the side effect of
             adjusting the current frame if it is pointing to a stub.
             So don't record the PC right now. Obtain the previous 
             frame and record current PC after any adjustmnents.
          */
          error = U_get_previous_frame_x(&curr_frame,
                                         &prev_frame,
                                         sizeof(cframe_info));
          if (error)
            goto beat_it_quick;

          /* reach for the call and not the return address ... */
          pc_list[i++] = (void *) ((curr_frame.currlo & ~3L) - 4);
          U_copy_frame_info (&curr_frame, &prev_frame);
        }
     } while ( i < __rtc_frame_count && curr_frame.currlo);

    /* fall thro ... */

beat_it_quick :
    /* Let's fillup the remaining PCs with 0s. */
    for (; level < __rtc_frame_count; level++)
        pc_list[level] = 0;
#else
    /* use of "level" to silence aCC6 unused variable message */
    level++;
#endif

    mutex_lock (&mutex);

    c_i->pc = cached_stack_trace (pc_list);
    new_c_i = allocate_chunk_info ();
    *new_c_i = *c_i;
    new_c_i->next = chunks_in_page[page_no];
    chunks_in_page[page_no] = new_c_i;

    /* Determine the heap end now. Turns out when the GC is
       running it is not safe even to query this value ! Also
       update our list of shared libraries if needed. GDB would
       set the variable `shlib_info_invalid' to ask us to do this.
       This is needed since we cannot ask dld for the list of
       shared libraries when GC is in progress. We can't trust
       anyone to give us as much as the time of day !
    */

    if (shlib_info_invalid)
      update_shlib_info ();

    mutex_unlock (&mutex);

  return;
}

/* Remove this block from our data structures if it exists. */
static void
rtc_record_free (void * pointer, int free_the_block)
{
    long page_no;
    rtc_chunk_info * this_chunk_info, *prev_chunk_info;

    if (rtc_disabled || pointer == 0)   /* nothing to do */
      return;

    page_no  = PAGE_FROM_POINTER (pointer);

    /* Grab the lock. */
    mutex_lock (&mutex);

    this_chunk_info = chunks_in_page[page_no];

    prev_chunk_info = 0;
    while (this_chunk_info != NULL)
      {
        if (this_chunk_info->base == pointer)
          {
            if (free_the_block)
              if (this_chunk_info->heap_block)
                {
		  /* Watching this block? report. */
                  if (((char *) __rtc_watch_address) >= this_chunk_info->base &&
                      ((char *) __rtc_watch_address) < this_chunk_info->end)
                     __rtc_event (RTC_DEALLOCATED_WATCHED_BLOCK, pointer, 0, 0);
		  /* bound checks on? check for overflow and underflow. */
                  if (__rtc_check_bounds)
                    if (this_chunk_info->padded_block)
                      check_bounds (pointer, this_chunk_info->end -
                                             this_chunk_info->base, this_chunk_info->pc);
		  /* scrambling on? scramble the memory here. */
                  if (__rtc_scramble_blocks)
                    scramble_block (pointer, this_chunk_info->end -
                                             this_chunk_info->base);
		  /* call the real free. */
                  if (this_chunk_info->padded_block)
                    libc_free (((char *) pointer) - HEADER_SIZE);
                  else 
                    libc_free (pointer);
                }
              else 
                {
		  /* double free? Complain only if not between heap_base and
		     real_heap_base. Otherwise just ignore. */
                  if (__rtc_check_free
		      && !(((char*)pointer >= real_heap_base)
			   && ((char*)pointer < heap_base)) ) 
                    __rtc_event (RTC_BAD_FREE, pointer,this_chunk_info->pc, 
                                 this_chunk_info->end - this_chunk_info->base);
                  break;
                }
	    /* Remove this from our list. */
            if (prev_chunk_info)
              prev_chunk_info->next = this_chunk_info->next;
            else  
              chunks_in_page[page_no] = this_chunk_info->next;

            deallocate_chunk_info (this_chunk_info);
            break;
          }
          prev_chunk_info = this_chunk_info;
          this_chunk_info = this_chunk_info->next;
      }
    
    /* Doesn't exist in our list. Report bad free. Complain only if not
       between heap_base and real_heap_base. Otherwise just ignore. */
    if (this_chunk_info == 0)
      if ((__rtc_check_free) && 
	  ! (((char*)pointer >= real_heap_base)
	     && ((char*)pointer < heap_base)))
        __rtc_event (RTC_BAD_FREE, pointer, 0, 0);

    if (shlib_info_invalid)
      update_shlib_info ();

    /* Unlock. */
    mutex_unlock (&mutex);
}

/* Allocate along with header and footer and write the header and footer
   with a known value. */
static void *
malloc_padded (size_t size)
{  
    char * ends_before = 0, * ends_after;
    unsigned int * pointer;
    int i;

    if (MONITOR_HEAP_GROWTH)
      ends_before = libc_sbrk (0);

    pointer = libc_malloc (size + HEADER_SIZE + FOOTER_SIZE);

    if (MONITOR_HEAP_GROWTH)
      {
        ends_after = libc_sbrk (0);
        if ((ends_after - ends_before) >= HEAP_GROWTH_THRESHOLD)
          __rtc_event (RTC_HEAP_GROWTH, pointer,0, 0);
      }

    if (pointer)
      {
        for (i=0; i < HEADER_SIZE; i += sizeof (int))
          *pointer++ = MAGIC_COOKIE;
        ((char *) pointer)[size] = 0xff;
      }

    return pointer;
}

/* Allocate along with header and footer and write the header and footer
   with a known value. */
static void *
calloc_padded (size_t nelem, size_t size)
{  
    char * ends_before = 0, * ends_after;
    unsigned int * pointer;
    int i;

    if (MONITOR_HEAP_GROWTH)
      ends_before = libc_sbrk (0);

    pointer = libc_malloc (nelem * size + HEADER_SIZE + FOOTER_SIZE);
      
    if (MONITOR_HEAP_GROWTH)
      {
        ends_after = libc_sbrk (0);
        if ((ends_after - ends_before) >= HEAP_GROWTH_THRESHOLD)
          __rtc_event (RTC_HEAP_GROWTH, pointer,0,0);
      }

    if (pointer)
      {
        for (i=0; i < HEADER_SIZE; i += sizeof (int))
          *pointer++ = MAGIC_COOKIE;
        ((char *) pointer)[nelem * size] = 0xff;
        memset (pointer, 0, nelem * size);
      }

    return pointer;
}

static void *
realloc_padded (void * opointer, size_t size)
{  
    char * ends_before = 0, * ends_after;
    unsigned int * pointer;
    int i;
    long page_no;
    rtc_chunk_info * c_i;

    page_no = PAGE_FROM_POINTER (opointer);

    mutex_lock (&mutex);

    /* Get the c_i associated with this pointer. */
    c_i = chunks_in_page[page_no];

    while (c_i != NULL)
      {
        if (c_i->base == opointer)
            break;
        else
          c_i = c_i->next;
      }

    mutex_unlock (&mutex);

    if (c_i == 0)
      {
        if (__rtc_check_free) 
          __rtc_event (RTC_BAD_REALLOC, opointer,0,0);
        return 0;
      }

    /* If the old block was not padded, calling realloc on it will be
       disastrous. This could happen since we allow the user to toggle
       bounds check option on the fly. We need to mimic realloc with 
       malloc() and free ().
    */
       
    if (c_i->padded_block)
      {
        if (MONITOR_HEAP_GROWTH)
          ends_before = libc_sbrk (0);
        pointer = libc_realloc (((char *) opointer) - HEADER_SIZE, 
                                 size + HEADER_SIZE + FOOTER_SIZE);
      
        if (MONITOR_HEAP_GROWTH)
          {
            ends_after = libc_sbrk (0);
            if ((ends_after - ends_before) >= HEAP_GROWTH_THRESHOLD)
              __rtc_event (RTC_HEAP_GROWTH, pointer,0,0);
          }

        if (pointer)
          {
            for (i=0; i < HEADER_SIZE; i += sizeof (int))
              *pointer++ = MAGIC_COOKIE;
            ((char *) pointer)[size] = 0xff;
          }
      }
    else
      {
        size_t osize;

        osize = c_i->end - c_i->base;
        pointer = malloc_padded (size);
        if (pointer)
          {
            memcpy (pointer, opointer, size < osize ? size : osize);
            libc_free (opointer);
          }
      }
    return pointer;
}

static int
calculate_random_count()
{
    int ret;
    srand(__rtc_null_check_seed_value);
    ret = rand() % __rtc_null_check_random_range;
    return ret;
}

static int
handle_null_check(int size)
{
    if (NULL_CHECK_ENABLED())
      {
         /* for null-check random, it is 0 for the
            the first time; we calculate the random
            value and assign to null-check-count
         */
         if (NULL_CHECK_RANDOM())  /* true if the first time */
              __rtc_null_check_count = calculate_random_count();

         if (NULL_CHECK_EXCEEDED())  
           {
             RESET_NULL_CHECK_VARS();
             if (__rtc_catch_nomem) /* for catch_nomem */
               __rtc_nomem_event (RTC_NOMEM, NULL);
             return 1;
           } 
         else
           {
               if (__rtc_null_check_count > 0)
                   current_null_check_count = 
                     (current_null_check_count == -1) ? 1 :
                      current_null_check_count + 1;
               else 
                   current_null_check_size = 
                     (current_null_check_size == -1) ? size :
                      current_null_check_size + size;
           }
           DEBUG(printf("current_null_check_size = %d\n",current_null_check_size);)
           DEBUG(printf("current_null_check_count = %d\n",current_null_check_count);)
      }
      return 0;
}

#ifdef HP_IA64
/* This is used in stack trace code of IPF, ia64-rtc.c, to do a faster
   backtrace when frame-count is 1. */
void * rp_val;
#endif

/* Wrapper function for malloc. */
#pragma _HP_SECONDARY_DEF __rtc_malloc malloc
void *
__rtc_malloc (size_t size)
{
    char * ends_before = 0, * ends_after;
    void * pointer;

#ifdef HP_IA64
    rp_val = _Asm_get_rp ();
#endif

    OBTAIN_BACKDOOR_ENTRY ();

    /* Baskar, check if this is command-line call & rtc not started
       if so, use libc-malloc. 
       FIXME: If this works, extend this for all the [de]allocators */

    if (rtc_disabled || __pthreads_not_ready || inside_librtc ||
	(command_line_call && !rtc_started))
      {
	command_line_call = 0;
     	return libc_malloc (size);
      }

    inside_librtc = 1;
    if (!rtc_started)
      rtc_initialize ();

    if (handle_null_check(size))
        RETURN(NULL);

    if (__rtc_check_bounds)
      pointer = malloc_padded (size);
    else 
      {
	/* Check for the size of heap-growth. */
        if (MONITOR_HEAP_GROWTH)
          ends_before = libc_sbrk (0);
        pointer = libc_malloc (size);
        if (MONITOR_HEAP_GROWTH)
          {
            ends_after = libc_sbrk (0);
            if ((ends_after - ends_before) >= HEAP_GROWTH_THRESHOLD)
              __rtc_event (RTC_HEAP_GROWTH, pointer,0, 0);
          }
      }

    /* Scramble this block. */
    if (pointer && __rtc_scramble_blocks)
      scramble_block (pointer, size);

    /* Record this allocation. */
    if (pointer != NULL)
      rtc_record_malloc (pointer, size, HEAP_BLOCK,
                                   __rtc_check_bounds);
    else /* JAGaf48255 - gdb should report if malloc returns null pointer */
      if (__rtc_catch_nomem)
	__rtc_nomem_event(RTC_MEM_NULL, NULL);	

    RETURN (pointer);
}

/* Wrapper for free. */
#pragma _HP_SECONDARY_DEF __rtc_free free
void 
__rtc_free (char * pointer)
{

    if (pointer == 0)
      return;

    OBTAIN_BACKDOOR_ENTRY ();

    if (rtc_disabled || __pthreads_not_ready || inside_librtc ||
	(command_line_call && !rtc_started))
      {
	command_line_call = 0;
        /* We are not expected to do any memory checking. */
        libc_free (pointer);
        return;
      }

    inside_librtc = 1;
    if (!rtc_started)
      rtc_initialize ();

    /* Obscurity alert ! In the case of C++, we arrive a little
       late for the party. A few mallocations have happened even
       before GDB intercepts and reroutes the calls to this module.
       These malloc calls appear to originate from support library
       code to construct a linked list of loaded libraries, termination
       handlers and such much. for more details on this, see the file
       /CLO/Components/HPCXX/Src/SupportLib/libshlInit.C
     
       However, some of these data structures get deallocated after
       we enter the picture (see undermain.c) As a result, we could see
       a few legal calls to free without having seen the corresponding
       mallocs in the first place. Here is what we will do :

       If we see a call to free and the block being freed is housed
       in the region between &end (end of data segment) and what we
       perceive to be the base of heap in rtc_initialize (), we will
       simply ignore the free and return to the application.

       We cannot call free on this object because, it could have been
       allocated by a different mallocator bound into a.out and should
       this be the case, the C library mallocator is highly likely to 
       get confused. Bindu 022803: Well looks like we are going through
       the libc mallocator...

       This has its downsides. Well, we can make things foolproof,
       can we make it damnfoolproof ?
    */

    /* Bindu 022803: The allocations after we came into picture would have
       gotten memory in between heap_base and real_heap_base (previously
       freed memory from C++ startup). We record these allocations in our
       data structures. If a free for these blocks happen and if we do not
       record that free, info leaks will show that as a leak, which is not
       right. So, try and record this free. If we cannot find the record
       for allocation in our data structures, it might be because we are
       looking at the free of pre-librtc allocation. So, just ignore this
       free in rtc_record_free.
     */

    rtc_record_free (pointer, 1); /* record & free */
    inside_librtc = 0;
    return;
}

/* Wrapper for realloc. */
#pragma _HP_SECONDARY_DEF __rtc_realloc realloc
void *
__rtc_realloc (void * pointer, size_t size)
{
    char * ends_before = 0, * ends_after;
    void * old_pointer;

    OBTAIN_BACKDOOR_ENTRY ();

    if (rtc_disabled || __pthreads_not_ready || inside_librtc ||
	(command_line_call && !rtc_started))
      {
	command_line_call = 0;
        return libc_realloc (pointer, size);
      }

    inside_librtc = 1;
    if (!rtc_started)
      rtc_initialize ();

    /* Special case (1) If realloc() is called with a non NULL pointer
       and a new size of 0, it is equivalent to freeing the object.
    */
    if (pointer && !size)
      {
        rtc_record_free (pointer, 1); /* record & free */
        RETURN (0);
      }

    /* Special case (2) If realloc is called with a NULL pointer, it
       is equivalent to malloc ()
    */

    if (pointer == 0)
      {
        if (__rtc_check_bounds)
          pointer = malloc_padded (size);
        else
          {
            if (MONITOR_HEAP_GROWTH)
              ends_before = libc_sbrk (0);
            pointer = libc_malloc (size);
            if (MONITOR_HEAP_GROWTH)
              {
                ends_after = libc_sbrk (0);
                if ((ends_after - ends_before) >= HEAP_GROWTH_THRESHOLD)
                  __rtc_event (RTC_HEAP_GROWTH, pointer,0,0);
              }
          }

        if (pointer && __rtc_scramble_blocks)
          scramble_block (pointer, size);

        if (pointer)
          rtc_record_malloc (pointer, size, HEAP_BLOCK,
                                    __rtc_check_bounds);
        else /* JAGaf48255 - gdb should report if malloc returns null pointer */
          if (__rtc_catch_nomem)
            __rtc_nomem_event(RTC_MEM_NULL, NULL);
      
        RETURN (pointer);
      }

    old_pointer = pointer;
    if (__rtc_check_bounds)
      pointer = realloc_padded (pointer, size);
    else
      {
        if (MONITOR_HEAP_GROWTH)
          ends_before = libc_sbrk (0);
        pointer = libc_realloc (pointer, size);
        if (MONITOR_HEAP_GROWTH)
          {
            ends_after = libc_sbrk (0);
            if ((ends_after - ends_before) >= HEAP_GROWTH_THRESHOLD)
              __rtc_event (RTC_HEAP_GROWTH, pointer,0,0);
          }
      }

    /* Let us not bother scrambling the block. It makes me feel
       queasy to be doing it when part of the block is valid ...
    */
    if (pointer)
      {
        rtc_record_free (old_pointer, 0); /* 0: just record. */
        rtc_record_malloc (pointer, size, HEAP_BLOCK, 
                                    __rtc_check_bounds);
      }
    else /* JAGaf48255 - gdb should report if malloc returns null pointer */
      if (__rtc_catch_nomem)
        __rtc_nomem_event(RTC_MEM_NULL, NULL);

    RETURN (pointer);
}

/* Wrapper for calloc. */
#pragma _HP_SECONDARY_DEF __rtc_calloc calloc
void *
__rtc_calloc (size_t nelem, size_t size)
{
    char * ends_before = 0, * ends_after;
    void * pointer;

    OBTAIN_BACKDOOR_ENTRY ();

    if (rtc_disabled || __pthreads_not_ready || inside_librtc ||
	(command_line_call && !rtc_started))
      {
	command_line_call = 0;
        return libc_calloc (nelem, size);
     }

    inside_librtc = 1;
    if (!rtc_started)
      rtc_initialize ();

    if (__rtc_check_bounds)
      pointer = calloc_padded (nelem, size);
    else 
      {
        if (MONITOR_HEAP_GROWTH)
          ends_before = libc_sbrk (0);
        pointer = libc_calloc (nelem, size);
        if (MONITOR_HEAP_GROWTH)
          {
            ends_after = libc_sbrk (0);
            if ((ends_after - ends_before) >= HEAP_GROWTH_THRESHOLD)
              __rtc_event (RTC_HEAP_GROWTH, pointer,0,0);
          }
      }


    /* We should not scramble calloc blocks, since they should be 
       initialized to 0. ! */

    if (pointer)
      rtc_record_malloc (pointer, nelem * size, HEAP_BLOCK, 
                                        __rtc_check_bounds);
    else /* JAGaf48255 - gdb should report if malloc returns null pointer */
      if (__rtc_catch_nomem)
        __rtc_nomem_event(RTC_MEM_NULL, NULL);

    RETURN (pointer);
}

/* Wrapper for valloc. */
#pragma _HP_SECONDARY_DEF __rtc_valloc valloc
void *
__rtc_valloc (size_t size)
{
    char * ends_before = 0, * ends_after;
    void * pointer;

    OBTAIN_BACKDOOR_ENTRY ();

    if (rtc_disabled || __pthreads_not_ready || inside_librtc ||
	(command_line_call && !rtc_started))
      {
	command_line_call = 0;
        return libc_valloc (size);
      }

    inside_librtc = 1;
    if (!rtc_started)
      rtc_initialize ();

    /* valloc() is supposed to return a page aligned address which
       means that we cannot attach extra pad bytes at the head. Let
       us also not bother with the footer bytes. This is really an
       obscure HP specific thingy.
    */

    if (MONITOR_HEAP_GROWTH)
      ends_before = libc_sbrk (0);
    pointer = libc_valloc (size);
    if (MONITOR_HEAP_GROWTH)
      {
        ends_after = libc_sbrk (0);
        if ((ends_after - ends_before) >= HEAP_GROWTH_THRESHOLD)
          __rtc_event (RTC_HEAP_GROWTH, pointer,0,0);
      }

    if (pointer && __rtc_scramble_blocks)
      scramble_block (pointer, size);

    if (pointer)
      rtc_record_malloc (pointer, size, HEAP_BLOCK,
                                    NON_PADDED_BLOCK);
    else /* JAGaf48255 - gdb should report if malloc returns null pointer */
      if (__rtc_catch_nomem)
        __rtc_nomem_event(RTC_MEM_NULL, NULL);

    RETURN (pointer);
}

/* Intercept and record the mmap calls too. For our purposes it is
   just fine to treat them as mallocated blocks.
*/

#pragma _HP_SECONDARY_DEF __rtc_mmap mmap
void *
__rtc_mmap (void *addr, size_t len, int prot, int flags, 
                                     int fildes, off_t off)
{
  void * pointer;

  OBTAIN_BACKDOOR_ENTRY ();

  if (rtc_disabled || __pthreads_not_ready || inside_librtc)
    return libc_mmap (addr, len, prot, flags, fildes, off);

  inside_librtc = 1;
  if (!rtc_started)
    rtc_initialize ();

  pointer = libc_mmap (addr, len, prot, flags, fildes, off);

  if (pointer != NULL)
    {
      /* The kernel always rounds size to the page boundary so that
         whole page(s) get mapped in. Let us do the same thing ... 
      */

      if (len % page_size)
        len = len + page_size - (len % page_size);

      rtc_record_malloc (pointer, len, NON_HEAP_BLOCK,
                                      NON_PADDED_BLOCK);
    }

    RETURN (pointer);
}

/* The pthreads library manages thread stacks via mmap and munmap.
   Unlike the main thread, the thread stacks cannot grow automatically
   and are limited to fixed size specified initially. In order to
   detect stack overruns, the library allocates a guard page at the
   end and eliminates all permissions from it. Unless we watch out, we
   will be reading from these pages without read permissions when
   we garbage collect. What we will do is to simply leave the read
   permission on.
*/

#pragma _HP_SECONDARY_DEF __rtc_mprotect mprotect
int
__rtc_mprotect (void *addr, size_t len, int prot)
{
  OBTAIN_BACKDOOR_ENTRY ();
  prot |= PROT_READ;
  return libc_mprotect (addr, len, prot);
}

#pragma _HP_SECONDARY_DEF __rtc_shl_unload shl_unload
int
__rtc_shl_unload (shl_t handle)
{
  int val;
  OBTAIN_BACKDOOR_ENTRY();

  if (rtc_disabled || __pthreads_not_ready || inside_librtc ||
        (command_line_call && !rtc_started))
    {
        command_line_call = 0;
        return libdld_shl_unload (handle);
    }

  inside_librtc = 1;

  if (!rtc_started)
    rtc_initialize ();

  val=libdld_shl_unload (handle);
  update_shlib_info ();
  RETURN(val);
}

#pragma _HP_SECONDARY_DEF __rtc_dlclose dlclose
int
__rtc_dlclose (void * handle)
{
  int val;

  OBTAIN_BACKDOOR_ENTRY();

  if (rtc_disabled || __pthreads_not_ready || inside_librtc ||
        (command_line_call && !rtc_started))
    {
       command_line_call = 0;
       return libdld_dlclose (handle);
    }

  inside_librtc = 1;

  if (!rtc_started)
    rtc_initialize ();

  val=libdld_dlclose (handle);
  update_shlib_info ();
  RETURN(val);
}

static void
rtc_record_munmap (char * pointer, size_t size)
{
  long page_no;
  size_t this_size, next_size;
  char * cp;
  rtc_chunk_info * c_i;
  rtc_chunk_info * ac_i = 0;

  /* We need to deal with many special cases here. A call to munmap()
     need not unmap the whole region mapped in by a call to mmap(). 
     Selective pages could get unmapped. These pages that get unmapped
     could be in the beginning, middle, or end. Further more, a single
     call to munmap() could unmap several regions mapped in 
     independently as long as they are contiguous.

     Depending upon the values of pointer and size we may need to throw
     away the chunk_info or throw away the old one & create a new one or
     retain the old one and adjust the values in it or split it into 
     two chunk_infos.

     Initially, I had code here that dealt with the many different 
     corner cases. It was too complex and ugly and I am sure it was so
     much ado about nothing. As a result, we now assume that the whole
     mmapped region is being unmapped. If this assumption proves 
     invalid, we would turn off RTC.

     If this ever comes up in a real customer situation, we could 
     address it by reinstating all the special case code ...

  */

  /* It did. The Java virtual machine does all the above and some
     more :-) So here we go with all the rigamarole of interval
     management  -- srikanth, 000222
  */

  /* The kernel always rounds size to the page boundary so that whole 
     page(s) are unmapped. Let us do the same thing ... Pointer is
     guaranteed to be page aligned as otherwise munmap would have
     failed.
  */
 
  if (size % page_size)
    size =  size + page_size - (size % page_size);

  page_no = PAGE_FROM_POINTER (pointer);

munmap_this_region:

  /* We get here from above as well as from below via a goto.
     The invariants to be maintained are : pointer points to
     an mmap region. size is its size. page_no is its pageno.
     We may be passed a pointer to the middle of an mmap region,
     in which case we need to take some pains to find it.
  */
  c_i = 0;
  mutex_lock (&mutex);
  while (page_no >= 0)
    {
      c_i = chunks_in_page[page_no];
      while (c_i)
        {
          if (pointer >= c_i->base && pointer < c_i->end)
            goto found;
          c_i = c_i->next;
        }
      --page_no;
    }

found :

  mutex_unlock (&mutex);
  if (c_i)
    {
      if (pointer == c_i->base)
        {
          /* the whole enchilada ? */
          if ((pointer + size) == c_i->end)
            rtc_record_free (pointer, 0);
          else
          if ((pointer + size) < c_i->end)
            {
              /* some initial pages are going away */
              rtc_record_malloc (pointer + size,
                                 c_i->end - (pointer + size),
                                 NON_HEAP_BLOCK,
                                 NON_PADDED_BLOCK);

              /* Gross ! rtc_record_malloc () would have captured
                 the current stack trace. Patch it with the old
                 one.
              */

              page_no = PAGE_FROM_POINTER (pointer + size);
              mutex_lock (&mutex);
              ac_i = chunks_in_page [page_no];
 
              while (ac_i)
                {
                  if (ac_i->base == (pointer + size))
                    ac_i->pc = c_i->pc;
                  ac_i = ac_i->next;
                }
              mutex_unlock (&mutex);
              rtc_record_free (pointer, 0);
            }
          else 
            {
              this_size = c_i->end - c_i->base;
              rtc_record_free (pointer, 0);
              pointer += this_size;
              size -= this_size;
              page_no = PAGE_FROM_POINTER (pointer);
              goto munmap_this_region;
            }
          }
        else
          {
            if ((pointer + size) == c_i->end)
              c_i->end = pointer;
            else 
            if ((pointer + size) > c_i->end)
              {
                size -= c_i->end - pointer;
                cp = c_i->end;
                c_i->end = pointer;
                pointer = cp;
                page_no = PAGE_FROM_POINTER (pointer);
                goto munmap_this_region;
              }
            else 
              {
                next_size = c_i->end - (pointer + size);
                c_i->end = pointer;
                rtc_record_malloc (pointer + size,
                                              next_size,
                                              NON_HEAP_BLOCK,
                                              NON_PADDED_BLOCK);
                page_no = PAGE_FROM_POINTER (pointer + size);
                mutex_lock (&mutex);
                ac_i = chunks_in_page [page_no];
 
                while (ac_i)
                  {
                    if (ac_i->base == (pointer + size))
                      ac_i->pc = c_i->pc;
                    ac_i = ac_i->next;
                  }
                mutex_unlock (&mutex);
              }
          }
    }

    return;
}

/* Wrapper for unmap. */
#pragma _HP_SECONDARY_DEF __rtc_munmap munmap
int
__rtc_munmap (char *addr, size_t len)
{
  int status;

  OBTAIN_BACKDOOR_ENTRY ();

  if (rtc_disabled || __pthreads_not_ready || inside_librtc)
    return libc_munmap (addr, len);

  inside_librtc = 1;

  /* The munmap and record_munmap must be atomic. Otherwise,
     if the GC kicks in between, we are going to die a dirty
     death. Use a different mutex for this purpose, so as not
     to block others from calling malloc.
  */

  mutex_lock (&unmap_mutex);
  status = libc_munmap (addr, len);

  if (!status)    /* munmap went thro ok */
    rtc_record_munmap (addr, len);
  mutex_unlock (&unmap_mutex);

  RETURN (status);
}

/* Wrapper for sbrk. */
#pragma _HP_SECONDARY_DEF __rtc_sbrk sbrk
void *
__rtc_sbrk (int incr)
{
  char * pointer;

  OBTAIN_BACKDOOR_ENTRY ();

  if (!rtc_started || rtc_disabled || __pthreads_not_ready || inside_librtc)
    {
      command_line_call = 0;
      return libc_sbrk (incr);
    }

  inside_librtc = 1;
  if (!rtc_started)
    rtc_initialize ();

  pointer = libc_sbrk (incr);

  if (pointer == (void *) -1L)  /* sbrk failed, nothing to do */
    RETURN (pointer);

  /* Negative sbrk calls from the application are a sure sign of 
     trouble. They are guaranteed to interfere adversely with the 
     malloc package and confuse RTC. In the unlikely event the program
     attempts this insanity, let us just get out of the suicide scene.
  */
  if (incr < 0)
    {
      __rtc_event (RTC_SBRK_NEGATIVE, 0,0,0);
      RETURN (pointer);
    }

  if (incr && pointer != NULL)
    {
      long aligned_pointer = (long) pointer;

      /* The return value of sbrk() need not have any specific 
         alignment. Force it to have an alignment suitable for a 
         pointer for our internal purposes, as other parts (mark()) 
         assume that the start address is suitably aligned to hold a
         pointer.
      */

      while (aligned_pointer % sizeof (pointer))
        {
          aligned_pointer++;
          incr --;
        }

      rtc_record_malloc ((char *) aligned_pointer, incr,
                                  NON_HEAP_BLOCK, NON_PADDED_BLOCK);
    }

    RETURN (pointer);
}

/* Wrapper for brk. */
#pragma _HP_SECONDARY_DEF __rtc_brk brk
int 
__rtc_brk (char *endds)
{
  char * heap_end; 
  int status;
  long aligned_pointer;

  OBTAIN_BACKDOOR_ENTRY ();

  if (!rtc_started || rtc_disabled || __pthreads_not_ready || inside_librtc)
    {
      command_line_call = 0;
      return libc_brk (endds);
    }

  inside_librtc = 1;
  if (!rtc_started)
    rtc_initialize ();

  heap_end = libc_sbrk(0);
  status = libc_brk (endds);

  if (status == -1)  /* brk failed, nothing to do */
    RETURN (status);

  /* Negative brk calls from the application are a sure sign of trouble.
     They are guaranteed to interfere adversely with the malloc package
     and confuse RTC. In the unlikely event the program attempts this 
     insanity, let us just drop the chalupa and back away.
  */
  if (endds < heap_end)
    {
      __rtc_event (RTC_SBRK_NEGATIVE, 0,0,0);
      RETURN (status);
    }

  /* We have a new block between heap_end (the old break value) and
     endds. The return value of sbrk() need not have any specific
     alignment. Force it to have an alignment suitable for a pointer
     for our internal purposes, as other parts (mark()) assume that the
     start address is suitably aligned to hold a pointer.
  */

  aligned_pointer = (long) heap_end;
  while (aligned_pointer % sizeof (heap_end))
    aligned_pointer++;

  rtc_record_malloc ((char *) aligned_pointer, 
                     endds - (char *) aligned_pointer,
                              NON_HEAP_BLOCK,
                              NON_PADDED_BLOCK);

  RETURN (status);
}


/* Wrappers for System V IPC shared memory operations : shmat()
   attaches a shared memory region to a process while shmdt() can
   be used to detach the same. We need to scan these regions for
   pointers to heap, otherwise we could mistakenly declare something
   to be garbage.
*/

#pragma _HP_SECONDARY_DEF __rtc_shmat shmat
void *
__rtc_shmat(int shmid, void *shmaddr, int shmflg)
{
  void * pointer;
  struct shmid_ds buf;

  OBTAIN_BACKDOOR_ENTRY ();

  if (rtc_disabled || __pthreads_not_ready || inside_librtc)
    return libc_shmat (shmid, shmaddr, shmflg);

  inside_librtc = 1;
  if (!rtc_started)
    rtc_initialize ();

  pointer = libc_shmat (shmid, shmaddr, shmflg);
  if (pointer == (void *) -1L) /* shmat() failed, nothing to do */
    RETURN (pointer);

  shmctl (shmid, IPC_STAT, &buf); /* To get the shm_segsz. */
  rtc_record_malloc (pointer, buf.shm_segsz, NON_HEAP_BLOCK, 
                                      NON_PADDED_BLOCK);
      
  RETURN (pointer);
}

#pragma _HP_SECONDARY_DEF __rtc_shmdt shmdt
int 
__rtc_shmdt(void *shmaddr)
{
  int status;

  OBTAIN_BACKDOOR_ENTRY ();

  if (rtc_disabled || __pthreads_not_ready || inside_librtc)
    return libc_shmdt (shmaddr);

  inside_librtc = 1;

  /* shmdt () and rtc_record_free () must be atomic. */

  mutex_lock (&unmap_mutex);

  status = libc_shmdt (shmaddr);
  if (status != -1)
    rtc_record_free (shmaddr, 0);

  mutex_unlock (&unmap_mutex);

  RETURN (status);
} 
/* JAGaf15615: For PA32, To enable RTC on attach, from the time process started. */
#if !defined(HP_IA64) && !defined(GDB_TARGET_IS_HPPA_20W)
#pragma _HP_SECONDARY_DEF __rtc__start _start
void  
__rtc__start (int argc, char **argv, char **envp)
{
	obtain_backdoor_entry();
        if (getenv("BATCH_RTC") == NULL)
          {
	     /* JAGaf37695 - Environment variable RTC_INIT should be turned 'on' 
	        to collect heap information from startup of the process for PA32 
		application (Attach case).
                $ LD_PRELOAD=/opt/langtools/lib/librtc.sl RTC_INIT=on <executable>

                Caution : If RTC_INIT is turned 'on', librtc starts recording
                heap information by default for PA32 process. So, user should
                avoid export-ing this environment variable for shell and set
                only when appropriate. */
    
	     if (getenv("RTC_INIT") != NULL)
	        __rtc_init_leaks();
          }
         else
          {
	     if (init_config (argv[0]) && process_config()) 
              {
	        file_included = is_file_included (argv[0]);
                __pthreads_not_ready = 0;
              }
          }
	 libc__start (argc, argv, envp);
}	

#pragma _HP_SECONDARY_DEF __rtc__exit _exit
void 
__rtc__exit (int status)
{
  if (file_included > 0 && rtc_started) 
     if (getenv("BATCH_RTC") != NULL)
         print_batch_info();

  libc__exit (status);
}

#endif

#ifdef RTC_BATCH_MODE

void 
__rtc_print_leaks ()
{
  rtc_chunk_info * leak_list, *__rtc_leaks_info ();
  long bytes_leaked = 0, blocks_leaked = 0;
  time_t t;

  if (!log_file)
    {
      log_file = fopen ("/tmp/gdbrtc.log", "a");
      if (!log_file)
        {
          fprintf (stderr, "Error logging memory leaks !\n");
          return;
        }
    }
  update_shlib_info ();
  leak_list = __rtc_leaks_info ();

  time (&t);
  fprintf (log_file, 
"-------------------------------------------------------------------------------\n");
  fprintf (log_file, "\tLeak Analysis Report [pid = %d] %s",
                                  getpid (), ctime (&t));
  fprintf (log_file, 
"-------------------------------------------------------------------------------\n\n");
  while (leak_list)
    {
      fprintf(log_file, "%8ld bytes leaked at 0x%p\n",
                          (leak_list->end - leak_list->base),
                          leak_list->base);
      blocks_leaked ++;
      bytes_leaked += leak_list->end - leak_list->base;
      leak_list = leak_list->next_leak;
    }
  fprintf (log_file, "\n");
  fprintf (log_file, "%8ld bytes leaked in %d blocks\n\n", 
                 bytes_leaked, blocks_leaked);
  fclose (log_file);
}


void 
__rtc_exit (int status)
{
  if (rtc_started)
     __rtc_print_leaks ();
  libc_exit (status);
}

void *
malloc (size_t size)
{
    return __rtc_malloc (size);
}

void *
calloc (size_t nelem, size_t size)
{
    return __rtc_calloc (nelem, size);
}

void *
realloc (void *ptr, size_t size)
{
    return __rtc_realloc (ptr, size);
}

void *
valloc (size_t size)
{
    return __rtc_valloc (size);
}

void free (void *ptr)
{
    __rtc_free (ptr);
}

void *
mmap (void *addr, size_t len, int prot, int flags, int fildes, off_t off)
{
    return __rtc_mmap (addr, len, prot, flags, fildes, off);
}

int 
munmap (void *addr, size_t len)
{
    return __rtc_munmap (addr, len);
}

int
mprotect (void * addr, size_t len, int prot)
{
    return __rtc_mprotect (addr, len, prot);
}

int shl_unload (shl_t handle)
{
   __rtc_shl_unload (handle);
}

int dlclose ( void *handle)
{
  __rtc_dlclose (handle);
}

void *
shmat (int shmid, const void *shmaddr, int shmflg)
{
    return __rtc_shmat (shmid, (void *) shmaddr, shmflg);
}

int shmdt (const void *shmaddr)
{
    return __rtc_shmdt ((void *) shmaddr);
}

int brk (void *endds)
{
    return __rtc_brk (endds);
}

void *sbrk (int incr)
{
    return __rtc_sbrk (incr);
}

void exit (int status)
{
    __rtc_exit (status);
}

#endif  /* RTC_BATCH_MODE */


/* Collate all the leaked blocks into a linked list. */
static rtc_chunk_info *
sweep_leaks_into_a_list (void)
{
  int i;
  struct rtc_chunk_info * c_i;
  rtc_chunk_info * leak_list;

  leak_list = 0;
  for (i=0; i < total_pages; i++)
    {
      c_i = chunks_in_page[i];
      while (c_i)
        {
	  /* JAGae73849: If not marked as scanned,  and it is not a preinit mmap
             add to the list.  
          */
          if (c_i->scanned != scanned_this_time && c_i->preinit_mmap == 0)
            {
              c_i->scanned = scanned_this_time; 
	      /* Report only the new leaks. */
              if (!c_i->old_leak)
                {
                  c_i->old_leak = 1;
                  c_i->next_leak = leak_list;
                  leak_list = c_i;
                } 
            }
          c_i = c_i->next;
        }
    }
    return leak_list;
}

/* Functions and macros to support delta heap */

static void 
heap_interval_start ()
{
   if (__rtc_check_heap_interval == 0)
     return;

   if (clock_gettime (CLOCK_REALTIME, &interval.start))
     {
        perror("clock_gettime(CLOCK_REALTIME) failed. Not starting heap-check interval");
        return;
     }

  interval.end.tv_sec = interval.start.tv_sec + __rtc_check_heap_interval;
  interval_in_progress = 1;
  return;
  
}

static int
clear_interval_data (void)
{
  int i;
  struct rtc_chunk_info *c_i;
  int retval = 0;

  inside_librtc = 1;

  if (mutex_trylock (&mutex))
    RETURN (RTC_MUTEX_LOCK_FAILED);

  for (i=0; i < total_pages; i++)
    {
      for (c_i = chunks_in_page[i]; c_i; c_i = c_i->next)
          c_i->new = 0;
    }
  mutex_tryunlock (&mutex);
  RETURN (retval);
}

static int 
heap_interval_expired ()
{
   struct timespec cur_time;

   if (clock_gettime (CLOCK_REALTIME, &cur_time))
     {
        perror("clock_gettime(CLOKC_REALTIME) failed. Switching off heap-check interval");
        __rtc_check_heap_interval = 0;
        clear_interval_data (); /* clears all heap allocations for this interval */
        return 0;
     }
     if (cur_time.tv_sec > interval.end.tv_sec)
       return 1;
     else
       return 0;
}

/*
  Every time the program stops and the user call info heap-interval
  command. We call the following function to get the latest report.
  There are two data files which are used for this functionality:
  __heap_interval_info --> this file is similar to the data file
                           for __rtc_heap_info. It contains all
   heap allocations  which have happended in an interval. The 
   file contains all allocations that happen in each interval.

  __heap_interval_info.idx --> this is a index file with the 
  following format:
  <interval start time><interval end time><interval amount><# allocations in this interval>
  GDB reads idx file first and allocated heap_idx array. Each entry in heap_idx array
  has allocations for that interval.
*/

int
__rtc_heap_interval_info (void)
{
   int ret;

   ret = write_interval_data ();
   repeat_count++;
   interval_in_progress = 0;
   return ret;
}

static int
write_interval_data (void)
{
  int i, j;
  struct rtc_chunk_info * c_i;
  int fd_d, fd_idx;
  int count = 0;
  int retval, corrupted = 0;
  char *timestamp_ptr;
  CORE_ADDR size;
  CORE_ADDR zero = 0;
  CORE_ADDR address;

  inside_librtc = 1;

  if (mutex_trylock (&mutex))
    RETURN (RTC_MUTEX_LOCK_FAILED);

  /* this check is needed to make sure calling this function
      without making any progress or when the interval checking
     is switched off because of expiry of repeat count or by 
     explicit call from the user, this function does not add
     misleading/confusing records for 0 allocations.
  */
  if (interval.start.tv_sec == 0)
    goto done;

  fd_d = open (heap_interval_filename, O_RDWR | O_APPEND | O_CREAT, 0777);
  if (fd_d == -1)
    {
      retval = RTC_FOPEN_FAILED;
      goto done;
    }
  fd_idx = open (heap_interval_idxfile, O_RDWR | O_APPEND | O_CREAT, 0777);
  if (fd_idx == -1)
    {
      retval = RTC_FOPEN_FAILED;
      goto done;
    }

  for (i=0; i < total_pages; i++)
    {
      c_i = chunks_in_page[i];
      while (c_i)
        {
          size = c_i->end - c_i->base;

          if ((c_i->new == 0) || (c_i->preinit_mmap == 1))
            {
               c_i = c_i->next;
               continue;
            }

          count++;

          write (fd_d, &size, sizeof (CORE_ADDR));
	  address = (CORE_ADDR) c_i->base;
          write (fd_d, &address, sizeof (CORE_ADDR));
	  address = (CORE_ADDR) c_i->pc;
          write (fd_d, &address, sizeof (CORE_ADDR));
          write (fd_d, &corrupted, sizeof (int));

          if (c_i->pc)
            {
              for (j=0; j < __rtc_frame_count && c_i->pc[j]; j++)
		{
	          address = (CORE_ADDR) c_i->pc[j];
          	  write (fd_d, &address, sizeof (CORE_ADDR));
		}
	      /* Fill up the remaining by zeros. */
              for (; j < __rtc_frame_count; j++)
                write (fd_d, &zero, sizeof (CORE_ADDR));
            }
          else 
            {
              for (j=0; j < __rtc_frame_count; j++)
                write (fd_d, &zero, sizeof (CORE_ADDR));
            }

          /* this chunk has been reported once, do not report again */
          c_i->new = 0;
          c_i = c_i->next;
        }
    }

  /* write start, end and interval  for each run */
  timestamp_ptr = ctime (&interval.start.tv_sec); 
  timestamp_ptr [strlen (timestamp_ptr)-1] = NULL; /* take out new line */
  write(fd_idx, timestamp_ptr, strlen (timestamp_ptr) + 1);

  timestamp_ptr = ctime (&interval.end.tv_sec); 
  timestamp_ptr [strlen (timestamp_ptr)-1] = NULL;
  write (fd_idx, timestamp_ptr, strlen(timestamp_ptr) + 1);

  write (fd_idx, &__rtc_check_heap_interval, sizeof(__rtc_check_heap_interval));

  write (fd_idx, &count, sizeof(count));

  /* reset interval structure */
  interval.start.tv_sec = interval.end.tv_sec = 0;

  retval = count;

  if (close (fd_d) == EOF)
    retval = RTC_FCLOSE_FAILED;

  if (close (fd_idx) == EOF)
    retval = RTC_FCLOSE_FAILED;

done:
  mutex_tryunlock (&mutex);
  RETURN (retval);
}

static void
heap_interval_check()
{
   if (__rtc_check_heap_reset) /* reinit the data files */
     {  /* remove data files. Will be recreated again whenever required */
        unlink (heap_interval_filename);
        unlink (heap_interval_idxfile);

        __rtc_check_heap_reset = 0; 
     }

   /* do not start sampling till rtc has been initialized and
      interval has been set.
    */
   if (rtc_started  == 0 || __rtc_check_heap_interval == 0)
      return;

   if (interval_in_progress && heap_interval_expired())
     {
        write_interval_data ();

        repeat_count++; /* finished one more round of interval profiling */

        interval_in_progress = 0;
     }

   if ((interval_in_progress == 0) && 
         (repeat_count < __rtc_check_heap_repeat))
       heap_interval_start ();

   return;
}



/* Function that gdb calls to get the heap info. This function writes the
   heap profile into the file /tmp/__heap_info. */

int
__rtc_heap_info (void)
{
  int i, j;
  struct rtc_chunk_info * c_i;
  int fd;
  int count = 0;
  int retval, corrupted = 0;
  CORE_ADDR size;
  CORE_ADDR zero = 0;
  CORE_ADDR address;


  if (!rtc_started || rtc_disabled)
    return RTC_NOT_RUNNING;

  if (inside_librtc)
    return RTC_UNSAFE_NOW;

  inside_librtc = 1;

  /* srikanth, 000221, if some other thread is inside librtc, wait until
     it gets out. OTOH, if we could successfully lock the mutex, that
     would also cause other allocations to block until the GC gets over.
  */
  if (mutex_trylock(&mutex))
    RETURN (RTC_MUTEX_LOCK_FAILED);

  /* Avoid all C library calls like the mom-in-law */

  fd = creat (heap_info_filename, 0777);
  if (fd == -1)
    {
      retval = RTC_FOPEN_FAILED;
      goto done;
    }

  for (i=0; i < total_pages; i++)
    {
      c_i = chunks_in_page[i];
      while (c_i)
        {
          corrupted = 0;
          size = c_i->end - c_i->base;

	  /* Write everything in terms of CORE_ADDR.
	     If you change the code here, you need to change the
             corresponding code in gdbrtc.c:down_load_data (). 
           */

          if (c_i->padded_block)
            {
              if (((int *)c_i->base)[-1] != MAGIC_COOKIE || 
		  ((int *)c_i->base)[-2] != MAGIC_COOKIE)
                corrupted = RTC_BAD_HEADER;
              else if (((unsigned char *)c_i->base)[size] != (unsigned char) 0xff)
                corrupted = RTC_BAD_FOOTER;
            }
          else
                corrupted = 0;

          /* If we are generating bounds overrun report and the current
             chunk we are looking at is not corrupted, ignore it.
           */
          if (__rtc_bounds_or_heap == BOUNDS_INFO)
            {
               if (corrupted == 0 || c_i->preinit_mmap == 1)
                 {
                    c_i = c_i->next;
                    continue;
                 }
            }
          else
            { /* JAGaf24984: skips __rtc_initialize from heap 
                 info list
               */
               if (c_i->preinit_mmap == 1)
                 {
                    c_i = c_i->next;
                    continue;
                 }
            }
          count++;

          write (fd, &size, sizeof (CORE_ADDR));
	  address = (CORE_ADDR) c_i->base;
          write (fd, &address, sizeof (CORE_ADDR));
	  address = (CORE_ADDR) c_i->pc;
          write (fd, &address, sizeof (CORE_ADDR));
          write (fd, &corrupted, sizeof (int));

          if (c_i->pc)
            {
              for (j=0; j < __rtc_frame_count && c_i->pc[j]; j++)
		{
	          address = (CORE_ADDR) c_i->pc[j];
          	  write (fd, &address, sizeof (CORE_ADDR));
		}
	      /* Fill up the remaining by zeros. */
              for (; j < __rtc_frame_count; j++)
                write (fd, &zero, sizeof (CORE_ADDR));
            }
          else 
            {
              for (j=0; j < __rtc_frame_count; j++)
                write (fd, &zero, sizeof (CORE_ADDR));
            }

          /* this chunk has been reported once, do not report again */
          c_i->new = 0;
          c_i = c_i->next;
        }
    }
  retval = count;
  if (close (fd) == EOF)
    retval = RTC_FCLOSE_FAILED;

done:
  mutex_tryunlock (&mutex);
  RETURN (retval);
}
#pragma OPTIMIZE ON

/* JAGae73849: Checks to see if a particular address falls in 
   known range of text segments. It happens with mmaps which
   are extracted by find_mmaps_in_startup function from kernel.
 */
static int falls_in_text_space(void *addr)
{
  int i;
    
  for (i= 0; i < shlib_info_count; i++) 
    {
      if (addr >= shlib_info[i].text_start && addr <= shlib_info[i].text_end)
        return 1; // falls within text segment of a shared library
    }
  return 0;
}

/* Scan for pointers to heap blocks in the region bounded by two given
   addresses `first' and `last' and mark reachable blocks as such.
   If we find a pointer to a block, that block would be scanned
   recursively for pointers to additional blocks. We use a depth first
   traversal. The pointer `first' *must* be suitably aligned to point 
   to a pointer, while `last' need not. See that in the natural order 
   of things this ought to be guaranteed by any mallocator.

   We don't know where all the "real" pointers are, so we will assume
   that any suitably aligned location could hold a pointer. In essence
   we scan all the words in memory accessible to the program and see if
   they could be pointing to a heap block.
 
   To do this, we can't just look at the blocks in the page
   corresponding to the pointer ("word") alone since we may have a
   pointer pointing into the middle of a mallocated block and the start
   address of the block could be in a different page than the pointer.
   We cannot assume that all live blocks will have a pointer to the
   beginning somewhere in user space. The rational behind not assuming
   this is that we want to accomodate the not so infrequent practice
   of malloc wrappers wherein a block is mallocated, a few bytes are
   reserved initially and a pointer past that space is returned to the
   application. If we were to decree strictly that blocks without
   pointers to the beginning are garbage, we would run into trouble.

   So ... we will have to look at previous pages too. However, to keep
   things moving at a reasonable pace, we will limit our backward
   search to atmost one page. Thus a block for which there are no
   pointers to the first page_size# of bytes, will be declared 
   garbage. As you can see, this is not foolproof, but then as the
   adage goes it is impossible to make anything foolproof because fools
   are so ingenious.
*/
      
static void
mark (void * first, void *last)
{
  char ** start, ** end;
  struct rtc_chunk_info * c_i;
  long page_no;
  /* Do we need to search in the prev page if the current page
     doesn't help ?*/
  int search_prev_page = 0;
  
  start = (char **) first;
  end = (char **) last;

  while ((start + 1) <= end )
    {
      /* Is this memory loc pointing to a heap address? */
      if (*start >= real_heap_base && falls_in_text_space(*start) == 0)
        {
          page_no = PAGE_FROM_POINTER (*start);

          c_i = chunks_in_page [page_no];

          if (!c_i)
            {
	      /* Maybe in the previous page. */
              if (page_no)
                c_i = chunks_in_page[page_no -1];
              else
                c_i = chunks_in_page [total_pages - 1];
              search_prev_page = 0;
            }
          else if (page_no)
            search_prev_page = 1;

          while (c_i)
            {
              if (*start >= c_i->base)
                {
                  /* If pointer points to a heap block at all, then
                     that block must begin in this page. No use in
                     barking up the wrong tree.
                  */
                  search_prev_page = 0;

                  /* ANSI C blesses a pointer just past an array
                     with legal status.
                  */
                  if (*start <= c_i->end)
                    {
                      if (c_i->scanned != scanned_this_time)
                        {
			  /* found the block. Scan this block too. */
                          c_i->old_leak = 0;
                          c_i->scanned = scanned_this_time;

                          /* to iterate is human, to recurse divine */
                          mark (c_i->base, c_i->end);
                        }
                      break;
                    }
                 }
              c_i = c_i->next;
              if (!c_i && search_prev_page)
                {
                  search_prev_page = 0;
                  if (page_no) c_i = chunks_in_page [page_no - 1];
                  else 
                    c_i = chunks_in_page [total_pages - 1];
                }
            } /* inner while loop. */
         }
      start++;
    } /* outer while loop. */
}


/* __rtc_leaks_info (). This is the routine the debugger will have to
   call to obtain a leak list. In the case of a single threaded 
   program, this routine arranges to scan the program data, shared
   library data, stack, register set, all reachable heap blocks, all
   reachable mmapped regions, all reachable (explicitly allocated) 
   sbrk() regions, and shmat blocks.

   We rely on the fact that pointers must be aligned on 4 byte 
   boundaries on ILP32 mode and aligned on 8 byte boundaries on LP64
   mode. The registers are scanned implicitly in the sense that the 
   call by hand mechanism of GDB pushes the register set onto the stack.
 
   This routines returns a pointer to a linked list of leaks found 
   during this attempt. NULL pointer is returned if no new leaks are
   found. GDB will have to walk this list and download data regarding
   each leak and present it to the user.

   On IPF ilp32 programs, even though the registers are 64 long and
   pointers are 32 bit long, we scan 32-bits at a time from register
   array. We rely on the fact that we will analyse a particular register
   to be a pointer into heap when we are scanning the lower 32-bits.
   (and ignore the upper 32-bits, as that doesn't look like a heap
   address.)
*/

#pragma OPTIMIZE OFF
rtc_chunk_info *
__rtc_leaks_info(void)
{

  int i = 0;
  rtc_chunk_info * new_leaks = 0;
  char dummy_stack_var;
 
  if (!rtc_started || rtc_disabled)
    return (rtc_chunk_info *) RTC_NOT_RUNNING;

  /* If the user hit a ctrl-C and then said `info leaks', there is some
     chance we were interrupted while running inside this module. As the
     data structures may not be kosher, it is best not to touch them.
  */
  if (inside_librtc)
    return (rtc_chunk_info *) RTC_UNSAFE_NOW;

  if (shlib_info_invalid)
    {
        printf("warning: GDB may not have access to the last dynamically loaded library . The following leaks report may show memory leaks which may have a valid pointer in the data segment of the last loaded library. Once the application encounters a malloc or free call after a library is loaded, GDB gets access to the data segment of the loaded library. You may want to continue your application, stop again and ask for leaks report again for more accurate information\n");
    }

  /* srikanth, 000221, if some other thread is inside librtc, wait until
     it gets out. OTOH, if we could successfully lock the mutex, that
     would also cause other allocations to block until the GC gets over.
     Also if an munmap () or shmdt () is in progress don't collect now.
  */

  if (mutex_trylock (&unmap_mutex))
    return (rtc_chunk_info *) RTC_MUTEX_LOCK_FAILED;

  if (mutex_trylock (&mutex))
    {
      mutex_tryunlock (&unmap_mutex);
      return (rtc_chunk_info *) RTC_MUTEX_LOCK_FAILED;
    }

  /* We used to call libc_sbrk () to determine the end of the heap.
     This is not safe in a multithreaded program. If someother thread
     is stopped in libc_malloc (), we would deadlock since the C
     library obtains its own mutex. Now we update this in the function
     rtc_record_malloc ()
  */

  /* In the classical depth first graph traversal, we need to mark the
     nodes that have already been visited, so as to avoid infinite
     recursion. This flag has to be "cleared" before each attempt to
     traverse. Rather than touch every chunk_info to clear this flag,
     let us simply reverse the semantics of this flag ...
  */
    
  scanned_this_time = !scanned_this_time;

  /* Scan the program and all shared library data looking for pointers
     to heap blocks. Mark blocks that are reachable by one or more hops.
  */

  for (i = 0; i < shlib_info_count; i++) 
    mark (shlib_info[i].data_start, shlib_info[i].data_end);

  /* If the library inititialization code allocated some heap space
     before we entered the picture, we need to scan that region too
  */

  if (real_heap_base < heap_base) 
    mark (real_heap_base, heap_base);

  stack_end = &dummy_stack_var;
  mark (stack_base, stack_end);   /* scan the stack ... */

  /* GDB would have dumped the inferior's registers on to the register
     file. Scan that too.
  */
    
  mark (__rtc_register_file, __rtc_register_file + register_file_size);
  memset (__rtc_register_file, 0, register_file_size);

#ifdef REGISTER_STACK_ENGINE_FP
  /* GDB would have dumped all threads' RSE state (rse_bottom, BSPSTORE)
     into __rtc_RSE_file. Scan that. */
  {
    char * rse_ptr = __rtc_RSE_file;
    while (rse_ptr < (__rtc_RSE_file + __rtc_RSE_file_size))
      {
        CORE_ADDR __rtc_RSE_bottom, __rtc_RSE_top;

        memcpy (&__rtc_RSE_bottom, rse_ptr, sizeof (CORE_ADDR));
        /* 0 means end. */
        if (__rtc_RSE_bottom == 0)
	  break;
        rse_ptr += sizeof (CORE_ADDR);

	memcpy (&__rtc_RSE_top, rse_ptr, sizeof (CORE_ADDR));
        rse_ptr += sizeof (CORE_ADDR);

        mark ((void *) (unsigned long) __rtc_RSE_bottom, 
	      (void *) (unsigned long) __rtc_RSE_top);
      }
    memset (__rtc_RSE_file, 0, __rtc_RSE_file_size);
  }
#endif /* REGISTER_STACK_ENGINE_FP */

  /* When the program is multithreaded, we need to scan four additional
     regions : thread stacks, TLS, TSD  and thread registers. Thread
     stacks are mmap regions and pthreads library seems to hold onto
     the beginning addresses (in user space.) There is an API call
     pthread_*_getstackaddr() that retrieves this.

     I suspect pthreads maintains pointers to TLS also in the user
     space. This is ok even otherwise as gdb pushes CR27 onto the
     register file.

     TSD is managed via malloc/free and these are entirely user space
     thingies. The kernel does not even know about these.

     As the thread registers have already been scanned with gdb's help,
     we are done. The one catch here is that we scan the entire thread
     stack, not just the region bounded by stack bottom and current SP.
     So dirty stack beyond SP will hide leaks, but this should even
     out as the program proceeds further.
  */

  new_leaks = sweep_leaks_into_a_list (); /* build the leaks list. */

  /* Release the locks. */
  mutex_tryunlock (&mutex);
  mutex_tryunlock (&unmap_mutex);

  RETURN (new_leaks); 
}
#pragma OPTIMIZE ON

/* Function to be called by the user program in main, so that we can start 
   collecting the rtc information from the start-up even though gdb is not 
   yet in the picture. Bindu 040303 for attach & rtc. */
void
__rtc_init_leaks ()
{
  __rtc_frame_count = DEFAULT_FRAME_COUNT;
  __pthreads_not_ready = 0;
}

/* Batch RTC related functions */

/* Check if the given file is being traced or not */
static int 
is_file_included(char *file)
{
    int i = 0;

    if (rtcfiles[0] == NULL)
      return 1; /* empty rtcfiles; all files are assumed included. */

    while (i < MAX_RTC_FILES && strstr(rtcfiles[i], file) != 0)
      i++;

    if (i < MAX_RTC_FILES) 
      return i + 1; /* 1-based match index */
    else
      return 0;
}

/* This function takes a string of file names separated by ':' and breaks
   it up in an array of character strings.
 */
static int
parse_values (char *value, char *rtcfiles[])
{
     char *tp;
     int   i = 0;
     char *last = NULL;

     tp = strtok_r (value, ":", &last);
     if ((rtcfiles[i] = (char *)malloc (strlen (tp) + 1)) == NULL) 
       {
         perror ("librtc internal malloc failed");
         return 0;
       }
     strcpy (rtcfiles[i], tp);
     DEBUG(printf("rtcfiles %s\n", rtcfiles[0]);)

     for (i=1; i< MAX_RTC_FILES && (tp = strtok_r (NULL, ":", &last)); i++) 
       {
          if ((rtcfiles[i] = (char *)malloc (strlen(tp) + 1)) == NULL) 
            {
               perror ("librtc internal malloc failed");
               return 0;
            }
         strcpy (rtcfiles[i], tp);
         DEBUG(printf("rtcfiles %s\n", rtcfiles[i]);)
       }
     return 1;
}

/*
 * Read the config file and put all configurables in rtcenv array; put
 * file names for leak detection in rtcfiles array.
 * Null will be used to signify the end of rtcfiles array.
 * The file supports following syntax:
 * check_leaks=on/off  --> switch on/off leak detection
 * check_heap=on/off  --> switch on/off info heap
 * check_free=on/off  --> switch on bad free (enhancement: to be done in future)
 * output_dir=<dir name> --> name of directory where output file should be
 * files="file1:file2:...." --> files of interest which are to be traced
 * min_leak_size=size --> track mallocs which are bigger than this size
 * scramble_block=on/off --> switch on/off scrambling of blocks
 * frame_count=num --> size of the frame count tobe used in displaying leak context
 */
#define SET_VALUE(value, config_var) \
    {\
        if(strcmp(value, "on") == 0)\
            config_var = 1;\
        else if(strcmp(value, "off") == 0)\
            config_var = 0;\
        else\
            fprintf(stderr, "Invalid " #config_var " check_bounds value. Ignoring it.\n");\
    }

static int
read_config_file(FILE *fp)
{
   int  val;
   char inbuf[PATH_MAX + 1];
   char *name, *value, *eqsep;

   while (fscanf(fp, "%s\n", inbuf) != EOF) 
     {
        if ((eqsep = strchr(inbuf,'=')) == NULL)
          continue; /* cannot parse; ignore this line */
        else 
          {
             *eqsep = NULL;
             name = inbuf;
             value = eqsep + 1;
 
             DEBUG(printf("Read name=%s value=%s\n", name, value);)

             if (strcmp (name, "frame_count") == 0) 
               {
                  if ((val = atoi (value)) > 0)
                    __rtc_frame_count = val;
                  else
                    fprintf (stderr, "Invalid frame_count value. Using default\n");
               } 
             else if (strcmp (name, "check_bounds") == 0) 
               {
                 SET_VALUE(value, __rtc_check_bounds);
               } 
             else if (strcmp (name, "check_free") == 0) 
               {
                 SET_VALUE(value, __rtc_check_free);
               } 
             else if (strcmp (name, "scramble_block") == 0) 
               {
                 SET_VALUE(value, __rtc_scramble_blocks);
               } 
             else if (strcmp (name, "check_leaks") == 0) 
               {
                 SET_VALUE(value, __rtc_check_leaks);
               } 
             else if (strcmp (name, "check_heap") == 0) 
               {
                 SET_VALUE(value, __rtc_check_heap);
               } 
             else if (strcmp (name, "min_leak_size") == 0) 
               {
                 if ((val = atoi (value)) > 0)
                   __rtc_min_leak_size = val;
                 else
                   fprintf (stderr, 
                            "Invalid min_leak_size value. Ignoring it.\n");
               } 
             else if (strcmp (name, "output_dir") == 0) 
               {
                  if ((rtcenv[RTC_OUTPUT_DIR] = 
                              malloc (strlen(name) + 1)) != NULL)
                    strcpy (rtcenv[RTC_OUTPUT_DIR], value);
                  else
                    fprintf (stderr, "librtc internal malloc failed.");
               } 
             else if (strcmp (name, "files") == 0) 
               {
                  if (!parse_values (value, rtcfiles)) 
                    {
                       return 0;
                    }
               }
           }
     } /* while */
   return 1;
}

/* 
 *  BATCH RTC config file is called rtcconfig
 *  Here is the priority order:
 *  - GDBRTC_CONFIG
 *  - current working directory
 * Returns file pointer to already opened config file. If file
 * cannot be found or opended, it returns NULL;
 */

static FILE * 
open_config_file()
{
    char *fname;
    FILE *fp = NULL;
    char config_file[PATH_MAX + 1];

    config_file[0] = NULL;

    if ((fname = getenv ("GDBRTC_CONFIG")) == NULL) 
      {
        strcpy (config_file, rtcenv[RTC_CWD]);
        strcat (config_file, "/");
        strcat (config_file, "rtcconfig");
      } 
    else
      strcpy (config_file, fname);

    if (config_file[0] != NULL) 
      {
         if ((fp = fopen (config_file, "r")) == NULL) 
           {
              perror ("Cannot open config file - rtcconfig.");
              return (FILE *)NULL;
           }
      }

    if ((rtcenv[RTC_CONFIG_FILE] = 
            (char *)malloc (strlen(config_file) + 1)) == NULL) 
      {
         perror ("librtc internal malloc failed");
         return 0;
      }

    strcpy (rtcenv[RTC_CONFIG_FILE], config_file);
    return fp;
}

/* Look for gdb in the following order
 * - GDB_SERVER
 * - /opt/langtools/bin/gdb
 * Returns nothing
 */
#define GDB_INSTALL_PATH "/opt/langtools/bin/gdb"
static void
find_gdb(char *g, size_t sz)
{
    char *tp;
    if ((tp = getenv ("GDB_SERVER")) != NULL) 
      {
         if (strlen (tp) > sz) 
           {
             fprintf (stderr, "GDB_SERVER value too long. Ignoring\n");
             strcpy (g, GDB_INSTALL_PATH);
           } 
           else
             strcpy (g,tp);
       } 
       else
         strcpy (g, GDB_INSTALL_PATH);

    DEBUG(printf("gdb = %s\n",g);)

    return; 
}

static int 
init_config(char *file)
{
    time_t t;
    char  *tp;
    /* path could be longer than PATH_MAX because of relative paths */
    char   buf[2*PATH_MAX + 1]; 

    if ((tp = getcwd (buf, PATH_MAX + 1)) == NULL) 
      {
         perror ("getcwd failed");
      }
    if ((rtcenv[RTC_CWD] = (char *)malloc (strlen(buf) + 1)) == NULL) 
      {
         perror ("librtc internal malloc failed");
         return 0;
      }
    strcpy (rtcenv[RTC_CWD], buf);

    time (&t);
    tp = ctime (&t);
    if ((rtcenv[RTC_START_TIME] = (char *)malloc (strlen(tp) + 1)) == NULL) 
      {
        perror ("librtc internal malloc failed");
        return 0;
      }
    strcpy (rtcenv[RTC_START_TIME],tp);

    if ((rtcenv[RTC_FILE] = (char *)malloc (strlen (file) + 1)) == NULL) 
      {
        perror ("librtc internal malloc failed");
        return 0;
      }

    strcpy (rtcenv[RTC_FILE], file);
    DEBUG(printf("RTC_FILE is %s\n", rtcenv[RTC_FILE]);)

    rtcenv[RTC_OUTPUT_DIR] = rtcenv[RTC_LAST] = NULL;

    /* If nothing in rtcfiles array => trace all executables. */
    rtcfiles[0] = NULL;
    return 1;
}

static int 
process_config()
{
    FILE  *config_fp;

    if ((config_fp = open_config_file ()) != NULL) 
      {

         DEBUG(printf("RTC_CONFIG_FILE %s\n", rtcenv[RTC_CONFIG_FILE]);)
         DEBUG(printf("RTC_CWD %s\n", rtcenv[RTC_CWD]);)

         if (read_config_file (config_fp) == 0) 
           {
              printf ("read_config_file failed\n");
              return 0;
           } 
         else
           return 1;
      }

    return 0;
}

static int
file_is_librtc(char *s)
{
    char *tp = NULL;

    if ((tp = strrchr (s,'/')) != NULL) 
      {
        ++tp;
#ifdef HP_IA64
        if (strcmp (tp, "librtc.so") == 0   || 
            strcmp (tp, "librtc.sl") == 0   ||
            strcmp (tp, "librtc64.sl") == 0 ||
            strcmp (tp, "librtc64.so") == 0) 
#else
        if (strcmp (tp, "librtc.sl") == 0 || 
            strcmp (tp, "librtc64.sl") == 0) 
#endif
          {
             return 1;
          }
      }
    return 0;
}

/* This function checks to see if the output file can be created.
 * It does not write any data in the file. The following order is used
 * to decide the place for output data
 * - RTC_OUTPUT_DIR, if specified and output file can be created there
 * - the current working directory and if output file can be created there
 * - stdout
 */

static void 
create_output_file(char *file,  char *pid, char *suffix, char *output_file,
                   char *output_dir)
{
    FILE *fp;

    if (output_dir != NULL) 
      {
         sprintf (output_file,"%s/%s.%s.%s", output_dir, file, pid, suffix);

         if ((fp = fopen (output_file, "w")) != NULL) 
           {
              DEBUG(printf( "Trying output file=%s\n",output_file);)
              fclose (fp);
              return;
           } 
         else 
           {
              DEBUG(printf("Trying output file=%s\n",output_file);)
              perror ("librtc cannot open output file. Using current directory");
           }
       }

     sprintf (output_file,"%s.%s.%s", file, pid, suffix);
     if ((fp = fopen (output_file, "w")) == NULL) 
       {
          DEBUG(printf ("Trying output file=%s\n",output_file);)
          perror ("librtc cannot open output file in current directory. Using stdout");
          strcpy (output_file, "");
       } 
     else
       fclose (fp);

    DEBUG(printf("output_file = %s\n", output_file);)
    return;
}

/* JAGaf15615: Turn off Optimization for __gdb_synchronizer */
#pragma OPTIMIZE OFF
volatile int   __gdb_synchronizer = 0;

/* This function prints leaks/heap data to a file. It does it by forking and 
 * execing gdb in child process. gdb attaches to the parent process and uses 
 * the gdb infrastructure to print leaks/heap data.
 */
static int 
print_batch_info()
{
    char *tp;
    DEBUG(pid_t cpid;)
    char  pid[10];
    FILE *gdbp;
    char  cnt[10];
    char  buf[PATH_MAX + 1];
    char  cmd[PATH_MAX + 1];

    int   old_inside_librtc = 0, old_shlib_info_invalid = 0;

    tp = strrchr (rtcenv[RTC_FILE], '/');
    if (tp == NULL || *tp != '/')
      tp = rtcenv[RTC_FILE];
    else
      tp++;

    sprintf (pid,"%d", getpid());

    strcpy (cmd, "set height 0\nset variable shlib_info_invalid=0\nthread 1\nset variable __gdb_synchronizer=1\n");
    strcat(cmd, "set heap-check frame-count ");
    sprintf(cnt, "%d\n", __rtc_frame_count);
    strcat(cmd, cnt);

    strcat(cmd, "set heap-check min-leak-size ");
    sprintf(cnt, "%d\n", __rtc_min_leak_size);
    strcat(cmd, cnt);

    if (__rtc_check_leaks) 
      {
         create_output_file (tp, pid, "leaks", buf, rtcenv[RTC_OUTPUT_DIR]);
         strcat (cmd, "info leaks ");
         strcat (cmd, buf);
         strcat (cmd, "\n");
      }
    if (__rtc_check_heap) 
      {
         create_output_file (tp, pid, "heap", buf, rtcenv[RTC_OUTPUT_DIR]);
         strcat (cmd, "info heap ");
         strcat (cmd, buf);
         strcat (cmd, "\n");
      }
    strcat (cmd, "c\nq\n");

    if ((gdbp = fopen (".rtcinit", "w")) == NULL) 
      {
         perror("Cannot open .rtcinit. Cannot print RTC information");
         return 0; /* bail out, no output */
      }

    fprintf (gdbp, "%s", cmd);
    fclose (gdbp);
    
    DEBUG(printf("__rtc_check_leaks=%d __rtc_check_heap=%d\n", __rtc_check_leaks, __rtc_check_heap);)

    find_gdb (buf, PATH_MAX); /* invoke gdb to print details */

    DEBUG(printf("exec=%s pid=%s\n", buf, pid);)

    putenv ("LD_PRELOAD="); /* remove LD_PRELOAD from env before exec */

    if ((DEBUG(cpid =) fork ()) == 0) 
      { /* child process */

         old_inside_librtc = inside_librtc;
         old_shlib_info_invalid = shlib_info_invalid;
         inside_librtc = shlib_info_invalid = 0;

         DEBUG(printf ("forked successfully buf = %s cpid=%d\n", buf, cpid);)

#ifdef HP_IA64
         if (execl (buf, buf, "-p", pid, "-n", 
                  "-x", ".rtcinit", "-q", "-brtc", "-leaks", 0) == -1) 
#else
         if (execl (buf, buf, "-p", pid, "-n", 
                  "-x", ".rtcinit", "-batch", "-q", "-brtc", "-leaks", 0) == -1) 
#endif
           {
	      DEBUG(printf ("execl failed buf = %s cpid=%d\n", buf, cpid);)
              DEBUG(printf ("execl failed buf = %s cpid=%d\n", buf, cpid);)
              inside_librtc = old_inside_librtc;
              shlib_info_invalid = old_shlib_info_invalid;
              perror ("execl failed. Cannot print RTC info"); /* bail out */
              unlink (".rtcinit"); /* remove .rtcinit file */
              exit (1);
           }
      } 
    else 
      {
         DEBUG(printf ("forked successfully cpid=%d\n", cpid);)

         /* parent process - wait outside the system call. The 
           following line is important. The parent process waits here
           in a busy wait loop. Later, gdb attaches to this process and
           changes the value of the variable so that the parent can 
           continue
         */
        while(__gdb_synchronizer == 0); /* wait; synchronize with gdb */

        unlink (".rtcinit"); /* remove .rtcinit file */
      }

    return 0;
}
#pragma OPTIMIZE ON

/* dlhook callback function which handles batch RTC initialization and
   printing.
 */
static void 
librtc_callback(unsigned int type, struct dld_hook_param *arg)
{
    static int dl_load_complete = 0;
    static int dl_unload_complete = 0;

    switch(type) 
      {
      case DL_LOAD_POST_INIT:
        /* event is called after the initializers for all  loaded
           libraries have been called. Enable rtc when the first 
           post initializer event is recvd since 
        */

        DEBUG(printf("DL_LOAD_POST_INIT AAA %s=%d\n", arg->filename,file_included);)

        if (dl_load_complete)
          break;
        dl_load_complete = 1;

        if (getenv("BATCH_RTC") == NULL)
          {
             DEBUG(printf("__pthreads_not_ready = 0\n");)
             __pthreads_not_ready = 0;
             return;
          }

        if (!init_config (arg->filename)) /* malloc must have failed */
          break; /* bail out; no RTC info */

        if (!process_config()) 
          break; /* malloc failed or config does not exist; bail out */

        file_included = is_file_included (arg->filename);
        __pthreads_not_ready = 0;

        break;

    case DL_UNLOAD_POST_FINI:

        DEBUG(printf("DL_UNLOAD_POST_FINI %s\n", arg->filename);)

        if (file_included > 0 && file_is_librtc (arg->filename)) 
          {
            if (dl_unload_complete)
              break;
            dl_unload_complete = 1;
            DEBUG(printf("DL_UNLOAD_POST_FINI file included %s\n", arg->filename);)
            print_batch_info ();
          }
        break;

      /* Following stmts are to enable event debugging in future. */
      case DL_LOAD_COMPLETE:
            DEBUG(printf("DL_LOAD_COMPLETE file included %s\n", arg->filename);)
            break;
      case DL_UNLOAD_PRE_FINI:
            DEBUG(printf("DL_UNLOAD_PRE_FINI file included %s\n", arg->filename);)
            break;
      case DL_LOAD_PRE_INIT:
            DEBUG(printf("DL_LOAD_PRE_INIT file included %s\n", arg->filename);)
            break;
      default: /* for all other valid events */
            DEBUG(printf("default switch\n");)
            break;
    }
    return;
}
    
void (*__rtc_malloc_plabel) (void) = (void (*) (void)) __rtc_malloc;
void (*__rtc_calloc_plabel) (void) = (void (*) (void)) __rtc_calloc;
void (*__rtc_valloc_plabel) (void) = (void (*) (void)) __rtc_valloc;
void (*__rtc_realloc_plabel) (void) = (void (*) (void)) __rtc_realloc;
void (*__rtc_free_plabel) (void) = (void (*) (void)) __rtc_free;
void (*__rtc_mmap_plabel) (void) = (void (*) (void)) __rtc_mmap;
void (*__rtc_munmap_plabel) (void) = (void (*) (void)) __rtc_munmap;
void (*__rtc_sbrk_plabel) (void) = (void (*) (void)) __rtc_sbrk;
void (*__rtc_brk_plabel) (void) = (void (*) (void)) __rtc_brk;
void (*__rtc_shmat_plabel) (void) = (void (*) (void)) __rtc_shmat;
void (*__rtc_shmdt_plabel) (void) = (void (*) (void)) __rtc_shmdt;
void (*__rtc_mprotect_plabel) (void) = (void (*) (void)) __rtc_mprotect;
void (*__rtc_shl_unload_plabel) (void) = (void (*) (void)) __rtc_shl_unload;
void (*__rtc_dlclose_plabel) (void) = (void (*) (void)) __rtc_dlclose;
