/* Definitions to make GDB run on an Alpha box under VMS.
   Copyright 1993, 1994, 1995 Free Software Foundation, Inc.

This file is part of GDB.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#ifndef TM_EVAX_H
#define TM_EVAX_H

#define GDB_TARGET_AVMS

#define __NEW_STARLET
#include "bfd.h"
#include "coff/sym.h"		/* Needed for PDR below.  */
#include "coff/symconst.h"
#include <pdscdef.h>
#include <libicb.h>

#define NO_SINGLE_STEP 1

#include "evax-solib.h"

#if !defined (TARGET_BYTE_ORDER)
#define TARGET_BYTE_ORDER LITTLE_ENDIAN
#endif

/* Redefine some target bit sizes from the default.  */

#define TARGET_LONG_BIT 32
#define TARGET_LONG_LONG_BIT 64
#define TARGET_PTR_BIT 32

/* Floating point is IEEE compliant */
#define IEEE_FLOAT

/* Number of traps that happen between exec'ing the shell 
 * to run an inferior, and when we finally get to 
 * the inferior code.  This is 2 on most implementations.
 */
#define START_INFERIOR_TRAPS_EXPECTED 3

/* Offset from address of function to start of its code.
   Zero on most machines.  */

#define FUNCTION_START_OFFSET 0

/* Advance PC across any function entry prologue instructions
   to reach some "real" code.  */

#define SKIP_PROLOGUE(pc)	pc = alpha_skip_prologue(pc, 0)
extern CORE_ADDR alpha_skip_prologue PARAMS ((CORE_ADDR addr, int lenient));

/* Immediately after a function call, return the saved pc.
   Can't always go through the frames for this because on some machines
   the new frame is not set up until the new function executes
   some instructions.  */

#define SAVED_PC_AFTER_CALL(frame)	alpha_saved_pc_after_call(frame)
#ifdef __STDC__
struct frame_info;
#endif
extern CORE_ADDR
alpha_saved_pc_after_call PARAMS ((struct frame_info *));

/* Are we currently handling a signal ?  */
/* This macro is completely useless on VMS, so we do this in
   INIT_EXTRA_FRAME_INFO instead */

#define IN_SIGTRAMP(pc, name)	0

/* Stack grows downward.  */

#define INNER_THAN <

#define BREAKPOINT {0x80, 0, 0, 0} /* call_pal bpt */

/* Amount PC must be decremented by after a breakpoint.
   This is often the number of bytes in BREAKPOINT
   but not always.  */

#define DECR_PC_AFTER_BREAK 0

/* Nonzero if instruction at PC is a return instruction.
   "ret $zero,($ra),1" on alpha. */

#define ABOUT_TO_RETURN(pc) (read_memory_integer (pc, 4) == 0x6bfa8001)

/* Say how long (ordinary) registers are.  This is a piece of bogosity
   used in push_word and a few other places; REGISTER_RAW_SIZE is the
   real way to know how big a register is.  */

#define REGISTER_SIZE 8

/* Number of machine registers */

#define NUM_REGS 67

/* Initializer for an array of names of registers.
   There should be NUM_REGS strings in this initializer.  */

#define REGISTER_NAMES 	\
    {	"r0",	"r1",	"r2",	"r3",	"r4",	"r5",	"r6",	"r7", \
	"r8",	"r9",	"r10",	"r11",	"r12",	"r13",	"r14",	"r15", \
	"a0",	"a1",	"a2",	"a3",	"a4",	"a5",	"r22",	"r23", \
	"r24",	"ai",	"ra",	"pv",	"r28",	"fp",	"sp",	"zero", \
	"f0",   "f1",   "f2",   "f3",   "f4",   "f5",   "f6",   "f7", \
	"f8",   "f9",   "f10",  "f11",  "f12",  "f13",  "f14",  "f15", \
	"fa0",  "fa1",  "fa2",  "fa3",  "fa4",  "fa5",  "f22",  "f23",\
	"f24",  "f25",  "f26",  "f27",  "f28",  "f29",  "f30",  "fzero",\
	"pc",	"ps",   "vfp",					\
    }

/* Register numbers of various important registers.
   Note that most of these values are "real" register numbers,
   and correspond to the general registers of the machine,
   and FP_REGNUM is a "phony" register number which is too large
   to be an actual register number as far as the user is concerned
   but serves to get the desired value when passed to read_register.  */

#define R0_REGNUM 0		/* Function integer return value */
#define A0_REGNUM 16		/* Loc of first arg during a subr call */
#define PV_REGNUM 27		/* Contains start addr of current proc */
#define SP_REGNUM 30		/* Contains address of top of stack */
#define RA_REGNUM 26		/* Contains return address value */
#define ZERO_REGNUM 31		/* Read-only register, always 0 */
#define FZERO_REGNUM 63		/* Read-only register, always 0 */
#define FP0_REGNUM 32           /* Floating point register 0 */
#define FPA0_REGNUM 48          /* First float arg during a subr call */
#define PC_REGNUM 64		/* Contains program counter */
#define FP_REGNUM 66		/* Virtual frame pointer */

#define CANNOT_FETCH_REGISTER(regno) \
  ((regno) == ZERO_REGNUM || (regno) == FZERO_REGNUM)
#define CANNOT_STORE_REGISTER(regno) \
  ((regno) == ZERO_REGNUM || (regno) == FZERO_REGNUM)

/* Total amount of space needed to store our copies of the machine's
   register state, the array `registers'.  */
#define REGISTER_BYTES (NUM_REGS * 8)

/* Index within `registers' of the first byte of the space for
   register N.  */

#define REGISTER_BYTE(N) ((N) * 8)

/* Number of bytes of storage in the actual machine representation
   for register N.  On Alphas, all regs are 8 bytes.  */

#define REGISTER_RAW_SIZE(N) 8

/* Number of bytes of storage in the program's representation
   for register N.  On Alphas, all regs are 8 bytes.  */

#define REGISTER_VIRTUAL_SIZE(N) 8

/* Largest value REGISTER_RAW_SIZE can have.  */

#define MAX_REGISTER_RAW_SIZE 8

/* Largest value REGISTER_VIRTUAL_SIZE can have.  */

#define MAX_REGISTER_VIRTUAL_SIZE 8

/* Nonzero if register N requires conversion
   from raw format to virtual format.
   The alpha needs a conversion between register and memory format if
   the register is a floating point register and
      memory format is float, as the register format must be double
   or
      memory format is an integer with 4 bytes or less, as the representation
      of integers in floating point registers is different. */

#define REGISTER_CONVERTIBLE(N) ((N) >= FP0_REGNUM && (N) < FP0_REGNUM + 32)

/* Convert data from raw format for register REGNUM in buffer FROM
   to virtual format with type TYPE in buffer TO.  */

#define REGISTER_CONVERT_TO_VIRTUAL(REGNUM, TYPE, FROM, TO) \
  alpha_register_convert_to_virtual (REGNUM, TYPE, FROM, TO)
#ifdef __STDC__
struct type;
#endif
extern void
alpha_register_convert_to_virtual PARAMS ((int, struct type *, char *, char *));

/* Convert data from virtual format with type TYPE in buffer FROM
   to raw format for register REGNUM in buffer TO.  */

#define REGISTER_CONVERT_TO_RAW(TYPE, REGNUM, FROM, TO)	\
  alpha_register_convert_to_raw (TYPE, REGNUM, FROM, TO)
extern void
alpha_register_convert_to_raw PARAMS ((struct type *, int, char *, char *));

/* Return the GDB type object for the "standard" data type
   of data in register N.  */

#define REGISTER_VIRTUAL_TYPE(N) \
	(((N) >= FP0_REGNUM && (N) < FP0_REGNUM+32)  \
	 ? builtin_type_double : builtin_type_long) \

/* Store the address of the place in which to copy the structure the
   subroutine will return.  Handled by alpha_push_arguments.  */

#define STORE_STRUCT_RETURN(addr, sp)	/**/

/* Extract from an array REGBUF containing the (raw) register state
   a function return value of type TYPE, and copy that, in virtual format,
   into VALBUF.  */

#define EXTRACT_RETURN_VALUE(TYPE,REGBUF,VALBUF) \
  alpha_extract_return_value(TYPE, REGBUF, VALBUF)
extern void
alpha_extract_return_value PARAMS ((struct type *, char *, char *));

/* Write into appropriate registers a function return value
   of type TYPE, given in virtual format.  */

#define STORE_RETURN_VALUE(TYPE,VALBUF) \
  alpha_store_return_value(TYPE, VALBUF)
extern void
alpha_store_return_value PARAMS ((struct type *, char *));

/* Extract from an array REGBUF containing the (raw) register state
   the address in which a function should return its structure value,
   as a CORE_ADDR (or an expression that can be used as one).  */
/* The address is passed in a0 upon entry to the function, but when
   the function exits, the compiler has copied the value to v0.  This
   convention is specified by the System V ABI, so I think we can rely
   on it.  */

#define EXTRACT_STRUCT_VALUE_ADDRESS(REGBUF) \
  (extract_address (REGBUF + REGISTER_BYTE (R0_REGNUM), \
		    REGISTER_RAW_SIZE (R0_REGNUM)))

/* Structures are returned by ref in extra arg0 */
#define USE_STRUCT_CONVENTION(gcc_p, type)	1


/* Describe the pointer in each stack frame to the previous stack frame
   (its caller).  */

/* FRAME_CHAIN takes a frame's nominal address
   and produces the frame's chain-pointer. */

#define FRAME_CHAIN(thisframe) (CORE_ADDR) alpha_frame_chain (thisframe)
extern CORE_ADDR alpha_frame_chain PARAMS ((struct frame_info *));

/* Define other aspects of the stack frame.  */

/* Saved Pc.  */

#define FRAME_SAVED_PC(FRAME)	(alpha_frame_saved_pc(FRAME))
extern CORE_ADDR
alpha_frame_saved_pc PARAMS ((struct frame_info *));

/* The alpha has two different virtual pointers for arguments and locals.

   The virtual argument pointer is pointing to the bottom of the argument
   transfer area, which is located immediately below the virtual frame
   pointer. Its size is fixed for the native compiler, it is either zero
   (for the no arguments case) or large enough to hold all argument registers.
   gcc uses a variable sized argument transfer area. As it has
   to stay compatible with the native debugging tools it has to use the same
   virtual argument pointer and adjust the argument offsets accordingly.

   The virtual local pointer is localoff bytes below the virtual frame
   pointer, the value of localoff is obtained from the PDR.  */

#define ALPHA_NUM_ARG_REGS	6

#define FRAME_ARGS_ADDRESS(fi)	0

#define FRAME_LOCALS_ADDRESS(fi) 0

/* Return number of args passed to a frame.
   Can return -1, meaning no way to tell.  */

#define FRAME_NUM_ARGS(num, fi)	((num) = -1)

/* Return number of bytes at start of arglist that are not really args.  */

#define FRAME_ARGS_SKIP 0

/* Put here the code to store, into a struct frame_saved_regs,
   the addresses of the saved registers of frame described by FRAME_INFO.
   This includes special registers such as pc and fp saved in special
   ways in the stack frame.  sp is even more special:
   the address we return for it IS the sp for the next frame.  */

extern void alpha_find_saved_regs PARAMS ((struct frame_info *));

#define FRAME_FIND_SAVED_REGS(frame_info, frame_saved_regs) \
  do { \
    if ((frame_info)->saved_regs == NULL) \
      alpha_find_saved_regs (frame_info); \
    (frame_saved_regs) = *(frame_info)->saved_regs; \
    (frame_saved_regs).regs[SP_REGNUM] \
      = (frame_info)->frame + (frame_info)->pd->pdsc$l_size; \
  } while (0)


/* Discard from the stack the innermost frame, restoring all registers.  */

#define RETVAL_BEFORE_POP_FRAME
#define POP_FRAME		alpha_pop_frame()
extern void
alpha_pop_frame PARAMS ((void));

/* Special symbol found in blocks associated with routines.  We can hang
   alpha_extra_func_info_t's off of this.  */

#define MIPS_EFI_SYMBOL_NAME "__GDB_EFI_INFO__"

/* Specific information about a procedure.
   This overlays the ALPHA's PDR records, 
   alpharead.c (ab)uses this to save memory */

typedef struct alpha_extra_func_info {
	long	numargs;	/* number of args to procedure (was iopt) */
	PDR	pdr;		/* Procedure descriptor record */
} *alpha_extra_func_info_t;

/* Define the extra_func_info that mipsread.c needs.
   FIXME: We should define our own PDR interface, perhaps in a separate
   header file. This would get rid of the <bfd.h> inclusion in all sources
   and would abstract the mips/alpha interface from ecoff.  */
#define mips_extra_func_info alpha_extra_func_info
#define mips_extra_func_info_t alpha_extra_func_info_t

#define FRAMELESS_FUNCTION_INVOCATION(FI, FRAMELESS)  \
  do { \
    if ((FI)->pd == NULL) \
      alpha_find_saved_regs (FI); \
    (FRAMELESS) = ((FI)->pd->pdsc$v_kind == PDSC$K_KIND_NULL); \
  } while (0)

#define EXTRA_FRAME_INFO \
  char frameflags;\
  unsigned long invo_handle; \
  PDSCDEF *pd; \
  CORE_ADDR prev_invo_pc; \
  struct frame_saved_regs *saved_regs;

#define INIT_EXTRA_FRAME_INFO(fromleaf, fci) init_extra_frame_info(fci)
extern void
init_extra_frame_info PARAMS ((struct frame_info *));

#define	PRINT_EXTRA_FRAME_INFO(fi) print_extra_frame_info(fi);
extern void
print_extra_frame_info PARAMS ((struct frame_info *));

/* It takes two values to specify a frame on the ALPHA.  Sigh.

   In fact, at the moment, the *PC* is the primary value that sets up
   a frame.  The PC is looked up to see what function it's in; symbol
   information from that function tells us which register is the frame
   pointer base, and what offset from there is the "virtual frame pointer".
   (This is usually an offset from SP.)  FIXME -- this should be cleaned
   up so that the primary value is the SP, and the PC is used to disambiguate
   multiple functions with the same SP that are at different stack levels. */

#define SETUP_ARBITRARY_FRAME(argc, argv) setup_arbitrary_frame (argc, argv)
extern struct frame_info *setup_arbitrary_frame PARAMS ((int, CORE_ADDR *));

/* This is used by heuristic_proc_start.  It should be shot it the head.  */
#ifndef VM_MIN_ADDRESS
#define VM_MIN_ADDRESS (CORE_ADDR)0x0
#endif

/* If PC is in a shared library trampoline code, return the PC
   where the function itself actually starts.  If not, return 0.  */
#define SKIP_TRAMPOLINE_CODE(pc)  find_solib_trampoline_target (pc)

/* If the current gcc for for this target does not produce correct debugging
   information for float parameters, both prototyped and unprototyped, then
   define this macro.  This forces gdb to  always assume that floats are
   passed as doubles and then converted in the callee.

   For the alpha, it appears that the debug info marks the parameters as
   floats regardless of whether the function is prototyped, but the actual
   values are always passed in as doubles.  Thus by setting this to 1, both
   types of calls will work. */

#define COERCE_FLOAT_TO_DOUBLE 1

#define CALL_DUMMY { 0 }
#define REMOTE_CALL_DUMMY(FUNADDR,NARGS,ARGS,RETBUF) \
  vmschild_remote_call (FUNADDR, NARGS, ARGS, RETBUF)
extern void vmschild_remote_call ();

#define CONVERT_TO_DESCRIPTOR(address) convert_to_descriptor(address)
/* #define CONVERT_FROM_FUNC_PTR_ADDR CONVERT_TO_DESCRIPTOR */

#define TARGET_MALLOC "decc$malloc"

extern char *evax_target_pid;  /* nonzero if target process spawned us. */

#define ADDITIONAL_OPTIONS \
        {"slave", required_argument, 0, 1004}, 

#define ADDITIONAL_OPTION_CASES \
        case 1004:      /* -slave option:  evax auto-start */     \
          evax_target_pid = optarg;       \
          break;

#define ADDITIONAL_OPTION_HELP \
        "\
  -slave PID         Target process PID has spawned us.\n\
"

#define MBXQIO_EF 32
#define TIMER_EF 33
#define MBXQIO_EF_MASK 0x1
#define TIMER_EF_MASK 0x2

#define BEFORE_MAIN_LOOP_HOOK \
  do { \
    SYS$CLREF (TIMER_EF); \
    if (evax_target_pid) \
      { \
        vmschild_open (evax_target_pid, 0); \
        evax_target_pid = 0; \
      } \
  } while (0)

#endif /* TM_EVAX_H */
