// The template and inlines for the -*- C++ -*- indirect_array class.

// Copyright (C) 1997,1998 Cygnus Solutions
//
// This file is part of the libstdc++ version 3 distribution.
//
// This software is a copyrighted work licensed under the terms of the
// Cygnus libstdc++ license. Please consult the file LICENSE.STD for
// details.

// Written by Gabriel Dos Reis <Gabriel.Dos-Reis@DPTMaths.ENS-Cachan.Fr>

#ifndef _CPP_BITS_INDIRECT_ARRAY_H
#define _CPP_BITS_INDIRECT_ARRAY_H

namespace std {

template <class _Tp> class indirect_array
{
public:
    typedef _Tp value_type;
    
    void operator=  (const valarray<_Tp>&) const;
    void operator*= (const valarray<_Tp>&) const;
    void operator/= (const valarray<_Tp>&) const;
    void operator%= (const valarray<_Tp>&) const; 
    void operator+= (const valarray<_Tp>&) const;
    void operator-= (const valarray<_Tp>&) const;  
    void operator^= (const valarray<_Tp>&) const;
    void operator&= (const valarray<_Tp>&) const;
    void operator|= (const valarray<_Tp>&) const;
    void operator<<= (const valarray<_Tp>&) const;
    void operator>>= (const valarray<_Tp>&) const; 
    void operator= (const _Tp&);
    ~indirect_array();

    template<class Expression>
      void operator=  (const _Meta<Expression, _Tp>&) const;
    template<class Expression>
      void operator*= (const _Meta<Expression, _Tp>&) const;
    template<class Expression>
      void operator/= (const _Meta<Expression, _Tp>&) const;
    template<class Expression>
      void operator%= (const _Meta<Expression, _Tp>&) const;
    template<class Expression>
      void operator+= (const _Meta<Expression, _Tp>&) const;
    template<class Expression>
      void operator-= (const _Meta<Expression, _Tp>&) const;
    template<class Expression>
      void operator^= (const _Meta<Expression, _Tp>&) const;
    template<class Expression>
      void operator&= (const _Meta<Expression, _Tp>&) const;
    template<class Expression>
      void operator|= (const _Meta<Expression, _Tp>&) const;
    template<class Expression>
      void operator<<= (const _Meta<Expression, _Tp>&) const;
    template<class Expression>
      void operator>>= (const _Meta<Expression, _Tp>&) const; 

private:
    indirect_array ();
    indirect_array (const indirect_array&);
    indirect_array& operator= (const indirect_array&);

    indirect_array (_Array<_Tp>, size_t, _Array<size_t>);

    friend class valarray<_Tp>;
    friend class gslice_array<_Tp>;

    const size_t 	 _M_sz;
    const _Array<size_t> _M_index;
    const _Array<_Tp> 	 _M_array;
};

template<typename _Tp>
inline
indirect_array<_Tp>::indirect_array (_Array<_Tp> __a, size_t __s, 
				    _Array<size_t> __i)
        : _M_sz (__s), _M_index (__i), _M_array (__a) {}

template<typename _Tp>
inline indirect_array<_Tp>::~indirect_array() {}

template<typename _Tp>
inline void
indirect_array<_Tp>::operator= (const _Tp& __t)
  { __valarray_fill(_M_array, _M_index, _M_sz, __t); }

template<typename _Tp>
inline void
indirect_array<_Tp>::operator= (const valarray<_Tp>& __v) const
  { __valarray_copy (_Array<_Tp> (__v), _M_sz, _M_array, _M_index); }

template<typename _Tp>
template<class _Expr>
inline void
indirect_array<_Tp>::operator= (const _Meta<_Expr,_Tp>& __e) const
  { __valarray_copy (__e, _M_sz, _M_array, _M_index); }

#undef _DEFINE_VALARRAY_OPERATOR
#define _DEFINE_VALARRAY_OPERATOR(op, name)				\
template<typename _Tp>							\
inline void								\
indirect_array<_Tp>::operator##op##= (const valarray<_Tp>& __v) const	\
{									\
  _Array_augmented_##name (_M_array, _M_index, _Array<_Tp> (__v), _M_sz); \
}									\
									\
template<typename _Tp> template<class _Expr>				\
inline void								\
indirect_array<_Tp>::operator##op##= (const _Meta<_Expr,_Tp>& __e) const \
{									\
  _Array_augmented_##name (_M_array, _M_index, __e, _M_sz);		\
}

_DEFINE_VALARRAY_OPERATOR(*, multiplies)
_DEFINE_VALARRAY_OPERATOR(/, divides)
_DEFINE_VALARRAY_OPERATOR(%, modulus)
_DEFINE_VALARRAY_OPERATOR(+, plus)
_DEFINE_VALARRAY_OPERATOR(-, minus)
_DEFINE_VALARRAY_OPERATOR(^, xor)
_DEFINE_VALARRAY_OPERATOR(&, and)
_DEFINE_VALARRAY_OPERATOR(|, or)
_DEFINE_VALARRAY_OPERATOR(<<, shift_left)
_DEFINE_VALARRAY_OPERATOR(>>, shift_right)

#undef _DEFINE_VALARRAY_OPERATOR

} // std::

#endif /* _CPP_BITS_INDIRECT_ARRAY_H */

// Local Variables:
// mode:c++
// End:
