#define MOVE_FIND_PARAM_ARRAYS
#define POSTCONDITION
#define DISAMB
#define CACHE_OPT
/*
 * balsched.c
 */

#include <stdio.h>
#ifdef DISAMB
#include "config.h"
#include "rtl.h"
#include "basic-block.h"
#include "regs.h"
#include "insn-config.h"
#endif
#ifdef CACHE_OPT
#include "tree.h"
#include "loop.h"
#include "matrices.h"
#endif
#include "predicate.h"
#ifdef CACHE_OPT
#include "nesting.h"
#endif
#include "balsched.h"

extern char *getenv ();

char *balanced_scheduling_enabled = NULL;
char *traditional_scheduling_enabled = NULL;
char *dump_xgrab_output = NULL;
char *dump_xgrab_output2 = NULL;
char *contrib_output = NULL;
char *splitting_enabled = NULL;
char *jlo_splitting_verbose = NULL;
#ifdef DISAMB
char *disambiguation_enabled = NULL;
char *jlo_disambiguation_verbose = NULL;
char *jlo_disambiguation_verbose2 = NULL;
char *jlo_disambiguation_verbose3 = NULL;
char *jlo_disambiguation_verbose4 = NULL;

short *reg_is_param = NULL;
#define NEWDISAMB
#ifdef NEWDISAMB
short *reg_param_num = NULL;
#endif
short *insn_set_param_address = NULL;
#define INSN_SET_PARAM_ADDRESS(INSN) (insn_set_param_address[INSN_UID (INSN)])
short *insn_param_mem_ref = NULL;

#define STACK_ARG_REG_BEFORE_RELOAD   0
#define STACK_ARG_REG_AFTER_RELOAD   29
#ifdef MIPS
#define FIRST_ARG_REG  4
#define LAST_ARG_REG   7
#endif
#ifdef SPARC
#define FIRST_ARG_REG  24
#define LAST_ARG_REG   29
#endif
#endif

#define FRAME_POINTER_REGNO  30
#define STACK_POINTER_REGNO  29
 
#ifdef CACHE_OPT
extern struct nesting *loop_stack;
char *cache_opt_enabled = NULL;
char *cache_opt_peeling_enabled = NULL;
char *cache_opt_unrolling_enabled = NULL;
short *reg_type = NULL;
short *reg_is_address = NULL;
short *insn_checked = NULL;
short *insn_array_ref = NULL;
char *jlo_cache_opt_verbose = NULL;
char *jlo_cache_opt_verbose2 = NULL;
char *peeling_and_unrolling_allowed = NULL;
char *jlo_incorrect_alignment = NULL;
char *jlo_turn_on_all = NULL;
char *jlo_nobsa_spill_code = NULL;
char *gcc_use_co_enabled = NULL;
char *jlo_machine_dependent_weight = NULL;
char *jlo_no_peel_for_spatial = NULL;
int bsa_max_unrolled_insns = 400;

char *jlo_stall_clock = NULL;
char *jlo_weight_atleast_two = NULL;
char *jlo_max_weight = NULL;
int bsa_max_weight = 0;

char *jlo_reverse_heuristic3 = NULL;
char *jlo_preferred_unroll_number = NULL;
int preferred_unroll_number = SPATIAL_UNROLL_NUMBER;
char *jlo_unroll_rename_regs = NULL;
char *jlo_rename_regs_verbose = NULL;

char *jlo_extra_spill_regs = NULL;
#define DEFAULT_EXTRA_SPILL_REGS 2
int extra_spill_regs = DEFAULT_EXTRA_SPILL_REGS;
#ifdef POSTCONDITION
char *postconditioning_enabled = NULL;
#endif
int to_assignment = 0;

/* counters */
unsigned int loops = 0;
unsigned int peeled_loops = 0;
unsigned int unrolled_loops = 0;
unsigned int unattempted_loops = 0;
unsigned int spatial_loops = 0;
unsigned int temporal_loops = 0;
unsigned int cache_opt_hacks = 0;
unsigned int too_big_loops = 0;

#define OUTFILE stdout

#define IS_UNKNOWN          0
#define IS_ARRAY            1
#define IS_INDEX            2
#define IS_VARIABLE         3
#define IS_OTHER            4
#define IS_ARRAY_REF        5
#define NOT_ARRAY_REF       6
#define IS_ADDRESS          7
#define IS_VAR_CONST_SUM    8
#define IS_VAR_OFFSET_SUM   9
#define IS_VAR_VAR_SUM     10 
#define IS_VAR_INDEX_SUM   11
#define IS_2_ASHIFT        12
#define IS_REG             13
#define IS_REG_OFFSET_SUM  14
#define NOT_VARIABLE       15
#define NOT_ADDRESS        16
#define IS_VAR_ADDRESS     17
#define IS_VAR_VAR_ADDR_SUM 18
#define IS_OFFSET           19
#define IS_2_ASHIFT_USERVAR 20
#define IS_ARG_REG          21
#define IS_ARG_OFFSET_SUM   22
#define LAST_TYPE           25
char *reg_type_names[LAST_TYPE] = {"IS_UNKNOWN",
				     "IS_ARRAY",
				     "IS_INDEX",
				     "IS_VARIABLE",
				     "IS_OTHER",
				     "IS_ARRAY_REF",
				     "NOT_ARRAY_REF",
				     "IS_ADDRESS",
				     "IS_VAR_CONST_SUM",
				     "IS_VAR_OFFSET_SUM",
				     "IS_VAR_VAR_SUM",
				     "IS_VAR_INDEX_SUM",
				     "IS_2_ASHIFT",
				     "IS_REG",
				     "IS_REG_OFFSET_SUM",
				     "NOT_VARIABLE",
				     "NOT_ADDRESS",
				     "IS_VAR_ADDRESS",
				     "IS_VAR_VAR_ADDR_SUM",
				     "IS_OFFSET",
				     "IS_2_ASHIFT_USERVAR",
				     "IS_ARG_OFFSET_SUM",
				     "IS_ARG_REG"};

tree *indices;
tree *iterators;
#endif

void balanced_scheduling_init ()
{
  char *temp;

  balanced_scheduling_enabled = getenv ("BALANCED_SCHEDULING");
  if (balanced_scheduling_enabled)
    {
      fprintf (stderr, "Balanced scheduling\t\tenabled\n"); 
    } else {
      traditional_scheduling_enabled = getenv ("TRADITIONAL_SCHEDULING");
      if (traditional_scheduling_enabled)
	fprintf (stderr, "Traditional scheduling\t\tenabled\n"); 
      else
	fprintf (stderr, "GCC scheduling\t\tenabled\n"); 
    }

  dump_xgrab_output = getenv ("XGRAB_OUTPUT");
  if (dump_xgrab_output)
    fprintf (stderr, "Xgrab output\t\tenabled\n");

  dump_xgrab_output2 = getenv ("XGRAB_OUTPUT2");
  if (dump_xgrab_output2)
    fprintf (stderr, "Xgrab output2\t\tenabled\n"); 

  contrib_output = getenv ("CONTRIB_OUTPUT");
  if (contrib_output)
    fprintf (stderr, "contrib output\t\tenabled\n"); 

  splitting_enabled = getenv ("SPLITTING");
  if (splitting_enabled)
    fprintf (stderr, "splitting\t\t\tenabled\n"); 

  jlo_splitting_verbose = getenv ("jlo_splitting_verbose");

#ifdef DISAMB
  disambiguation_enabled = getenv ("DISAMBIGUATION");
  if (disambiguation_enabled)
    fprintf (stderr, "disambiguation\t\t\tenabled\n"); 

  jlo_disambiguation_verbose = getenv ("jlo_disambiguation_verbose");
  jlo_disambiguation_verbose2 = getenv ("jlo_disambiguation_verbose2");
  jlo_disambiguation_verbose3 = getenv ("jlo_disambiguation_verbose3");
  jlo_disambiguation_verbose4 = getenv ("jlo_disambiguation_verbose4");
#endif

#ifdef CACHE_OPT
  cache_opt_enabled = getenv ("CACHE_OPT");
  if (cache_opt_enabled)
    fprintf (stderr, "cache optimization\t\tenabled\n");

  cache_opt_peeling_enabled = getenv ("CACHE_OPT_PEELING");
  if (cache_opt_peeling_enabled)
    fprintf (stderr, "cache optimization peeling\tenabled\n"); 

  cache_opt_unrolling_enabled = getenv ("CACHE_OPT_UNROLLING");
  if (cache_opt_unrolling_enabled)
    fprintf (stderr, "cache optimization unrolling\tenabled\n"); 


  jlo_cache_opt_verbose = getenv ("jlo_cache_opt_verbose");
  jlo_cache_opt_verbose2 = getenv ("jlo_cache_opt_verbose2");
  jlo_incorrect_alignment = getenv ("jlo_incorrect_alignment");
  if (jlo_incorrect_alignment)
    fprintf (stderr, "incorrect_alignment option set\n");

  jlo_turn_on_all = getenv ("jlo_turn_on_all");
  if (jlo_turn_on_all)
    {
      fprintf (stderr, "turning on BSA for all loads\n");
    }

  jlo_nobsa_spill_code = getenv ("jlo_nobsa_spill_code");
  if (jlo_nobsa_spill_code)
    {
      fprintf (stderr, "turning off BSA for spill code\n");
    }

  gcc_use_co_enabled = getenv ("gcc_use_co");
  if (gcc_use_co_enabled)
    {
      fprintf (stderr, "gcc scheduler using cache opt information\n");
    }

  jlo_machine_dependent_weight = getenv ("jlo_machine_dependent_weight");
  if (jlo_machine_dependent_weight)
    {
      fprintf (stderr, "weights are machine dependent\n");
    }

  jlo_stall_clock = getenv ("jlo_stall_clock");
  if (jlo_stall_clock)
    {
      fprintf (stderr, "list scheduler will increment clock on stalls\n");
    }

  jlo_reverse_heuristic3 = getenv ("jlo_reverse_heuristic3");
  if (jlo_reverse_heuristic3)
    {
      fprintf (stderr, "list scheduler is using reversed heuristic 3\n");
    }

  jlo_weight_atleast_two = getenv ("jlo_weight_atleast_two");
  if (jlo_weight_atleast_two)
    {
      fprintf (stderr, "list scheduler assumes load costs are at least two\n");
    }

  jlo_max_weight = getenv ("jlo_max_weight");
  if (jlo_max_weight)
    {
      bsa_max_weight = atoi (jlo_max_weight);
      fprintf (stderr, "max_weight:\t\t%d\n",
	       bsa_max_weight);
    }

  if (temp = getenv ("bsa_max_unrolled_insns"))
    {
      bsa_max_unrolled_insns = atoi (temp);
      fprintf (stderr, "bsa_max_unrolled_insns:\t\t%d\n", 
	       bsa_max_unrolled_insns); 
    }

  jlo_no_peel_for_spatial = getenv ("jlo_no_peel_for_spatial");
  if (jlo_no_peel_for_spatial)
    {
      fprintf (stderr, "disabling peeling to support spatial locality\n");
    }

  peeling_and_unrolling_allowed = getenv ("peeling_and_unrolling_allowed");
  if (peeling_and_unrolling_allowed)
    fprintf (stderr, "peeling_and_unrolling\t\tenabled\n"); 
#endif

  jlo_preferred_unroll_number = getenv ("jlo_preferred_unroll_number");
  if (jlo_preferred_unroll_number)
    {
      preferred_unroll_number = atoi (jlo_preferred_unroll_number);
    }
  fprintf (stderr, "preferred_unroll_number:\t\t%d\n",
	   preferred_unroll_number);

  jlo_unroll_rename_regs = getenv ("jlo_unroll_rename_regs");
  if (jlo_unroll_rename_regs)
    {
      fprintf (stderr, "Reg Renaming during loop unrolling enabled\n");
    }

  jlo_rename_regs_verbose = getenv ("jlo_rename_regs_verbose");

#ifdef POSTCONDITION
  postconditioning_enabled = getenv ("postconditioning");
  if (postconditioning_enabled)
    fprintf (stderr, "postconditioning\t\tenabled\n"); 
#endif

  jlo_extra_spill_regs = getenv ("jlo_extra_spill_regs");
  if (jlo_extra_spill_regs)
    {
      extra_spill_regs = atoi (jlo_extra_spill_regs);
    }
  fprintf (stderr, "extra_spill_regs:\t\t%d\n",
	   extra_spill_regs);

}


#ifdef DISAMB
static int
is_stack_arg_reg (op, insn)
     rtx op;
     rtx insn;
{
  if (GET_CODE (op) == REG)
    {
      if (reload_completed)
	return ((REGNO (op) == STACK_ARG_REG_AFTER_RELOAD) &&
		(strcmp (reg_names[REGNO (op)], "$sp") == 0) &&
		(INSN_SET_PARAM_ADDRESS (insn)));
      else
	return ((REGNO (op) == STACK_ARG_REG_BEFORE_RELOAD) &&
		(strcmp (reg_names[REGNO (op)], "$0") == 0));

    } else {
      return FALSE;
    }
}

static int
is_arg_reg (src)
     rtx src;
{
  if (GET_CODE (src) == REG)
    {
      if (REGNO (src) >= FIRST_PSEUDO_REGISTER)
	{
	  if (IS_PARAM (REGNO (src)) != UNKNOWN)
	    {
#define NEWDISAMB
#ifdef NEWDISAMB
	      if (IS_PARAM (REGNO (src)))
		return reg_param_num [REGNO (src)];
	      else 
		return FALSE;
#else
	      return IS_PARAM (REGNO (src));
#endif
	    } else {

#ifdef NEWDISAMB
	      return LAST_ARG_REG - FIRST_ARG_REG + 2;
	      /* This number is used for all parameters passed on the
		 stack */
#else	      
	      return TRUE;
#endif
	    }
	} else {
	  if ((REGNO (src) >= FIRST_ARG_REG) &&
	      (REGNO (src) <= LAST_ARG_REG))
/*	  if ((strcmp (reg_names[REGNO (src)], "a0") == 0) ||
	      (strcmp (reg_names[REGNO (src)], "a1") == 0) ||
	      (strcmp (reg_names[REGNO (src)], "a2") == 0) ||
	      (strcmp (reg_names[REGNO (src)], "a3") == 0))
*/
	    {
#define NEWDISAMB
#ifdef NEWDISAMB
	      return (REGNO (src) - FIRST_ARG_REG + 1);
	      /* return the parameter number */
#else
	      return TRUE;
#endif
	    } else {
	      if (IS_PARAM (REGNO (src)) != UNKNOWN)
		{
#define NEWDISAMB
#ifdef NEWDISAMB
		  if (IS_PARAM (REGNO (src)))
		    return reg_param_num [REGNO (src)];
		  else 
		    return FALSE;
#else
		  return IS_PARAM (REGNO (src));
#endif
		} else {
#ifdef NEWDISAMB
	      return LAST_ARG_REG - FIRST_ARG_REG + 2;
	      /* This number is used for all parameters passed on the
		 stack */
#else	      
		  return TRUE;
#endif
		}
	    }
	}
    } else {
      return FALSE;
    }
}

static int
is_param (src, insn)
     rtx src;
     rtx insn;
{
  rtx op0, op1;
  int param_num;
  /* Recursively figure out whether the src pattern is a parameter*/
  if (GET_CODE (src) == REG)
    {
      if (param_num = is_arg_reg (src))
	{
	  if (reload_completed == 0)
	    {
	      INSN_SET_PARAM_ADDRESS (insn) = 1;
	      if (jlo_disambiguation_verbose2)
		fprintf (stderr, "Set_param_address for insn %d\n", 
			 INSN_UID (insn));;
	    }
#ifdef NEWDISAMB
	  return param_num;
#else
	  return TRUE;
#endif
	} else {
	  if (IS_PARAM (REGNO (src)) != UNKNOWN)
	    {
#ifdef NEWDISAMB
	      if (IS_PARAM (REGNO (src)))
		return param_num;
	      else
		return 0;
#else
	      return IS_PARAM (REGNO (src));
#endif
	    } else {
	      /* Not set yet, so assume it is. It'll get cancelled later*/
#ifdef NEWDISAMB
	      return param_num;
#else
	      return TRUE;
#endif
	    }
	}
    }
  if (GET_CODE (src) == PLUS)
    {
      /* Arrays are sometimes passed in a0 and then first ref to it
	 is a load with a constant offset to an element. */
      op0 = XEXP (src, 0);
      op1 = XEXP (src, 1);

      /* This works but doesn't include as many cases
	 if ((is_arg_reg (op0) && 
	   (IS_PARAM (REGNO (op0)) != NOT_PARAM) && 
	   (GET_CODE (op1) == CONST_INT)) || 
	  (is_arg_reg (op1) && 
	   (IS_PARAM (REGNO (op1)) != NOT_PARAM) &&
	   (GET_CODE (op0) == CONST_INT)))*/

      if ((param_num = is_arg_reg (op0)) && 
	  (IS_PARAM (REGNO (op0)) != NOT_PARAM) && 
	  ((GET_CODE (op1) == CONST_INT) ||
	   (GET_CODE (op1) == REG)))
	{
	  if (reload_completed == 0)
	    {
	      INSN_SET_PARAM_ADDRESS (insn) = 1;
	      if (jlo_disambiguation_verbose2)
		fprintf (stderr, "Set_param_address for insn %d\n", 
			 INSN_UID (insn));;
	    }
	  return param_num;
	}
      if ((param_num = is_arg_reg (op1)) && 
	  (IS_PARAM (REGNO (op1)) != NOT_PARAM) &&
	  ((GET_CODE (op0) == CONST_INT) ||
	   (GET_CODE (op0) == REG)))
	{
	  if (reload_completed == 0)
	    {
	      INSN_SET_PARAM_ADDRESS (insn) = 1;
	      if (jlo_disambiguation_verbose2)
		fprintf (stderr, "Set_param_address for insn %d\n", 
			 INSN_UID (insn));;
	    }
	  return param_num;
	}
      return FALSE;
    }

  /* Before reloading, if a source is a 
     (mem:SI (plus:SI (reg:SI 0 $0) (const_int xx))), then
     it's a parameter argument that had to be placed on the stack */
  /* It's insn will also have a REG_EQUIV note attached to it */
  
  if (GET_CODE (src) == MEM)
    {
      if (GET_CODE (XEXP (src, 0)) == PLUS)
	{
	  op0 = XEXP (XEXP (src, 0), 0);
	  op1 = XEXP (XEXP (src, 0), 1);

	  if (reload_completed == 0)
	    {
	      if (((GET_CODE (op1) == CONST_INT) &&
		   (is_stack_arg_reg (op0, insn))) ||
		  ((GET_CODE (op0) == CONST_INT) &&
		   (is_stack_arg_reg (op1, insn))))
		{
		  INSN_SET_PARAM_ADDRESS (insn) = 1;
		  if (jlo_disambiguation_verbose2)
		    fprintf (stderr, "Set_param_address for insn %d\n", 
			 INSN_UID (insn));;
#ifdef NEWDISAMB
		  return LAST_ARG_REG -FIRST_ARG_REG + 2;
#else
		  return TRUE;
#endif
		}
	    } else {
	      if (INSN_SET_PARAM_ADDRESS (insn))
		{
		  if (jlo_disambiguation_verbose2)
		    fprintf (stderr, 
			     "Src is param because of SET_PARAM_ADDRESS \n", 
			     INSN_UID (insn));
#ifdef NEWDISAMB
		  return LAST_ARG_REG -FIRST_ARG_REG + 2;
#else
		  return TRUE;
#endif
		} else {
		  if (jlo_disambiguation_verbose2)
		    fprintf (stderr, "Ignoring mem set insn %d\n",
			     INSN_UID (insn));
		  return FALSE;
		}
	    }
	}
    }
  return FALSE;
}

void find_param_arrays ()
{
  int b;
  rtx head, tail;
  rtx insn;
  rtx link;
  rtx src, dest;
  int conflicts = 0;
  int conflicts2 = 0;
  int max_uid = MAX_INSNS_PER_SPLIT * (get_max_uid () + 1);
  int param_num = 0;

/*  n_basic_blocks
    basic_block_head
    basic_block_end
*/

#ifndef MOVE_FIND_PARAM_ARRAYS
  reg_is_param = (short *) alloca (max_regno * sizeof (short));
  bzero (reg_is_param, max_regno * sizeof (short));
  reg_param_num = (short *) alloca (max_regno * sizeof (short));
  bzero (reg_param_num, max_regno * sizeof (short));
/* Move this to toplev, so that it's not deallocated.
   if (reload_completed == 0)
    {
      insn_set_param_address = (short *) alloca (max_uid * sizeof (short));
      bzero (insn_set_param_address, max_uid * sizeof (short));
    }*/
#endif

  for (insn = basic_block_head[0]; insn; insn = NEXT_INSN (insn))
    {
      /* Keep an rtx list of regs that are set to
	 non-param arrays, and an rtx list of regs that are set to
	 param arrays */
      if ((GET_CODE (insn) == INSN) &&
	  (GET_CODE (PATTERN (insn)) == SET))
	{
	  if (GET_CODE (SET_DEST (PATTERN (insn))) == REG)
	    {
	      src = SET_SRC (PATTERN (insn));
	      dest = SET_DEST (PATTERN (insn));
	      if ((GET_CODE (src) == REG) &&
		  (IS_PARAM (REGNO (src)) != UNKNOWN))
		{
		  if (IS_PARAM (REGNO (src)) == NOT_PARAM)
		    {
		      IS_PARAM (REGNO (dest)) = NOT_PARAM;
		      reg_param_num [REGNO (dest)] = 0;
		      if (jlo_disambiguation_verbose2)
			{
			  fprintf (stderr, "Regno %d put into NOT_param list ",
				   REGNO (dest));
			  fprintf (stderr, "because of status of Regno %d\n", 
				   REGNO (src));
			}
		    } else {
		      /* IS_PARAM (REGNO (dest)) stays the same */
		      if (jlo_disambiguation_verbose2)
			{
			  fprintf (stderr, "Regno %d stays the same because of status of Regno %d\n",
				   REGNO (dest), REGNO (src));
			}
		    }
		} else {
		  if (param_num = is_param (src, insn))
		    {
		      switch (IS_PARAM (REGNO (dest)))
			{
			case PARAM:
			  /* already in param list, so don't do anything */
			  if (jlo_disambiguation_verbose2)
			    fprintf (stderr, "Regno %d already in is_param list\n",
				     REGNO (dest));
			  break;
			case NOT_PARAM:
			  /* already in not param list, so we conservatively
			     assume that it's not a param */
			  /* Sometimes conflicts aren't bad, since it'll be
			     a not_param that gets a constant added to it */
			  if (jlo_disambiguation_verbose2)
			    {
			      fprintf (stderr, "Regno %d already in NOT_param list...",
				       REGNO (dest));
			      fprintf (stderr, "not moved even though src is ok.\n");
			    }
			  conflicts2++;
			  break;
			case UNKNOWN:
			  if (jlo_disambiguation_verbose2)
			    fprintf (stderr, "Adding Regno %d to is_param list\n",
				     REGNO (dest));
			  IS_PARAM (REGNO (dest)) = PARAM;
			  reg_param_num[REGNO (dest)] = param_num;
			  break;
			}
		    } else {
		      switch (IS_PARAM (REGNO (dest)))
			{
			case NOT_PARAM:
			  /* It's already in the not param list, so don't do
			     anything */
			  if (jlo_disambiguation_verbose2)
			    fprintf (stderr, "Regno %d already in NOT_param list\n",
				     REGNO (dest));
			  break;
			case PARAM:

			  if ((REGNO (dest) < FIRST_ARG_REG) ||
			      (REGNO (dest) > LAST_ARG_REG))
			    {
			      if (jlo_disambiguation_verbose2)
				fprintf (stderr, "Moving Regno %d to NOT_param list\n",
					 REGNO (dest));

			      conflicts++;
			      IS_PARAM (REGNO (dest)) = NOT_PARAM; 
			      reg_param_num[REGNO (dest)] = 0;
			    }
			  break;
			case UNKNOWN:

			  if (jlo_disambiguation_verbose2)
			    fprintf (stderr, "Adding Regno %d to NOT_param list\n",
				     REGNO (dest));

			  IS_PARAM (REGNO (dest)) = NOT_PARAM; 
			  break;
			}
		    }
		}
	    }
	}
    }
  if (jlo_disambiguation_verbose)
    {
      fprintf (stderr, "Conflicts found: %d\n", conflicts);
      fprintf (stderr, "Conflicts2 found: %d\n", conflicts2);
    }
}


int
is_fp_or_sp (op)
     rtx op;
{
  return ((REGNO (op) == FRAME_POINTER_REGNO) ||
	  (REGNO (op) == STACK_POINTER_REGNO));
}


void
check_insn (insn)
     rtx insn;
{
  rtx dest, src;
  int result;

  if (jlo_cache_opt_verbose)
    {
      fprintf (OUTFILE, "Check_insn for insn %d\n", INSN_UID (insn));
    }
  /* Use a reverse traversal of insns and use LOG_LINKS to find the
     contents of registers */
  /* Done before reg allocation, so a register will be used for the
     same thing throughout */
  
  if ((GET_CODE (insn) == INSN) &&
      (GET_CODE (PATTERN (insn)) == SET))
    {
      dest = SET_DEST (PATTERN (insn));
      src = SET_SRC (PATTERN (insn));
      if (GET_CODE (dest) == REG)
	{ 
	  if (REG_TYPE (REGNO (dest)) == IS_UNKNOWN)
	    {
	      if (REG_USERVAR_P (dest))
		{
		  if (jlo_cache_opt_verbose)
		    fprintf (OUTFILE, "Regno %d IS_VARIABLE\n",
			     REGNO (dest));
		  REG_TYPE (REGNO (dest)) = IS_VARIABLE;
		} else {
		  if (jlo_cache_opt_verbose)
		    fprintf (OUTFILE, "Regno %d IS_UNKNOWN in check_insn\n",
			     REGNO (dest));
		}
	    } else {
	      switch (check_pattern (src, insn))
		{
		case IS_ARRAY:
		  if (jlo_cache_opt_verbose)
		    fprintf (OUTFILE, "Insn %d IS_ARRAY_REF\n",
			     INSN_UID (insn));
		  INSN_ARRAY_REF (INSN_UID (insn)) = IS_ARRAY_REF;
		  break;
		case IS_INDEX:
		  if (jlo_cache_opt_verbose)
		    fprintf (OUTFILE, "Regno %d IS_INDEX\n",
			     REGNO (dest));
		  REG_TYPE (REGNO (dest)) = IS_INDEX;
		  break;
		case IS_VARIABLE:
		  if (jlo_cache_opt_verbose)
		    fprintf (OUTFILE, "Regno %d IS_VARIABLE\n",
			     REGNO (dest));
		  REG_TYPE (REGNO (dest)) = IS_VARIABLE;
		  break;
		default:
		  if (jlo_cache_opt_verbose)
		    fprintf (OUTFILE, "Regno %d is neither\n",
			     REGNO (dest));
		  REG_TYPE (REGNO (dest)) = IS_OTHER;
		  break;
		}
	    }
	}
      if (GET_CODE (dest) == MEM)
	{
	  result = check_pattern (src, insn);
	  if (jlo_cache_opt_verbose)
	    fprintf (OUTFILE, "check_pattern returned %s\n", 
		     reg_type_names[result]);
	  switch (result)
	    {
	    case IS_INDEX:
	      if (jlo_cache_opt_verbose)
		fprintf (OUTFILE, "Insn %d IS_ARRAY_REF\n",
			 INSN_UID (insn));
	      INSN_ARRAY_REF (INSN_UID (insn)) = IS_ARRAY_REF;
	      break;
	    case IS_VARIABLE:
	    default:
	      if (jlo_cache_opt_verbose)
		fprintf (OUTFILE, "Insn %d not_array_ref\n",
			 INSN_UID (insn));
	      INSN_ARRAY_REF (INSN_UID (insn)) = NOT_ARRAY_REF;
	      break;
	    }
	}
    }
  INSN_CHECKED (INSN_UID (insn)) = CHECKED;
}


void
check_links (insn)
     rtx insn;
{
  rtx link, elem;

  /* Go up LOG_LINKS chain to find out */
  for (link = LOG_LINKS (insn); link; link = XEXP (link, 1))
    {
      elem = XEXP (link, 0);
      /* If an insn has already been checked, then it can't
	 be one that will help us determine the type of this
	 register, otherwise it would have already told us so */
      
      if (INSN_CHECKED (INSN_UID (insn)) == NOT_CHECKED)
	check_insn (elem); 
    }
}
/* 
 * Sets the status of registers contained in the pattern op
 */
 
void
set_reg (op, insn)
     rtx op, insn;
{

  switch (GET_CODE (op))
    {
    case REG:
      if (REG_TYPE (REGNO (op)) == IS_UNKNOWN)
	  {
	    if (REG_LOOP_TEST_P (op))
	      {
		/* contained in loop test */
		if (jlo_cache_opt_verbose)
		  fprintf (OUTFILE, "Regno %d set to NEITHER because of REG_LOOP_TEST_P\n",
			   REGNO (op));
		REG_TYPE (REGNO (op)) = IS_OTHER;
	      } else {
/*		check_links (insn);*/
		if (REG_TYPE (REGNO (op)) == IS_UNKNOWN)
		  {
		    if (jlo_cache_opt_verbose)
		      fprintf (OUTFILE, "Regno %d still unknown after LOG_LINKS in INSN %d\n",
			       REGNO (op), INSN_UID (insn));
		  }
		
	      }
	  }
      break;
    case CONST_INT:
      return;
      break;
    }
}

void
set_regs_is_address (op, insn, type)
     rtx op, insn;
     int type;
{
  rtx op0, op1;

  switch (GET_CODE (op))
    {
    case REG:
      if (REG_IS_ADDRESS (REGNO (op)) != type)
	if (jlo_cache_opt_verbose)
	  fprintf (OUTFILE, "Regno %d previously of type %s\n",
		   REGNO (op), reg_type_names[REG_IS_ADDRESS (REGNO (op))]);

      REG_IS_ADDRESS (REGNO (op)) = type;
      if (jlo_cache_opt_verbose)
	fprintf (OUTFILE, "Regno %d set to type %s\n",
		 REGNO (op),
		 reg_type_names[type]);
      break;
    case ASHIFT:
    case PLUS:
      op0 = XEXP (op, 0);
      op1 = XEXP (op, 1);
      if ((op0) && (GET_CODE (op0) == REG))
	{
	  if (REG_IS_ADDRESS (REGNO (op0)) != type)
	    if (jlo_cache_opt_verbose)
	      fprintf (OUTFILE, "Regno %d previously of type %s\n",
		       REGNO (op0), 
		       reg_type_names[REG_IS_ADDRESS (REGNO (op0))]);

	  REG_IS_ADDRESS (REGNO (op0)) = type;
	  if (jlo_cache_opt_verbose)
	    fprintf (OUTFILE, "Regno %d set to type %s\n",
		     REGNO (op0),
		     reg_type_names[type]);

	}
      if ((op1) && (GET_CODE (op1) == REG))
	{
	  if (REG_TYPE (REGNO (op0)) == IS_VAR_ADDRESS)
	    {
	      /* Adding a reg to a variable's base address, so this
		 reg is an offset */
	      type = IS_OFFSET;
	    }
	  if (REG_IS_ADDRESS (REGNO (op1)) != type)
	    if (jlo_cache_opt_verbose)
	      fprintf (OUTFILE, "Regno %d previously of type %s\n",
		       REGNO (op1), 
		       reg_type_names[REG_IS_ADDRESS (REGNO (op1))]);
	  
	  REG_IS_ADDRESS (REGNO (op1)) = type;
	  if (jlo_cache_opt_verbose)
	    fprintf (OUTFILE, "Regno %d set to type %s\n",
		     REGNO (op1),
		     reg_type_names[type]);
	}
      break;
    default:
      break;
    }
}

/*
 * Checks the insn pattern and if necessary, recursively determines
 * the status of the registers in the pattern.
 * It returns a flag that indicates what this pattern corresponds to,
 * i.e., if reg 1 is set to this pattern r, then the status of reg 1 
 * will be returned. 
 */

int
check_pattern (r, insn)
     rtx r, insn;
{
  rtx op0, op1;
  int temp;

  op0 = XEXP (r, 0);
  op1 = XEXP (r, 1);
  switch (GET_CODE (r))
    {
    case CONST:
    case CONST_INT:
      return IS_OTHER;
    case PLUS:
      if (GET_CODE (op0) == REG)
	{
	  switch (GET_CODE (op1))
	    {
	    case CONST_INT:
	      if (is_fp_or_sp (op0))
		return IS_VAR_ADDRESS;
	      else 
		if (REG_USERVAR_P (op0))
		  return IS_VAR_CONST_SUM;
	      if (REG_TYPE (REGNO (op0)) == IS_VARIABLE)
		return IS_VAR_OFFSET_SUM;
	      if (REG_TYPE (REGNO (op0)) == IS_VAR_ADDRESS)
		return IS_VAR_VAR_ADDR_SUM;
	      if (is_arg_reg (op0))
		return IS_ARG_OFFSET_SUM;
	      else 
		return IS_REG_OFFSET_SUM;
	      break;
	    case REG:
	      if ((REG_TYPE (REGNO (op0)) == IS_VARIABLE) &&
		  (REG_TYPE (REGNO (op1)) == IS_VARIABLE))
		{
		  if (((REG_IS_ADDRESS (REGNO (op0)) == IS_ADDRESS) &&
		       (REG_IS_ADDRESS (REGNO (op1)) != IS_ADDRESS)) ||
		      ((REG_IS_ADDRESS (REGNO (op1)) == IS_ADDRESS) &&
		       (REG_IS_ADDRESS (REGNO (op0)) != IS_ADDRESS)))
		    return IS_VAR_VAR_ADDR_SUM;
		  else
		    return IS_VAR_VAR_SUM;
		}
	      if (((REG_TYPE (REGNO (op0)) == IS_VARIABLE) &&
		  (REG_TYPE (REGNO (op1)) == IS_VAR_ADDRESS)) ||
		  ((REG_TYPE (REGNO (op1)) == IS_VARIABLE) &&
		   (REG_TYPE (REGNO (op0)) == IS_VAR_ADDRESS)))
		return IS_VAR_VAR_ADDR_SUM;
	      if (((REG_TYPE (REGNO (op0)) == IS_VARIABLE) &&
		   (REG_TYPE (REGNO (op1)) == IS_INDEX)) ||
		  ((REG_TYPE (REGNO (op1)) == IS_VARIABLE) &&
		   (REG_TYPE (REGNO (op0)) == IS_INDEX)))
		return IS_VAR_INDEX_SUM;
	      break;
	    }
	} else {
	  if (op0)
	    set_reg (op0, insn);
	  if (op1 && (op0 != op0))
	    set_reg (op1, insn); 
/*	  else
	    Adding something to myself
	    if set_reg determines op0 is a reg
	    return; */
	}
      break;
    case ASHIFT:
      if ((GET_CODE (op0) == REG) && 
	  ((REG_TYPE (REGNO (op0)) == IS_VARIABLE) || 
	   (REG_TYPE (REGNO (op0)) == IS_INDEX)))
	{
	  if (GET_CODE (op1) == CONST_INT)
	    {
	      temp = XINT (op1, 0);
	      if (temp == 2) 
		if (REG_USERVAR_P (op0)) 
		  {
		    REG_TYPE (REGNO (op0)) = IS_INDEX;
		    if (jlo_cache_opt_verbose)
		      fprintf (OUTFILE, "Regno %d IS_INDEX\n",
			       REGNO (op0));
		    return IS_2_ASHIFT_USERVAR;
		  } else
		    return IS_2_ASHIFT;
/*		return REG_TYPE (REGNO (op0));*/
	    }
	}
      return IS_OTHER;
      break;
    case REG:
      if (REG_TYPE (REGNO (r)) != IS_UNKNOWN)
	{
	  return REG_TYPE (REGNO (r));
	} else {
	  if (is_arg_reg (r))
	    return IS_ARG_REG;
/*	  check_links (insn);*/
	  return IS_REG;
/*	  if (REG_TYPE (REGNO (r)) == IS_UNKNOWN)
	    {
	      if (jlo_cache_opt_verbose)
		fprintf (OUTFILE, "Regno %d still unknown after LOG_LINKS in INSN %d\n",
			 REGNO (r), INSN_UID (insn));
	    }
	  */
	}
      break;
    case MEM:
      if (MEM_IN_STRUCT_P (r))
	{
	  set_reg (op0, insn);
	  /* might be an array */
	  if ((GET_CODE (op0) == REG) && 
	      (REG_TYPE (REGNO (op0)) == IS_INDEX))
	    {
	      return IS_ARRAY;
	    }
	  /* This is still not done */
	} else {
	  /* can't be an array */
	  return IS_OTHER;
	}
      break;
    case SYMBOL_REF:
      if (op0)
	set_reg (op0, insn);
      return IS_OTHER;
      break;
    default:
      if (op0)
	set_reg (op0, insn);
      if (op1)
	set_reg (op1, insn);
      return IS_OTHER;
      break;
    }
}

void
find_addresses (insn)
     rtx insn;
{
  rtx dest, src;
  rtx reg;
  int result;

  if ((GET_CODE (insn) == INSN) &&
      (GET_CODE (PATTERN (insn)) == SET))
    {
      dest = SET_DEST (PATTERN (insn));
      src = SET_SRC (PATTERN (insn));

      if ((GET_CODE (dest) == MEM) &&
	  (GET_CODE (src) == REG))
	{
	  reg = XEXP (dest, 0);
	  if (GET_CODE (reg) == REG)
	    {
	      REG_IS_ADDRESS (REGNO (reg)) = IS_ADDRESS;
	      if (jlo_cache_opt_verbose)
		fprintf (OUTFILE, "Regno %d IS_ADDRESS\n",
			 REGNO (reg));
	      REG_IS_ADDRESS (REGNO (src)) = NOT_ADDRESS;
	      if (jlo_cache_opt_verbose)
		fprintf (OUTFILE, "Regno %d NOT_ADDRESS\n",
			 REGNO (src));
	    } else {
	      result = check_pattern (dest, insn);
	      if (jlo_cache_opt_verbose)
		fprintf (OUTFILE, "check_pattern returned %s\n", 
			 reg_type_names[result]);
	      switch (result)
		{
		case IS_VAR_CONST_SUM:
		case IS_REG_OFFSET_SUM:
		  REG_IS_ADDRESS (REGNO (reg)) = IS_ADDRESS;
		  if (jlo_cache_opt_verbose)
		    fprintf (OUTFILE, "Regno %d IS_ADDRESS\n",
			     REGNO (reg));
		  break;
		default:
		  if (jlo_cache_opt_verbose)
		    fprintf (OUTFILE, "MEM is indexed by more than just a VAR CONST, insn %d\n", INSN_UID (insn));
		  break;
		}
	    }
	  return;
	}
      if ((GET_CODE (src) == MEM) &&
	  (GET_CODE (dest) == REG))
	{
	  reg = XEXP (src, 0);
	  if (GET_CODE (reg) == REG)
	    {
	      REG_IS_ADDRESS (REGNO (reg)) = IS_ADDRESS;
	      if (jlo_cache_opt_verbose)
		fprintf (OUTFILE, "Regno %d IS_ADDRESS\n",
			 REGNO (reg));
	      REG_IS_ADDRESS (REGNO (dest)) = NOT_ADDRESS;
	      if (jlo_cache_opt_verbose)
		fprintf (OUTFILE, "Regno %d NOT_ADDRESS\n",
			 REGNO (dest));
	    } else {
	      result = check_pattern (src, insn);
	      if (jlo_cache_opt_verbose)
		fprintf (OUTFILE, "check_pattern returned %s\n", 
			 reg_type_names[result]);
	      switch (result)
		{
		case IS_VAR_CONST_SUM:
		  REG_IS_ADDRESS (REGNO (dest)) = IS_ADDRESS;
		  if (jlo_cache_opt_verbose)
		    fprintf (OUTFILE, "Regno %d IS_ADDRESS\n",
			     REGNO (reg));
		  break;
		default:
		  if (jlo_cache_opt_verbose)
		    fprintf (OUTFILE, "src MEM is indexed by more than just a reg, insn %d\n", INSN_UID (insn));
		  break;
		}
	    }
	  return;
	}
      if (GET_CODE (dest) == REG)
	{
	  result = check_pattern (src, insn);
	  if (jlo_cache_opt_verbose)
	    fprintf (OUTFILE, "check_pattern returned %s\n", 
		     reg_type_names[result]);
	  if (REG_IS_ADDRESS (REGNO (dest)) == IS_ADDRESS)
	    {
	      switch (result)
		{
		case IS_VAR_VAR_ADDR_SUM:
		case IS_VAR_OFFSET_SUM:
		case IS_VAR_CONST_SUM:
		  if (jlo_cache_opt_verbose)
		    fprintf (OUTFILE, "Regno %d already IS_ADDRESS\n",
			     REGNO (dest));
		  set_regs_is_address (src, insn, IS_ADDRESS);
		  break;
		case IS_REG:
		case IS_VAR_VAR_SUM:
		case IS_2_ASHIFT:
		  if (jlo_cache_opt_verbose)
		    fprintf (OUTFILE, "Regno %d already IS_ADDRESS\n",
			     REGNO (dest));
		  /* The src register should be an index, 
		     but not an address */
		  set_regs_is_address (src, insn, NOT_ADDRESS);
		  break;
		case IS_2_ASHIFT_USERVAR:
		  if (jlo_cache_opt_verbose)
		    fprintf (OUTFILE, "Regno %d IS_ADDRESS moving to IS_OFFSET\n",
			     REGNO (dest));
		  REG_IS_ADDRESS (REGNO (dest)) = IS_OFFSET;
		  break;
		case IS_ARG_REG:
		  /* Don't do anything, but don't print a message about it*/
		  break;
		default:
		  if (jlo_cache_opt_verbose)
		    {
		      fprintf (OUTFILE, "Regno %d already IS_ADDRESS, but ",
			       REGNO (dest));
		      fprintf (OUTFILE, "Default case for insn %d is doing nothing\n", INSN_UID (insn)); 
		    }
		  break;
		}
	    } else {
	      switch (result)
		{
		case IS_VAR_VAR_ADDR_SUM:
		case IS_VAR_OFFSET_SUM:
		case IS_VAR_ADDRESS:
		case IS_ARG_OFFSET_SUM:
		  if (jlo_cache_opt_verbose)
		    fprintf (OUTFILE, "Regno %d probably IS_ADDRESS\n",
			     REGNO (dest));
		  REG_IS_ADDRESS (REGNO (dest)) = IS_ADDRESS;
		  break;
		case IS_2_ASHIFT_USERVAR:
		  if (jlo_cache_opt_verbose)
		    fprintf (OUTFILE, "Regno %d IS_OFFSET\n",
			     REGNO (dest));
		  REG_IS_ADDRESS (REGNO (dest)) = IS_OFFSET;
		  break;
		case IS_2_ASHIFT:
		  if (REG_IS_ADDRESS (REGNO (dest)) != IS_UNKNOWN)
		    {
		      if (jlo_cache_opt_verbose)
			fprintf (OUTFILE, "Regno %d being kept as %s\n",
				 REGNO (dest),
				 reg_type_names[REG_IS_ADDRESS (REGNO (dest))]);
		      break;
		    }
		  /* Otherwise, fall through to the default */
		case IS_REG_OFFSET_SUM:
		default:
		  if (jlo_cache_opt_verbose)
		    fprintf (OUTFILE, "Regno %d IS_NOT_ADDRESS\n",
			     REGNO (dest));
		  REG_IS_ADDRESS (REGNO (dest)) = NOT_ADDRESS;
		}
	    }
	}
    }
}

void
find_variables (insn)
     rtx insn;
{
  rtx dest, src;
  int result;

  if ((GET_CODE (insn) == INSN) &&
      (GET_CODE (PATTERN (insn)) == SET))
    {
      dest = SET_DEST (PATTERN (insn));
      src = SET_SRC (PATTERN (insn));
      if (GET_CODE (dest) == REG)
	{
	  if (REG_TYPE (REGNO (dest)) != IS_UNKNOWN)
	    return;

	  if (REG_USERVAR_P (dest))
	    {
	      if (jlo_cache_opt_verbose)
		fprintf (OUTFILE, "Regno %d IS_VARIABLE\n",
			 REGNO (dest));
	      REG_TYPE (REGNO (dest)) = IS_VARIABLE;
	    } else {
	      result = check_pattern (src, insn);
	      if (jlo_cache_opt_verbose)
		fprintf (OUTFILE, "check_pattern returned %s\n", 
			 reg_type_names[result]);
	      switch (result)
		{
		case IS_ARRAY:
		  if (jlo_cache_opt_verbose)
		    fprintf (OUTFILE, "Regno %d IS_ARRAY\n",
			     REGNO (dest));
		  REG_TYPE (REGNO (dest)) = NOT_VARIABLE;
		  break;
		case IS_INDEX:
		  if (jlo_cache_opt_verbose)
		    fprintf (OUTFILE, "Regno %d IS_INDEX, setting to VARIABLE\n",
			     REGNO (dest));
		  REG_TYPE (REGNO (dest)) = IS_VARIABLE;
		  break;
		case IS_VAR_ADDRESS:
		  if (jlo_cache_opt_verbose)
		    fprintf (OUTFILE, "Regno %d IS_VAR_ADDRESS\n",
			     REGNO (dest));
		  REG_TYPE (REGNO (dest)) = IS_VAR_ADDRESS;
		  break;
		case IS_VAR_CONST_SUM:
		  if (GET_CODE (XEXP (src, 0)) == REG)
		    {
		      if (REG_TYPE (REGNO (XEXP (src, 0))) == IS_INDEX)
			{
			  if (jlo_cache_opt_verbose)
			    fprintf (OUTFILE, "Regno %d IS_INDEX\n",
				     REGNO (dest));
			  REG_TYPE (REGNO (dest)) = IS_INDEX;
			  break;
			}
		    }
		  /* else, fall through to next case statement (make it
		     a variable) */ 
		case IS_VARIABLE:
		case IS_2_ASHIFT:
		case IS_2_ASHIFT_USERVAR:
		case IS_VAR_VAR_SUM:
		case IS_VAR_OFFSET_SUM:
		case IS_VAR_VAR_ADDR_SUM:
		case IS_ARG_REG:
		case IS_ARG_OFFSET_SUM:
		  if (jlo_cache_opt_verbose)
		    fprintf (OUTFILE, "Regno %d IS_VARIABLE\n",
			     REGNO (dest));
		  REG_TYPE (REGNO (dest)) = IS_VARIABLE;
		  break;
		default:
		  if (jlo_cache_opt_verbose)
		    fprintf (OUTFILE, "Regno %d is other, setting to NOT_VARIABLE\n",
			     REGNO (dest));
		  REG_TYPE (REGNO (dest)) = NOT_VARIABLE;
		  break;
		}
	    }
	}
    }
}

void 
find_arrays ()
{
  rtx head, tail;
  rtx insn;
  rtx link;
  rtx src, dest;
  int regno;
  int max_uid = MAX_INSNS_PER_SPLIT * (get_max_uid () + 1);

  reg_type = (short *) alloca (max_regno * sizeof (short));
  bzero (reg_type, max_regno * sizeof (short));
  reg_is_address = (short *) alloca (max_regno * sizeof (short));
  bzero (reg_is_address, max_regno * sizeof (short));
  insn_checked = (short *) alloca (max_uid * sizeof (short));
  bzero (insn_checked, max_regno * sizeof (short));
  insn_array_ref = (short *) alloca (max_uid * sizeof (short));
  bzero (insn_array_ref, max_regno * sizeof (short));

  if (jlo_cache_opt_verbose)
    fprintf (OUTFILE, "Finding variables\n");
  for (insn = basic_block_head[0]; insn; insn = NEXT_INSN (insn))
    {
      find_variables (insn); 
    }

  if (jlo_cache_opt_verbose)
    fprintf (OUTFILE, "Finding addresses\n");
  for (insn = basic_block_end[n_basic_blocks-1]; insn; insn = PREV_INSN (insn))
    {
      find_addresses (insn); 
    }

  for (regno = FIRST_PSEUDO_REGISTER; regno < max_regno; regno++)
    {
      if (REG_IS_ADDRESS (regno) || REG_TYPE (regno))
	{
	  fprintf (OUTFILE, "Regno %4d: %15s\t%15s\n",
		   regno, 
		   reg_type_names[REG_TYPE (regno)], 
		   reg_type_names[REG_IS_ADDRESS (regno)]);
	}
    }

#ifdef OLD
  if (jlo_cache_opt_verbose)
    fprintf (OUTFILE, "Checking insns\n");
  for (insn = basic_block_end[n_basic_blocks-1]; insn; insn = PREV_INSN (insn))
/*  for (insn = basic_block_head[0]; insn; insn = NEXT_INSN (insn))*/
    {
      check_insn (insn); 
    }
#endif
}

#endif

#ifdef CACHE_OPT
/* Returns the predicates generated by this array reference */

void
locality_analysis (arr_ref, curr_temporal_pred, curr_spatial_pred)
     tree arr_ref;
     predicate *curr_temporal_pred;
     predicate *curr_spatial_pred;
{
  int loop_depth;
  int array_dimension;
  int curr_depth;
  int curr_dimension;
  struct nesting *curr_loop;
  int len;
  tree arg;
  tree arg0, arg1;
  int i, j;
  tree curr_ref;
  float value;
  matrix m;
  matrix m_spatial;
  matrix Rst;  /* Reuse: self-temporal */
  matrix Rss;  /* Reuse: self-spatial */
  int found_dep = 0;
  predicate this_refs_preds = NULL;
  int lower_bound = -1;
  rtx start_insn = NULL;
  *curr_spatial_pred = NULL;
  *curr_temporal_pred = NULL;

  /* Provide option to purposely misalign the cache accesses to see what
     kind of performance we get.*/

  if (jlo_incorrect_alignment)
    lower_bound = 1;
  else
    lower_bound = 0;

  /* We only balanced schedule loads */
  if (to_assignment)
    return;

  /* Punt on indirect refs for now */
  if ((!((TREE_CODE (arr_ref) == ARRAY_REF) &&
	 (TREE_CODE (TREE_TYPE (TREE_OPERAND (arr_ref, 0))) == ARRAY_TYPE))) &&
      (!((TREE_CODE (arr_ref) == INDIRECT_REF) &&
	 (TREE_CODE (TREE_OPERAND (arr_ref, 0)) == PLUS_EXPR))))
    return;
  if (!((TREE_CODE (arr_ref) == ARRAY_REF) &&
	(TREE_CODE (TREE_TYPE (TREE_OPERAND (arr_ref, 0))) == ARRAY_TYPE)))
    return;

  for (loop_depth = 0, curr_loop = loop_stack;
       curr_loop;
       curr_loop = curr_loop->next, loop_depth++);

  iterators = (tree *) alloca (loop_depth * sizeof (tree)); 

  /* Determine number of dimensions of array ref and of loop nest */
  for (i = loop_depth - 1, curr_loop = loop_stack;
       i >= 0; i--, curr_loop = curr_loop->next)
    {
      iterators[i] = curr_loop->data.loop.iterators;
    }

  curr_ref = arr_ref;
  for (array_dimension = 0; 
       (TREE_CODE (curr_ref) == ARRAY_REF) || 
       (TREE_CODE (curr_ref) == INDIRECT_REF);
       curr_ref = TREE_OPERAND (curr_ref, 0), array_dimension++);

  indices = (tree *) alloca (array_dimension * sizeof (tree)); 
  
  if (TREE_CODE (arr_ref) == ARRAY_REF)
    {
      for (i = array_dimension - 1, curr_ref = arr_ref; 
	   i >= 0; 
	   i--, curr_ref = TREE_OPERAND (curr_ref, 0))
	{
	  indices[i] = TREE_OPERAND (curr_ref, 1);
	}
    }

  if (TREE_CODE (arr_ref) == INDIRECT_REF)
    {
      for (i = array_dimension - 1, curr_ref = TREE_OPERAND (arr_ref, 0); 
	   i >= 0; 
	   i--, curr_ref = TREE_OPERAND (curr_ref, 0))
	{
	  indices[i] = TREE_OPERAND (curr_ref, 1);
	}
    }
  
  /* Create a matrix */
  m = matrix_create (array_dimension, loop_depth);

  len = tree_code_length[(int) TREE_CODE (arr_ref)];
  
  for (curr_depth = 0; curr_depth < loop_depth; curr_depth++)
    {
      for (curr_dimension = 0; curr_dimension < array_dimension; 
	   curr_dimension++)
	{
	  if (value = ref_depends_on (indices[curr_dimension], 
				      iterators[curr_depth]))
	    {
	      found_dep = 1;
	      if (jlo_cache_opt_verbose)
		{
		  fprintf (stderr, "Array ref: ");
		  print_arr_ref (stderr, arr_ref);
		  fprintf (stderr, "\tIterator: ");
		  print_expr (stderr, iterators[curr_depth]);
		  fprintf (stderr, "\nIndex: ");
		  print_expr (stderr, indices[curr_dimension]);
		  fprintf (stderr, "\n");
		}
	      if (jlo_cache_opt_verbose2)
		{
		  fprintf (stderr, "Dependency in depth %d, dimension %d, value = %.2f\n",
			   curr_depth, curr_dimension, value);
		}
	      if (loop_dump_stream)
		{
		  fprintf (loop_dump_stream, "Array ref:");
		  print_arr_ref (loop_dump_stream, arr_ref);
		}
	      if (!matrix_set_elt (m, curr_dimension, curr_depth, value))
		fprintf (stderr, "set_matrix_elt ERROR\n");
	    }
	}
    }

  /* Starting with the inner loop nest, 
     determine what the iterator is.
     Loop through the dimensions of the array
     If the index of the array reference the this dimension
     depends on the iterator, then mark the entry in the vector space
     */
  /* Calculate the span */

  if (!found_dep)
    return;

  if (jlo_cache_opt_verbose2)
    matrix_print (m);
  m_spatial = matrix_copy (m);
  Rst = find_span (m);
  matrix_remove_complex_rows (Rst);
  if ((jlo_cache_opt_verbose2) && (!matrix_is_zero (Rst)))
    {
      fprintf (stderr, "Rst:\n");
      fprintf (stderr, "----\n");
      matrix_print (Rst);
    }
  matrix_clear_last_row (m_spatial);
  Rss = find_span (m_spatial);
  if ((jlo_cache_opt_verbose2) && (!matrix_is_zero (Rst)))
    {
      fprintf (stderr, "Rss:\n");
      fprintf (stderr, "----\n");
      matrix_print (Rss);
    }
  
  /* Set up the predicates for the loops */
  
 for (curr_loop = loop_stack, curr_depth = loop_depth-1; 
       curr_loop; 
       curr_loop = curr_loop->next, curr_depth--)
    {
      /* Look at Rst */
      /* What do multiple rows in Rst correspond to */
      if (matrix_get_elt (Rst, 0, curr_depth, &value))
	{
	  /* predicate should identify the loop iterator, not the
	     actual index variable */
	  /* assume init 0 for now */
	  if (value)
	    {
#ifdef OLD
	      curr_loop->data.loop.loop_pred = 
		predicate_create (TEMPORAL_PREDICATE, 
				  curr_loop->data.loop.iterators, 
				  0/*init*/,
				  curr_loop->data.loop.loop_pred,
				  get_last_insn (),
				  NULL);
#endif
	      /* Keep a separate list of predicates just for this 
		 array reference */
	      start_insn = curr_loop->data.loop.start_label;
	      if (start_insn && PREV_INSN (start_insn))
		{
		  if ((GET_CODE (PREV_INSN (start_insn)) == NOTE) &&
		      (NOTE_LINE_NUMBER (PREV_INSN (start_insn)) == 
		       NOTE_INSN_LOOP_BEG))
		    {
		      start_insn = PREV_INSN (start_insn);
		    }
		} else {
		  start_insn = get_last_insn ();
		}
	      *curr_temporal_pred = 
		predicate_create (TEMPORAL_PREDICATE, 
				  curr_loop->data.loop.iterators, 
				  arr_ref,
				  0/*init*/,
				  *curr_temporal_pred,
				  start_insn,
/*				  get_last_insn (),*/
				  NULL, NULL, 
				  curr_loop->data.loop.init,
				  curr_depth,
				  lower_bound,
				  value,
  				  DECL_RTL (curr_loop->data.loop.iterators));
	      if (jlo_cache_opt_verbose)
		{
		  fprintf (stderr, "Adding temporal predicate to depth %d\n\t",
			   curr_depth);
		  predicate_print (stderr, *curr_temporal_pred);
/*		  print_expr (stderr, curr_loop->data.loop.iterators);
		  fprintf (stderr, " = %d\n", 0);*/
		}
	      if (loop_dump_stream)
		{
		  fprintf (loop_dump_stream, 
			   "Adding temporal predicate to depth %d\n\t",
			   curr_depth);
		  predicate_print (loop_dump_stream, *curr_temporal_pred);
/*		  print_expr (loop_dump_stream, 
			      curr_loop->data.loop.iterators);
		  fprintf (loop_dump_stream, " = %d\n", 0);*/
		}
	      curr_loop->data.loop.loop_pred = 
		loop_predicates_create (*curr_temporal_pred,
					curr_loop->data.loop.loop_pred);
	    }
	}
    }
  /* The span matrices are reversed? 
     Each row corresponds to a vector, and each column corresponds to 
     the loop depth in which there is reuse */
  /* Look at Rss */
  /* Spatial locality only if innermost index has dependence */
  /* What do multiple rows in Rss correspond to */
  /* assume stride 4 for now */
  /* Only do it on inner loop for now */
  /* Sppatial locality exists at the loop depth where the 
     innermost index is the iterator, but the predicate should
     exist at the loop depth which encloses the locality depth - no!*/ 

  /* Clean this up later */
  for (i = 0; i < Rss->num_rows; i++)
    {
      for (j = 0; j < Rss->num_cols; j++)
	{
	  if (j != loop_depth - 1)
	    continue;
	  if (matrix_get_elt (Rss, i, j, &value))
	    if (value)
	      /* Move this out if I don't expand the scope of locality
		 analysis later */
	      if ((value = ref_depends_on (indices[array_dimension-1],
				  iterators[loop_depth-1])) &&
		  ((value == 1.0) || (value == -1.0)))
		{
		  /* If abs(value) != 1.0, then the stride of access will
		     not be 1, so we don't apply spatial locality */
#ifdef OLD
		  if (loop_stack->next == NULL)
		    /* No enclosing loop */
		    break;
#endif
/*		  curr_loop = loop_stack->next;*/
		  curr_loop = loop_stack;
#ifdef OLD
		  curr_loop->data.loop.loop_pred = 
		    predicate_create (SPATIAL_PREDICATE, 
				      curr_loop->data.loop.iterators, 
				      2,
				      curr_loop->data.loop.loop_pred,
				      get_last_insn (),
				      NULL);
#endif
		  /* If the stride will be 0, then add a predicate. */
		  /* This can occur for an array vh[k][l], when the
		     vh[k] portion is sent as the array ref. */

		  if (!(CACHE_LINE_SIZE * 8 / 
			TREE_INT_CST_LOW (TYPE_SIZE (TREE_TYPE (arr_ref)))))
		    continue;

		  /* Keep a separate list of predicates just for this 
		     array reference */
		  start_insn = curr_loop->data.loop.start_label;
		  if (start_insn && PREV_INSN (start_insn))
		    {
		      if ((GET_CODE (PREV_INSN (start_insn)) == NOTE) &&
			  (NOTE_LINE_NUMBER (PREV_INSN (start_insn)) == 
			   NOTE_INSN_LOOP_BEG))
			{
			  start_insn = PREV_INSN (start_insn);
			}
		    } else {
		      start_insn = get_last_insn ();
		    }
		  *curr_spatial_pred =
		    predicate_create (SPATIAL_PREDICATE, 
				      curr_loop->data.loop.iterators, 
				      arr_ref,
				      CACHE_LINE_SIZE * 8 / 
				      TREE_INT_CST_LOW 
				      (TYPE_SIZE (TREE_TYPE (arr_ref))),
				      *curr_spatial_pred,
				      start_insn,
/*				      get_last_insn (),*/
				      NULL, NULL, 
				      curr_loop->data.loop.init,
				      loop_depth-1,
				      lower_bound,
				      value,
				      DECL_RTL (curr_loop->data.loop.iterators));
		  if (jlo_cache_opt_verbose)
		    {
		      fprintf (stderr, 
			       "Adding spatial predicate to depth %d\n\t",
			       loop_depth-1);
		      predicate_print (stderr, *curr_spatial_pred);

/*		      print_expr (stderr, curr_loop->data.loop.iterators);
		      fprintf (stderr, " mod %d\n", 2);*/
		    }
		  if (loop_dump_stream)
		    {
		      fprintf (loop_dump_stream, 
			       "Adding spatial predicate to depth %d\n\t",
			       loop_depth-1);
		      predicate_print (loop_dump_stream, *curr_spatial_pred);
/*		      print_expr (loop_dump_stream, 
				  curr_loop->data.loop.iterators);
		      fprintf (loop_dump_stream, " mod %d\n", 2);*/
		    }
		  curr_loop->data.loop.loop_pred = 
		    loop_predicates_create (*curr_spatial_pred,
					    curr_loop->data.loop.loop_pred);
		  
		}
	}
    }
  
  return;
}

float
ref_depends_on (ref, iterator)
     tree ref, iterator;
{
  float result;

  if (iterator == ref)
    return 1.0;
  else
    {
      if (ref == NULL)
	return 0;
      switch (TREE_CODE (ref))
	{
	case PLUS_EXPR:
	  if (result = ref_depends_on (TREE_OPERAND (ref, 0), iterator))
	    return result;
	  else
	    return (ref_depends_on (TREE_OPERAND (ref, 1), iterator));
	  break;
	case MINUS_EXPR:
	  if (result = ref_depends_on (TREE_OPERAND (ref, 0), iterator))
	    return result;
	  else
	    return (-(ref_depends_on (TREE_OPERAND (ref, 1), iterator)));
	  break;
	case MULT_EXPR:
	  /* Handle more cases */
	  if ((TREE_CODE (TREE_OPERAND (ref, 0)) == INTEGER_CST) &&
	      (TREE_CODE (TREE_OPERAND (ref, 1)) != INTEGER_CST))
	    {
	      if (result = ref_depends_on (TREE_OPERAND (ref, 1), iterator))
		/* INT_CST_HIGH ? */
		return result * TREE_INT_CST_LOW (TREE_OPERAND (ref, 0));
	    }
	  if ((TREE_CODE (TREE_OPERAND (ref, 0)) != INTEGER_CST) &&
	      (TREE_CODE (TREE_OPERAND (ref, 1)) == INTEGER_CST))
	    {
	      if (result = ref_depends_on (TREE_OPERAND (ref, 0), iterator))
		/* INT_CST_HIGH ? */
		return result * TREE_INT_CST_LOW (TREE_OPERAND (ref, 1));
	    }
	  return 0;
	  break;
	case LSHIFT_EXPR:
	case LROTATE_EXPR:
	  /* Handle more cases */
	  if ((TREE_CODE (TREE_OPERAND (ref, 0)) != INTEGER_CST) &&
	      (TREE_CODE (TREE_OPERAND (ref, 1)) == INTEGER_CST))
	    {
	      if (result = ref_depends_on (TREE_OPERAND (ref, 0), iterator))
		/* INT_CST_HIGH ? */
		return (float) ((int)result << 
				TREE_INT_CST_LOW (TREE_OPERAND (ref, 1)));
	    }
	  return 0;
	  break;
	case RSHIFT_EXPR:
	case RROTATE_EXPR:
	  /* Handle more cases */
	  if ((TREE_CODE (TREE_OPERAND (ref, 0)) != INTEGER_CST) &&
	      (TREE_CODE (TREE_OPERAND (ref, 1)) == INTEGER_CST))
	    {
	      if (result = ref_depends_on (TREE_OPERAND (ref, 0), iterator))
		/* INT_CST_HIGH ? */
		return (float) ((int)result >> 
				TREE_INT_CST_LOW (TREE_OPERAND (ref, 1)));
	    }
	  return 0;
	  break;
	case TRUNC_DIV_EXPR:
	case CEIL_DIV_EXPR:
	case FLOOR_DIV_EXPR:
	case ROUND_DIV_EXPR:
	case RDIV_EXPR:
	case EXACT_DIV_EXPR:
	  /* Handle more cases */
	  if ((TREE_CODE (TREE_OPERAND (ref, 0)) == INTEGER_CST) &&
	      (TREE_CODE (TREE_OPERAND (ref, 1)) != INTEGER_CST))
	    {
	      if (result = ref_depends_on (TREE_OPERAND (ref, 1), iterator))
		/* INT_CST_HIGH ? */
		return result / TREE_INT_CST_LOW (TREE_OPERAND (ref, 0));
	    }
	  if ((TREE_CODE (TREE_OPERAND (ref, 0)) != INTEGER_CST) &&
	      (TREE_CODE (TREE_OPERAND (ref, 1)) == INTEGER_CST))
	    {
	      if (result = ref_depends_on (TREE_OPERAND (ref, 0), iterator))
		/* INT_CST_HIGH ? */
		return result / TREE_INT_CST_LOW (TREE_OPERAND (ref, 1));
	    }
	  return 0;
	  break;
	case NOP_EXPR:
	  if (result = ref_depends_on (TREE_OPERAND (ref, 0), iterator))
	    return result;
	  break;
	default:
	  /* Don't support these yet */
	  return 0;
	  break;
	}
    }
  /*  if (TREE_CODE_CLASS (TREE_CODE (indices[curr_dimension])) == 'd')
      {
      if (IDENTIFIER_POINTER (DECL_NAME (indices[curr_dimension])))
      {
      }
      }
      */
}

void
print_expr (f, exp)
     FILE *f;
     tree exp;
{
  char class;

  if (exp == 0)
    return;

  class = TREE_CODE_CLASS (TREE_CODE (exp));
  if (class == 'd')
    if (DECL_NAME (exp))
      fprintf (f, "%s", IDENTIFIER_POINTER (DECL_NAME (exp)));

  switch (TREE_CODE (exp))
    {
    case INTEGER_CST:
      if (TREE_INT_CST_HIGH (exp) == 0)
	fprintf (f, " %1u", TREE_INT_CST_LOW (exp));
      else if (TREE_INT_CST_HIGH (exp) == -1
	       && TREE_INT_CST_LOW (exp) != 0)
	fprintf (f, " -%1u", -TREE_INT_CST_LOW (exp));
      else
	fprintf (f,
		 " 0x%x%08x",
/*#if HOST_BITS_PER_WIDE_INT == 64
#if HOST_BITS_PER_WIDE_INT != HOST_BITS_PER_INT
		 " 0x%lx%016lx",
#else
		 " 0x%x%016x",
#endif
#else
#if HOST_BITS_PER_WIDE_INT != HOST_BITS_PER_INT
		 " 0x%lx%08lx",
#else
		 " 0x%x%08x",
#endif
#endif*/
		 TREE_INT_CST_HIGH (exp), TREE_INT_CST_LOW (exp));
      break;
    case PLUS_EXPR:
      fprintf (f, "(");
      print_expr (f, TREE_OPERAND (exp, 0));
      fprintf (f, " + ");
      print_expr (f, TREE_OPERAND (exp, 1));
      fprintf (f, ")");
      break;
    case MINUS_EXPR:
      fprintf (f, "(");
      print_expr (f, TREE_OPERAND (exp, 0));
      fprintf (f, " - ");
      print_expr (f, TREE_OPERAND (exp, 1));
      fprintf (f, ")");
      break;
    case MULT_EXPR:
      fprintf (f, "(");
      print_expr (f, TREE_OPERAND (exp, 0));
      fprintf (f, " * ");
      print_expr (f, TREE_OPERAND (exp, 1));
      fprintf (f, ")");
      break;
    case LSHIFT_EXPR:
    case LROTATE_EXPR:
      fprintf (f, "(");
      print_expr (f, TREE_OPERAND (exp, 0));
      fprintf (f, " << ");
      print_expr (f, TREE_OPERAND (exp, 1));
      fprintf (f, ")");
      break;
    case RSHIFT_EXPR:
    case RROTATE_EXPR:
      fprintf (f, "(");
      print_expr (f, TREE_OPERAND (exp, 0));
      fprintf (f, " >> ");
      print_expr (f, TREE_OPERAND (exp, 1));
      fprintf (f, ")");
      break;
    case NOP_EXPR:
      print_expr (f, TREE_OPERAND (exp, 0));
      break;
    case INDIRECT_REF:
      fprintf (f, "*");
      print_expr (f, TREE_OPERAND (exp, 0));
      break;
    case COMPONENT_REF:
      print_expr (f, TREE_OPERAND (exp, 0));
      break;
    } 
}

void
print_arr_ref (f, ref)
  FILE *f;
  tree ref;
{
  int len; 
  tree arg0;
  tree arg1;
  
  if (ref == NULL)
    return;
  if (TREE_CODE (ref) == ARRAY_REF)
    {
      len = tree_code_length[(int) TREE_CODE (ref)];
      arg0 = TREE_OPERAND (ref, 0);
      arg1 = TREE_OPERAND (ref, 1);
      switch (TREE_CODE (arg0))
	{
	case ARRAY_REF:
	  print_arr_ref (f, arg0);
	  break;
	case COMPONENT_REF:
	  print_expr (f, TREE_OPERAND (arg0, 0));
	  fprintf (f, ".");
	  print_expr (f, TREE_OPERAND (arg0, 1));
	  break;
	default:
	  print_expr (f, arg0);
	}
      fprintf (f, "[");
      print_expr (f, arg1);
      fprintf (f, "]");
    }
}

void 
debug_arr_ref (ref)
     tree ref;
{
  print_arr_ref (stderr, ref);
}

#ifdef CACHE_OPT
void
print_loop_stats (f)
     FILE *f;
{
  if (f)
    {
      fprintf (f, "------------------\n");
      fprintf (f, "loops:\t\t\t%4d\n", loops);
      fprintf (f, "peeled_loops:\t\t%4d\n", peeled_loops);
      fprintf (f, "unrolled_loops:\t\t%4d\n", unrolled_loops);
      fprintf (f, "unattempted_loops:\t%4d\n", unattempted_loops);
      fprintf (f, "spatial_loops:\t\t%4d\n", spatial_loops);
      fprintf (f, "temporal_loops:\t\t%4d\n", temporal_loops);
      fprintf (f, "cache_opt_hacks:\t%4d\n", cache_opt_hacks);
      fprintf (f, "too_big_loops:\t\t%4d\n", too_big_loops);
    }
}

void
init_loop_stats (f)
     FILE *f;
{
  loops = 0;
  peeled_loops = 0;
  unrolled_loops = 0;
  unattempted_loops = 0;
  spatial_loops = 0;
  temporal_loops = 0;
  cache_opt_hacks = 0;
  too_big_loops = 0;
}

/* Default is to turn it on */
/* Need to know array's lower bound and the loop's initial iteration */

int
turn_on_this_iteration (iteration, spatial_pred, initial_value)
     int iteration;
     predicate spatial_pred;
     int initial_value;
{
  int result;

  if (!spatial_pred || (spatial_pred->type != SPATIAL_PREDICATE))
    {
      fprintf (stderr, "WARNING: non-spatial predicate passed to ");
      fprintf (stderr, "turn_on_this_iteration\n");
      return TRUE;
    }
  /* Iterations start from 0 and go to the number of unrolls */

  /* This assumes that the initial loop index is 0, and that the array
     is cache-aligned on even indices. */
  /* If we know where the array indexing starts, then we can determine
     whether or not to turn on/off BSA.  But if we don't know this info,
     we can't do anything. */

  /* if array is even index aligned, but we begin the loop on an odd
     iteration, then the first iteration is different from the others
     because we'll have a cache miss on iterations 0,1,3,5,7,... */

/*
  if (((spatial_pred->lower_bound - initial_value) % spatial_pred->info.stride)
      != 0)
    return TRUE;
    In this case, we need to peel another iteration 
*/
  if ((spatial_pred->lower_bound == LOWER_BOUND_IS_UNKNOWN) ||
      jlo_turn_on_all)
    {
      if (jlo_cache_opt_verbose)
	{
	  fprintf (stderr, "turn ON iteration %d\n", iteration);
	}
      if (loop_dump_stream)
	{
	  fprintf (loop_dump_stream, "turn ON iteration %d\n", iteration);
	}
      return TRUE;
    } else {
      result = ((((int)spatial_pred->coefficient * iteration + 
		  spatial_pred->offset + initial_value - 
		  spatial_pred->lower_bound) % spatial_pred->info.stride)
		== 0);

      if (jlo_cache_opt_verbose)
	{
	  fprintf (stderr, "turn %s iteration %d\n", 
		   result ? "ON" : "OFF", iteration);
	}
      if (loop_dump_stream)
	{
	  fprintf (loop_dump_stream, "turn %s iteration %d\n", 
		   result ? "ON" : "OFF", iteration);
	}
      return result;
    }
    
}
#endif
#endif


#ifdef OLD
  for (i = loop_depth - 1, curr_loop = loop_stack; 
       /* only do on innermost loop for now */
       curr_loop = loop_stack;
       i--, curr_loop = curr_loop->next)
    {
      for (j = 0; j < array_dimension; j++)
	{
	  if (matrix_get_elt (m, j, i, &value))
	    if (value)
	      {
		if (matrix_get_elt (Rss, j, i, &value))
		  {
		    if (value)
		      {
			if (curr_loop->next == NULL) 
			  {
			    /* no enclosing loop*/
			    continue;
			  }
#ifdef OLD
			curr_loop->next->data.loop.loop_pred = 
			  predicate_create (SPATIAL_PREDICATE, 
					    curr_loop->next->data.loop.iterators, 
					    2/*stride*/,
					    curr_loop->next->data.loop.loop_pred,
					    get_last_insn (),
					    NULL);
#endif
			/* Keep a separate list of predicates just for this 
			   array reference */
			this_refs_preds = 
			  predicate_create (SPATIAL_PREDICATE, 
					    curr_loop->data.loop.iterators, 
					    arr_ref,
					    2,
					    curr_loop->data.loop.loop_pred,
					    this_refs_preds,
					    get_last_insn (),
					    NULL);
			if (jlo_cache_opt_verbose)
			  {
			    fprintf (stderr, 
				     "Adding spatial predicate to depth %d",
				     i-1);
			    print_expr (stderr, 
					curr_loop->next->data.loop.iterators);
			    fprintf (stderr, " mod %d\n", 2);
			  }
			if (loop_dump_stream)
			  {
			    fprintf (loop_dump_stream, 
				     "Adding spatial predicate to depth %d",
				     i-1);
			    print_expr (loop_dump_stream, 
					curr_loop->next->data.loop.iterators);
			    fprintf (loop_dump_stream, " mod %d\n", 2);
			  }
		      }
		  }
	      }
	}	  
    }
#endif

int
ref_offset (ref)
     tree ref;
{
  int result1;
  int result2;

  if (ref == NULL)
    return 0;
  switch (TREE_CODE (ref))
    {
    case ARRAY_REF:
      return ref_offset (TREE_OPERAND (ref, 1));
    case PLUS_EXPR:
      result1 = ref_offset (TREE_OPERAND (ref, 0));
      result2 = ref_offset (TREE_OPERAND (ref, 1));
      return result1+result2;
    case MINUS_EXPR:
      result1 = ref_offset (TREE_OPERAND (ref, 0));
      result2 = ref_offset (TREE_OPERAND (ref, 1));
      return result1-result2;
    case NOP_EXPR:
      return (ref_offset (TREE_OPERAND (ref, 0)));
    case INTEGER_CST:
      return TREE_INT_CST_LOW (ref);
    default:
      return 0;
    }
}

void
pretty_print_rtx (f, r)
     FILE *f;
     rtx r;
{
  if (r == NULL)
    {
      fprintf (f, "(nil)\n");
    }

  switch (GET_CODE (r))
    {
    case JUMP_INSN:
    case INSN:
      fprintf (f, "%d\t", INSN_UID (r));
      pretty_print_rtx (f, PATTERN (r));
      break;
    case REG:
      fprintf (f, "R%d", REGNO (r));
      break;
    case MEM:
      fprintf (f, "[");
      pretty_print_rtx (f, XEXP (r, 0));
      fprintf (f, "]");
      break;
    case SET:
      pretty_print_rtx (f, SET_DEST (r));
      fprintf (f, " <-- ");
      pretty_print_rtx (f, SET_SRC (r));
      break;
    case PLUS:
      pretty_print_rtx (f, XEXP (r, 0));
      fprintf (f, " + ");
      pretty_print_rtx (f, XEXP (r, 1));
      break;
    case ASHIFT:
      pretty_print_rtx (f, XEXP (r, 0));
      fprintf (f, " << ");
      pretty_print_rtx (f, XEXP (r, 1));
      break;
    case MINUS:
      pretty_print_rtx (f, XEXP (r, 0));
      fprintf (f, " - ");
      pretty_print_rtx (f, XEXP (r, 1));
      break;
    case UDIV:
    case DIV:
      pretty_print_rtx (f, XEXP (r, 0));
      fprintf (f, " \ ");
      pretty_print_rtx (f, XEXP (r, 1));
      break;
    case UMOD:
    case MOD:
      pretty_print_rtx (f, XEXP (r, 0));
      fprintf (f, " % ");
      pretty_print_rtx (f, XEXP (r, 1));
      break;
    case MULT:
      pretty_print_rtx (f, XEXP (r, 0));
      fprintf (f, " * ");
      pretty_print_rtx (f, XEXP (r, 1));
      break;
    case AND:
      pretty_print_rtx (f, XEXP (r, 0));
      fprintf (f, " & ");
      pretty_print_rtx (f, XEXP (r, 1));
      break;
    case IOR:
      pretty_print_rtx (f, XEXP (r, 0));
      fprintf (f, " | ");
      pretty_print_rtx (f, XEXP (r, 1));
      break;
    case XOR:
      pretty_print_rtx (f, XEXP (r, 0));
      fprintf (f, " ^ ");
      pretty_print_rtx (f, XEXP (r, 1));
      break;
    case NOT:
      fprintf (f, " ! ");
      pretty_print_rtx (f, XEXP (r, 0));
      break;
    case LSHIFT:
      pretty_print_rtx (f, XEXP (r, 0));
      fprintf (f, " << ");
      pretty_print_rtx (f, XEXP (r, 1));
      break;
    case ROTATE:
      pretty_print_rtx (f, XEXP (r, 0));
      fprintf (f, " << ");
      pretty_print_rtx (f, XEXP (r, 1));
      break;
    case ASHIFTRT:
      pretty_print_rtx (f, XEXP (r, 0));
      fprintf (f, " >> ");
      pretty_print_rtx (f, XEXP (r, 1));
      break;
    case LSHIFTRT:
      pretty_print_rtx (f, XEXP (r, 0));
      fprintf (f, " >> ");
      pretty_print_rtx (f, XEXP (r, 1));
      break;
    case ROTATERT:
      pretty_print_rtx (f, XEXP (r, 0));
      fprintf (f, " >> ");
      pretty_print_rtx (f, XEXP (r, 1));
      break;
    case NE:
      pretty_print_rtx (f, XEXP (r, 0));
      fprintf (f, " != ");
      pretty_print_rtx (f, XEXP (r, 1));
      break;
    case EQ:
      pretty_print_rtx (f, XEXP (r, 0));
      fprintf (f, " == ");
      pretty_print_rtx (f, XEXP (r, 1));
      break;
    case GE:
      pretty_print_rtx (f, XEXP (r, 0));
      fprintf (f, " >= ");
      pretty_print_rtx (f, XEXP (r, 1));
      break;
    case GT:
      pretty_print_rtx (f, XEXP (r, 0));
      fprintf (f, " > ");
      pretty_print_rtx (f, XEXP (r, 1));
      break;
    case LE:
      pretty_print_rtx (f, XEXP (r, 0));
      fprintf (f, " <= ");
      pretty_print_rtx (f, XEXP (r, 1));
      break;
    case LT:
      pretty_print_rtx (f, XEXP (r, 0));
      fprintf (f, " < ");
      pretty_print_rtx (f, XEXP (r, 1));
      break;
    case GEU:
      pretty_print_rtx (f, XEXP (r, 0));
      fprintf (f, " >= ");
      pretty_print_rtx (f, XEXP (r, 1));
      break;
    case GTU:
      pretty_print_rtx (f, XEXP (r, 0));
      fprintf (f, " > ");
      pretty_print_rtx (f, XEXP (r, 1));
      break;
    case LEU:
      pretty_print_rtx (f, XEXP (r, 0));
      fprintf (f, " <= ");
      pretty_print_rtx (f, XEXP (r, 1));
      break;
    case LTU:
      pretty_print_rtx (f, XEXP (r, 0));
      fprintf (f, " < ");
      pretty_print_rtx (f, XEXP (r, 1));
      break;
    case SIGN_EXTEND:
    case ZERO_EXTEND:
    case TRUNCATE:
    case FLOAT_EXTEND:
    case FLOAT_TRUNCATE:
    case FLOAT:
    case HIGH:
    case LO_SUM:
      pretty_print_rtx (f, XEXP (r, 0));
      break;
    case ABS:
      fprintf (f, " abs ( ");
      pretty_print_rtx (f, XEXP (r, 0));
      fprintf (f, " ) ");
      break;
    case SQRT:
      fprintf (f, " sqrt ( ");
      pretty_print_rtx (f, XEXP (r, 0));
      fprintf (f, " ) ");
      break;
    case PARALLEL:
    case USE:
    case CLOBBER:
    case CALL:
    case RETURN:
    case CONST_INT:
      break;
    case CONST:
    case CONST_DOUBLE:
      pretty_print_rtx (f, XEXP (r, 0));
      break;
    case CONST_STRING:
      break;
    case PC:
      fprintf (f, " PC ");
      break;
    case LABEL_REF:
      fprintf (f, " LABEL ");
      break;
    case SYMBOL_REF:
      fprintf (f, " symbol ");
      pretty_print_rtx (f, XEXP (r, 0));
      break;
    case CC0:
      fprintf (f, " CC0 ");
      break;
    case COMPARE:
      pretty_print_rtx (f, XEXP (r, 0));
      pretty_print_rtx (f, XEXP (r, 1));
      break;
    }
}

void
pretty_print_rtl (f, rtx_first)
     FILE *f;
     rtx rtx_first;
{
  rtx tmp_rtx;

  if (rtx_first == NULL)
    fprintf (f, "NULL\n");
  else 
    {
    switch (GET_CODE (rtx_first))
      {
      case INSN:
      case JUMP_INSN:
      case CALL_INSN:
      case NOTE:
      case CODE_LABEL:
      case BARRIER:
	for (tmp_rtx = rtx_first; NULL != tmp_rtx; tmp_rtx = NEXT_INSN (tmp_rtx))
	  {
	    pretty_print_rtx (tmp_rtx);
	    fprintf (f, "\n");
	  }
	break;

      default:
	pretty_print_rtx (rtx_first);
      }
  }
}

