//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that "this" may not be used within a default argument
// expression for a member function.

struct base {
	int data_member;

	base (int val);
	int member (base* other_base = this);	// ERROR
};

base* bp;

int main ()
{
	bp = new base (9999);

	return bp->member(bp);
}

base::base (int val)
{
	data_member = val;
}

int base::member (base* other_base)	// possible error
{
	bp = other_base;
	return 0;
}
