//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that the & operator, when applied to a global function
// or member function is considered to be ambiguous if there is
// an insufficient context requiring the result of & to be a
// specific (unambiguous) pointer-to-function type.

overload function;

void function (char c)
{
	c = c;
}

void function (float f)
{
	f = f;
}

class base {
	int member;
public:
	void method (char);
	void method (float);
};

void* vp;

int test ()
{
	vp = &function;			// ERROR - ambiguous use of &
	vp = &base::method;		// ERROR - ambiguous use of &
	return 0;
}

void base::method (char c)
{
	c = c;
	vp = &base::method;		// ERROR - ambiguous use of &
}

void base::method (float f)
{
	f = f;
	vp = &base::method;		// ERROR - ambiguous use of &
}
